/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharingDescriptorsMap
extends PersistentDiskBackedHashMap<StringWrapper, ISharingDescriptor> {
    private static final int METADATA_VERSION = 0;
    private final boolean isCaseSensitive;

    public SharingDescriptorsMap(File file, boolean isCaseSensitive) {
        super(file);
        this.isCaseSensitive = isCaseSensitive;
    }

    protected void writeCustomMetadata(DataOutputStream out) throws IOException {
        super.writeCustomMetadata(out);
        out.writeInt(0);
    }

    protected void readCustomMetadata(DataInputStream in) throws IOException {
        super.readCustomMetadata(in);
        int v = in.readInt();
        if (v != 0) {
            throw new IllegalArgumentException("Metadata version mismatch " + v + " != " + 0);
        }
    }

    protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
        ObjectInputStream objIn = new ObjectInputStream(in){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                if (desc.getName().equals(SharingDescriptor.class.getName())) {
                    return SharingDescriptor.class;
                }
                return super.resolveClass(desc);
            }
        };
        Object o = objIn.readObject();
        if ((flags & 1) != 0) {
            return new StringWrapper((String)o, this.isCaseSensitive);
        }
        return o;
    }

    protected long writeObject(Object o, int flags) throws IOException {
        if ((flags & 1) != 0) {
            return super.writeObject((Object)o.toString(), flags);
        }
        return super.writeObject(o, flags);
    }
}

