/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;

public final class Shareable
implements IShareable {
    private final IPath path;
    private final ResourceType resourceTypeHint;
    private final ISandbox sandbox;
    private final int cachedHashCode;
    private IFileStorage fileStorage;
    private IPath fullPath;

    public Shareable(IPath copyFileAreaRoot, IPath path, ResourceType resourceTypeHint) {
        this.path = path;
        if (resourceTypeHint == null) {
            throw new IllegalArgumentException();
        }
        this.resourceTypeHint = resourceTypeHint;
        this.sandbox = new Sandbox(copyFileAreaRoot);
        this.cachedHashCode = this.calculateHashCode();
    }

    public Shareable(ISandbox sandbox, IPath path, ResourceType resourceTypeHint) {
        this.sandbox = sandbox;
        this.path = path;
        if (resourceTypeHint == null) {
            throw new IllegalArgumentException();
        }
        this.resourceTypeHint = resourceTypeHint;
        this.cachedHashCode = this.calculateHashCode();
    }

    public Shareable(ISandbox sandbox, IPath path, IFileStorage fileStorage) {
        this.sandbox = sandbox;
        this.path = path;
        this.resourceTypeHint = null;
        this.fileStorage = fileStorage;
        this.cachedHashCode = this.calculateHashCode();
    }

    public final IPath getCopyFileAreaRoot() {
        return this.getSandbox().getRoot();
    }

    public final IPath getLocalPath() {
        return this.path;
    }

    public final IPath getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.getCopyFileAreaRoot().append(this.getLocalPath());
        }
        return this.fullPath;
    }

    public final IShare getShare(IProgressMonitor monitor) throws FileSystemClientException {
        return SharingManager.instance.getShare(this.getCopyFileAreaRoot(), this.path, monitor);
    }

    public int getState(IProgressMonitor monitor) throws FileSystemClientException {
        IVersionableHandle versionable;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        int mask = 0;
        if (this.exists((IProgressMonitor)progress.newChild(1))) {
            mask |= 8;
        }
        if (this.getShare((IProgressMonitor)progress.newChild(49)) == null) {
            return mask;
        }
        mask |= 1;
        FileItemInfo itemInfo = this.getFileItemInfo((IProgressMonitor)progress.newChild(50));
        if (itemInfo != null && (versionable = itemInfo.getVersionableHandle()).hasStateId()) {
            mask |= 2;
        }
        return mask;
    }

    public final IShare share(ISharingDescriptor descriptor, FileItemInfo fileItemInfo, boolean overwrite, IProgressMonitor monitor) throws FileSystemClientException {
        return this.share(descriptor, fileItemInfo, overwrite, true, monitor);
    }

    public IShare share(ISharingDescriptor descriptor, FileItemInfo fileItemInfo, boolean overwrite, boolean loadChanges, IProgressMonitor monitor) throws FileSystemClientException {
        int options = 0;
        if (overwrite) {
            options |= 1;
        }
        if (loadChanges) {
            options |= 4;
        }
        return SharingManager.getInstance().share(this, descriptor, fileItemInfo, options, monitor);
    }

    public final IVersionableHandle getRemote(IProgressMonitor monitor) throws FileSystemClientException {
        FileItemInfo info = this.getFileItemInfo(monitor);
        return info != null && info.getVersionableHandle().hasStateId() ? info.getVersionableHandle() : null;
    }

    public final IVersionableHandle getVersionable(IProgressMonitor monitor) throws FileSystemClientException {
        FileItemInfo info = this.getFileItemInfo(monitor);
        return info != null ? info.getVersionableHandle() : null;
    }

    public void accept(final IShareableVisitor visitor, final int depth, final boolean includeLocal, boolean mutable, IProgressMonitor monitor) throws FileSystemClientException {
        final ArrayList visitorExceptions = new ArrayList();
        final boolean[] visitedRoot = new boolean[1];
        IVisitor metadataVisitor = new IVisitor(){

            public boolean visit(IPath path, FileItemInfo fileItem, IProgressMonitor monitor) {
                SubMonitor progress;
                visitedRoot[0] = true;
                IVersionableHandle versionableHandle = fileItem.getVersionableHandle();
                boolean remote = versionableHandle.hasStateId();
                if (!includeLocal) {
                    if (!remote) {
                        return false;
                    }
                    Shareable shareable = new Shareable(Shareable.this.getCopyFileAreaRoot(), path, ResourceType.getResourceType(fileItem.getVersionableHandle()));
                    return visitor.visit(shareable, monitor);
                }
                final Shareable shareable = new Shareable(Shareable.this.getCopyFileAreaRoot(), path, ResourceType.getResourceType(fileItem.getVersionableHandle()));
                boolean visitChildren = visitor.visit(shareable, (IProgressMonitor)(progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100)).newChild(50));
                if (!visitChildren) {
                    return false;
                }
                if (!fileItem.isFolder()) {
                    return false;
                }
                try {
                    shareable.visit(new IShareableVisitor(){

                        public boolean visit(IShareable shareableToVisit, IProgressMonitor monitor) {
                            if (shareable.equals(shareableToVisit)) {
                                return true;
                            }
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            boolean hasMetadata = false;
                            try {
                                FileItemInfo fileItemInfo = ((Shareable)shareableToVisit).getFileItemInfo((IProgressMonitor)progress.newChild(1));
                                boolean bl = hasMetadata = fileItemInfo != null;
                                if (hasMetadata && !shareable.getSandbox().isCaseSensitive()) {
                                    ISharingDescriptor desc = shareable.getShare((IProgressMonitor)progress.newChild(1)).getSharingDescriptor();
                                    InverseFileItemInfo itemInfo = ICopyFileAreaManager.instance.getExistingCopyFileArea(Shareable.this.getCopyFileAreaRoot()).getItemInfo(fileItemInfo.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                                    hasMetadata = itemInfo.getLocalName().equals(shareableToVisit.getLocalPath().lastSegment());
                                }
                            }
                            catch (FileSystemClientException e) {
                                visitorExceptions.add(e);
                            }
                            if (!hasMetadata) {
                                boolean result = visitor.visit(shareableToVisit, (IProgressMonitor)progress.newChild(99));
                                return result;
                            }
                            return false;
                        }
                    }, depth, (IProgressMonitor)progress.newChild(50));
                    progress.done();
                }
                catch (FileSystemClientException e) {
                    visitorExceptions.add(e);
                }
                return true;
            }
        };
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForUpdate(this.getCopyFileAreaRoot(), this.getLocalPath(), (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            progress.done();
            return;
        }
        try {
            ICopyFileAreaManager.instance.getExistingCopyFileArea(this.getCopyFileAreaRoot()).accept(metadataVisitor, this.getLocalPath(), mutable, depth, (IProgressMonitor)progress.newChild(95));
            if (!visitedRoot[0]) {
                progress.setWorkRemaining(100);
                if (this.exists((IProgressMonitor)progress.newChild(1))) {
                    visitor.visit(this, (IProgressMonitor)progress.newChild(4));
                    this.visit(visitor, depth, (IProgressMonitor)progress.newChild(95));
                }
            }
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
        if (!visitorExceptions.isEmpty()) {
            if (visitorExceptions.size() == 1) {
                throw (FileSystemClientException)((Object)visitorExceptions.get(0));
            }
            IStatus first = ((FileSystemClientException)((Object)visitorExceptions.get(0))).getStatus();
            MultiStatus ms = new MultiStatus(first.getPlugin(), first.getCode(), first.getMessage(), null);
            for (FileSystemClientException e : visitorExceptions) {
                ms.add(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
            }
            throw new FileSystemClientException((IStatus)ms);
        }
    }

    public IFileStorage getFileStorage() {
        if (this.fileStorage == null) {
            this.fileStorage = new FileStorageWrapper(this, this.resourceTypeHint);
        }
        return this.fileStorage;
    }

    public void forget(IProgressMonitor monitor) throws FileSystemClientException {
        SharingManager.getInstance().forget(this, monitor);
    }

    public void unshare(IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.isShare((IProgressMonitor)progress.newChild(10))) {
            throw new IllegalStateException("Only the root of the share can be unshared");
        }
        SharingManager.getInstance().forget(this, (IProgressMonitor)progress.newChild(90));
    }

    public boolean isShare(IProgressMonitor monitor) throws FileSystemClientException {
        IShare share = this.getShare(monitor);
        return share != null && this.getLocalPath().segmentCount() == share.getPath().segmentCount();
    }

    public IShareable getParent() {
        IPath parentPath = this.getLocalPath().removeLastSegments(1);
        if (parentPath.segmentCount() == 0) {
            return null;
        }
        IFileStorage parent = this.getFileStorage().getParent();
        if (parent == null) {
            return null;
        }
        return parent.getShareable();
    }

    public boolean shouldBeIgnored(IProgressMonitor monitor) throws FileSystemClientException {
        return this.getFileStorage().shouldBeIgnored(monitor);
    }

    public ResourceType getResourceType(IProgressMonitor monitor) throws FileSystemClientException {
        return this.getFileStorage().getResourceType(monitor);
    }

    public ILocalChange getChange(IProgressMonitor progress) throws FileSystemClientException {
        return SharingManager.getInstance().getChange(this, progress);
    }

    public FileLineDelimiter getLineDelimiter(IProgressMonitor monitor) throws FileSystemClientException {
        FileItemInfo info = this.getFileItemInfo(monitor);
        if (info != null) {
            return info.getLineDelimiter();
        }
        return FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    public String getContentType(IProgressMonitor monitor) throws FileSystemClientException {
        FileItemInfo info = this.getFileItemInfo(monitor);
        if (info != null) {
            return info.getContentType();
        }
        return null;
    }

    public FileLineDelimiter getOriginalLineDelimiter(IProgressMonitor monitor) throws FileSystemClientException {
        FileItemInfo info = this.getFileItemInfo(monitor);
        if (info != null) {
            return info.getOriginalLineDelimiter();
        }
        return FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    public String getOriginalContentType(IProgressMonitor monitor) throws FileSystemClientException {
        FileItemInfo info = this.getFileItemInfo(monitor);
        if (info != null) {
            return info.getOriginalContentType();
        }
        return null;
    }

    public boolean isExecutable(IProgressMonitor monitor) throws FileSystemClientException {
        return this.getFileStorage().isExecutable(monitor);
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    private final int calculateHashCode() {
        int result = 1;
        result = this.getCopyFileAreaRoot() == null ? 0 : this.getCopyFileAreaRoot().segmentCount();
        result = 31 * result + (this.path == null ? 0 : this.path.segmentCount());
        result = 31 * result + (this.path == null || this.path.segmentCount() == 0 ? 0 : this.path.lastSegment().toLowerCase().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Shareable other = (Shareable)obj;
        if (!PathUtils.samePath(this.getCopyFileAreaRoot(), this.sandbox.isCaseSensitive(), other.getCopyFileAreaRoot(), other.sandbox.isCaseSensitive())) {
            return false;
        }
        return PathUtils.sameRelativePath(this.path, this.sandbox.isCaseSensitive(), other.path, other.sandbox.isCaseSensitive());
    }

    public Object getAdapter(Class adaptTo) {
        if (adaptTo.isAssignableFrom(Shareable.class)) {
            return this;
        }
        if (adaptTo.isAssignableFrom(File.class)) {
            return this.getFullPath().toFile();
        }
        IFileStorage fileStorage = this.getFileStorage();
        return fileStorage.getAdapter(adaptTo);
    }

    final void setFileStorage(IFileStorage fileStorageToCache) {
        if (fileStorageToCache.getShareable() == this) {
            this.fileStorage = fileStorageToCache;
        }
    }

    private void visit(IShareableVisitor visitor, int depth, IProgressMonitor monitor) throws FileSystemClientException {
        IFileStorage fileStorage;
        Collection<IFileStorage> children;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.FOLDER && depth != 0 && (children = (fileStorage = this.getFileStorage()).getChildren((IProgressMonitor)progress.newChild(1))) != null) {
            progress.setWorkRemaining(children.size());
            for (IFileStorage child : children) {
                SubMonitor subProgress = progress.newChild(1);
                subProgress.setWorkRemaining(100);
                Shareable shareable = child.getShareable();
                boolean visitChildren = visitor.visit(shareable, (IProgressMonitor)subProgress.newChild(5));
                if (!visitChildren) continue;
                shareable.visit(visitor, depth - 1, (IProgressMonitor)subProgress.newChild(95));
            }
        }
    }

    public ISandbox getSandbox() {
        return this.sandbox;
    }

    public FileItemInfo getFileItemInfo(IProgressMonitor monitor) throws FileSystemClientException {
        return this.getFileItemInfo(this.path, monitor);
    }

    private FileItemInfo getFileItemInfo(IPath localPath, IProgressMonitor monitor) throws FileSystemClientException {
        FileItemInfo info = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        AbstractLock lock = CFALockUtil.lockExistingForRead(this.getCopyFileAreaRoot(), (IProgressMonitor)progress.newChild(1));
        if (lock != null) {
            try {
                ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(this.getCopyFileAreaRoot());
                if (cfa != null) {
                    info = cfa.getItemInfo(localPath);
                }
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
        return info;
    }

    public String toString() {
        return String.valueOf(this.getSandbox().getRoot().toPortableString()) + " -> " + this.getLocalPath().toPortableString();
    }

    public boolean exists(IProgressMonitor progress) throws FileSystemClientException {
        return this.getFileStorage().exists(progress);
    }
}

