/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.operations.AutoResolveOperation;
import com.ibm.team.filesystem.client.internal.operations.ChangeFilePropertiesOperation;
import com.ibm.team.filesystem.client.internal.operations.CreateBaselineOperation;
import com.ibm.team.filesystem.client.internal.operations.DeleteInRepositoryOperation;
import com.ibm.team.filesystem.client.internal.operations.DeliverOperation;
import com.ibm.team.filesystem.client.internal.operations.DiscardOperation;
import com.ibm.team.filesystem.client.internal.operations.LoadOperation;
import com.ibm.team.filesystem.client.internal.operations.LockOperation;
import com.ibm.team.filesystem.client.internal.operations.MoveFoldersOperation;
import com.ibm.team.filesystem.client.internal.operations.NewCheckInOperation;
import com.ibm.team.filesystem.client.internal.operations.ResumeOperation;
import com.ibm.team.filesystem.client.internal.operations.SuspendOperation;
import com.ibm.team.filesystem.client.internal.operations.TransferLockOperation;
import com.ibm.team.filesystem.client.internal.operations.UnlockOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.operations.WorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.internal.share.ShareOperation;
import com.ibm.team.filesystem.client.internal.share.UnshareOperation;
import com.ibm.team.filesystem.client.operations.AutoResolveConflictsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAutoResolveConflictsOperation;
import com.ibm.team.filesystem.client.operations.IChangeFilePropertiesOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICreateBaselineOperation;
import com.ibm.team.filesystem.client.operations.IDeleteFoldersOperation;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.operations.IDiscardOperation;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.ILockOperation;
import com.ibm.team.filesystem.client.operations.IMoveFoldersOperation;
import com.ibm.team.filesystem.client.operations.IResumeOperation;
import com.ibm.team.filesystem.client.operations.IShareOperation;
import com.ibm.team.filesystem.client.operations.ISuspendOperation;
import com.ibm.team.filesystem.client.operations.ITransferLockOperation;
import com.ibm.team.filesystem.client.operations.IUnlockOperation;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MoveFoldersDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OperationOptions;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ResumeDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ShareDilemmaHandler;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.filesystem.client.operations.WorkspaceUpdateDilemmaHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationFactory
implements IOperationFactory {
    private static OperationFactory operationFactory;
    private OperationOptions options = new OperationOptions();

    public static IOperationFactory getInstance() {
        if (operationFactory == null) {
            operationFactory = new OperationFactory();
        }
        return operationFactory;
    }

    private OperationFactory() {
    }

    public void setOperationOptions(OperationOptions newOptions) {
        this.options = newOptions == null ? new OperationOptions() : newOptions;
    }

    @Override
    public OperationOptions getOperationOptions() {
        return this.options;
    }

    private <T extends IFileSystemOperation> T configure(T object) {
        if (this.options != null) {
            this.options.configureOperation(object);
        }
        return object;
    }

    @Override
    public IVerifyInSyncOperation getVerifyInSyncOperation(OutOfSyncDilemmaHandler dilemmaHandler) {
        return this.configure(new VerifySharesOperation(dilemmaHandler));
    }

    @Override
    public ILoadOperation getLoadOperation(LoadDilemmaHandler dilemmaHandler) {
        return this.configure(new LoadOperation(dilemmaHandler));
    }

    @Override
    public IShareOperation getShareOperation(ShareDilemmaHandler dilemmaHandler) {
        return this.configure(new ShareOperation(dilemmaHandler));
    }

    @Override
    public IUnshareOperation getUnshareOperation(UnshareDilemmaHandler dilemmaHandler) {
        return this.configure(new UnshareOperation(dilemmaHandler));
    }

    @Override
    public ICheckinOperation getCheckinOperation(CommitDilemmaHandler problemHandler) {
        return this.configure(new NewCheckInOperation(problemHandler));
    }

    @Override
    public IDeliverOperation getDeliverOperation(DeliverDilemmaHandler dilemmaHandler) {
        return this.configure(new DeliverOperation(dilemmaHandler));
    }

    @Override
    public IChangeFilePropertiesOperation getChangeFilePropertiesOperation(ChangePropertiesDilemmaHandler dilemmaHandler) {
        return this.configure(new ChangeFilePropertiesOperation(dilemmaHandler));
    }

    @Override
    public ICreateBaselineOperation getCreateBaselineOperation(CreateBaselineDilemmaHandler dilemmaHandler) {
        return this.configure(new CreateBaselineOperation(dilemmaHandler));
    }

    @Override
    public IWorkspaceUpdateOperation getWorkspaceUpdateOperation(WorkspaceUpdateDilemmaHandler dilemmaHandler) {
        return this.configure(new WorkspaceUpdateOperation(dilemmaHandler));
    }

    @Override
    public IAutoResolveConflictsOperation getAutoResolveConflictsOperation(AutoResolveConflictsDilemmaHandler dilemmaHandler) {
        return this.configure(new AutoResolveOperation(dilemmaHandler));
    }

    @Override
    public IMoveFoldersOperation getMoveFoldersOperation(MoveFoldersDilemmaHandler dilemmaHandler) {
        return this.configure(new MoveFoldersOperation(dilemmaHandler));
    }

    @Override
    public IDeleteFoldersOperation getDeleteFoldersOperation(CommitDilemmaHandler dilemmaHandler) {
        return this.configure(new DeleteInRepositoryOperation(dilemmaHandler));
    }

    @Override
    public ILockOperation getLockOperation(LockDilemmaHandler dilemmaHandler) {
        return this.configure(new LockOperation(dilemmaHandler));
    }

    @Override
    public ITransferLockOperation getTransferLockOperation(LockDilemmaHandler dilemmaHandler) {
        return this.configure(new TransferLockOperation(dilemmaHandler));
    }

    @Override
    public IUnlockOperation getUnlockOperation(LockDilemmaHandler dilemmaHandler) {
        return this.configure(new UnlockOperation(dilemmaHandler));
    }

    @Override
    public ISuspendOperation getSuspendOperation(SuspendDilemmaHandler dilemmaHandler) {
        return this.configure(new SuspendOperation(dilemmaHandler));
    }

    @Override
    public IResumeOperation getResumeOperation(ResumeDilemmaHandler dilemmaHandler) {
        return this.configure(new ResumeOperation(dilemmaHandler));
    }

    @Override
    public IDiscardOperation getDiscardOperation(DiscardDilemmaHandler dilemmaHandler) {
        return this.configure(new DiscardOperation(dilemmaHandler));
    }
}

