/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.internal.FileSystemCoreActivator;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataUpdateJob
extends Job {
    private static final boolean DEBUG = System.getProperty("jazz.scm.debug.metadataUpdateJob", "false").equals("true");
    private static final boolean DETAILED_DEBUG = System.getProperty("jazz.scm.debug.metadataUpdateJob.detailed", "false").equals("true");
    private static final long MAX_LOCK_TIME = 500L;
    private static final long SCHEDULING_DELAY = 200L;
    private static MetadataUpdateJob instance;
    private final Map<IPath, Map<IPath, TreeMap<IPath, UpdateRequest>>> updates = new HashMap<IPath, Map<IPath, TreeMap<IPath, UpdateRequest>>>();
    private boolean workspaceReady = false;
    private ThreadLocal<Boolean> updating = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    private static synchronized MetadataUpdateJob getInstance() {
        if (instance == null) {
            instance = new MetadataUpdateJob();
            instance.setSystem(true);
        }
        return instance;
    }

    public static void queueUpdate(ManagedFileStore managedFileStore, boolean updateChildren) {
        if (DETAILED_DEBUG) {
            System.out.print("Request to update metadata for " + managedFileStore.getCfaPath().append(managedFileStore.getLocalPath()).toOSString());
            if (updateChildren) {
                System.out.println(" including children");
            } else {
                System.out.println();
            }
        }
        MetadataUpdateJob.getInstance().queue(new UpdateRequest(managedFileStore, updateChildren));
    }

    public MetadataUpdateJob() {
        super(Messages.MetadataUpdateJob_JobName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue(UpdateRequest updateRequest) {
        Map<IPath, Map<IPath, TreeMap<IPath, UpdateRequest>>> map = this.updates;
        synchronized (map) {
            if (!this.updating.get().booleanValue()) {
                IPath localPath;
                UpdateRequest existingRequest;
                IPath sharePath;
                TreeMap<IPath, UpdateRequest> shareUpdates;
                IPath cfaPath = updateRequest.getCfaPath();
                Map<IPath, TreeMap<IPath, UpdateRequest>> cfaUpdates = this.updates.get(cfaPath);
                if (cfaUpdates == null) {
                    cfaUpdates = new HashMap<IPath, TreeMap<IPath, UpdateRequest>>();
                    this.updates.put(cfaPath, cfaUpdates);
                }
                if ((shareUpdates = cfaUpdates.get(sharePath = updateRequest.getLockPath())) == null) {
                    shareUpdates = new TreeMap(new Comparator<IPath>(){

                        @Override
                        public int compare(IPath path1, IPath path2) {
                            int segments = Math.min(path1.segmentCount(), path2.segmentCount());
                            int i = 0;
                            while (i < segments) {
                                int c = path1.segment(i).compareTo(path2.segment(i));
                                if (c != 0) {
                                    return c;
                                }
                                ++i;
                            }
                            return path1.segmentCount() - path2.segmentCount();
                        }
                    });
                    cfaUpdates.put(sharePath, shareUpdates);
                }
                if ((existingRequest = shareUpdates.get(localPath = updateRequest.getLocalPath())) == null) {
                    shareUpdates.put(localPath, updateRequest);
                } else {
                    shareUpdates.put(localPath, updateRequest.combine(existingRequest));
                }
            }
        }
        this.schedule(200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requeue(IPath cfaPath, IPath lockPath, TreeMap<IPath, UpdateRequest> skippedUpdates) {
        Map<IPath, Map<IPath, TreeMap<IPath, UpdateRequest>>> map = this.updates;
        synchronized (map) {
            IPath sharePath;
            TreeMap<IPath, UpdateRequest> shareUpdates;
            Map<IPath, TreeMap<IPath, UpdateRequest>> cfaUpdates = this.updates.get(cfaPath);
            if (cfaUpdates == null) {
                cfaUpdates = new HashMap<IPath, TreeMap<IPath, UpdateRequest>>();
                this.updates.put(cfaPath, cfaUpdates);
            }
            if ((shareUpdates = cfaUpdates.get(sharePath = lockPath)) == null) {
                cfaUpdates.put(sharePath, skippedUpdates);
            } else {
                for (UpdateRequest updateRequest : skippedUpdates.values()) {
                    IPath localPath = updateRequest.getLocalPath();
                    UpdateRequest existingRequest = shareUpdates.get(localPath);
                    if (existingRequest == null) {
                        shareUpdates.put(localPath, updateRequest);
                        continue;
                    }
                    shareUpdates.put(localPath, updateRequest.combine(existingRequest));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRun() {
        Map<IPath, Map<IPath, TreeMap<IPath, UpdateRequest>>> map = this.updates;
        synchronized (map) {
            return !this.updates.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.isWorkspaceReady()) {
            this.schedule(2000L);
            return Status.OK_STATUS;
        }
        while (true) {
            TreeMap<IPath, UpdateRequest> next = null;
            IPath cfaPath = null;
            IPath lockPath = null;
            Map<IPath, Map<IPath, TreeMap<IPath, UpdateRequest>>> map = this.updates;
            synchronized (map) {
                if (this.updates.isEmpty()) {
                    if (!FileSystemCore.isShutDown()) {
                        this.schedule(200L);
                    }
                    return Status.OK_STATUS;
                }
                Iterator<Map.Entry<IPath, Map<IPath, TreeMap<IPath, UpdateRequest>>>> cfaIterator = this.updates.entrySet().iterator();
                Map.Entry<IPath, Map<IPath, TreeMap<IPath, UpdateRequest>>> cfaUpdates = cfaIterator.next();
                cfaPath = cfaUpdates.getKey();
                Iterator<Map.Entry<IPath, TreeMap<IPath, UpdateRequest>>> shareIterator = cfaUpdates.getValue().entrySet().iterator();
                if (shareIterator.hasNext()) {
                    Map.Entry<IPath, TreeMap<IPath, UpdateRequest>> shareUpdates = shareIterator.next();
                    lockPath = shareUpdates.getKey();
                    next = shareUpdates.getValue();
                    shareIterator.remove();
                    if (!shareIterator.hasNext()) {
                        cfaIterator.remove();
                    }
                } else {
                    cfaIterator.remove();
                }
            }
            if (next == null) continue;
            progress.setWorkRemaining(100);
            try {
                this.process(cfaPath, lockPath, next, progress.newChild(1));
            }
            catch (OperationCanceledException e) {
                this.requeue(cfaPath, lockPath, next);
                this.schedule(200L);
                throw e;
            }
        }
    }

    public boolean isWorkspaceReady() {
        block17: {
            if (!this.workspaceReady) {
                BundleContext context = FileSystemCoreActivator.getBundleContext();
                if (context == null) {
                    this.workspaceReady = true;
                } else {
                    ServiceTracker bundleTracker = this.getPackageAdminServiceTracker(context);
                    try {
                        try {
                            Bundle[] bundles;
                            PackageAdmin bundleAdmin = (PackageAdmin)bundleTracker.getService();
                            this.workspaceReady = bundleAdmin == null ? true : ((bundles = bundleAdmin.getBundles("org.eclipse.core.resources", null)).length != 1 ? true : bundles[0].getState() == 32);
                        }
                        catch (Exception exception) {
                            this.workspaceReady = true;
                            try {
                                if (bundleTracker != null) {
                                    bundleTracker.close();
                                }
                                break block17;
                            }
                            catch (Exception exception2) {}
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bundleTracker != null) {
                                bundleTracker.close();
                            }
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        if (bundleTracker != null) {
                            bundleTracker.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return this.workspaceReady;
    }

    private ServiceTracker getPackageAdminServiceTracker(BundleContext context) {
        ServiceTracker bundleTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        bundleTracker.open();
        return bundleTracker;
    }

    private void process(IPath cfaPath, IPath lockPath, TreeMap<IPath, UpdateRequest> toUpdate, SubMonitor monitor) {
        block17: {
            monitor.setWorkRemaining(100);
            try {
                monitor.subTask(NLS.bind((String)Messages.MetadataUpdateJob_WaitingSubTask, (Object)cfaPath));
                CFALockUtil.LockResult lock = CFALockUtil.createAndLockForUpdateOfChildren(cfaPath, lockPath, true, (IProgressMonitor)monitor.newChild(1));
                long startTime = System.currentTimeMillis();
                if (DEBUG) {
                    System.out.println("Processing metadata updates for share " + cfaPath.append(lockPath).toOSString());
                }
                if (lock.code == 0) {
                    boolean changeFound = false;
                    try {
                        monitor.setWorkRemaining(toUpdate.size() + 1);
                        Iterator<UpdateRequest> iterator = toUpdate.values().iterator();
                        while (iterator.hasNext()) {
                            UpdateRequest updateRequest = iterator.next();
                            if (monitor.isCanceled() || this.isTimeToStop(startTime, changeFound)) {
                                if (DEBUG) {
                                    System.out.println("Processing time expired. Requeuing request to update " + updateRequest.store.getCfaPath().append(updateRequest.store.getLocalPath()).toOSString());
                                }
                                monitor.subTask(Messages.MetadataUpdateJob_TimedoutSubtask);
                                throw new OperationCanceledException();
                            }
                            try {
                                this.updating.set(true);
                                changeFound |= updateRequest.update(monitor.newChild(1));
                                iterator.remove();
                            }
                            finally {
                                this.updating.set(false);
                            }
                        }
                    }
                    finally {
                        CFALockUtil.endBatching(lock, monitor.newChild(1));
                    }
                    if (DEBUG) {
                        System.out.println("Processing completed in " + (System.currentTimeMillis() - startTime) + "ms for share " + cfaPath.append(lockPath).toOSString());
                    }
                    break block17;
                }
                if (monitor.isCanceled()) {
                    if (DEBUG) {
                        System.out.println("Processing canceled. Requeuing request to update " + cfaPath.append(lockPath).toOSString());
                    }
                    throw new OperationCanceledException();
                }
            }
            catch (FileSystemClientException e) {
                LoggingHelper.log(e);
            }
        }
    }

    private boolean isTimeToStop(long startTime, boolean changeFound) {
        if (changeFound || FileSystemCore.isShutDown()) {
            return false;
        }
        return System.currentTimeMillis() - startTime > 500L;
    }

    public boolean belongsTo(Object family) {
        if (family == CopyFileAreaManager.instance) {
            return true;
        }
        if (family == LocalChangeManager.getInstance()) {
            return true;
        }
        return super.belongsTo(family);
    }

    public int getUpdateCount() {
        int count = 0;
        for (Map.Entry<IPath, Map<IPath, TreeMap<IPath, UpdateRequest>>> urs : this.updates.entrySet()) {
            count += 1 + urs.getValue().size();
        }
        return count;
    }

    private static class UpdateRequest {
        private final ManagedFileStore store;
        private final boolean updateChildren;
        private final boolean updateElement;

        public UpdateRequest(ManagedFileStore store, boolean updateChildren) {
            this(store, updateChildren, !updateChildren);
        }

        public UpdateRequest(ManagedFileStore store, boolean updateChildren, boolean updateElement) {
            this.store = store;
            this.updateChildren = updateChildren;
            this.updateElement = updateElement;
        }

        public boolean update(SubMonitor monitor) {
            try {
                monitor.subTask(NLS.bind((String)Messages.MetadataUpdateJob_UpdatingMetadataSubTask, (Object)this.store.getCfaPath().append(this.store.getLocalPath())));
                if (DETAILED_DEBUG) {
                    System.out.print("Updating metadata for " + this.store.getCfaPath().append(this.store.getLocalPath()).toOSString());
                    if (this.updateChildren) {
                        System.out.println(" including children");
                    } else {
                        System.out.println();
                    }
                }
                boolean changeFound = this.store.ensureMetadataUpToDate(this.updateElement, this.updateChildren, (IProgressMonitor)monitor);
                if (DEBUG && changeFound) {
                    System.out.print("Metadata updated for " + this.store.getCfaPath().append(this.store.getLocalPath()).toOSString());
                    if (this.updateChildren) {
                        System.out.println(" including children");
                    } else {
                        System.out.println();
                    }
                }
                return changeFound;
            }
            catch (CoreException e) {
                LoggingHelper.log(e);
                return false;
            }
        }

        public IPath getLockPath() {
            return new Path(null, this.store.getLocalPath().segment(0));
        }

        public UpdateRequest combine(UpdateRequest existing) {
            if (existing == null) {
                return this;
            }
            if (existing.updateChildren && existing.updateElement) {
                return existing;
            }
            if (this.updateChildren && this.updateElement) {
                return this;
            }
            if (existing.updateChildren == this.updateChildren && existing.updateElement == this.updateElement) {
                return existing;
            }
            return new UpdateRequest(this.store, this.updateChildren || existing.updateChildren, this.updateElement || existing.updateElement);
        }

        public IPath getCfaPath() {
            return this.store.getCfaPath();
        }

        public IPath getLocalPath() {
            return this.store.getLocalPath();
        }
    }
}

