/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.ChangeTrackingOutputStream;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.JavaSymLinkHelper;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileSystem;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataUpdateJob;
import com.ibm.team.filesystem.client.internal.NativeSymLinkHelper;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.SymLinkHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class ManagedFileStore
extends FileStore {
    private static final SymLinkHelper symlinkHelper;
    private final IFileStore baseStore;
    private final IPath cfaPath;
    private final IPath localPath;

    static {
        boolean efsSupportsSymLinks;
        SymLinkHelper slh;
        block11: {
            slh = NativeSymLinkHelper.newInstance();
            if (slh == null) {
                try {
                    Class<?> cls = ManagedFileStore.class.getClassLoader().loadClass("com.ibm.team.filesystem.client.internal.Java17SymLinkHelper");
                    Method m = cls.getDeclaredMethod("newInstance", new Class[0]);
                    try {
                        slh = (SymLinkHelper)m.invoke(null, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        Throwable target = e.getCause();
                        if (target == null) {
                            throw e;
                        }
                        if (target instanceof NoClassDefFoundError) {
                            slh = JavaSymLinkHelper.newInstance();
                            break block11;
                        }
                        if (target instanceof Exception) {
                            throw (Exception)target;
                        }
                        if (target instanceof Error) {
                            throw (Error)target;
                        }
                        throw new RuntimeException(target);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        symlinkHelper = slh;
        boolean slhSupportsSymLinks = slh.supportsSymLinks();
        boolean bl = efsSupportsSymLinks = (EFS.getLocalFileSystem().attributes() & 0x20) != 0;
        if (slhSupportsSymLinks != efsSupportsSymLinks) {
            LoggingHelper.log((IStatus)new Status(2, "com.ibm.team.filesystem.client", slhSupportsSymLinks ? Messages.ManagedFileStore_10 : Messages.ManagedFileStore_11));
        }
    }

    public static boolean supportsSymLinks() {
        return symlinkHelper.supportsSymLinks();
    }

    public static String getResolvedPath(String path) throws CoreException {
        return symlinkHelper.getResolvedPath(path);
    }

    public static void createSymlink(IFileStore file, String targetPath, IProgressMonitor monitor) throws CoreException {
        if (!symlinkHelper.supportsSymLinks()) {
            throw new CoreException(FileSystemStatus.getStatusFor(4, Messages.ManagedFileStore_5, null));
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        String filePath = file.toLocalFile(0, (IProgressMonitor)progress.newChild(1)).getPath();
        IFileInfo info = file.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
        if (info.exists() || info.getAttribute(32)) {
            throw new CoreException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ManagedFileStore_6, (Object)filePath), null));
        }
        IFileStore parent = file.getParent();
        IFileInfo parentInfo = parent.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
        if (!parentInfo.exists()) {
            throw new CoreException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ManagedFileStore_7, (Object)filePath), null));
        }
        if (!parentInfo.isDirectory()) {
            throw new CoreException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ManagedFileStore_8, (Object)filePath), null));
        }
        symlinkHelper.createSymlink(filePath, targetPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void symlink(String targetPath, IProgressMonitor monitor) throws CoreException {
        if (!symlinkHelper.supportsSymLinks()) {
            throw new CoreException(FileSystemStatus.getStatusFor(4, Messages.ManagedFileStore_5, null));
        }
        if (this.trackingChanges()) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
            CFALockUtil.LockResult lock = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, false, (IProgressMonitor)progress.newChild(1));
            try {
                ManagedFileStore.createSymlink(this.baseStore, targetPath, (IProgressMonitor)progress.newChild(1));
                if (lock.code == 0) {
                    IFileInfo info = this.baseStore.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
                    ManagedFileStore.updateMetadata(this, info, (IProgressMonitor)progress.newChild(1));
                    return;
                }
                if (lock.code != 2) return;
                this.requestBackgroundMetadataUpdate(false);
                return;
            }
            finally {
                if (lock != null) {
                    CFALockUtil.endBatching(lock, progress.newChild(1));
                }
            }
        } else {
            ManagedFileStore.createSymlink(this.baseStore, targetPath, monitor);
        }
    }

    protected void addDatelessItem(IVersionableHandle item, IComponentHandle component, IContextHandle connection) {
        ISchedulingRule rule = SharingManager.getInstance().getTrackingRule(this.cfaPath);
        LocalChangeTracker tracker = LocalChangeManager.getInstance().getTracker(connection, component, this.cfaPath, rule);
        tracker.registerDatelessVersionable(this.baseStore.fetchInfo().getLastModified(), item, component, connection);
    }

    public ManagedFileStore(IPath cfaPath, IPath sharePath, IFileStore baseStore) {
        this.cfaPath = cfaPath;
        this.baseStore = baseStore;
        this.localPath = sharePath;
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IFileInfo[] iFileInfoArray = this.childInfosInternal(false, options, (IProgressMonitor)progress.newChild(100));
            return iFileInfoArray;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    private static void done(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.done();
        }
    }

    private boolean trackingChanges() {
        return SharingManager.getInstance().isChangeMonitoringEnabled() && !FileSystemCore.isShutDown();
    }

    private IFileInfo[] childInfosInternal(boolean isNested, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress;
        block16: {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (this.trackingChanges()) {
                try {
                    IFileInfo[] iFileInfoArray;
                    block15: {
                        CFALockUtil.LockResult lock = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, false, (IProgressMonitor)progress.newChild(1));
                        try {
                            IFileInfo[] infos = this.baseStore.childInfos(options, (IProgressMonitor)progress.newChild(40));
                            if (lock.code == 0) {
                                this.updateMetadataForChildren(infos, progress.newChild(58));
                            } else if (lock.code == 2) {
                                this.requestBackgroundMetadataUpdate(true);
                            }
                            iFileInfoArray = infos;
                            if (lock == null) break block15;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (lock != null) {
                                    CFALockUtil.endBatching(lock, progress.newChild(1));
                                }
                                throw throwable;
                            }
                            catch (RuntimeException e) {
                                this.handleException(isNested, e);
                                ManagedFileStore.done(monitor);
                                break block16;
                            }
                            catch (CoreException e) {
                                this.handleException(isNested, e);
                                break block16;
                            }
                        }
                        CFALockUtil.endBatching(lock, progress.newChild(1));
                    }
                    return iFileInfoArray;
                }
                finally {
                    ManagedFileStore.done(monitor);
                }
            }
        }
        progress.setWorkRemaining(45);
        return this.baseStore.childInfos(options, (IProgressMonitor)progress.newChild(45));
    }

    private void handleException(boolean isNested, CoreException e) throws CoreException {
        if (isNested) {
            throw e;
        }
        LoggingHelper.log(FileSystemStatus.getStatusFor(e));
    }

    private void handleException(boolean isNested, RuntimeException e) {
        if (isNested) {
            throw e;
        }
        LoggingHelper.log(FileSystemStatus.getStatusFor(e));
    }

    private void requestBackgroundMetadataUpdate(boolean updateChildren) {
        MetadataUpdateJob.queueUpdate(this, updateChildren);
    }

    private boolean updateMetadataForChildren(IFileInfo[] infos, SubMonitor progress) throws FileSystemClientException, CoreException {
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
        FileItemInfo baseInfo = cfa.getItemInfo(this.localPath);
        if (baseInfo != null && (baseInfo.isSymbolicLink() || baseInfo.isFile() && infos.length == 0)) {
            return false;
        }
        SharingManager sm = SharingManager.getInstance();
        Sandbox sandbox = new Sandbox(cfa);
        Shareable shareable = sm.findShareable(sandbox, this.localPath, ResourceType.FOLDER);
        Share share = cfa.getShare(shareable.getLocalPath());
        IFileStorage fileStorage = shareable.getFileStorage();
        boolean isCaseSensitive = cfa.isCaseSensitive();
        HashMap<StringWrapper, IFileInfo> infoMap = new HashMap<StringWrapper, IFileInfo>(infos.length * 4 / 3);
        IFileInfo[] iFileInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo info = iFileInfoArray[n2];
            infoMap.put(new StringWrapper(info.getName(), isCaseSensitive), info);
            ++n2;
        }
        boolean changeFound = false;
        if (share != null) {
            if (fileStorage.shouldBeIgnored((IProgressMonitor)progress.newChild(5))) {
                return false;
            }
            if (!(share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle)) {
                if (infos.length != 0) {
                    cfa.deleteTreeInfo(share.getPath(), false, (IProgressMonitor)progress.newChild(53));
                }
                return true;
            }
            if (!(infos.length == 0 || baseInfo != null && baseInfo.isFolder())) {
                IFileInfo parentInfo = this.fetchInfoInternal(true, 0, (IProgressMonitor)progress.newChild(5));
                if (parentInfo.getAttribute(32) || !parentInfo.isDirectory()) {
                    return false;
                }
                baseInfo = cfa.getItemInfo(this.localPath);
                if (baseInfo == null) {
                    return false;
                }
            }
            progress.setWorkRemaining(52);
            Map<StringWrapper, FileItemInfo> children = cfa.getChildInfos(this.localPath, (IProgressMonitor)progress.newChild(35));
            HashMap<StringWrapper, IFileStorage> fileStorageChildrenMap = new HashMap<StringWrapper, IFileStorage>();
            Collection<IFileStorage> fileStorageChildren = fileStorage.getChildren((IProgressMonitor)progress.newChild(1));
            if (fileStorageChildren != null) {
                for (IFileStorage iFileStorage : fileStorageChildren) {
                    fileStorageChildrenMap.put(new StringWrapper(iFileStorage.getName(), isCaseSensitive), iFileStorage);
                }
            }
            SubMonitor comparisonMonitor = progress.newChild(10);
            comparisonMonitor.beginTask(Messages.ManagedFileStore_0, children.size());
            for (Map.Entry<StringWrapper, FileItemInfo> e : children.entrySet()) {
                IFileStorage childFileStorage;
                SubMonitor iterationProgress = comparisonMonitor.newChild(1);
                iterationProgress.setWorkRemaining(3);
                StringWrapper name = e.getKey();
                FileItemInfo info = e.getValue();
                IFileInfo fInfo = (IFileInfo)infoMap.remove(name);
                IPath childPath = this.localPath.append(fInfo == null ? name.toString() : fInfo.getName());
                IFileStorage iFileStorage = childFileStorage = fInfo == null ? null : (IFileStorage)fileStorageChildrenMap.get(name);
                if (childFileStorage == null) {
                    ResourceType hint = fInfo == null ? ResourceType.getResourceType(info.getVersionableHandle()) : (fInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
                    Shareable childShareable = sm.findShareable(sandbox, childPath, hint);
                    childFileStorage = childShareable.getFileStorage();
                }
                if (childFileStorage.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                if (fInfo == null) {
                    iterationProgress.setWorkRemaining(1);
                    changeFound |= cfa.deleteTreeInfo(childPath, false, (IProgressMonitor)iterationProgress.newChild(1));
                    continue;
                }
                if (!ManagedFileStore.isSameType(fInfo, info)) {
                    iterationProgress.setWorkRemaining(1);
                    changeFound |= cfa.deleteTreeInfo(childPath, false, (IProgressMonitor)iterationProgress.newChild(1));
                    infoMap.put(name, fInfo);
                    continue;
                }
                if (info.isFile()) {
                    long checkStamp;
                    iterationProgress.setWorkRemaining(2);
                    ManagedFileStore child = this.getChild(fInfo.getName());
                    boolean contentChanged = ManagedFileStore.contentChanged(child, fInfo, info, share, childFileStorage, iterationProgress.newChild(1));
                    boolean executable = childFileStorage.supportsExecBit() ? fInfo.getAttribute(4) : info.isExecutable();
                    long l = checkStamp = info.getVersionableHandle().hasStateId() ? childFileStorage.getModificationStamp() : -1L;
                    if (name.toString().equals(fInfo.getName()) && contentChanged == info.isContentChanged() && executable == info.isExecutable() && checkStamp == info.getLastContentChangeCheckStamp()) continue;
                    cfa.setItemInfo(childPath, new FileItemInfo(info.getVersionableHandle(), contentChanged, checkStamp, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), executable, info.isOriginalExecutable()), (IProgressMonitor)iterationProgress.newChild(1));
                    changeFound = true;
                    continue;
                }
                if (info.isSymbolicLink()) {
                    boolean contentChanged = LocalChangeTracker.contentChanged(info, fInfo.getStringAttribute(64));
                    if (contentChanged == info.isContentChanged()) continue;
                    cfa.setItemInfo(childPath, new FileItemInfo((ISymbolicLinkHandle)info.getVersionableHandle(), contentChanged, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getHash(), info.getStoredHash()), (IProgressMonitor)iterationProgress.newChild(1));
                    changeFound = true;
                    continue;
                }
                if (name.toString().equals(fInfo.getName())) continue;
                iterationProgress.setWorkRemaining(1);
                cfa.setItemInfo(childPath, info, (IProgressMonitor)iterationProgress.newChild(1));
                changeFound = true;
            }
            comparisonMonitor.done();
            SubMonitor subProgress = progress.newChild(5);
            subProgress.setWorkRemaining(infoMap.size());
            for (IFileInfo info : infoMap.values()) {
                SubMonitor iterationProgress = subProgress.newChild(1).setWorkRemaining(3);
                IPath childPath = this.localPath.append(info.getName());
                IFileStorage childStorage = fileStorage.getChild(info.getName(), (IProgressMonitor)iterationProgress.newChild(1));
                Shareable childShareable = childStorage != null ? childStorage.getShareable() : sm.findShareable(sandbox, childPath, this.getResourceType(info));
                if (childShareable.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                if (info.getAttribute(32)) {
                    share.getTracker().trackSymbolicLinkAddition((IFolderHandle)baseInfo.getVersionableHandle(), childShareable, (IProgressMonitor)iterationProgress.newChild(1));
                } else if (info.isDirectory()) {
                    share.getTracker().trackFolderAddition((IFolderHandle)baseInfo.getVersionableHandle(), childShareable, (IProgressMonitor)iterationProgress.newChild(1));
                } else {
                    share.getTracker().trackFileAddition((IFolderHandle)baseInfo.getVersionableHandle(), childShareable, (IProgressMonitor)iterationProgress.newChild(1));
                }
                changeFound = true;
            }
        } else {
            progress.setWorkRemaining(51);
            Collection<IPath> shareRoots = cfa.allSharePaths(this.localPath);
            int segNum = this.localPath.segmentCount();
            SubMonitor deletionMonitor = progress.newChild(25);
            deletionMonitor.setWorkRemaining(shareRoots.size());
            for (IPath root : shareRoots) {
                Shareable rootShareable;
                SubMonitor iterationProgress = deletionMonitor.newChild(1);
                iterationProgress.setWorkRemaining(2);
                IFileInfo info = (IFileInfo)infoMap.get(new StringWrapper(root.segment(segNum), isCaseSensitive));
                boolean exists = false;
                ISharingDescriptor desc = null;
                if (info != null) {
                    if (root.segmentCount() == segNum + 1) {
                        desc = cfa.getSharingInfo(root);
                        if (this.isSameType(desc.getRootVersionable(), info)) {
                            exists = true;
                        }
                    } else if (info.isDirectory()) {
                        exists = true;
                    }
                }
                if (!exists) {
                    if (desc == null) {
                        desc = cfa.getSharingInfo(root);
                    }
                    if ((rootShareable = sm.findShareable(sandbox, root, ResourceType.getResourceType(desc.getRootVersionable()))).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                    changeFound |= cfa.deleteTreeInfo(root, false, (IProgressMonitor)iterationProgress.newChild(1));
                    continue;
                }
                if (root.segment(segNum).equals(info.getName())) continue;
                if (desc == null) {
                    desc = cfa.getSharingInfo(root);
                }
                if ((rootShareable = sm.findShareable(sandbox, root, ResourceType.getResourceType(desc.getRootVersionable()))).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                IPath newPath = root.removeLastSegments(root.segmentCount() - segNum).append(info.getName()).append(root.removeFirstSegments(segNum + 1));
                cfa.moveSharingInfo(root, newPath, (IProgressMonitor)iterationProgress.newChild(1));
                changeFound = true;
            }
            deletionMonitor.done();
            SubMonitor additionMonitor = progress.newChild(25);
            additionMonitor.setWorkRemaining(shareRoots.size());
            for (IPath root : shareRoots) {
                boolean contentChanged;
                Shareable rootShareable;
                IFileInfo fInfo;
                SubMonitor iterationProgress = additionMonitor.newChild(1);
                iterationProgress.setWorkRemaining(2);
                if (root.segmentCount() != segNum + 1 || (fInfo = (IFileInfo)infoMap.get(new StringWrapper(root.segment(segNum), isCaseSensitive))) == null || (rootShareable = sm.findShareable(sandbox, root.removeLastSegments(1).append(fInfo.getName()), fInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE)).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                FileItemInfo info = cfa.getItemInfo(root);
                if (info == null) {
                    Share s = cfa.getShare(root);
                    if (!this.isSameType(s.getSharingDescriptor().getRootVersionable(), fInfo)) continue;
                    iterationProgress.setWorkRemaining(1);
                    if (fInfo.getAttribute(32)) {
                        s.getTracker().trackSymbolicLinkAddition(null, rootShareable, (IProgressMonitor)iterationProgress.newChild(1));
                    } else if (fInfo.isDirectory()) {
                        s.getTracker().trackFolderAddition(null, rootShareable, (IProgressMonitor)iterationProgress.newChild(1));
                    } else {
                        s.getTracker().trackFileAddition(null, rootShareable, (IProgressMonitor)iterationProgress.newChild(1));
                    }
                    if (!fInfo.getName().equals(root.segment(segNum))) {
                        iterationProgress.setWorkRemaining(1);
                        cfa.moveSharingInfo(root, root.removeLastSegments(1).append(fInfo.getName()), (IProgressMonitor)iterationProgress.newChild(1));
                    }
                    changeFound = true;
                    continue;
                }
                Assert.isTrue((boolean)ManagedFileStore.isSameType(fInfo, info));
                if (info.isFile()) {
                    long checkStamp;
                    iterationProgress.setWorkRemaining(3);
                    ManagedFileStore child = this.getChild(fInfo.getName());
                    Share childShare = share == null ? cfa.getShare(rootShareable.getLocalPath()) : share;
                    boolean contentChanged2 = ManagedFileStore.contentChanged(child, fInfo, info, childShare, rootShareable.getFileStorage(), iterationProgress.newChild(1));
                    boolean executable = rootShareable.getFileStorage().supportsExecBit() ? fInfo.getAttribute(4) : info.isExecutable();
                    long l = checkStamp = info.getVersionableHandle().hasStateId() ? rootShareable.getFileStorage().getModificationStamp() : -1L;
                    if (contentChanged2 != info.isContentChanged() || executable != info.isExecutable() || checkStamp != info.getLastContentChangeCheckStamp()) {
                        cfa.setItemInfo(root, new FileItemInfo(info.getVersionableHandle(), contentChanged2, checkStamp, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), executable, info.isOriginalExecutable()), (IProgressMonitor)iterationProgress.newChild(1));
                        changeFound = true;
                    }
                } else if (info.isSymbolicLink() && (contentChanged = LocalChangeTracker.contentChanged(info, fInfo.getStringAttribute(64))) != info.isContentChanged()) {
                    cfa.setItemInfo(root, new FileItemInfo((ISymbolicLinkHandle)info.getVersionableHandle(), contentChanged, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getHash(), info.getStoredHash()), (IProgressMonitor)iterationProgress.newChild(1));
                    changeFound = true;
                }
                if (fInfo.getName().equals(root.segment(segNum))) continue;
                iterationProgress.setWorkRemaining(1);
                cfa.moveSharingInfo(root, root.removeLastSegments(1).append(fInfo.getName()), (IProgressMonitor)iterationProgress.newChild(1));
                changeFound = true;
            }
        }
        return changeFound;
    }

    private ResourceType getResourceType(IFileInfo fInfo) {
        if (fInfo.getAttribute(32)) {
            return ResourceType.SYMBOLIC_LINK;
        }
        return fInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
    }

    private boolean isSameType(IVersionableHandle handle, IFileInfo info) {
        if (info.getAttribute(32)) {
            return handle instanceof ISymbolicLinkHandle;
        }
        if (info.isDirectory()) {
            return handle instanceof IFolderHandle;
        }
        return handle instanceof IFileItemHandle;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return this.childNamesInternal(false, options, monitor);
    }

    public String[] childNamesInternal(boolean isNested, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (!this.trackingChanges()) {
                String[] stringArray = this.baseStore.childNames(options, (IProgressMonitor)progress.newChild(100));
                return stringArray;
            }
            IFileInfo[] childInfos = this.childInfosInternal(isNested, options, (IProgressMonitor)progress.newChild(100));
            String[] names = new String[childInfos.length];
            int i = childInfos.length - 1;
            while (i >= 0) {
                names[i] = childInfos[i].getName();
                --i;
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        return this.childStoresInternal(false, options, monitor);
    }

    public ManagedFileStore[] childStoresInternal(boolean isNested, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            String[] childNames = this.childNamesInternal(isNested, options, (IProgressMonitor)progress.newChild(100));
            ManagedFileStore[] childStores = new ManagedFileStore[childNames.length];
            int i = childStores.length - 1;
            while (i >= 0) {
                childStores[i] = new ManagedFileStore(this.cfaPath, this.localPath.append(childNames[i]), this.baseStore.getChild(childNames[i]));
                --i;
            }
            ManagedFileStore[] managedFileStoreArray = childStores;
            return managedFileStoreArray;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        this.baseStore.copy(destination, options, monitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        if (this.trackingChanges()) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                CFALockUtil.LockResult lock = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, true, (IProgressMonitor)progress.newChild(1));
                try {
                    this.baseStore.delete(options, (IProgressMonitor)progress.newChild(60));
                    if (lock.code == 0) {
                        this.updateMetadataForDeletion(progress);
                        return;
                    }
                    if (lock.code != 2) return;
                    this.requestBackgroundMetadataUpdate(false);
                    return;
                }
                finally {
                    if (lock != null) {
                        CFALockUtil.endBatching(lock, progress.newChild(1));
                    }
                }
            }
            finally {
                ManagedFileStore.done(monitor);
            }
        } else {
            this.baseStore.delete(options, monitor);
        }
    }

    private void updateMetadataForDeletion(SubMonitor progress) throws FileSystemClientException {
        SharingManager sm = SharingManager.getInstance();
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
        Sandbox sandbox = new Sandbox(cfa);
        Share share = cfa.getShare(this.localPath);
        if (share != null) {
            FileItemInfo info = cfa.getItemInfo(this.localPath);
            if (info != null) {
                Shareable shareable = sm.findShareable(sandbox, this.localPath, ResourceType.getResourceType(info.getVersionableHandle()));
                if (shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(10))) {
                    return;
                }
                if (share.getPath().segmentCount() == this.localPath.segmentCount()) {
                    cfa.forget(this.localPath, (IProgressMonitor)progress.newChild(28));
                } else {
                    cfa.deleteTreeInfo(this.localPath, false, (IProgressMonitor)progress.newChild(28));
                }
            }
        } else {
            Collection<IPath> shareRoots = cfa.allSharePaths(this.localPath);
            SubMonitor deletionMonitor = progress.newChild(38);
            deletionMonitor.setWorkRemaining(shareRoots.size());
            for (IPath root : shareRoots) {
                Shareable shareable;
                SubMonitor iterationProgress = deletionMonitor.newChild(1).setWorkRemaining(2);
                FileItemInfo info = cfa.getItemInfo(root);
                if (info == null || (shareable = sm.findShareable(sandbox, root, ResourceType.getResourceType(info.getVersionableHandle()))).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                cfa.forget(root, (IProgressMonitor)iterationProgress.newChild(1));
            }
            deletionMonitor.done();
        }
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return this.fetchInfoInternal(false, options, monitor);
    }

    public static IFolderHandle createFolderHierarchyUpToParentOf(IPath path, Share share, CopyFileArea cfa, boolean checkIgnore, IProgressMonitor monitor) throws CoreException {
        IPath parentPath;
        SubMonitor iterationProgress;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        int numSegInShare = share.getPath().segmentCount();
        int numSegInPath = path.segmentCount();
        int max = numSegInPath - numSegInShare;
        if (max <= 0) {
            progress.done();
            return null;
        }
        SharingManager sm = SharingManager.getInstance();
        Sandbox sandbox = new Sandbox(cfa);
        if (share.getSharingDescriptor().getRootVersionable() instanceof ISymbolicLinkHandle) {
            progress.done();
            return null;
        }
        if (!(share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle)) {
            Shareable shareable;
            if (checkIgnore && (shareable = (Shareable)sm.findShareable(share.getPath(), ResourceType.getResourceType(share.getSharingDescriptor().getRootVersionable()))).shouldBeIgnored((IProgressMonitor)progress.newChild(30))) {
                progress.done();
                return null;
            }
            cfa.deleteTreeInfo(share.getPath(), false, (IProgressMonitor)progress.newChild(70));
            progress.done();
            return null;
        }
        IFolderHandle parent = null;
        SubMonitor subProgress = progress.newChild(50);
        subProgress.setWorkRemaining(max);
        int i = 1;
        while (i <= max) {
            iterationProgress = subProgress.newChild(1).setWorkRemaining(2);
            parentPath = path.removeLastSegments(i);
            FileItemInfo parentInfo = cfa.getItemInfo(parentPath);
            if (parentInfo != null) {
                if (parentInfo.isSymbolicLink()) {
                    progress.done();
                    return null;
                }
                if (!parentInfo.isFolder()) {
                    Shareable shareable;
                    if (checkIgnore && (shareable = (Shareable)sm.findShareable(parentPath, ResourceType.getResourceType(parentInfo.getVersionableHandle()))).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) {
                        progress.done();
                        return null;
                    }
                    cfa.deleteTreeInfo(parentPath, false, (IProgressMonitor)iterationProgress.newChild(1));
                    if (i != max) {
                        parent = (IFolderHandle)cfa.getItemInfo(parentPath.removeLastSegments(1)).getVersionableHandle();
                    }
                    ++i;
                    break;
                }
                parent = (IFolderHandle)parentInfo.getVersionableHandle();
                break;
            }
            ++i;
        }
        subProgress.done();
        subProgress = progress.newChild(50);
        subProgress.setWorkRemaining(i - 1);
        while (i != 1) {
            iterationProgress = subProgress.newChild(1).setWorkRemaining(2);
            parentPath = path.removeLastSegments(--i);
            Shareable parentShareable = sm.findShareable(sandbox, parentPath, ResourceType.FOLDER);
            if (checkIgnore && parentShareable.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) {
                progress.done();
                return null;
            }
            if (parentShareable.getFileStorage().getResourceType((IProgressMonitor)iterationProgress.newChild(1)) == ResourceType.SYMBOLIC_LINK) {
                share.getTracker().trackSymbolicLinkAddition(parent, parentShareable, (IProgressMonitor)iterationProgress.newChild(1));
                parent = null;
                break;
            }
            share.getTracker().trackFolderAddition(parent, parentShareable, (IProgressMonitor)iterationProgress.newChild(1));
            parent = (IFolderHandle)cfa.getItemInfo(parentPath).getVersionableHandle();
        }
        subProgress.done();
        progress.done();
        return parent;
    }

    public IFileInfo fetchInfoInternal(boolean isNested, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress;
        block18: {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (this.trackingChanges()) {
                try {
                    IFileInfo iFileInfo;
                    block17: {
                        if (monitor == null) {
                            this.requestBackgroundMetadataUpdate(false);
                            IFileInfo iFileInfo2 = this.baseStore.fetchInfo(options, monitor);
                            return iFileInfo2;
                        }
                        CFALockUtil.LockResult lock = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, false, (IProgressMonitor)progress.newChild(1));
                        try {
                            IFileInfo info = this.baseStore.fetchInfo(options, (IProgressMonitor)progress.newChild(40));
                            if (lock.code == 0) {
                                ManagedFileStore.updateMetadata(this, info, (IProgressMonitor)progress.newChild(58));
                            } else if (lock.code == 2) {
                                this.requestBackgroundMetadataUpdate(false);
                            }
                            iFileInfo = info;
                            if (lock == null) break block17;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (lock != null) {
                                    CFALockUtil.endBatching(lock, progress.newChild(1));
                                }
                                throw throwable;
                            }
                            catch (RuntimeException e) {
                                this.handleException(isNested, e);
                                break block18;
                            }
                            catch (CoreException e) {
                                this.handleException(isNested, e);
                                break block18;
                            }
                        }
                        CFALockUtil.endBatching(lock, progress.newChild(1));
                    }
                    return iFileInfo;
                }
                finally {
                    ManagedFileStore.done(monitor);
                }
            }
        }
        progress.setWorkRemaining(45);
        return this.baseStore.fetchInfo(options, (IProgressMonitor)progress.newChild(45));
    }

    public boolean ensureMetadataUpToDate(boolean includeElement, boolean includeChildren, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        CFALockUtil.LockResult lock = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, true, (IProgressMonitor)progress.newChild(10));
        try {
            if (lock.code != 0) {
                throw new OperationCanceledException();
            }
            boolean result = false;
            if (includeElement) {
                IFileInfo info = this.baseStore.fetchInfo(0, (IProgressMonitor)progress.newChild(20));
                result |= ManagedFileStore.updateMetadata(this, info, (IProgressMonitor)progress.newChild(20));
            }
            if (includeChildren) {
                IFileInfo[] infos = this.baseStore.childInfos(0, (IProgressMonitor)progress.newChild(20));
                result |= this.updateMetadataForChildren(infos, progress.newChild(20));
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (lock != null) {
                CFALockUtil.endBatching(lock, progress.newChild(10));
            }
            progress.done();
        }
    }

    public static boolean updateMetadata(ManagedFileStore store, IFileInfo info, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IPath cfaPath = store.getCfaPath();
        IPath localPath = store.getLocalPath();
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaPath);
        SharingManager sm = SharingManager.getInstance();
        Sandbox sandbox = new Sandbox(cfa);
        Shareable shareable = sm.findShareable(sandbox, localPath, info.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
        Share share = cfa.getShare(localPath);
        if (shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(30))) {
            if (share != null && info.exists()) {
                if (!info.isDirectory()) {
                    ManagedFileStore.createFolderHierarchyUpToParentOf(localPath, share, cfa, true, (IProgressMonitor)progress.newChild(28));
                } else {
                    ManagedFileStore.createFolderHierarchyUpToParentOf(localPath.append("a"), share, cfa, true, (IProgressMonitor)progress.newChild(28));
                }
            }
            return false;
        }
        if (share != null) {
            if (!info.exists() && !info.getAttribute(32)) {
                return cfa.deleteTreeInfo(localPath, false, (IProgressMonitor)progress.newChild(28));
            }
            FileItemInfo fInfo = cfa.getItemInfo(localPath);
            if (fInfo == null) {
                IPath path;
                IFolderHandle parent = null;
                int numSeg = share.getPath().segmentCount();
                if (localPath.segmentCount() != numSeg) {
                    parent = ManagedFileStore.createFolderHierarchyUpToParentOf(localPath, share, cfa, false, (IProgressMonitor)progress.newChild(20));
                    if (parent == null) {
                        return true;
                    }
                    if (!(share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle)) {
                        return true;
                    }
                } else if (share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle != info.isDirectory()) {
                    return false;
                }
                progress.setWorkRemaining(21);
                IPath iPath = path = localPath.segmentCount() == 0 ? localPath : localPath.removeLastSegments(1).append(info.getName());
                if (info.getAttribute(32)) {
                    share.getTracker().trackSymbolicLinkAddition(parent, sm.findShareable(sandbox, path, info.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE), (IProgressMonitor)progress.newChild(10));
                } else if (info.isDirectory()) {
                    share.getTracker().trackFolderAddition(parent, sm.findShareable(sandbox, path, ResourceType.FOLDER), (IProgressMonitor)progress.newChild(10));
                } else {
                    share.getTracker().trackFileAddition(parent, sm.findShareable(sandbox, path, ResourceType.FILE), (IProgressMonitor)progress.newChild(10));
                }
                if (numSeg != 0 && numSeg == localPath.segmentCount() && !info.getName().equals(share.getPath().lastSegment())) {
                    cfa.moveSharingInfo(share.getPath(), share.getPath().removeLastSegments(1).append(info.getName()), (IProgressMonitor)progress.newChild(10));
                }
                return true;
            }
            if (!ManagedFileStore.isSameType(info, fInfo)) {
                cfa.deleteTreeInfo(localPath, false, (IProgressMonitor)progress.newChild(18));
                if (localPath.segmentCount() != share.getPath().segmentCount()) {
                    IFolderHandle parent = (IFolderHandle)cfa.getItemInfo(localPath.removeLastSegments(1)).getVersionableHandle();
                    if (info.getAttribute(32)) {
                        share.getTracker().trackSymbolicLinkAddition(parent, sm.findShareable(sandbox, localPath.removeLastSegments(1).append(info.getName()), info.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE), (IProgressMonitor)progress.newChild(10));
                    } else if (info.isDirectory()) {
                        share.getTracker().trackFolderAddition(parent, sm.findShareable(sandbox, localPath.removeLastSegments(1).append(info.getName()), ResourceType.FOLDER), (IProgressMonitor)progress.newChild(10));
                    } else {
                        share.getTracker().trackFileAddition(parent, sm.findShareable(sandbox, localPath.removeLastSegments(1).append(info.getName()), ResourceType.FILE), (IProgressMonitor)progress.newChild(10));
                    }
                }
                return true;
            }
            if (fInfo.isSymbolicLink()) {
                boolean contentChanged = LocalChangeTracker.contentChanged(fInfo, info.getStringAttribute(64));
                boolean nonShareRootNameChange = false;
                boolean changed = false;
                if (localPath.segmentCount() == share.getPath().segmentCount()) {
                    if (localPath.segmentCount() != 0 && !share.getPath().lastSegment().equals(info.getName())) {
                        cfa.moveSharingInfo(share.getPath(), share.getPath().removeLastSegments(1).append(info.getName()), (IProgressMonitor)progress.newChild(1));
                        changed = true;
                    }
                } else {
                    ISharingDescriptor desc = share.getSharingDescriptor();
                    InverseFileItemInfo inverseInfo = cfa.getItemInfo(fInfo.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                    boolean bl = nonShareRootNameChange = !inverseInfo.getLocalName().equals(info.getName());
                }
                if (nonShareRootNameChange || contentChanged != fInfo.isContentChanged()) {
                    progress.setWorkRemaining(11);
                    cfa.setItemInfo(localPath.removeLastSegments(1).append(info.getName()), new FileItemInfo((ISymbolicLinkHandle)fInfo.getVersionableHandle(), contentChanged, fInfo.getParent(), fInfo.getName(), fInfo.isLoadedWithAnotherName(), fInfo.getHash(), fInfo.getStoredHash()), (IProgressMonitor)progress.newChild(10));
                    changed = true;
                }
                return changed;
            }
            if (fInfo.isFile()) {
                boolean contentChanged = ManagedFileStore.contentChanged(store, info, fInfo, share, shareable.getFileStorage(), progress.newChild(15));
                boolean executable = shareable.getFileStorage().supportsExecBit() ? info.getAttribute(4) : fInfo.isExecutable();
                long checkStamp = fInfo.getVersionableHandle().hasStateId() ? shareable.getFileStorage().getModificationStamp() : -1L;
                boolean nonShareRootNameChange = false;
                boolean changed = false;
                if (localPath.segmentCount() == share.getPath().segmentCount()) {
                    if (localPath.segmentCount() != 0 && !share.getPath().lastSegment().equals(info.getName())) {
                        cfa.moveSharingInfo(share.getPath(), share.getPath().removeLastSegments(1).append(info.getName()), (IProgressMonitor)progress.newChild(1));
                        changed = true;
                    }
                } else {
                    ISharingDescriptor desc = share.getSharingDescriptor();
                    InverseFileItemInfo inverseInfo = cfa.getItemInfo(fInfo.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                    boolean bl = nonShareRootNameChange = !inverseInfo.getLocalName().equals(info.getName());
                }
                if (nonShareRootNameChange || contentChanged != fInfo.isContentChanged() || executable != fInfo.isExecutable() || checkStamp != fInfo.getLastContentChangeCheckStamp()) {
                    progress.setWorkRemaining(11);
                    cfa.setItemInfo(localPath.removeLastSegments(1).append(info.getName()), new FileItemInfo(fInfo.getVersionableHandle(), contentChanged, checkStamp, fInfo.getParent(), fInfo.getName(), fInfo.isLoadedWithAnotherName(), fInfo.getHash(), fInfo.getContentLength(), fInfo.getOriginalLineDelimiter(), fInfo.getLineDelimiter(), fInfo.getOriginalContentType(), fInfo.getContentType(), fInfo.getStoredPredecessorHintHash(), fInfo.getStoredSize(), fInfo.getStoredEncoding(), fInfo.getStoredHash(), fInfo.getStoredNumLineDelimiters(), executable, fInfo.isOriginalExecutable()), (IProgressMonitor)progress.newChild(10));
                    changed = true;
                }
                return changed;
            }
            if (localPath.segmentCount() == share.getPath().segmentCount()) {
                if (localPath.segmentCount() != 0 && !share.getPath().lastSegment().equals(info.getName())) {
                    cfa.moveSharingInfo(share.getPath(), share.getPath().removeLastSegments(1).append(info.getName()), (IProgressMonitor)progress.newChild(28));
                    return true;
                }
            } else {
                ISharingDescriptor desc = share.getSharingDescriptor();
                InverseFileItemInfo inverseInfo = cfa.getItemInfo(fInfo.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                if (!inverseInfo.getLocalName().equals(info.getName())) {
                    cfa.setItemInfo(localPath.removeLastSegments(1).append(info.getName()), fInfo, (IProgressMonitor)progress.newChild(28));
                    return true;
                }
            }
        } else {
            Collection<IPath> shareRoots = cfa.allSharePaths(localPath);
            if (!info.exists() || !info.isDirectory()) {
                SubMonitor deletionMonitor = progress.newChild(28);
                deletionMonitor.setWorkRemaining(shareRoots.size());
                for (IPath root : shareRoots) {
                    Shareable rootShareable;
                    SubMonitor iterationProgress = deletionMonitor.newChild(1).setWorkRemaining(2);
                    FileItemInfo fInfo = cfa.getItemInfo(root);
                    if (fInfo == null || (rootShareable = sm.findShareable(sandbox, root, ResourceType.getResourceType(fInfo.getVersionableHandle()))).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                    cfa.deleteTreeInfo(root, false, (IProgressMonitor)iterationProgress.newChild(1));
                    return true;
                }
                deletionMonitor.done();
            } else {
                int segNum = localPath.segmentCount() - 1;
                boolean changed = false;
                if (segNum >= 0) {
                    SubMonitor shareMoveMonitor = progress.newChild(28);
                    shareMoveMonitor.setWorkRemaining(shareRoots.size());
                    for (IPath root : shareRoots) {
                        ISharingDescriptor desc;
                        Shareable rootShareable;
                        SubMonitor iterationProgress = shareMoveMonitor.newChild(1).setWorkRemaining(2);
                        if (root.segment(segNum).equals(info.getName()) || (rootShareable = sm.findShareable(sandbox, root, ResourceType.getResourceType((desc = cfa.getSharingInfo(root)).getRootVersionable()))).shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                        IPath newPath = root.removeLastSegments(root.segmentCount() - segNum).append(info.getName()).append(root.removeFirstSegments(segNum + 1));
                        cfa.moveSharingInfo(root, newPath, (IProgressMonitor)iterationProgress.newChild(1));
                        changed = true;
                    }
                }
                return changed;
            }
        }
        return false;
    }

    private static boolean isSameType(IFileInfo info, FileItemInfo fInfo) {
        if (info.getAttribute(32)) {
            return fInfo.isSymbolicLink();
        }
        if (info.isDirectory()) {
            return fInfo.isFolder();
        }
        return fInfo.isFile();
    }

    private static boolean contentChanged(ManagedFileStore store, IFileInfo info, FileItemInfo fiInfo, Share share, IFileStorage storage, SubMonitor progress) throws CoreException {
        ContentHash newHash;
        if (fiInfo == null || fiInfo.getHash() == null) {
            return false;
        }
        if (info.getLength() != fiInfo.getContentLength()) {
            return true;
        }
        if (fiInfo.getLastContentChangeCheckStamp() != -1L && fiInfo.getLastContentChangeCheckStamp() == storage.getModificationStamp() && storage.getLocalTimeStamp() == info.getLastModified()) {
            return fiInfo.isContentChanged();
        }
        IVersionableHandle item = fiInfo.getVersionableHandle();
        IComponentHandle component = share.getSharingDescriptor().getComponent();
        IContextHandle connection = share.getSharingDescriptor().getConnectionHandle();
        if (share.getTracker().containsDatelessVersionable(info.getLastModified(), item, component, connection)) {
            return fiInfo.isContentChanged();
        }
        progress.beginTask(Messages.ManagedFileStore_1, 100);
        try {
            InputStream in = store.openInputStream(0, (IProgressMonitor)progress.newChild(50));
            try {
                newHash = ContentHash.valueOf((InputStream)in);
                in.close();
                in = null;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                    }
                    catch (RuntimeException runtimeException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        catch (ContentHashAlgorithmException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)e));
        }
        boolean isSame = newHash.equals((Object)fiInfo.getHash());
        share.getTracker().registerDatelessVersionable(info.getLastModified(), item, component, connection);
        return !isSame;
    }

    public ManagedFileStore getChild(IPath path) {
        return new ManagedFileStore(this.cfaPath, this.localPath.append(path), this.baseStore.getChild(path));
    }

    public ManagedFileStore getChild(String name) {
        return new ManagedFileStore(this.cfaPath, this.localPath.append(name), this.baseStore.getChild(name));
    }

    public ManagedFileSystem getFileSystem() {
        return ManagedFileSystem.getInstance();
    }

    public String getName() {
        return this.baseStore.getName();
    }

    public ManagedFileStore getParent() {
        if (this.localPath.segmentCount() == 0) {
            return null;
        }
        IFileStore baseParent = this.baseStore.getParent();
        if (baseParent == null) {
            return null;
        }
        return new ManagedFileStore(this.cfaPath, this.localPath.removeLastSegments(1), baseParent);
    }

    public boolean isParentOf(IFileStore other) {
        if (!(other instanceof ManagedFileStore)) {
            return false;
        }
        ManagedFileStore otherStore = (ManagedFileStore)other;
        if (!ManagedFileStore.equal(this.cfaPath, otherStore.cfaPath) || !ManagedFileStore.isPrefixOf(this.localPath, otherStore.localPath)) {
            return false;
        }
        IFileStore s = this.baseStore;
        if (this.localPath.segmentCount() != otherStore.localPath.segmentCount()) {
            s.getChild(otherStore.localPath.removeFirstSegments(this.localPath.segmentCount()).setDevice(null));
        }
        return otherStore.baseStore.equals(s);
    }

    private static boolean isPrefixOf(IPath p1, IPath p2) {
        if (!ManagedFileSystem.getInstance().isCaseSensitive()) {
            p1 = new Path(p1.toString().toUpperCase().toLowerCase());
            p2 = new Path(p2.toString().toUpperCase().toLowerCase());
        }
        return p1.equals((Object)p2);
    }

    private static boolean equal(IPath p1, IPath p2) {
        if (!ManagedFileSystem.getInstance().isCaseSensitive()) {
            p1 = new Path(p1.toString().toUpperCase().toLowerCase());
            p2 = new Path(p2.toString().toUpperCase().toLowerCase());
        }
        return p1.equals((Object)p2);
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        if (this.trackingChanges()) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                AbstractLock lock = CFALockUtil.createAndLockForUpdate(this.cfaPath, this.localPath, true, (IProgressMonitor)progress.newChild(1));
                try {
                    this.baseStore.mkdir(options, (IProgressMonitor)progress.newChild(70));
                    if (lock == null) {
                        this.requestBackgroundMetadataUpdate(false);
                    }
                    CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
                    Share share = cfa.getShare(this.localPath);
                    ManagedFileStore.createFolderHierarchyUpToParentOf(this.localPath.append("a"), share, cfa, true, (IProgressMonitor)progress.newChild(28));
                }
                finally {
                    if (lock != null) {
                        CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                    }
                }
            }
            finally {
                ManagedFileStore.done(monitor);
            }
        } else {
            this.baseStore.mkdir(options, monitor);
        }
        return this;
    }

    private static void moveMetadata(IPath sourcePath, Share sourceShare, ManagedFileStore managedDestination, CopyFileArea cfa, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)110);
        IPath destinationPath = managedDestination.localPath;
        SharingManager sm = SharingManager.getInstance();
        Sandbox sandbox = new Sandbox(cfa);
        FileItemInfo info = cfa.getItemInfo(sourcePath);
        ResourceType hint = info == null ? ResourceType.FOLDER : ResourceType.getResourceType(info.getVersionableHandle());
        Shareable sourceShareable = sm.findShareable(sandbox, sourcePath, hint);
        Shareable targetShareable = sm.findShareable(sandbox, destinationPath, hint);
        boolean sourceIgnored = sourceShareable.shouldBeIgnored((IProgressMonitor)progress.newChild(10));
        Share targetShare = cfa.getShare(destinationPath);
        boolean moved = false;
        if (!sourceIgnored && targetShare == null) {
            Collection<IPath> roots = cfa.allSharePaths(destinationPath);
            if (roots.isEmpty()) {
                if (sourceShare.getPath().segmentCount() == sourcePath.segmentCount() && !targetShareable.shouldBeIgnored((IProgressMonitor)progress.newChild(10))) {
                    cfa.moveSharingInfo(sourcePath, destinationPath, (IProgressMonitor)progress.newChild(90));
                    moved = true;
                }
            } else {
                SubMonitor subProgress = progress.newChild(90);
                subProgress.setWorkRemaining(roots.size());
                for (IPath root : roots) {
                    SubMonitor iterationProgress = subProgress.newChild(1).setWorkRemaining(2);
                    ISharingDescriptor desc = cfa.getSharingInfo(root);
                    IPath srcPath = sourcePath.append(root.removeFirstSegments(destinationPath.segmentCount()));
                    Shareable rootTargetShareable = sm.findShareable(sandbox, root, ResourceType.getResourceType(desc.getRootVersionable()));
                    if (rootTargetShareable.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                    FileItemInfo srcInfo = cfa.getItemInfo(srcPath);
                    if (srcInfo == null) {
                        cfa.deleteTreeInfo(root, false, (IProgressMonitor)iterationProgress.newChild(1));
                        continue;
                    }
                    if (desc.getConnectionHandle().sameItemId((IItemHandle)sourceShare.getSharingDescriptor().getConnectionHandle()) && desc.getComponent().sameItemId((IItemHandle)sourceShare.getSharingDescriptor().getComponent())) {
                        if (srcInfo.isFolder() != desc.getRootVersionable() instanceof IFolderHandle) {
                            cfa.deleteTreeInfo(root, false, (IProgressMonitor)iterationProgress.newChild(1));
                            continue;
                        }
                        if (srcInfo.isFolder()) {
                            SubMonitor subSubProgress = iterationProgress.newChild(1);
                            subSubProgress.setWorkRemaining(100);
                            targetShare.getTracker().trackFolderAddition(null, rootTargetShareable, (IProgressMonitor)subSubProgress.newChild(10));
                            Map<StringWrapper, FileItemInfo> infoMap = cfa.getChildInfos(srcPath, (IProgressMonitor)subSubProgress.newChild(10));
                            subSubProgress.setWorkRemaining(infoMap.size());
                            for (Map.Entry<StringWrapper, FileItemInfo> e : infoMap.entrySet()) {
                                FileItemInfo childInfo;
                                SubMonitor subIterationProgress = subSubProgress.newChild(1).setWorkRemaining(2);
                                String name = e.getKey().toString();
                                IPath sourceChildPath = srcPath.append(name);
                                IPath targetChildPath = root.append(name);
                                Shareable childTargetShareable = sm.findShareable(sandbox, targetChildPath, ResourceType.getResourceType((childInfo = e.getValue()).getVersionableHandle()));
                                if (childTargetShareable.shouldBeIgnored((IProgressMonitor)subIterationProgress.newChild(1))) continue;
                                cfa.moveTreeInfo(sourceChildPath, targetChildPath, false, (IProgressMonitor)subIterationProgress.newChild(1));
                            }
                            continue;
                        }
                        if (srcInfo.isFile()) {
                            targetShare.getTracker().trackFileAddition(null, rootTargetShareable, (IProgressMonitor)iterationProgress.newChild(1));
                            continue;
                        }
                        if (!srcInfo.isSymbolicLink()) continue;
                        targetShare.getTracker().trackSymbolicLinkAddition(null, rootTargetShareable, (IProgressMonitor)iterationProgress.newChild(1));
                        continue;
                    }
                    ManagedFileStore.refreshSubtree(managedDestination.getChild(root.removeFirstSegments(destinationPath.segmentCount())), (IProgressMonitor)iterationProgress.newChild(1));
                }
                subProgress.done();
            }
        } else if (!sourceIgnored && targetShare != null && targetShare.getSharingDescriptor().getConnectionHandle().sameItemId((IItemHandle)sourceShare.getSharingDescriptor().getConnectionHandle()) && targetShare.getSharingDescriptor().getComponent().sameItemId((IItemHandle)sourceShare.getSharingDescriptor().getComponent())) {
            if (sourcePath.segmentCount() == sourceShare.getPath().segmentCount() && sourceShare.getSharingDescriptor().getRootVersionable().sameItemId((IItemHandle)targetShare.getSharingDescriptor().getRootVersionable())) {
                if (!targetShareable.shouldBeIgnored((IProgressMonitor)progress.newChild(50))) {
                    if (!sourcePath.equals((Object)destinationPath)) {
                        cfa.moveSharingInfo(sourcePath, destinationPath, (IProgressMonitor)progress.newChild(50));
                    }
                    moved = true;
                }
            } else if (sourcePath.segmentCount() == sourceShare.getPath().segmentCount() || destinationPath.segmentCount() == targetShare.getPath().segmentCount()) {
                if (!(targetShareable.shouldBeIgnored((IProgressMonitor)progress.newChild(10)) || info == null || destinationPath.segmentCount() == targetShare.getPath().segmentCount() && info.getVersionableHandle().getItemType() != targetShare.getSharingDescriptor().getRootVersionable().getItemType())) {
                    if (info.isFolder()) {
                        targetShare.getTracker().trackFolderAddition(null, targetShareable, (IProgressMonitor)progress.newChild(10));
                        Map<StringWrapper, FileItemInfo> infoMap = cfa.getChildInfos(sourcePath, (IProgressMonitor)progress.newChild(10));
                        SubMonitor subProgress = progress.newChild(60);
                        subProgress.setWorkRemaining(infoMap.size());
                        for (Map.Entry<StringWrapper, FileItemInfo> e : infoMap.entrySet()) {
                            FileItemInfo childInfo;
                            SubMonitor iterationProgress = subProgress.newChild(1).setWorkRemaining(2);
                            String name = e.getKey().toString();
                            IPath sourceChildPath = sourcePath.append(name);
                            IPath targetChildPath = destinationPath.append(name);
                            Shareable childTargetShareable = sm.findShareable(sandbox, targetChildPath, ResourceType.getResourceType((childInfo = e.getValue()).getVersionableHandle()));
                            if (childTargetShareable.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                            cfa.moveTreeInfo(sourceChildPath, targetChildPath, false, (IProgressMonitor)iterationProgress.newChild(1));
                        }
                    } else {
                        targetShare.getTracker().trackFileAddition(null, targetShareable, (IProgressMonitor)progress.newChild(90));
                    }
                }
            } else if (!targetShareable.shouldBeIgnored((IProgressMonitor)progress.newChild(50))) {
                cfa.moveTreeInfo(sourcePath, destinationPath, false, (IProgressMonitor)progress.newChild(50));
                moved = true;
            }
        } else if (targetShare != null) {
            ManagedFileStore.refreshSubtree(managedDestination, (IProgressMonitor)progress.newChild(90));
        } else {
            Collection<IPath> roots = cfa.allSharePaths(destinationPath);
            SubMonitor subProgress = progress.newChild(90);
            subProgress.setWorkRemaining(roots.size());
            for (IPath root : roots) {
                ManagedFileStore.refreshSubtree(managedDestination.getChild(root.removeFirstSegments(destinationPath.segmentCount())), (IProgressMonitor)subProgress.newChild(1));
            }
            subProgress.done();
        }
        if (!moved && !sourceIgnored && info != null) {
            cfa.deleteTreeInfo(sourcePath, false, (IProgressMonitor)progress.newChild(10));
        }
        progress.done();
    }

    /*
     * Unable to fully structure code
     */
    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            block28: {
                source = this.getCanonicalFileStore((IFileStore)this, progress.newChild(1));
                if (!source.equals((Object)this) && !(baseInfo = this.baseStore.fetchInfo(0, (IProgressMonitor)progress.newChild(1))).getAttribute(32)) {
                    source.move(destination, options, (IProgressMonitor)progress.newChild(99));
lbl6:
                    // 7 sources

                    return;
                }
                destination = this.getCanonicalFileStore(destination, progress.newChild(1));
                managedDestination = null;
                if (destination instanceof ManagedFileStore) {
                    managedDestination = (ManagedFileStore)destination;
                    destination = managedDestination.baseStore;
                }
                if (this.trackingChanges()) break block28;
                this.moveBaseStore(destination, options, progress.newChild(100));
                ** GOTO lbl6
            }
            lock = managedDestination == null ? CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, true, (IProgressMonitor)progress.newChild(1)) : CFALockUtil.createAndLockForUpdateOfChildren(Arrays.asList(new IPath[]{this.cfaPath, managedDestination.cfaPath}), Arrays.asList(new IPath[]{this.localPath, managedDestination.localPath}), true, (IProgressMonitor)progress.newChild(1));
            try {
                block29: {
                    this.moveBaseStore(destination, options, progress.newChild(50));
                    if (lock.code == 0) break block29;
                    if (lock.code != 2) ** GOTO lbl6
                    this.requestBackgroundMetadataUpdate(false);
                    if (managedDestination == null) ** GOTO lbl6
                    MetadataUpdateJob.queueUpdate(managedDestination, false);
                    ** GOTO lbl6
                }
                progress.setWorkRemaining(49);
                sm = SharingManager.getInstance();
                sourceCFA = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
                sourceSandbox = new Sandbox(sourceCFA);
                sourceShare = sourceCFA.getShare(this.localPath);
                targetCFA = null;
                targetShare = null;
                if (managedDestination != null) {
                    targetCFA = CopyFileAreaManager.instance.getExistingCopyFileArea(managedDestination.cfaPath);
                    targetShare = targetCFA.getShare(managedDestination.localPath);
                }
                if (sourceShare != null) {
                    ManagedFileStore.createFolderHierarchyUpToParentOf(this.localPath, sourceShare, sourceCFA, true, (IProgressMonitor)progress.newChild(10));
                }
                progress.setWorkRemaining(39);
                if (targetShare != null) {
                    ManagedFileStore.createFolderHierarchyUpToParentOf(managedDestination.localPath, targetShare, targetCFA, true, (IProgressMonitor)progress.newChild(10));
                }
                progress.setWorkRemaining(29);
                if (managedDestination == null || sourceCFA != targetCFA) {
                    if (sourceShare == null) {
                        roots = sourceCFA.allSharePaths(this.localPath);
                        subProgress = progress.newChild(28);
                        subProgress.setWorkRemaining(roots.size());
                        for (IPath root : roots) {
                            iterationProgress = subProgress.newChild(1).setWorkRemaining(2);
                            desc = sourceCFA.getSharingInfo(root);
                            sourceShareable = sm.findShareable(sourceSandbox, this.localPath, ResourceType.getResourceType(desc.getRootVersionable()));
                            if (sourceShareable.shouldBeIgnored((IProgressMonitor)iterationProgress.newChild(1))) continue;
                            sourceCFA.deleteTreeInfo(root, false, (IProgressMonitor)iterationProgress.newChild(1));
                        }
                        subProgress.done();
                    } else {
                        info = sourceCFA.getItemInfo(this.localPath);
                        if (info != null && !(sourceShareable = sm.findShareable(sourceSandbox, this.localPath, ResourceType.getResourceType(info.getVersionableHandle()))).shouldBeIgnored((IProgressMonitor)progress.newChild(8))) {
                            sourceCFA.deleteTreeInfo(this.localPath, false, (IProgressMonitor)progress.newChild(20));
                        }
                    }
                    if (managedDestination != null) {
                        if (targetShare != null) {
                            ManagedFileStore.refreshSubtree(managedDestination, (IProgressMonitor)progress.newChild(28));
                        } else {
                            roots = targetCFA.allSharePaths(managedDestination.localPath);
                            subProgress = progress.newChild(28);
                            subProgress.setWorkRemaining(roots.size());
                            for (IPath root : roots) {
                                ManagedFileStore.refreshSubtree(managedDestination.getChild(root.removeFirstSegments(managedDestination.localPath.segmentCount())), (IProgressMonitor)subProgress.newChild(1));
                            }
                            subProgress.done();
                        }
                    }
                } else if (sourceShare == null) {
                    roots = sourceCFA.allSharePaths(this.localPath);
                    subProgress = progress.newChild(28);
                    subProgress.setWorkRemaining(roots.size());
                    for (IPath root : roots) {
                        share = sourceCFA.getShare(root);
                        ManagedFileStore.moveMetadata(root, share, managedDestination.getChild(root.removeFirstSegments(this.localPath.segmentCount())), sourceCFA, (IProgressMonitor)subProgress.newChild(1));
                    }
                    subProgress.done();
                } else {
                    ManagedFileStore.moveMetadata(this.localPath, sourceShare, managedDestination, sourceCFA, (IProgressMonitor)progress.newChild(28));
                }
            }
            finally {
                if (lock == null) ** GOTO lbl6
                CFALockUtil.endBatching(lock, progress.newChild(1));
                ** continue;
            }
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    private void moveBaseStore(IFileStore destination, int options, SubMonitor progress) throws CoreException {
        if (!this.baseStore.toURI().equals(destination.toURI())) {
            progress.setWorkRemaining(100);
            IFileInfo targetInfo = destination.fetchInfo(0, (IProgressMonitor)progress.newChild(10));
            if (targetInfo.getAttribute(32) || targetInfo.exists() && !this.isSameFile(this.baseStore, destination, progress.newChild(2))) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ManagedFileStore_9, (Object)destination.toLocalFile(0, (IProgressMonitor)progress.newChild(10)).getAbsolutePath()), null));
            }
            try {
                this.baseStore.move(destination, options & 0xFFFFFFFD, (IProgressMonitor)progress.newChild(70));
            }
            catch (CoreException e) {
                IFileInfo destInfo;
                IFileInfo sourceInfo;
                if (e.getStatus().getCode() == 272 && !(sourceInfo = this.baseStore.fetchInfo(0, (IProgressMonitor)progress.newChild(10))).exists() && !sourceInfo.getAttribute(32) && !(destInfo = destination.fetchInfo(0, (IProgressMonitor)progress.newChild(10))).exists() && destInfo.getAttribute(32)) {
                    return;
                }
                throw e;
            }
        }
    }

    private boolean isSameFile(IFileStore s1, IFileStore s2, SubMonitor monitor) throws CoreException {
        monitor.setWorkRemaining(2);
        File file1 = s1.toLocalFile(0, (IProgressMonitor)monitor.newChild(1));
        if (file1 == null) {
            return false;
        }
        File file2 = s2.toLocalFile(0, (IProgressMonitor)monitor.newChild(1));
        if (file2 == null) {
            return false;
        }
        try {
            return file1.getCanonicalFile().equals(file2.getCanonicalFile());
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
        }
    }

    private IFileStore getCanonicalFileStore(IFileStore destination, SubMonitor progress) throws CoreException {
        try {
            File localFile = destination.toLocalFile(0, (IProgressMonitor)progress);
            File cf = localFile.getCanonicalFile();
            if (cf.equals(localFile)) {
                return destination;
            }
            Path path = new Path(cf.getAbsolutePath());
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath((IPath)path);
            if (cfa != null) {
                IPath rootPath = cfa.getRoot();
                return new ManagedFileStore(rootPath, path.removeFirstSegments(rootPath.segmentCount()).makeRelative(), EFS.getLocalFileSystem().fromLocalFile(cf));
            }
            return EFS.getLocalFileSystem().fromLocalFile(cf);
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
        }
    }

    private static void refreshSubtree(ManagedFileStore root, IProgressMonitor mon) throws CoreException {
        Sandbox sandbox;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        progress.setTaskName(Messages.ManagedFileStore_3);
        IFileInfo info = root.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
        if (!info.exists()) {
            return;
        }
        SharingManager sm = SharingManager.getInstance();
        Shareable shareable = sm.findShareable(sandbox = new Sandbox(CopyFileAreaManager.instance.getExistingCopyFileArea(root.cfaPath)), root.localPath, info.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
        if (shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(10))) {
            return;
        }
        ArrayList<ManagedFileStore> toVisit = new ArrayList<ManagedFileStore>();
        toVisit.add(root);
        do {
            int idx = toVisit.size() - 1;
            progress.setWorkRemaining(idx + 2);
            ManagedFileStore fs = (ManagedFileStore)((Object)toVisit.remove(idx));
            IFileInfo[] children = fs.childInfos(0, (IProgressMonitor)progress.newChild(1));
            progress.setWorkRemaining(idx + children.length + 2);
            IFileInfo[] iFileInfoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileInfo child = iFileInfoArray[n2];
                shareable = sm.findShareable(sandbox, fs.localPath.append(child.getName()), child.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
                if (!shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(1))) {
                    toVisit.add(fs.getChild(child.getName()));
                }
                ++n2;
            }
        } while (!toVisit.isEmpty());
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.openInputStream(options, monitor);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        if (!this.trackingChanges()) {
            return this.baseStore.openOutputStream(options, monitor);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            OutputStream outputStream;
            block16: {
                CFALockUtil.LockResult lock;
                block12: {
                    OutputStream outputStream2;
                    block15: {
                        block13: {
                            FilterOutputStream filterOutputStream;
                            block14: {
                                lock = CFALockUtil.createAndLockForUpdateOfChildren(this.cfaPath, this.localPath, true, (IProgressMonitor)progress.newChild(1));
                                try {
                                    if (lock.code == 0) break block12;
                                    if (lock.code != 2) break block13;
                                    OutputStream out = this.baseStore.openOutputStream(options, (IProgressMonitor)progress.newChild(99));
                                    filterOutputStream = new FilterOutputStream(out){

                                        public void close() throws IOException {
                                            super.close();
                                            ManagedFileStore.this.requestBackgroundMetadataUpdate(true);
                                        }
                                    };
                                    if (lock == null) break block14;
                                }
                                catch (Throwable throwable) {
                                    if (lock != null) {
                                        CFALockUtil.endBatching(lock, progress.newChild(1));
                                    }
                                    throw throwable;
                                }
                                CFALockUtil.endBatching(lock, progress.newChild(1));
                            }
                            return filterOutputStream;
                        }
                        outputStream2 = this.baseStore.openOutputStream(options, (IProgressMonitor)progress.newChild(99));
                        if (lock == null) break block15;
                        CFALockUtil.endBatching(lock, progress.newChild(1));
                    }
                    return outputStream2;
                }
                outputStream = this.openOutputStreamInternal(options, progress.newChild(99));
                if (lock == null) break block16;
                CFALockUtil.endBatching(lock, progress.newChild(1));
            }
            return outputStream;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    private OutputStream openOutputStreamInternal(int options, SubMonitor progress) throws CoreException, FileSystemClientException {
        progress.setWorkRemaining(99);
        Object out = this.baseStore.openOutputStream(options, (IProgressMonitor)progress.newChild(70));
        try {
            MessageDigest cs;
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.cfaPath);
            SharingManager sm = SharingManager.getInstance();
            Sandbox sandbox = new Sandbox(cfa);
            Share share = cfa.getShare(this.localPath);
            if (share == null) {
                Collection<IPath> shareRoots = cfa.allSharePaths(this.localPath);
                progress.setWorkRemaining(shareRoots.size() * 2);
                for (IPath root : shareRoots) {
                    ISharingDescriptor desc;
                    Shareable shareable = sm.findShareable(sandbox, root, ResourceType.getResourceType((desc = cfa.getSharingInfo(root)).getRootVersionable()));
                    if (shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(1))) continue;
                    cfa.deleteTreeInfo(root, false, (IProgressMonitor)progress.newChild(1));
                }
                OutputStream outputStream = out;
                return outputStream;
            }
            Shareable shareable = sm.findShareable(sandbox, this.localPath, ResourceType.FILE);
            if (shareable.shouldBeIgnored((IProgressMonitor)progress.newChild(10))) {
                ManagedFileStore.createFolderHierarchyUpToParentOf(this.localPath, share, cfa, true, (IProgressMonitor)progress.newChild(19));
                OutputStream outputStream = out;
                return outputStream;
            }
            if (share.getPath().segmentCount() == this.localPath.segmentCount() && share.getSharingDescriptor().getRootVersionable() instanceof IFolderHandle) {
                cfa.deleteTreeInfo(this.localPath, false, (IProgressMonitor)progress.newChild(29));
                OutputStream outputStream = out;
                return outputStream;
            }
            progress.setWorkRemaining(100);
            IFileInfo info = this.baseStore.fetchInfo(0, (IProgressMonitor)progress.newChild(5));
            FileItemInfo fInfo = cfa.getItemInfo(this.localPath);
            IFolderHandle parent = ManagedFileStore.createFolderHierarchyUpToParentOf(this.localPath, share, cfa, false, (IProgressMonitor)progress.newChild(1));
            if (parent == null && share.getPath().segmentCount() != this.localPath.segmentCount()) {
                OutputStream outputStream = out;
                return outputStream;
            }
            if (fInfo != null && fInfo.isSymbolicLink()) {
                OutputStream outputStream = out;
                return outputStream;
            }
            if (fInfo == null) {
                if (share.getPath().segmentCount() == this.localPath.segmentCount()) {
                    ISharingDescriptor desc = share.getSharingDescriptor();
                    InverseFileItemInfo inverse = cfa.getItemInfo(desc.getRootVersionable(), desc.getComponent(), desc.getConnectionHandle());
                    if (inverse != null && inverse.getHash() != null) {
                        fInfo = new FileItemInfo(fInfo.getVersionableHandle(), true, -1L, fInfo.getParent(), fInfo.getName(), fInfo.isLoadedWithAnotherName(), fInfo.getHash(), fInfo.getContentLength(), fInfo.getOriginalLineDelimiter(), fInfo.getOriginalLineDelimiter(), fInfo.getOriginalContentType(), fInfo.getOriginalContentType(), fInfo.getStoredPredecessorHintHash(), fInfo.getStoredSize(), fInfo.getStoredEncoding(), fInfo.getStoredHash(), fInfo.getStoredNumLineDelimiters(), info.getAttribute(4), fInfo.isOriginalExecutable());
                        cfa.setItemInfo(this.localPath, fInfo, (IProgressMonitor)progress.newChild(5));
                    }
                } else {
                    FileItemInfo parentInfo = cfa.getItemInfo(this.localPath.removeLastSegments(1));
                    if (parentInfo != null && parentInfo.getVersionableHandle().hasStateId() && (fInfo = cfa.getDeletedItem((IFolderHandle)parentInfo.getVersionableHandle(), this.localPath.lastSegment(), share.getSharingDescriptor().getComponent(), share.getSharingDescriptor().getConnectionHandle(), (IProgressMonitor)progress.newChild(5))) != null) {
                        if (fInfo.getVersionableHandle() instanceof IFileItemHandle) {
                            fInfo = new FileItemInfo(fInfo.getVersionableHandle(), true, -1L, fInfo.getParent(), fInfo.getName(), fInfo.isLoadedWithAnotherName(), fInfo.getHash(), fInfo.getContentLength(), fInfo.getOriginalLineDelimiter(), fInfo.getOriginalLineDelimiter(), fInfo.getOriginalContentType(), fInfo.getOriginalContentType(), fInfo.getStoredPredecessorHintHash(), fInfo.getStoredSize(), fInfo.getStoredEncoding(), fInfo.getStoredHash(), fInfo.getStoredNumLineDelimiters(), info.getAttribute(4), fInfo.isOriginalExecutable());
                            cfa.setItemInfo(this.localPath, fInfo, (IProgressMonitor)progress.newChild(5));
                        } else {
                            fInfo = null;
                        }
                    }
                }
            }
            try {
                cs = ContentHash.getHashDigest();
            }
            catch (ContentHashAlgorithmException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)e));
            }
            if (fInfo != null && fInfo.getHash() != null && (options & 1) != 0 && info.getLength() < fInfo.getContentLength()) {
                InputStream in = this.baseStore.openInputStream(0, (IProgressMonitor)progress.newChild(5));
                try {
                    try {
                        byte[] buf = new byte[8192];
                        int len = in.read(buf);
                        while (len != -1) {
                            cs.update(buf, 0, len);
                            len = in.read(buf);
                        }
                        in.close();
                        in = null;
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)e));
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            LoggingHelper.log(FileSystemStatus.getStatusFor(e));
                        }
                    }
                }
                progress.setWorkRemaining(95);
            }
            if (fInfo != null) {
                ContentHash targetHash = fInfo.getHash();
                if (targetHash != null) {
                    if ((options & 1) != 0) {
                        if (info.getLength() <= fInfo.getContentLength()) {
                            out = new ChangeTrackingOutputStream(cs, (OutputStream)out, this, (IFileItemHandle)fInfo.getVersionableHandle(), share, targetHash, fInfo.getContentLength() - info.getLength());
                        } else {
                            Assert.isTrue((boolean)fInfo.isContentChanged());
                        }
                    } else {
                        out = new ChangeTrackingOutputStream(cs, (OutputStream)out, this, (IFileItemHandle)fInfo.getVersionableHandle(), share, targetHash, fInfo.getContentLength());
                    }
                }
            } else {
                share.getTracker().trackFileAddition(parent, shareable, (IProgressMonitor)progress.newChild(25));
            }
            OutputStream outputStream = out;
            return outputStream;
        }
        catch (CoreException e) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw e;
        }
        catch (RuntimeException e) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw e;
        }
        finally {
            progress.done();
        }
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean needRefresh = (options & 0x400) != 0 && this.trackingChanges();
        this.baseStore.putInfo(info, options, (IProgressMonitor)progress.newChild(needRefresh ? 50 : 100));
        if (needRefresh) {
            this.fetchInfo(0, (IProgressMonitor)progress.newChild(50));
        }
    }

    public URI toURI() {
        return ManagedFileSystem.getCanonicalManagedURI(this.cfaPath, this.localPath, this.baseStore.toURI());
    }

    public IFileStore getBaseStore() {
        return this.baseStore;
    }

    public IPath getLocalPath() {
        return this.localPath;
    }

    public IPath getCfaPath() {
        return this.cfaPath;
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.toLocalFile(options, monitor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ManagedFileStore)) {
            return false;
        }
        ManagedFileStore store = (ManagedFileStore)((Object)obj);
        return ManagedFileStore.equal(this.cfaPath, store.cfaPath) && ManagedFileStore.equal(store.localPath, this.localPath) && store.baseStore.equals(this.baseStore);
    }

    public String toString() {
        return this.baseStore.toString();
    }

    public int hashCode() {
        IPath p1 = this.cfaPath;
        IPath p2 = this.localPath;
        if (!ManagedFileSystem.getInstance().isCaseSensitive()) {
            p1 = new Path(p1.toString().toUpperCase().toLowerCase());
            p2 = new Path(p2.toString().toUpperCase().toLowerCase());
        }
        return p1.hashCode() ^ p2.hashCode() ^ this.baseStore.hashCode();
    }
}

