/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalFileStorage
extends FileStorage {
    protected static final Method canExecute;
    protected static final Method setExecutable;
    protected static final Method setWritableMethod;
    private final File file;

    static {
        Method m = null;
        try {
            m = File.class.getMethod("canExecute", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        canExecute = m;
        m = null;
        try {
            m = File.class.getMethod("setExecutable", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        setExecutable = m;
        m = null;
        try {
            m = File.class.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        setWritableMethod = m;
    }

    LocalFileStorage(IFileStorage storage) {
        super(storage);
        this.file = storage.getShareable().getCopyFileAreaRoot().append(storage.getShareable().getLocalPath()).toFile();
    }

    LocalFileStorage(ISandbox sandbox, IPath localPath, ResourceType hint) {
        super(new FileStorageWrapper(sandbox, localPath, hint));
        this.file = sandbox.getRoot().append(localPath).toFile();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public long getModificationStamp() {
        long result = this.file.lastModified();
        if (result == 0L) {
            return this.getFileStore().fetchInfo().exists() ? 0L : -1L;
        }
        return result;
    }

    @Override
    public long getLocalTimeStamp() {
        return this.file.lastModified();
    }

    @Override
    public IFileStorage getParent() {
        FileStorageWrapper parent = null;
        IPath parentPath = this.getLocalPath().removeLastSegments(1);
        if (parentPath.segmentCount() != 0) {
            Shareable parentShareable = new Shareable(this.getSandbox(), parentPath, ResourceType.FOLDER);
            parent = new FileStorageWrapper(parentShareable, ResourceType.FOLDER);
        }
        return parent;
    }

    @Override
    public void resolveChildStorage(FileStorageWrapper childStorage, String name, ResourceType type) {
        if (this.file.isDirectory()) {
            File childFile = new File(this.file, name);
            if (childFile.exists()) {
                String caseCorrectName = name;
                if (!this.getSandbox().isCaseSensitive()) {
                    File[] children;
                    File[] fileArray = children = this.file.listFiles();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        if (child.getName().equalsIgnoreCase(name)) {
                            caseCorrectName = child.getName();
                        }
                        ++n2;
                    }
                    if (!caseCorrectName.equals(name)) {
                        childStorage = new FileStorageWrapper(this.getSandbox(), this.getLocalPath().append(caseCorrectName), type);
                    }
                }
                SharingManager.getInstance().resolveFileStorage(childStorage, type);
            } else {
                childStorage.setUnderlyingStorage(new LocalFileStorage(childStorage));
            }
        } else {
            throw new IllegalStateException(NLS.bind((String)Messages.LocalFileStorage_7, (Object)name, (Object[])new Object[]{childStorage.getShareable().getLocalPath().toOSString()}));
        }
    }

    @Override
    public Collection<IFileStorage> getChildren(IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            IFileInfo fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
            if (!fileInfo.isDirectory() || fileInfo.getAttribute(32)) {
                return null;
            }
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.LocalFileStorage_8, (Object)this.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
        }
        finally {
            sm.enableChangeMonitoring();
        }
        File[] listing = this.file.listFiles();
        if (listing == null) {
            return null;
        }
        ArrayList<IFileStorage> children = new ArrayList<IFileStorage>(listing.length);
        ISandbox sandbox = this.getSandbox();
        IPath path = this.getLocalPath();
        File[] fileArray = listing;
        int n = listing.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            ResourceType type = child.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
            Shareable childShareable = new Shareable(sandbox, path.append(child.getName()), type);
            FileStorageWrapper storage = new FileStorageWrapper(childShareable, this.getStorage(), type);
            children.add(storage);
            ++n2;
        }
        return children;
    }

    @Override
    public InputStream getContents(boolean force) throws FileSystemClientException {
        return this.getContents();
    }

    @Override
    public InputStream getContents() throws FileSystemClientException {
        if (this.file.isDirectory()) {
            return null;
        }
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 203, Messages.LocalFileStorage_1, e));
        }
    }

    @Override
    public void create(InputStream in, IProgressMonitor monitor) throws FileSystemClientException {
        this.setContents(in, false, monitor);
    }

    @Override
    public void create(boolean createParents, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        try {
            try {
                this.getFileStore().mkdir(createParents ? 0 : 4, (IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.LocalFileStorage_2, (Object)this.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setContents(InputStream in, boolean force, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            if (this.file.isDirectory()) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                    }
                }
                throw new FileSystemClientException(new FileSystemStatus(Messages.LocalFileStorage_3));
            }
            boolean success = false;
            try {
                try {
                    OutputStream out = this.getFileStore().openOutputStream(0, (IProgressMonitor)progress.newChild(1));
                    try {
                        if (in != null) {
                            byte[] buf = new byte[8192];
                            int size = in.read(buf);
                            while (size != -1) {
                                out.write(buf, 0, size);
                                size = in.read(buf);
                            }
                        }
                        success = true;
                    }
                    finally {
                        block28: {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                if (!success) break block28;
                                success = false;
                                throw e;
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                }
                catch (CoreException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                }
            }
            finally {
                block29: {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            if (!success) break block29;
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                        }
                    }
                }
            }
        }
        finally {
            progress.done();
        }
    }

    @Override
    public void setContents(InputStream in, Shed backupShed, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            if (this.file.isDirectory()) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                    }
                }
                throw new FileSystemClientException(new FileSystemStatus(Messages.LocalFileStorage_3));
            }
            boolean success = false;
            try {
                try {
                    backupShed.backupIfDirty(this.getStorage().getShareable(), (IProgressMonitor)progress.newChild(1));
                    OutputStream out = this.getFileStore().openOutputStream(0, (IProgressMonitor)progress.newChild(1));
                    try {
                        if (in != null) {
                            byte[] buf = new byte[8192];
                            int size = in.read(buf);
                            while (size != -1) {
                                out.write(buf, 0, size);
                                size = in.read(buf);
                            }
                        }
                        success = true;
                    }
                    finally {
                        block28: {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                if (!success) break block28;
                                success = false;
                                throw e;
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                }
                catch (CoreException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                }
            }
            finally {
                block29: {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            if (!success) break block29;
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                        }
                    }
                }
            }
        }
        finally {
            progress.done();
        }
    }

    @Override
    public IPath getIDEPath() {
        return new Path(this.file.getPath());
    }

    @Override
    public String getActualName() {
        String[] potentialNames;
        if (this.getSandbox().isCaseSensitive()) {
            return this.file.getName();
        }
        String expectedName = this.file.getName();
        File parent = this.file.getParentFile();
        if (parent != null && (potentialNames = this.file.getParentFile().list()) != null) {
            String[] stringArray = potentialNames;
            int n = potentialNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equalsIgnoreCase(expectedName)) {
                    return name;
                }
                ++n2;
            }
        }
        return this.file.getName();
    }

    @Override
    public boolean isExecutable(IProgressMonitor monitor) throws FileSystemClientException {
        if (canExecute != null) {
            try {
                return (Boolean)canExecute.invoke((Object)this.file, new Object[0]);
            }
            catch (IllegalAccessException e) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(e));
            }
            catch (InvocationTargetException e) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(e.getTargetException()));
            }
        }
        IFileStore store = EFS.getLocalFileSystem().fromLocalFile(this.file);
        IFileInfo info = store.fetchInfo();
        return info.getAttribute(4);
    }

    @Override
    public boolean setExecutable(boolean exec, IProgressMonitor monitor) {
        if (setExecutable != null) {
            try {
                return (Boolean)setExecutable.invoke((Object)this.file, exec);
            }
            catch (IllegalAccessException e) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(e));
            }
            catch (InvocationTargetException e) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(e.getTargetException()));
            }
        }
        IFileStore store = EFS.getLocalFileSystem().fromLocalFile(this.file);
        IFileInfo info = store.fetchInfo();
        info.setAttribute(4, exec);
        try {
            store.putInfo(info, 1024, monitor);
        }
        catch (CoreException e) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(e));
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsExecBit() {
        return setExecutable != null && canExecute != null && FileStorage.PLATFORM_SUPPORTS_EXEC_BIT || (EFS.getLocalFileSystem().attributes() & 4) != 0;
    }

    @Override
    public void move(FileStorage targetStorage, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        try {
            try {
                IFileStore managedFileStore = this.getFileStore();
                managedFileStore.move(targetStorage.getFileStore(), 0, (IProgressMonitor)progress.newChild(1));
                targetStorage.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)progress.newChild(1));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
            }
        }
        finally {
            progress.done();
        }
    }

    @Override
    protected final IFileStore getFileStore() {
        return new ManagedFileStore(this.getSandbox().getRoot(), this.getLocalPath(), EFS.getLocalFileSystem().getStore(this.getStorage().getShareable().getFullPath()));
    }

    @Override
    public void delete(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                if (this.storageExists((IProgressMonitor)progress.newChild(1))) {
                    this.preserveHistory((IProgressMonitor)progress.newChild(1));
                    this.getFileStore().delete(0, (IProgressMonitor)progress.newChild(98));
                }
            }
            catch (CoreException e) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.LocalFileStorage_6, (Object)this.file.getPath(), (Object[])new Object[0]), (Throwable)e);
            }
        }
        finally {
            progress.done();
        }
    }

    @Override
    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            MultiRule multi = (MultiRule)rule;
            ISchedulingRule[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (!(rule instanceof IFileStorage)) {
            return false;
        }
        return this.getIDEPath().isPrefixOf(((IFileStorage)rule).getIDEPath());
    }

    @Override
    public boolean isConflicting(ISchedulingRule rule) {
        if (!(rule instanceof IFileStorage)) {
            return false;
        }
        IPath otherPath = ((IFileStorage)rule).getShareable().getFullPath();
        IPath fullPath = this.getStorage().getShareable().getFullPath();
        return fullPath.isPrefixOf(otherPath) || otherPath.isPrefixOf(fullPath);
    }

    public String toString() {
        return this.getIDEPath().toString();
    }

    @Override
    public void refreshCachedSubTree(int depth, IProgressMonitor monitor) throws FileSystemClientException {
    }

    @Override
    public Object getAdapter(Class adaptTo) {
        if (adaptTo.isAssignableFrom(File.class)) {
            return this.file;
        }
        return null;
    }

    @Override
    public void deregisterRepositoryProvider(IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<IFileStorage> children = this.getChildren((IProgressMonitor)progress.newChild(1));
        if (children != null) {
            progress.setWorkRemaining(2 * children.size());
            for (IFileStorage child : children) {
                if (child.getResourceType((IProgressMonitor)progress.newChild(1)) != ResourceType.FOLDER) continue;
                child.deregisterRepositoryProvider((IProgressMonitor)progress.newChild(1));
            }
        }
    }

    @Override
    public void registerRepositorProvider(IProgressMonitor monitor) throws FileSystemClientException {
    }

    @Override
    public boolean isRepositoryProviderRegistered(IProgressMonitor monitor) throws FileSystemClientException {
        return false;
    }

    @Override
    public void preserveHistory(IProgressMonitor monitor) throws TeamRepositoryException {
    }

    @Override
    public URI getLocationURI() {
        String path = this.file.getAbsolutePath();
        String realPath = PathUtils.getRealPath(path);
        if (realPath != null) {
            path = realPath;
        }
        return URIUtil.toURI((String)path);
    }

    @Override
    public ISchedulingRule getResourceRuleForIDE(ISharingManager.RuleKind kind) {
        return null;
    }

    @Override
    public void backup(Shed shed, BackupDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        shed.backupInShed(this.getStorage().getShareable(), monitor);
    }

    @Override
    public boolean storageExists(IProgressMonitor progress) throws FileSystemClientException {
        return this.getStorage().exists(progress);
    }

    @Override
    public boolean setWritable(boolean writable, IProgressMonitor progress) {
        boolean success;
        block10: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)30);
            IFileStore fileStorage = this.getFileStore();
            success = false;
            if ((fileStorage.getFileSystem().attributes() & 2) != 0) {
                SharingManager sm = SharingManager.getInstance();
                sm.disableChangeMonitoring();
                try {
                    try {
                        IFileInfo fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(10));
                        fileInfo.setAttribute(2, false);
                        fileStorage.putInfo(fileInfo, 0, (IProgressMonitor)monitor.newChild(10));
                        fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(10));
                        success = !fileInfo.getAttribute(2);
                    }
                    catch (CoreException coreException) {
                        sm.enableChangeMonitoring();
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    sm.enableChangeMonitoring();
                    throw throwable;
                }
                sm.enableChangeMonitoring();
            }
        }
        if (!success && setWritableMethod != null) {
            try {
                success = (Boolean)setWritableMethod.invoke((Object)writable, true);
            }
            catch (IllegalAccessException e) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(e));
            }
            catch (InvocationTargetException e) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(e.getTargetException()));
            }
        }
        return success;
    }
}

