/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SymLinkHelper;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;

class JavaSymLinkHelper
extends SymLinkHelper {
    private static final String altSeparator = File.separator.equals("\\") ? "/" : null;

    static JavaSymLinkHelper newInstance() {
        return new JavaSymLinkHelper();
    }

    private JavaSymLinkHelper() {
    }

    public void createSymlink(String path, String targetPath) throws CoreException {
        throw new CoreException(FileSystemStatus.getStatusFor(4, Messages.ManagedFileStore_5, null));
    }

    public String getResolvedPath(String path) throws CoreException {
        File f = new File(path).getAbsoluteFile();
        File parent = f.getParentFile();
        while (parent != null) {
            if (!parent.isDirectory() && parent.exists()) {
                return null;
            }
            parent = parent.getParentFile();
        }
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
        }
        String result = f.getPath();
        if (path.endsWith(File.separator) || altSeparator != null && path.endsWith(altSeparator)) {
            if (!f.isDirectory() && f.exists()) {
                return null;
            }
            if (!result.endsWith(File.separator)) {
                result = String.valueOf(result) + File.separator;
            }
        }
        return result;
    }

    public boolean supportsSymLinks() {
        return false;
    }
}

