/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileStorage {
    public static final boolean PLATFORM_SUPPORTS_EXEC_BIT = !System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    private final IFileStorage storage;

    public FileStorage(IFileStorage storage) {
        this.storage = storage;
        ((FileStorageWrapper)storage).setUnderlyingStorage(this);
    }

    protected final ISandbox getSandbox() {
        return this.storage.getShareable().getSandbox();
    }

    protected final IPath getLocalPath() {
        return this.storage.getShareable().getLocalPath();
    }

    public final IFileStorage getStorage() {
        return this.storage;
    }

    public void lock(IProgressMonitor mon) {
    }

    public void unlock() {
    }

    public abstract void backup(Shed var1, BackupDilemmaHandler var2, IProgressMonitor var3) throws TeamRepositoryException, FileSystemClientException;

    public abstract void create(InputStream var1, IProgressMonitor var2) throws FileSystemClientException;

    public abstract void create(boolean var1, IProgressMonitor var2) throws FileSystemClientException;

    public abstract void delete(IProgressMonitor var1) throws FileSystemClientException, TeamRepositoryException;

    public abstract void deregisterRepositoryProvider(IProgressMonitor var1) throws FileSystemClientException;

    public abstract String getActualName();

    public abstract void resolveChildStorage(FileStorageWrapper var1, String var2, ResourceType var3);

    public abstract Collection<IFileStorage> getChildren(IProgressMonitor var1) throws FileSystemClientException;

    public abstract InputStream getContents() throws FileSystemClientException;

    public abstract InputStream getContents(boolean var1) throws FileSystemClientException;

    public abstract IPath getIDEPath();

    public abstract long getLocalTimeStamp();

    public abstract URI getLocationURI();

    public abstract long getModificationStamp();

    public abstract IFileStorage getParent();

    public abstract ISchedulingRule getResourceRuleForIDE(ISharingManager.RuleKind var1);

    public abstract boolean isExecutable(IProgressMonitor var1) throws FileSystemClientException;

    public abstract boolean isRepositoryProviderRegistered(IProgressMonitor var1) throws FileSystemClientException;

    public abstract void move(FileStorage var1, IProgressMonitor var2) throws FileSystemClientException;

    public abstract void preserveHistory(IProgressMonitor var1) throws TeamRepositoryException;

    public abstract void refreshCachedSubTree(int var1, IProgressMonitor var2) throws FileSystemClientException;

    public abstract void registerRepositorProvider(IProgressMonitor var1) throws FileSystemClientException;

    public boolean requiresBackup(IProgressMonitor monitor) throws FileSystemClientException {
        return false;
    }

    public abstract void setContents(InputStream var1, boolean var2, IProgressMonitor var3) throws FileSystemClientException;

    public abstract void setContents(InputStream var1, Shed var2, IProgressMonitor var3) throws FileSystemClientException, TeamRepositoryException;

    public abstract boolean setExecutable(boolean var1, IProgressMonitor var2);

    public abstract boolean storageExists(IProgressMonitor var1) throws FileSystemClientException;

    public abstract boolean supportsExecBit();

    public abstract boolean contains(ISchedulingRule var1);

    public abstract boolean isConflicting(ISchedulingRule var1);

    public abstract Object getAdapter(Class var1);

    public boolean shouldBeIgnored(IProgressMonitor monitor) {
        return IgnoreManager.getInstance().shouldBeIgnored(this.getStorage().getShareable(), monitor);
    }

    protected abstract IFileStore getFileStore();

    public abstract boolean setWritable(boolean var1, IProgressMonitor var2);
}

