/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ICorruptible;
import com.ibm.team.filesystem.client.internal.LockableMap;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiskBackedMapManager<K, V> {
    protected ReadWriteLock lock;
    protected Map<IPath, LockableMap<K, V>> inUse;
    protected AsyncSaveJob saveJob;
    protected Set<IPath> lockedExclusively = new HashSet<IPath>();
    protected final ICorruptible corruptible;

    public DiskBackedMapManager(ReadWriteLock lock, PersistentBusyFlag busyFlag, ICorruptible corruptible) {
        this.lock = lock;
        this.inUse = new HashMap<IPath, LockableMap<K, V>>();
        this.saveJob = new AsyncSaveJob(busyFlag);
        this.corruptible = corruptible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockableMap<K, V> loadMap(IPath path, boolean exclusive, IPath realPath) throws FileSystemClientException {
        this.lock.acquireRead();
        boolean success = false;
        try {
            LockableMap<K, V> map;
            Map<IPath, LockableMap<K, V>> map2 = this.inUse;
            synchronized (map2) {
                map = this.inUse.get(path);
                try {
                    if (map == null) {
                        map = this.getLockableMap(path, realPath);
                        this.inUse.put(path, map);
                        if (exclusive) {
                            this.setBusy();
                            this.lockedExclusively.add(path);
                        }
                    }
                }
                catch (DBHMException e) {
                    this.corruptible.setCorrupt(true, "Failure during load", e.getCause());
                    throw e;
                }
                catch (Exception e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.DiskBackedMapManager_1, (Throwable)e));
                }
            }
            this.saveJob.cancelSave(path);
            map.acquire(exclusive);
            success = true;
            LockableMap<K, V> lockableMap = map;
            return lockableMap;
        }
        finally {
            if (!success) {
                this.lock.release();
            }
        }
    }

    private void setBusy() {
        MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", -1, "Exception setting busy flag", null);
        this.saveJob.busyFlag.setBusy(multi);
        if (!multi.isOK()) {
            LoggingHelper.log((IStatus)multi);
        }
    }

    public void releaseMap(LockableMap<K, V> map) throws FileSystemClientException {
        if (map.release()) {
            this.saveJob.requestSave(map.getPath());
        }
        this.lock.release();
    }

    public void closeAll() throws FileSystemClientException {
        Assert.isTrue((this.lock.threadWrites() > 0 ? 1 : 0) != 0);
        MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, "Errors happening while saving map", null);
        Iterator<LockableMap<K, V>> i = this.inUse.values().iterator();
        while (i.hasNext()) {
            LockableMap<K, V> current = i.next();
            try {
                i.remove();
                current.close();
            }
            catch (DBHMException e) {
                this.corruptible.setCorrupt(true, "Failure during closeAll()", e.getCause());
                result.add(FileSystemStatus.getStatusFor(4, this.errorClosing(current), e.getCause()));
            }
            catch (IOException e) {
                result.add(FileSystemStatus.getStatusFor(4, this.errorClosing(current), (Throwable)e));
            }
        }
        this.lockedExclusively.clear();
        this.saveJob.busyFlag.setComplete(result);
        if (!result.isOK()) {
            throw new FileSystemClientException((IStatus)result);
        }
    }

    private String errorClosing(LockableMap<K, V> current) {
        return NLS.bind((String)"Error closing {0}", (Object)current.getPath(), (Object[])new Object[0]);
    }

    protected abstract LockableMap<K, V> getLockableMap(IPath var1, IPath var2);

    class AsyncSaveJob
    extends Job {
        private static final int SAVE_THRESHOLD = 1024;
        private static final int SCHEDULING_DELAY = 200;
        private Collection<IPath> toSave;
        private volatile long latestRequest;
        protected PersistentBusyFlag busyFlag;

        public AsyncSaveJob(PersistentBusyFlag busyFlag) {
            super("Saving metadata maps");
            this.toSave = new LinkedHashSet<IPath>();
            this.setUser(false);
            this.setSystem(true);
            this.busyFlag = busyFlag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestSave(IPath path) {
            Collection<IPath> collection = this.toSave;
            synchronized (collection) {
                this.toSave.add(path);
            }
            this.latestRequest = System.currentTimeMillis();
            this.schedule(200L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelSave(IPath path) {
            Collection<IPath> collection = this.toSave;
            synchronized (collection) {
                this.toSave.remove(path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            if (System.currentTimeMillis() - this.latestRequest < 200L) {
                boolean mustSave;
                Collection<IPath> collection = this.toSave;
                synchronized (collection) {
                    mustSave = this.toSave.size() > 1024;
                }
                if (!mustSave) {
                    this.schedule(200L);
                    return Status.CANCEL_STATUS;
                }
            }
            MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, "Errors happened while saving map", null);
            DiskBackedMapManager.this.lock.acquireWrite();
            try {
                IPath next;
                if (!this.busyFlag.isBusy() && !DiskBackedMapManager.this.lockedExclusively.isEmpty()) {
                    result.add((IStatus)new FileSystemStatus(NLS.bind((String)"Expected busyFlag to be set: {0}", (Object)this.busyFlag, (Object[])new Object[0])));
                }
                boolean saved = false;
                while ((next = this.getNext()) != null) {
                    LockableMap toSave = DiskBackedMapManager.this.inUse.remove(next);
                    DiskBackedMapManager.this.lockedExclusively.remove(next);
                    if (toSave == null) continue;
                    try {
                        toSave.close();
                        saved = true;
                    }
                    catch (DBHMException e) {
                        DiskBackedMapManager.this.corruptible.setCorrupt(true, "close() failed", e.getCause());
                        result.add(FileSystemStatus.getStatusFor(4, NLS.bind((String)"Error closing {0}", (Object)next, (Object[])new Object[0]), e.getCause()));
                    }
                    catch (IOException e) {
                        result.add(FileSystemStatus.getStatusFor(4, NLS.bind((String)"Error closing {0}", (Object)next, (Object[])new Object[0]), (Throwable)e));
                    }
                }
                if (DiskBackedMapManager.this.lockedExclusively.isEmpty() && (saved || !result.isOK())) {
                    this.busyFlag.setComplete(result);
                }
            }
            finally {
                DiskBackedMapManager.this.lock.release();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IPath getNext() {
            Collection<IPath> collection = this.toSave;
            synchronized (collection) {
                block4: {
                    if (!this.toSave.isEmpty()) break block4;
                    return null;
                }
                Iterator<IPath> i = this.toSave.iterator();
                IPath path = i.next();
                i.remove();
                return path;
            }
        }
    }
}

