/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.MarshallerImpl;
import com.ibm.team.repository.common.transport.internal.services.DataArg;
import com.ibm.team.repository.common.transport.internal.services.DataArgType;
import com.ibm.team.repository.common.transport.internal.services.NullDataArg;
import com.ibm.team.repository.common.transport.internal.services.PrimitiveArrayDataArg;
import com.ibm.team.repository.common.transport.internal.services.ServicesFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class PrimitiveArrayMarshaller
extends MarshallerImpl {
    public PrimitiveArrayMarshaller() {
        this.setSupportedType(String.class);
        this.setMarshallerType(MarshallerType.PRIMITIVE_ARRAY_LITERAL);
    }

    public DataArgType getSupportedDataArgType() {
        return DataArgType.PRIMITIVE_ARRAY_LITERAL;
    }

    public boolean canMarshal(Class type) {
        if (type.isArray()) {
            return String.class.isAssignableFrom(type.getComponentType());
        }
        return false;
    }

    public void marshalObjectToOutputStream(Object object, OutputStream outputStream) throws MarshallingException {
    }

    public void marshalObjectToOutputStream(Object object, OutputStream outputStream, Charset charset) throws MarshallingException {
    }

    public String marshalObjectToString(Object object) throws MarshallingException {
        return null;
    }

    public void marshalArrayToOutputStream(Object[] objects, OutputStream outputStream) throws MarshallingException {
    }

    public Object demarshalInputStreamToObject(InputStream inputStream) throws MarshallingException {
        return null;
    }

    public Object demarshalInputStreamToObject(InputStream inputStream, Charset charset) throws MarshallingException {
        return null;
    }

    public DataArg marshalObjectToDataArg(Object object) {
        if (object == null) {
            return this.createNullDataArg();
        }
        PrimitiveArrayDataArg primitiveArrayDataArg = ServicesFactory.eINSTANCE.createPrimitiveArrayDataArg();
        primitiveArrayDataArg.setType(DataArgType.STRING_LITERAL);
        String[] stringArray = (String[])object;
        int i = 0;
        while (i < stringArray.length) {
            if (stringArray[i] != null) {
                primitiveArrayDataArg.getValues().add((Object)stringArray[i]);
            }
            ++i;
        }
        if (stringArray.length != primitiveArrayDataArg.getValues().size()) {
            i = 0;
            while (i < stringArray.length) {
                int index = primitiveArrayDataArg.getValues().indexOf((Object)stringArray[i]);
                primitiveArrayDataArg.getIndices().add((Object)new Integer(index));
                ++i;
            }
        }
        return primitiveArrayDataArg;
    }

    private DataArg createNullDataArg() {
        NullDataArg nullDataArg = ServicesFactory.eINSTANCE.createNullDataArg();
        nullDataArg.setType(DataArgType.NULL_LITERAL);
        return nullDataArg;
    }

    public Object demarshalDataArgToObject(DataArg dataArg, Class type, List containedReferences) {
        return this.demarshalDataArgToObject(dataArg, type);
    }

    public Object demarshalDataArgToObject(DataArg dataArg, Class classZ) {
        PrimitiveArrayDataArg primitiveArrayDataArg = (PrimitiveArrayDataArg)dataArg;
        if (primitiveArrayDataArg.getIndices().size() > 0) {
            return this.demarshalDataArgToObjectUsingIndices(primitiveArrayDataArg, classZ);
        }
        EList values = primitiveArrayDataArg.getValues();
        String[] stringArrayParameter = new String[values.size()];
        int i = 0;
        while (i < values.size()) {
            stringArrayParameter[i] = (String)values.get(i);
            ++i;
        }
        return stringArrayParameter;
    }

    private Object demarshalDataArgToObjectUsingIndices(PrimitiveArrayDataArg primitiveArrayDataArg, Class classZ) {
        EList indices = primitiveArrayDataArg.getIndices();
        EList values = primitiveArrayDataArg.getValues();
        String[] stringArrayParameters = new String[indices.size()];
        int i = 0;
        while (i < indices.size()) {
            int index = (Integer)indices.get(i);
            stringArrayParameters[i] = index != -1 ? (String)values.get(index) : null;
            ++i;
        }
        return stringArrayParameters;
    }
}

