/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.PrimitiveTypeMarshallerImpl;
import com.ibm.team.repository.common.internal.util.SafeSimpleDataFormat;
import com.ibm.team.repository.common.transport.internal.services.DataArg;
import com.ibm.team.repository.common.transport.internal.services.DataArgType;
import com.ibm.team.repository.common.transport.internal.services.PrimitiveDataArg;
import com.ibm.team.repository.common.transport.internal.services.ServicesFactory;
import java.util.Date;

public class DateMarshaller
extends PrimitiveTypeMarshallerImpl {
    public DateMarshaller() {
        this.setSupportedType(Date.class);
        this.setMarshallerType(MarshallerType.TIMESTAMP_LITERAL);
    }

    public DataArgType getSupportedDataArgType() {
        return DataArgType.DATE_LITERAL;
    }

    public DataArg marshalObjectToDataArg(Object object) {
        PrimitiveDataArg primitiveDataArg = ServicesFactory.eINSTANCE.createPrimitiveDataArg();
        primitiveDataArg.setType(this.getSupportedDataArgType());
        if (object == null) {
            primitiveDataArg.setValue(null);
        } else {
            primitiveDataArg.setValue(SafeSimpleDataFormat.DATE_FORMATS[0].format(object));
        }
        return primitiveDataArg;
    }

    public String marshalObjectToString(Object object) throws MarshallingException {
        return SafeSimpleDataFormat.DATE_FORMATS[0].format(object);
    }

    public Object demarshalDataArgToObject(DataArg dataArg, Class classZ) {
        String stringValue = ((PrimitiveDataArg)dataArg).getValue();
        if (stringValue == null) {
            return null;
        }
        return this.demarshalObjectFromString(stringValue);
    }

    public Object demarshalObjectFromString(String value) {
        return SafeSimpleDataFormat.convertStringToDate((String)value);
    }
}

