/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.internal.marshal.MarshallerNotDefinedException;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.ComplexTypeMarshallerImpl;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.transport.internal.services.ComplexArrayDataArg;
import com.ibm.team.repository.common.transport.internal.services.DataArg;
import com.ibm.team.repository.common.transport.internal.services.DataArgType;
import com.ibm.team.repository.common.transport.internal.services.ServicesFactory;
import com.ibm.team.repository.common.util.NLS;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ComplexArrayMarshaller
extends ComplexTypeMarshallerImpl {
    public ComplexArrayMarshaller() {
        this.setSupportedType(EObject.class);
        this.setMarshallerType(MarshallerType.COMPLEX_ARRAY_LITERAL);
    }

    public DataArgType getSupportedDataArgType() {
        return DataArgType.EOBJECT_ARRAY_LITERAL;
    }

    public boolean canMarshal(Class type) {
        if (type.isArray()) {
            return EObject.class.isAssignableFrom(type.getComponentType());
        }
        return false;
    }

    public void marshalObjectToOutputStream(Object object, OutputStream outputStream) throws MarshallingException {
    }

    public void marshalObjectToOutputStream(Object object, OutputStream outputStream, Charset charset) throws MarshallingException {
    }

    public String marshalObjectToString(Object object) throws MarshallingException {
        return null;
    }

    public Object demarshalInputStreamToObject(InputStream inputStream) throws MarshallingException {
        return null;
    }

    public Object demarshalInputStreamToObject(InputStream inputStream, Charset charset) throws MarshallingException {
        return null;
    }

    public DataArg marshalObjectToDataArg(Object object) {
        ComplexArrayDataArg complexArrayDataArg = ServicesFactory.eINSTANCE.createComplexArrayDataArg();
        complexArrayDataArg.setType(DataArgType.COMPLEX_LITERAL);
        if (object == null) {
            return complexArrayDataArg;
        }
        Object[] eObjectArray = null;
        try {
            eObjectArray = (Object[])object;
        }
        catch (ClassCastException classCastException) {
            String pattern = Messages.getServerString("ComplexArrayMarshaller.MarshallerNotDefinedForType");
            String componentType = object.getClass().getComponentType().getName();
            String message = NLS.bind((String)pattern, (Object)(String.valueOf(componentType) + "[]"), (Object[])new Object[0]);
            throw new MarshallerNotDefinedException(message);
        }
        int i = 0;
        while (i < eObjectArray.length) {
            if (eObjectArray[i] != null) {
                complexArrayDataArg.getValues().add(eObjectArray[i]);
            }
            ++i;
        }
        if (eObjectArray.length != complexArrayDataArg.getValues().size()) {
            i = 0;
            while (i < eObjectArray.length) {
                int index = complexArrayDataArg.getValues().indexOf(eObjectArray[i]);
                complexArrayDataArg.getIndices().add((Object)new Integer(index));
                ++i;
            }
        }
        return complexArrayDataArg;
    }

    public Object demarshalDataArgToObject(DataArg dataArg, Class type) {
        ComplexArrayDataArg complexArrayDataArg = (ComplexArrayDataArg)dataArg;
        if (complexArrayDataArg.getIndices().size() > 0) {
            return this.demarshalDataArgToObjectArrayUsingIndices(complexArrayDataArg, type);
        }
        EList values = complexArrayDataArg.getValues();
        Class<?> componentType = type.getComponentType();
        Object[] eObjectParameter = null;
        try {
            eObjectParameter = (Object[])Array.newInstance(componentType, values.size());
        }
        catch (ClassCastException classCastException) {
            String pattern = Messages.getServerString("ComplexArrayMarshaller.MarshallerNotDefinedForType");
            String message = NLS.bind((String)pattern, (Object)type.getCanonicalName(), (Object[])new Object[0]);
            throw new MarshallerNotDefinedException(message);
        }
        int i = 0;
        while (i < values.size()) {
            eObjectParameter[i] = values.get(i);
            ++i;
        }
        return eObjectParameter;
    }

    private Object demarshalDataArgToObjectArrayUsingIndices(ComplexArrayDataArg complexArrayDataArg, Class type) {
        EList indices = complexArrayDataArg.getIndices();
        EList eObjectArray = complexArrayDataArg.getValues();
        Class<?> componentType = type.getComponentType();
        Object[] eObjectParameters = (Object[])Array.newInstance(componentType, indices.size());
        int i = 0;
        while (i < indices.size()) {
            int index = (Integer)indices.get(i);
            eObjectParameters[i] = index != -1 ? eObjectArray.get(index) : null;
            ++i;
        }
        return eObjectParameters;
    }
}

