/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.json.internal;

import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Serializer {
    private final Writer writer;

    public Serializer(Writer writer) {
        this.writer = writer;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public Serializer writeRawString(String s) throws IOException {
        this.writer.write(s);
        return this;
    }

    public Serializer writeNull() throws IOException {
        this.writeRawString(String.valueOf(null));
        return this;
    }

    public Serializer writeNumber(Number value) throws IOException {
        if (value == null) {
            return this.writeNull();
        }
        if (value instanceof Float) {
            if (Float.NaN == value.floatValue()) {
                return this.writeNull();
            }
            if (Float.NEGATIVE_INFINITY == value.floatValue()) {
                return this.writeNull();
            }
            if (Float.POSITIVE_INFINITY == value.floatValue()) {
                return this.writeNull();
            }
        }
        if (value instanceof Double) {
            if (Double.NaN == (double)value.floatValue()) {
                return this.writeNull();
            }
            if (Double.NEGATIVE_INFINITY == (double)value.floatValue()) {
                return this.writeNull();
            }
            if (Double.POSITIVE_INFINITY == (double)value.floatValue()) {
                return this.writeNull();
            }
        }
        return this.writeRawString(value.toString());
    }

    public Serializer writeBoolean(Boolean value) throws IOException {
        if (value == null) {
            return this.writeNull();
        }
        this.writeRawString(value.toString());
        return this;
    }

    private String rightAlignedZero(String s, int len) {
        if (len == s.length()) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s);
        while (sb.length() < len) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public Serializer writeString(String value) throws IOException {
        if (value == null) {
            return this.writeNull();
        }
        this.writer.write(34);
        char[] chars = value.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            switch (c) {
                case '\"': {
                    this.writer.write("\\\"");
                    break;
                }
                case '\\': {
                    this.writer.write("\\\\");
                    break;
                }
                case '\b': {
                    this.writer.write("\\b");
                    break;
                }
                case '\t': {
                    this.writer.write("\\t");
                    break;
                }
                case '\n': {
                    this.writer.write("\\n");
                    break;
                }
                case '\f': {
                    this.writer.write("\\f");
                    break;
                }
                case '\r': {
                    this.writer.write("\\r");
                    break;
                }
                case '/': {
                    this.writer.write("\\/");
                    break;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        this.writer.write(c);
                        break;
                    }
                    this.writer.write("\\u");
                    this.writer.write(this.rightAlignedZero(Integer.toHexString(c), 4));
                }
            }
            ++i;
        }
        this.writer.write(34);
        return this;
    }

    private Serializer write(Object object) throws IOException {
        if (object == null) {
            return this.writeNull();
        }
        if (object instanceof Number) {
            return this.writeNumber((Number)object);
        }
        if (object instanceof String) {
            return this.writeString((String)object);
        }
        if (object instanceof Boolean) {
            return this.writeBoolean((Boolean)object);
        }
        if (object instanceof JSONObject) {
            return this.writeObject((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            return this.writeArray((JSONArray)object);
        }
        throw new IOException(MessageFormat.format("Unsupported object for serialization: \"{0}\"", object));
    }

    public Serializer writeObject(JSONObject object) throws IOException {
        if (object == null) {
            return this.writeNull();
        }
        this.writeRawString("{");
        this.indentPush();
        List propertyNames = this.getPropertyNames(object);
        Iterator iter = propertyNames.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (!(key instanceof String)) {
                throw new IOException(MessageFormat.format("Invalid property name encountered while serializing: \"{0}\"", key));
            }
            Object value = object.get(key);
            if (!JSONObject.isValidObject(value)) {
                throw new IOException(MessageFormat.format("Invalid property value encountered while serializing: \"{0}\"", value));
            }
            this.newLine();
            this.indent();
            this.writeString((String)key);
            this.writeRawString(":");
            this.space();
            this.write(value);
            if (!iter.hasNext()) continue;
            this.writeRawString(",");
        }
        this.indentPop();
        this.newLine();
        this.indent();
        this.writeRawString("}");
        return this;
    }

    public Serializer writeArray(JSONArray value) throws IOException {
        if (value == null) {
            return this.writeNull();
        }
        this.writeRawString("[");
        this.indentPush();
        Iterator iter = value.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!JSONObject.isValidObject(element)) {
                throw new IOException(MessageFormat.format("Invalid element encountered while serializing array: \"{0}\"", value));
            }
            this.newLine();
            this.indent();
            this.write(element);
            if (!iter.hasNext()) continue;
            this.writeRawString(",");
        }
        this.indentPop();
        this.newLine();
        this.indent();
        this.writeRawString("]");
        return this;
    }

    public void space() throws IOException {
    }

    public void newLine() throws IOException {
    }

    public void indent() throws IOException {
    }

    public void indentPush() {
    }

    public void indentPop() {
    }

    public List getPropertyNames(Map map) {
        return new ArrayList(map.keySet());
    }
}

