@echo off

rem *******************************************************************************
rem Licensed Materials - Property of IBM
rem (c) Copyright IBM Corporation 2008. All Rights Reserved.
rem 
rem Note to U.S. Government Users Restricted Rights:  
rem Use, duplication or disclosure restricted by GSA ADP Schedule 
rem Contract with IBM Corp. 
rem *******************************************************************************
:: CQ Jazz Connector Sync Tool Launcher

rem -----------------------------------------------------------------------
rem Find the cqjni.jar file in the ClearQuest installation.
rem It should be one of the CLASSPATH elements.
rem -----------------------------------------------------------------------
setlocal
set LOCAL_CLASSPATH=%CLASSPATH%
set CQJNI_NAME=cqjni.jar
set CQJNI_PATH=

:loop
if not "%LOCAL_CLASSPATH%"=="" (
    for /f "delims=; tokens=1,*" %%i in ("%LOCAL_CLASSPATH%") do (
        if /i "%%~nxi"=="%CQJNI_NAME%" (
            set CQJNI_PATH=%%i
            set LOCAL_CLASSPATH=
        ) else (
            set LOCAL_CLASSPATH=%%j
        )
    )
    goto loop
)

rem -----------------------------------------------------------------------
rem If cqjni.jar wasn't on the CLASSPATH, construct path from
rem available environment variables
rem -----------------------------------------------------------------------
if "%CQJNI_PATH%"=="" (
    if defined CLEARQUEST_HOME (
        set CQJNI_PATH="%CLEARQUEST_HOME%"\%CQJNI_NAME%
    ) else (
        if defined RATIONAL_HOME (
            set CQJNI_PATH="%RATIONAL_HOME%"\ClearQuest\%CQJNI_NAME%
        ) else (
            if defined CQ_HOME (
                set CQJNI_PATH="%CQ_HOME%"\%CQJNI_NAME%
            )
        )
    )
)

if "%CQJNI_PATH%"=="" (
    echo Cannot find the ClearQuest Java native library %CQJNI_NAME%
    echo It must be in the CLASSPATH environment variable, or one of
    echo CLEARQUEST_HOME, RATIONAL_HOME, or CQ_HOME must be defined
    exit /b 1
)

if not exist "%CQJNI_PATH%" (
    echo The ClearQuest Java native library does not exist at "%CQJNI_PATH%"
    echo Check the CLASSPATH, CLEARQUEST_HOME, RATIONAL_HOME, or CQ_HOME environment variables
    exit /b 1
)

rem ----------------------------------------------------------
rem Copy the installed cqjni.jar into the CQ JNI plugin dir
rem ----------------------------------------------------------
set START_DIR=%~dp0
set CQ_JNI_PLUGIN_DIR=%START_DIR%..\synctool\plugins\com.rational.clearquest.cqjni.71_*\lib
cd "%CQ_JNI_PLUGIN_DIR%"
if %ERRORLEVEL% NEQ 0 (
    echo The "%CQ_JNI_PLUGIN_DIR%" directory does not exist
    exit /b 1
)

copy "%CQJNI_PATH%" /B . /Y /B
if %ERRORLEVEL% NEQ 0 (
    echo Problem copying "%CQJNI_PATH%" to "%CD%"
    exit /b 1
)

cd %START_DIR%

rem ----------------------------------------------------------
rem Launch the synctool application
rem ----------------------------------------------------------
set JAVA=%START_DIR%..\jre\bin\java
set CONFIG_PROP=-Dcom.ibm.rational.interop.gateway.configURL=file:///"%cd%\cqconnector.properties"
set LOG_CONFIG=-Dlog4j.configuration=file:///"%cd%\log4j.properties"
set LAUNCHER=org.eclipse.equinox.launcher_1.0.101.R34x_v20081125.jar
set JAR=%START_DIR%..\synctool\plugins\%LAUNCHER%
set APPLICATION=com.ibm.rational.connector.cq.synctools.application 
"%JAVA%" -Xmx1024M %CONFIG_PROP% %LOG_CONFIG% -DCQ_HOME="%CQ_HOME%" -jar "%JAR%" -application %APPLICATION% %*
