@echo off

rem *******************************************************************************
rem Licensed Materials - Property of IBM
rem (c) Copyright IBM Corporation 2007,2008. All Rights Reserved.
rem 
rem Note to U.S. Government Users Restricted Rights:  
rem Use, duplication or disclosure restricted by GSA ADP Schedule 
rem Contract with IBM Corp. 
rem *******************************************************************************

rem -----------------------------------------------------------------------
rem Find the cqjni.jar file in the ClearQuest installation.
rem It should be one of the CLASSPATH elements.
rem -----------------------------------------------------------------------
setlocal
set LOCAL_CLASSPATH=%CLASSPATH%
set CQJNI_NAME=cqjni.jar
set CQJNI_PATH=

:loop
if not "%LOCAL_CLASSPATH%"=="" (
    for /f "delims=; tokens=1,*" %%i in ("%LOCAL_CLASSPATH%") do (
        if /i "%%~nxi"=="%CQJNI_NAME%" (
            set CQJNI_PATH=%%i
            set LOCAL_CLASSPATH=
        ) else (
            set LOCAL_CLASSPATH=%%j
        )
    )
    goto loop
)

rem -----------------------------------------------------------------------
rem If cqjni.jar wasn't on the CLASSPATH, construct path from
rem available environment variables
rem -----------------------------------------------------------------------
if "%CQJNI_PATH%"=="" (
    if defined CLEARQUEST_HOME (
	set CQJNI_PATH="%CLEARQUEST_HOME%"\%CQJNI_NAME%
    ) else (
        if defined RATIONAL_HOME (
            set CQJNI_PATH="%RATIONAL_HOME%"\ClearQuest\%CQJNI_NAME%
        ) else (
            if defined CQ_HOME (
                set CQJNI_PATH="%CQ_HOME%"\%CQJNI_NAME%
            )
        )
    )
)

if "%CQJNI_PATH%"=="" (
    echo Cannot find the ClearQuest Java native library %CQJNI_NAME%
    echo It must be in the CLASSPATH environment variable, or one of
    echo CLEARQUEST_HOME, RATIONAL_HOME, or CQ_HOME must be defined
    exit /b 1
)

if not exist "%CQJNI_PATH%" (
    echo The ClearQuest Java native library does not exist at "%CQJNI_PATH%"
    echo Check the CLASSPATH, CLEARQUEST_HOME, RATIONAL_HOME, or CQ_HOME environment variables
    exit /b 1
)

rem Make sure CQ_HOME is set, so that it can be accessed by the setup servlet.

set CQ_HOME=%CQJNI_PATH:\cqjni.jar=%

rem if CQ 7.1 is installed, then the clearquest install directory is not on the PATH ev
rem but the CLEARQUEST_HOME ev is defined, so add the value of that ev to the PATH ev

if defined CLEARQUEST_HOME (
	path | find /i "%CLEARQUEST_HOME%" >NUL 
	if %ERRORLEVEL% NEQ 0 (
		set PATH="%CLEARQUEST_HOME%;%PATH%"
	)
)
        
set CQPACKAGEDIR=-Dcom.ibm.rational.connector.cq.gateway.cqPackageDir="%cd%/cqPackage"
set CONFIG_PROP=-Dcom.ibm.rational.interop.gateway.configURL="%cd%/cqconnector.properties"
set LOG_PROP=-Dlog4j.configuration="file:///%cd%/log4j.properties"

rem -----------------------------------------------------------------------
rem Startup tomcat
rem -----------------------------------------------------------------------
set JRE_HOME=%cd%\..\jre
set CATALINA_HOME=%cd%\tomcat
set CATALINA_OPTS=-Dcq.home="%CQ_HOME%" %CQPACKAGEDIR% %CONFIG_PROP% %LOG_PROP%
set JAVA_OPTS=-Xmx700M
call "%CATALINA_HOME%"\bin\startup.bat