/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.cache.Cache;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.JNLPClassLoader;
import com.sun.jnlp.SmartSecurityDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;

public final class PersistenceServiceImpl
implements PersistenceService {
    private long _globalLimit = -1L;
    private long _appLimit = -1L;
    private long _size = -1L;
    private static PersistenceServiceImpl _sharedInstance = null;
    private final SmartSecurityDialog _securityDialog = new SmartSecurityDialog();

    private PersistenceServiceImpl() {
    }

    public static synchronized PersistenceServiceImpl getInstance() {
        PersistenceServiceImpl.initialize();
        return _sharedInstance;
    }

    public static synchronized void initialize() {
        if (_sharedInstance == null) {
            _sharedInstance = new PersistenceServiceImpl();
        }
        if (_sharedInstance != null) {
            PersistenceServiceImpl._sharedInstance._appLimit = (long)Config.getIntProperty((String)"deployment.javaws.muffin.max") * 1024L;
        }
    }

    long getLength(URL uRL) throws MalformedURLException, IOException {
        this.checkAccess(uRL);
        return Cache.getMuffinSize(uRL);
    }

    long getMaxLength(final URL uRL) throws MalformedURLException, IOException {
        Long l = null;
        try {
            l = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    long[] lArray = Cache.getMuffinAttributes(uRL);
                    if (lArray == null) {
                        return new Long(-1L);
                    }
                    return new Long(lArray[1]);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return l;
    }

    long setMaxLength(final URL uRL, long l) throws MalformedURLException, IOException {
        long l2;
        block4: {
            l2 = 0L;
            this.checkAccess(uRL);
            l2 = this.checkSetMaxSize(uRL, l);
            if (l2 < 0L) {
                return -1L;
            }
            final long l3 = l2;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException {
                        Cache.putMuffinAttributes(uRL, PersistenceServiceImpl.this.getTag(uRL), l3);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
        return l2;
    }

    private long checkSetMaxSize(final URL uRL, long l) throws IOException {
        long l2;
        URL[] uRLArray = null;
        try {
            uRLArray = (URL[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return Cache.getAccessibleMuffins(uRL);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        long l3 = 0L;
        if (uRLArray != null) {
            for (int i = 0; i < uRLArray.length; ++i) {
                URL uRL2;
                if (uRLArray[i] == null || (uRL2 = uRLArray[i]).equals(uRL)) continue;
                long l4 = 0L;
                try {
                    l4 = this.getMaxLength(uRL2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                l3 += l4;
            }
        }
        if ((l2 = l + l3) > this._appLimit) {
            return this.reconcileMaxSize(l, l3, this._appLimit);
        }
        return l;
    }

    private long reconcileMaxSize(long l, long l2, long l3) {
        long l4 = l + l2;
        boolean bl = CheckServicePermission.hasFileAccessPermissions();
        if (bl || this.askUser(l4, l3)) {
            this._appLimit = l4;
            return l;
        }
        return l3 - l2;
    }

    private URL[] getAccessibleMuffins(URL uRL) throws IOException {
        return Cache.getAccessibleMuffins(uRL);
    }

    public long create(final URL uRL, long l) throws MalformedURLException, IOException {
        Long l2;
        block4: {
            this.checkAccess(uRL);
            l2 = null;
            long l3 = -1L;
            l3 = this.checkSetMaxSize(uRL, l);
            if (l3 < 0L) {
                return -1L;
            }
            final long l4 = l3;
            try {
                l2 = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException {
                        File file = Cache.getTempCacheFile(uRL, null);
                        if (file == null) {
                            return new Long(-1L);
                        }
                        Cache.insertMuffinEntry(uRL, file, 0, l4);
                        return new Long(l4);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
        return l2;
    }

    public FileContents get(URL uRL) throws MalformedURLException, IOException {
        this.checkAccess(uRL);
        File file = Cache.getMuffinFileForURL(uRL);
        if (file == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return new FileContentsImpl(file, this, uRL, this.getMaxLength(uRL));
    }

    public void delete(final URL uRL) throws MalformedURLException, IOException {
        block3: {
            this.checkAccess(uRL);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException {
                        DiskCacheEntry diskCacheEntry = Cache.getMuffinEntry('P', uRL);
                        if (diskCacheEntry == null) {
                            throw new FileNotFoundException(uRL.toString());
                        }
                        Cache.removeMuffinEntry(diskCacheEntry);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block3;
                throw (MalformedURLException)exception;
            }
        }
    }

    public String[] getNames(URL uRL) throws MalformedURLException, IOException {
        String[] stringArray;
        block3: {
            stringArray = null;
            final URL uRL2 = URLUtil.asPathURL((URL)uRL);
            this.checkAccess(uRL2);
            try {
                stringArray = (String[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException {
                        File file = Cache.getMuffinFileForURL(uRL2);
                        if (!file.isDirectory()) {
                            file = file.getParentFile();
                        }
                        File[] fileArray = file.listFiles();
                        Vector<String> vector = new Vector<String>();
                        for (int i = 0; i < fileArray.length; ++i) {
                            if (!Cache.isMainMuffinFile(fileArray[i])) continue;
                            DiskCacheEntry diskCacheEntry = Cache.getMuffinCacheEntryFromFile(fileArray[i]);
                            URL uRL = diskCacheEntry.getLocation();
                            File file2 = new File(uRL.getFile());
                            vector.addElement(file2.getName());
                        }
                        return vector.toArray(new String[0]);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block3;
                throw (MalformedURLException)exception;
            }
        }
        return stringArray;
    }

    public int getTag(final URL uRL) throws MalformedURLException, IOException {
        Integer n;
        block3: {
            n = null;
            this.checkAccess(uRL);
            try {
                n = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException {
                        long[] lArray = Cache.getMuffinAttributes(uRL);
                        if (lArray == null) {
                            throw new MalformedURLException();
                        }
                        return new Integer((int)lArray[0]);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block3;
                throw (MalformedURLException)exception;
            }
        }
        return n;
    }

    public void setTag(final URL uRL, final int n) throws MalformedURLException, IOException {
        block3: {
            this.checkAccess(uRL);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MalformedURLException, IOException {
                        Cache.putMuffinAttributes(uRL, n, PersistenceServiceImpl.this.getMaxLength(uRL));
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block3;
                throw (MalformedURLException)exception;
            }
        }
    }

    private boolean askUser(final long l, final long l2) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = ResourceManager.getString((String)"APIImpl.persistence.message", (Long)new Long(l), (Long)new Long(l2));
                boolean bl = PersistenceServiceImpl.this._securityDialog.showDialog(string);
                if (bl) {
                    long l3 = Math.min(Integer.MAX_VALUE, (l + 1023L) / 1024L);
                    Config.setIntProperty((String)"deployment.javaws.muffin.max", (int)((int)l3));
                    Config.storeIfDirty();
                }
                return new Boolean(bl);
            }
        });
        return bl;
    }

    private void checkAccess(URL uRL) throws MalformedURLException {
        URL uRL2;
        LaunchDesc launchDesc;
        if (uRL == null || uRL.toString().indexOf(92) != -1) {
            this.throwAccessDenied(uRL);
        }
        if ((launchDesc = JNLPClassLoader.getInstance().getLaunchDesc()) != null && (uRL2 = launchDesc.getCodebase()) != null) {
            int n;
            String string;
            if (uRL == null || !uRL2.getHost().equals(uRL.getHost())) {
                this.throwAccessDenied(uRL);
            }
            if ((string = uRL.getFile()) == null) {
                this.throwAccessDenied(uRL);
            }
            if ((n = string.lastIndexOf(47)) == -1) {
                return;
            }
            if (!uRL2.getFile().startsWith(string.substring(0, n + 1))) {
                this.throwAccessDenied(uRL);
            }
        }
    }

    private void throwAccessDenied(URL uRL) throws MalformedURLException {
        throw new MalformedURLException(ResourceManager.getString((String)"APIImpl.persistence.accessdenied", (String)uRL.toString()));
    }
}

