/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.ExtensionsProvider;
import org.apache.xpath.ExtensionsProvider2;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.functions.Function;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNull;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;

public class FuncExtFunction
extends Function {
    static final long serialVersionUID = 5196115554693708718L;
    String m_namespace;
    String m_extensionName;
    Object m_methodKey;
    Vector m_argVec = new Vector();
    private XPathFunction m_xpathFunction;
    private boolean m_fromXPathAPI = false;

    public void fixupVariables(Vector vars, int globalsSize) {
        if (null != this.m_argVec) {
            int nArgs = this.m_argVec.size();
            int i = 0;
            while (i < nArgs) {
                Expression arg = (Expression)this.m_argVec.elementAt(i);
                arg.fixupVariables(vars, globalsSize);
                ++i;
            }
        }
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getFunctionName() {
        return this.m_extensionName;
    }

    public Object getMethodKey() {
        return this.m_methodKey;
    }

    public Expression getArg(int n) {
        if (n >= 0 && n < this.m_argVec.size()) {
            return (Expression)this.m_argVec.elementAt(n);
        }
        return null;
    }

    public int getArgCount() {
        return this.m_argVec.size();
    }

    public FuncExtFunction(String namespace, String extensionName, Object methodKey) {
        this(namespace, extensionName, methodKey, false);
    }

    public FuncExtFunction(String namespace, String extensionName, Object methodKey, boolean fromXPathAPI) {
        this.m_namespace = namespace;
        this.m_extensionName = extensionName;
        this.m_methodKey = methodKey;
        this.m_fromXPathAPI = fromXPathAPI;
    }

    public void setXPathFunction(XPathFunction xpathFunction) {
        this.m_xpathFunction = xpathFunction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XObject execute(XPathContext xctxt) throws TransformerException {
        Object val;
        if (xctxt.isSecureProcessing()) {
            throw new TransformerException(XPATHMessages.createXPATHMessage("ER_EXTENSION_NOT_ALLOWED_IN_SECURE_PROCESSING", new Object[]{this.toString()}));
        }
        Vector<Object> argVec = new Vector<Object>();
        int nArgs = this.m_argVec.size();
        int i = 0;
        while (i < nArgs) {
            Expression arg = (Expression)this.m_argVec.elementAt(i);
            XObject xobj = arg.execute(xctxt);
            xobj.allowDetachToRelease(false);
            if (this.m_fromXPathAPI) {
                if (xobj instanceof XNodeSet) {
                    argVec.addElement(((XNodeSet)xobj).nodelist());
                } else {
                    argVec.addElement(xobj.object());
                }
            } else {
                argVec.addElement(xobj);
            }
            ++i;
        }
        if (this.m_fromXPathAPI) {
            if (this.m_xpathFunction == null) throw new TransformerException(XPATHMessages.createXPATHMessage("ER_UNRESOLVED_EXTENSION_FUNCTION", new Object[]{this.toString()}));
            try {
                val = this.m_xpathFunction.evaluate(argVec);
            }
            catch (XPathFunctionException e) {
                throw new TransformerException(e);
            }
        } else {
            ExtensionsProvider extProvider = (ExtensionsProvider)xctxt.getOwnerObject();
            val = extProvider instanceof ExtensionsProvider2 ? ((ExtensionsProvider2)extProvider).extFunction(xctxt, this, argVec) : extProvider.extFunction(this, argVec);
        }
        if (null == val) return new XNull();
        return XObject.create(val, xctxt);
    }

    public void setArg(Expression arg, int argNum) throws WrongNumberArgsException {
        this.m_argVec.addElement(arg);
        arg.exprSetParent(this);
    }

    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
    }

    public void callArgVisitors(XPathVisitor visitor) {
        int i = 0;
        while (i < this.m_argVec.size()) {
            Expression exp = (Expression)this.m_argVec.elementAt(i);
            exp.callVisitors(new ArgExtOwner(exp), visitor);
            ++i;
        }
    }

    public void exprSetParent(ExpressionNode n) {
        super.exprSetParent(n);
        int nArgs = this.m_argVec.size();
        int i = 0;
        while (i < nArgs) {
            Expression arg = (Expression)this.m_argVec.elementAt(i);
            arg.exprSetParent(n);
            ++i;
        }
    }

    protected void reportWrongNumberArgs() throws WrongNumberArgsException {
        String fMsg = XPATHMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{"Programmer's assertion:  the method FunctionMultiArgs.reportWrongNumberArgs() should never be called."});
        throw new RuntimeException(fMsg);
    }

    public String toString() {
        if (this.m_namespace != null && this.m_namespace.length() > 0) {
            return "{" + this.m_namespace + "}" + this.m_extensionName;
        }
        return this.m_extensionName;
    }

    class ArgExtOwner
    implements ExpressionOwner {
        Expression m_exp;

        ArgExtOwner(Expression exp) {
            this.m_exp = exp;
        }

        public Expression getExpression() {
            return this.m_exp;
        }

        public void setExpression(Expression exp) {
            exp.exprSetParent(FuncExtFunction.this);
            this.m_exp = exp;
        }
    }
}

