/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.validation;

import java.util.Locale;
import javax.xml.validation.TypeInfoProvider;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.jaxp.validation.JAXPValidationMessageFormatter;
import org.apache.xerces.jaxp.validation.XMLSchemaTypeInfo;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.TypeInfo;

final class XMLSchemaTypeInfoProvider
extends TypeInfoProvider {
    private final ValidStateTypeInfoProvider fValidStateTypeInfoProvider = new ValidStateTypeInfoProvider();
    private final IllegalStateTypeInfoProvider fIllegalStateTypeInfoProvider = IllegalStateTypeInfoProvider.getInstance();
    private TypeInfoProvider fCurrentTypeInfoProvider = this.fIllegalStateTypeInfoProvider;
    private Augmentations fElementAugs;
    private XMLAttributes fAttributes;

    void beginStartElement(Augmentations augmentations, XMLAttributes xMLAttributes) {
        this.fCurrentTypeInfoProvider = this.fValidStateTypeInfoProvider;
        this.fElementAugs = augmentations;
        this.fAttributes = xMLAttributes;
    }

    void finishStartElement() {
        this.fCurrentTypeInfoProvider = this.fIllegalStateTypeInfoProvider;
        this.fElementAugs = null;
        this.fAttributes = null;
        this.fValidStateTypeInfoProvider.fCachedElementTypeInfo = null;
        this.fValidStateTypeInfoProvider.fCachedAttributeIndex = -1;
        this.fValidStateTypeInfoProvider.fCachedAttributePSVI = null;
    }

    void beginEndElement(Augmentations augmentations) {
        this.fElementAugs = augmentations;
    }

    void finishEndElement() {
        this.fElementAugs = null;
    }

    public TypeInfo getElementTypeInfo() {
        return this.fCurrentTypeInfoProvider.getElementTypeInfo();
    }

    public TypeInfo getAttributeTypeInfo(int n) {
        return this.fCurrentTypeInfoProvider.getAttributeTypeInfo(n);
    }

    public boolean isIdAttribute(int n) {
        return this.fCurrentTypeInfoProvider.isIdAttribute(n);
    }

    public boolean isSpecified(int n) {
        return this.fCurrentTypeInfoProvider.isSpecified(n);
    }

    ElementPSVI getElementPSVI() {
        return this.fElementAugs != null ? (ElementPSVI)this.fElementAugs.getItem("ELEMENT_PSVI") : null;
    }

    AttributePSVI getAttributePSVI(int n) {
        Augmentations augmentations;
        if (this.fAttributes != null && (augmentations = this.fAttributes.getAugmentations(n)) != null) {
            return (AttributePSVI)augmentations.getItem("ATTRIBUTE_PSVI");
        }
        return null;
    }

    AttributePSVI getAttributePSVIByName(String string, String string2) {
        Augmentations augmentations;
        if (this.fAttributes != null && (augmentations = this.fAttributes.getAugmentations(string, string2)) != null) {
            return (AttributePSVI)augmentations.getItem("ATTRIBUTE_PSVI");
        }
        return null;
    }

    static final class IllegalStateTypeInfoProvider
    extends TypeInfoProvider {
        private static IllegalStateTypeInfoProvider ILLEGAL_STATE_TYPE_INFO_PROVIDER_INSTANCE = new IllegalStateTypeInfoProvider();

        private IllegalStateTypeInfoProvider() {
        }

        public static IllegalStateTypeInfoProvider getInstance() {
            return ILLEGAL_STATE_TYPE_INFO_PROVIDER_INSTANCE;
        }

        public TypeInfo getElementTypeInfo() {
            throw new IllegalStateException(JAXPValidationMessageFormatter.formatMessage(Locale.getDefault(), "TypeInfoProviderIllegalState", null));
        }

        public TypeInfo getAttributeTypeInfo(int n) {
            throw new IllegalStateException(JAXPValidationMessageFormatter.formatMessage(Locale.getDefault(), "TypeInfoProviderIllegalState", null));
        }

        public boolean isIdAttribute(int n) {
            throw new IllegalStateException(JAXPValidationMessageFormatter.formatMessage(Locale.getDefault(), "TypeInfoProviderIllegalState", null));
        }

        public boolean isSpecified(int n) {
            throw new IllegalStateException(JAXPValidationMessageFormatter.formatMessage(Locale.getDefault(), "TypeInfoProviderIllegalState", null));
        }
    }

    final class ValidStateTypeInfoProvider
    extends TypeInfoProvider {
        private TypeInfo fCachedElementTypeInfo;
        private int fCachedAttributeIndex = -1;
        private AttributePSVI fCachedAttributePSVI;

        public TypeInfo getElementTypeInfo() {
            ElementPSVI elementPSVI;
            if (this.fCachedElementTypeInfo != null) {
                return this.fCachedElementTypeInfo;
            }
            XSTypeDefinition xSTypeDefinition = null;
            if (XMLSchemaTypeInfoProvider.this.fElementAugs != null && (elementPSVI = (ElementPSVI)XMLSchemaTypeInfoProvider.this.fElementAugs.getItem("ELEMENT_PSVI")) != null && (xSTypeDefinition = elementPSVI.getMemberTypeDefinition()) == null) {
                xSTypeDefinition = elementPSVI.getTypeDefinition();
            }
            this.fCachedElementTypeInfo = new XMLSchemaTypeInfo(xSTypeDefinition);
            return this.fCachedElementTypeInfo;
        }

        public TypeInfo getAttributeTypeInfo(int n) {
            AttributePSVI attributePSVI = this.getAttributePSVI(n);
            XSTypeDefinition xSTypeDefinition = null;
            if (attributePSVI != null && (xSTypeDefinition = attributePSVI.getMemberTypeDefinition()) == null) {
                xSTypeDefinition = attributePSVI.getTypeDefinition();
            }
            return new XMLSchemaTypeInfo(xSTypeDefinition);
        }

        public boolean isIdAttribute(int n) {
            AttributePSVI attributePSVI = this.getAttributePSVI(n);
            if (attributePSVI != null) {
                XSTypeDefinition xSTypeDefinition = attributePSVI.getMemberTypeDefinition();
                if (xSTypeDefinition == null) {
                    xSTypeDefinition = attributePSVI.getTypeDefinition();
                    if (xSTypeDefinition != null) {
                        return ((XSSimpleType)xSTypeDefinition).isIDType();
                    }
                } else {
                    return ((XSSimpleType)xSTypeDefinition).isIDType();
                }
            }
            return false;
        }

        public boolean isSpecified(int n) {
            AttributePSVI attributePSVI = this.getAttributePSVI(n);
            if (attributePSVI != null) {
                return !attributePSVI.getIsSchemaSpecified();
            }
            return true;
        }

        private AttributePSVI getAttributePSVI(int n) {
            if (n < 0 || n >= XMLSchemaTypeInfoProvider.this.fAttributes.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n);
            }
            if (this.fCachedAttributeIndex != n) {
                this.fCachedAttributeIndex = n;
                this.fCachedAttributePSVI = (AttributePSVI)XMLSchemaTypeInfoProvider.this.fAttributes.getAugmentations(n).getItem("ATTRIBUTE_PSVI");
            }
            return this.fCachedAttributePSVI;
        }
    }
}

