/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import com.ibm.xslt4j.bcel.generic.ALOAD;
import com.ibm.xslt4j.bcel.generic.ASTORE;
import com.ibm.xslt4j.bcel.generic.BranchHandle;
import com.ibm.xslt4j.bcel.generic.ConstantPoolGen;
import com.ibm.xslt4j.bcel.generic.IFEQ;
import com.ibm.xslt4j.bcel.generic.IFNULL;
import com.ibm.xslt4j.bcel.generic.ILOAD;
import com.ibm.xslt4j.bcel.generic.INVOKEINTERFACE;
import com.ibm.xslt4j.bcel.generic.INVOKEVIRTUAL;
import com.ibm.xslt4j.bcel.generic.ISTORE;
import com.ibm.xslt4j.bcel.generic.InstructionConstants;
import com.ibm.xslt4j.bcel.generic.InstructionHandle;
import com.ibm.xslt4j.bcel.generic.InstructionList;
import com.ibm.xslt4j.bcel.generic.LocalVariableGen;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.LiteralElement;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.UseAttributeSets;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class Copy
extends Instruction {
    private UseAttributeSets _useSets;

    Copy() {
    }

    public void parseContents(Parser parser) {
        String useSets = this.getAttribute("use-attribute-sets");
        if (useSets.length() > 0) {
            if (!Util.isValidQNames(useSets)) {
                ErrorMsg err = new ErrorMsg("INVALID_QNAME_ERR", (Object)useSets, this);
                parser.reportError(3, err);
            }
            this._useSets = new UseAttributeSets(useSets, parser);
        }
        this.parseChildren(parser);
    }

    public void display(int indent) {
        this.indent(indent);
        Util.println("Copy");
        this.indent(indent + 4);
        this.displayContents(indent + 4);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (this._useSets != null) {
            this._useSets.typeCheck(stable);
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        LocalVariableGen name = methodGen.addLocalVariable2("name", Util.getJCRefType("Ljava/lang/String;"), null);
        LocalVariableGen length = methodGen.addLocalVariable2("length", Util.getJCRefType("I"), null);
        il.append(methodGen.loadDOM());
        il.append(methodGen.loadCurrentNode());
        il.append(methodGen.loadHandler());
        int cpy = cpg.addInterfaceMethodref("org.apache.xalan.xsltc.DOM", "shallowCopy", "(ILorg/apache/xml/serializer/SerializationHandler;)Ljava/lang/String;");
        il.append(new INVOKEINTERFACE(cpy, 3));
        il.append(InstructionConstants.DUP);
        name.setStart(il.append(new ASTORE(name.getIndex())));
        BranchHandle ifBlock1 = il.append(new IFNULL(null));
        il.append(new ALOAD(name.getIndex()));
        int lengthMethod = cpg.addMethodref("java.lang.String", "length", "()I");
        il.append(new INVOKEVIRTUAL(lengthMethod));
        length.setStart(il.append(new ISTORE(length.getIndex())));
        if (this._useSets != null) {
            SyntaxTreeNode parent = this.getParent();
            if (parent instanceof LiteralElement || parent instanceof LiteralElement) {
                this._useSets.translate(classGen, methodGen);
            } else {
                il.append(new ILOAD(length.getIndex()));
                BranchHandle ifBlock2 = il.append(new IFEQ(null));
                this._useSets.translate(classGen, methodGen);
                ifBlock2.setTarget(il.append(InstructionConstants.NOP));
            }
        }
        this.translateContents(classGen, methodGen);
        length.setEnd(il.append(new ILOAD(length.getIndex())));
        BranchHandle ifBlock3 = il.append(new IFEQ(null));
        il.append(methodGen.loadHandler());
        name.setEnd(il.append(new ALOAD(name.getIndex())));
        il.append(methodGen.endElement());
        InstructionHandle end = il.append(InstructionConstants.NOP);
        ifBlock1.setTarget(end);
        ifBlock3.setTarget(end);
        methodGen.removeLocalVariable(name);
        methodGen.removeLocalVariable(length);
    }
}

