/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.namespace.QName;

public abstract class Duration {
    public abstract Duration add(Duration var1);

    public abstract void addTo(Calendar var1);

    public void addTo(Date date) {
        if (date == null) {
            throw new NullPointerException("date is null");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.addTo(gregorianCalendar);
        date.setTime(gregorianCalendar.getTime().getTime());
    }

    public abstract int compare(Duration var1);

    public boolean equals(Object object) {
        if (object == null) {
            throw new NullPointerException("duration is null");
        }
        if (!(object instanceof Duration)) {
            throw new UnsupportedOperationException("Not a valid duration");
        }
        return this.compare((Duration)object) == 0;
    }

    public abstract Number getField(DatatypeConstants.Field var1);

    public abstract boolean isSet(DatatypeConstants.Field var1);

    public int getDays() {
        if (this.isSet(DatatypeConstants.DAYS)) {
            return this.getField(DatatypeConstants.DAYS).intValue();
        }
        return 0;
    }

    public int getHours() {
        if (this.isSet(DatatypeConstants.HOURS)) {
            return this.getField(DatatypeConstants.HOURS).intValue();
        }
        return 0;
    }

    public int getMonths() {
        if (this.isSet(DatatypeConstants.MONTHS)) {
            return this.getField(DatatypeConstants.MONTHS).intValue();
        }
        return 0;
    }

    public int getMinutes() {
        if (this.isSet(DatatypeConstants.MINUTES)) {
            return this.getField(DatatypeConstants.MINUTES).intValue();
        }
        return 0;
    }

    public int getSeconds() {
        if (this.isSet(DatatypeConstants.SECONDS)) {
            return this.getField(DatatypeConstants.SECONDS).intValue();
        }
        return 0;
    }

    public int getYears() {
        if (this.isSet(DatatypeConstants.YEARS)) {
            return this.getField(DatatypeConstants.YEARS).intValue();
        }
        return 0;
    }

    public abstract int getSign();

    public long getTimeInMillis(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        this.addTo(calendar);
        return calendar.getTime().getTime() - calendar2.getTime().getTime();
    }

    public long getTimeInMillis(Date date) {
        Date date2 = (Date)date.clone();
        this.addTo(date);
        return date.getTime() - date2.getTime();
    }

    public QName getXMLSchemaType() {
        boolean bl = this.isSet(DatatypeConstants.DAYS);
        boolean bl2 = this.isSet(DatatypeConstants.HOURS);
        boolean bl3 = this.isSet(DatatypeConstants.MINUTES);
        boolean bl4 = this.isSet(DatatypeConstants.SECONDS);
        boolean bl5 = this.isSet(DatatypeConstants.YEARS);
        boolean bl6 = this.isSet(DatatypeConstants.MONTHS);
        if (bl5 && bl6) {
            if (bl && bl2 && bl3 && bl4) {
                return DatatypeConstants.DURATION;
            }
            if (!(bl || bl2 || bl3 || bl4)) {
                return DatatypeConstants.DURATION_YEARMONTH;
            }
        } else if (!bl5 && !bl6 && bl && bl2 && bl3 && bl4) {
            return DatatypeConstants.DURATION_DAYTIME;
        }
        throw new IllegalStateException("invalid duration");
    }

    public abstract int hashCode();

    public boolean isLongerThan(Duration duration) {
        return this.compare(duration) == 1;
    }

    public boolean isShorterThan(Duration duration) {
        return this.compare(duration) == -1;
    }

    public abstract Duration multiply(BigDecimal var1);

    public Duration multiply(int n) {
        return this.multiply(BigDecimal.valueOf(n));
    }

    public abstract Duration negate();

    public abstract Duration normalizeWith(Calendar var1);

    public Duration subtract(Duration duration) {
        return this.add(duration.negate());
    }

    public String toString() {
        Number number;
        Number number2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getSign() < 0) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        Number number3 = this.getField(DatatypeConstants.YEARS);
        if (number3 != null) {
            stringBuffer.append(number3);
            stringBuffer.append('Y');
        }
        if ((number2 = this.getField(DatatypeConstants.MONTHS)) != null) {
            stringBuffer.append(number2);
            stringBuffer.append('M');
        }
        if ((number = this.getField(DatatypeConstants.DAYS)) != null) {
            stringBuffer.append(number);
            stringBuffer.append('D');
        }
        Number number4 = this.getField(DatatypeConstants.HOURS);
        Number number5 = this.getField(DatatypeConstants.MINUTES);
        Number number6 = this.getField(DatatypeConstants.SECONDS);
        if (number4 != null || number5 != null || number6 != null) {
            stringBuffer.append('T');
            if (number4 != null) {
                stringBuffer.append(number5);
                stringBuffer.append('H');
            }
            if (number5 != null) {
                stringBuffer.append(number5);
                stringBuffer.append('M');
            }
            if (number6 != null) {
                stringBuffer.append(number6);
                stringBuffer.append('S');
            }
        }
        return stringBuffer.toString();
    }
}

