/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.util;

import com.ibm.xml.b2b.util.CharConversionError;
import com.ibm.xml.b2b.util.EncodingSupport;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.SingleByteEncodingSupport;
import com.ibm.xml.b2b.util.XMLString;

public final class SymbolTable {
    private static final boolean CHECK_SYMBOL_HANDLES = false;
    private static final boolean CHECK_CACHE_CONSISTENCY = false;
    private static final boolean DUMP_CACHE = false;
    private static final boolean DEBUG_CACHE = false;
    private static final boolean DEBUG_LOOKUPS = false;
    private static final boolean DEBUG_ADDITIONS = false;
    private static final boolean DEBUG_ALLOC = false;
    private static final int SYMBOL_MASK = 0x60000000;
    private static final int SYMBOL_FLAG = 0x40000000;
    private static final int STRING_FLAG = 0x20000000;
    private static final int INITIAL_CHUNK_SHIFT = 8;
    private static final int INITIAL_CHUNK_SIZE = 256;
    private static final int CHUNK_SHIFT = 13;
    private static final int CHUNK_SIZE = 8192;
    private static final int CHUNK_MASK = 8191;
    private static final int INITIAL_CHUNK_COUNT = 8;
    private int fSymbolCount;
    private String[][] fString = new String[8][];
    private int[][] fPrefixHandle = new int[8][];
    private int[][] fLocalHandle = new int[8][];
    private char[] fStringChars;
    private char[] fSymbolChars;
    private int[] fMBLen = new int[1];
    private Node fCache;
    private Node fFreeNodes;

    public SymbolTable() {
        this.fStringChars = new char[256];
        this.fCache = new Node();
        this.fCache.next = new Node();
        this.fCache.next.ch = 108;
        this.setStringForHandle(XMLString.EMPTY_STRING, 0);
        this.fSymbolCount = 1;
    }

    private void cacheNodeDeallocate(Node node) {
        Node node2;
        do {
            node.ch = 0;
            node.handle = 0;
            if (node.left != null) {
                this.cacheNodeDeallocate(node.left);
                node.left = null;
            }
            if (node.right != null) {
                this.cacheNodeDeallocate(node.right);
                node.right = null;
            }
            node2 = node.next;
            node.next = this.fFreeNodes;
            this.fFreeNodes = node;
        } while ((node = node2) != null);
    }

    public void reset(boolean bl) {
        if (!bl) {
            int n = 0;
            int n2 = 1;
            int n3 = 1;
            while (n3 < this.fSymbolCount) {
                this.fString[n][n2] = null;
                this.fPrefixHandle[n][n2] = 0;
                this.fLocalHandle[n][n2] = 0;
                if (++n2 == 8192) {
                    ++n;
                    n2 = 0;
                }
                ++n3;
            }
            this.cacheNodeDeallocate(this.fCache.next);
            this.fCache.next = this.cacheNodeAllocate();
            this.fCache.next.ch = 108;
            this.fSymbolCount = 1;
        }
    }

    public String toString(int n) {
        if (n == -1) {
            return null;
        }
        if (n >= this.fSymbolCount) {
            throw new RuntimeException("SymbolTable.toString(" + n + ")");
        }
        int n2 = n >>> 13;
        int n3 = n & 0x1FFF;
        String string = this.fString[n2][n3];
        return string;
    }

    private String getString(int n) {
        int n2 = n >>> 13;
        int n3 = n & 0x1FFF;
        String string = this.fString[n2][n3];
        return string;
    }

    public int addSymbol(XMLString xMLString) {
        int n;
        int n2;
        int n3;
        if (xMLString.handle >= 0) {
            return xMLString.handle;
        }
        xMLString.handle = xMLString.bytes != null ? ((n3 = xMLString.offset) < (n2 = xMLString.endOffset) ? this.addSymbol(xMLString.bytes, n3, n2, xMLString.encoding, xMLString.str) : 0) : (xMLString.chars != null ? ((n3 = xMLString.offset) < (n = xMLString.endOffset) ? this.addSymbol(xMLString.chars, n3, n, xMLString.str) : 0) : this.addSymbol(xMLString.str));
        if (xMLString.handle >= 0) {
            String string;
            xMLString.str = string = this.getString(xMLString.handle);
        }
        return xMLString.handle;
    }

    public void addQNameSymbols(QName qName) {
        int n;
        int n2;
        int n3 = qName.sepOffset;
        byte[] byArray = qName.bytes;
        int n4 = qName.offset;
        int n5 = qName.endOffset;
        String string = qName.str;
        if (byArray != null) {
            int n6;
            EncodingSupport encodingSupport = qName.encoding;
            qName.handle = n6 = this.addSymbol(byArray, n4, n5, encodingSupport, string);
            int n7 = n6 >>> 13;
            int n8 = n6 & 0x1FFF;
            qName.str = this.fString[n7][n8];
            n2 = this.fPrefixHandle[n7][n8];
            if (n2 != 0) {
                n = this.fLocalHandle[n7][n8];
            } else {
                n2 = this.addSymbol(byArray, n4, n3, encodingSupport, null);
                n = this.addSymbol(byArray, n3 + 1, n5, encodingSupport, null);
                this.fPrefixHandle[n7][n8] = n2;
                this.fLocalHandle[n7][n8] = n;
            }
        } else {
            int n9;
            char[] cArray = qName.chars;
            if (cArray == null) {
                throw new IllegalArgumentException("SymbolTable#addQNameSymbols()");
            }
            qName.handle = n9 = this.addSymbol(cArray, n4, n5, string);
            int n10 = n9 >>> 13;
            int n11 = n9 & 0x1FFF;
            qName.str = this.fString[n10][n11];
            n2 = this.fPrefixHandle[n10][n11];
            if (n2 != 0) {
                n = this.fLocalHandle[n10][n11];
            } else {
                n2 = this.addSymbol(cArray, n4, n3, null);
                n = this.addSymbol(cArray, n3 + 1, n5, null);
                this.fPrefixHandle[n10][n11] = n2;
                this.fLocalHandle[n10][n11] = n;
            }
        }
        qName.prefix = this.getString(n2);
        qName.prefixHandle = n2;
        qName.localPart = this.getString(n);
        qName.localHandle = n;
    }

    public int addSymbol(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        if (n > this.fStringChars.length) {
            int n2 = this.fStringChars.length << 1;
            while (n > n2) {
                n2 <<= 1;
            }
            this.fStringChars = new char[n2];
        }
        string.getChars(0, n, this.fStringChars, 0);
        return this.addSymbol(this.fStringChars, 0, n, string);
    }

    public void dumpCache() {
    }

    private void dumpCacheRecord(Node node, int n) {
    }

    public void checkCache() {
    }

    private Node cacheNodeAllocate() {
        Node node = this.fFreeNodes;
        if (node != null) {
            this.fFreeNodes = node.next;
            node.next = null;
        } else {
            node = new Node();
        }
        return node;
    }

    private int addSymbol(byte[] byArray, int n, int n2, EncodingSupport encodingSupport, String string) {
        if (encodingSupport.isASCIITransparent()) {
            return this.addASCIITransparentSymbol(byArray, n, n2, encodingSupport, string);
        }
        if (encodingSupport.isSingleByte()) {
            return this.addSingleByteSymbol(byArray, n, n2, (SingleByteEncodingSupport)encodingSupport, string);
        }
        return this.addMultiByteSymbol(byArray, n, n2, encodingSupport, string);
    }

    private int addASCIITransparentSymbol(byte[] byArray, int n, int n2, EncodingSupport encodingSupport, String string) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Node node;
        int n8;
        int n9;
        byte[] byArray2;
        block20: {
            block21: {
                byArray2 = byArray;
                n9 = n;
                n8 = n2;
                Node node2 = this.fCache;
                node = node2.next;
                n7 = 0;
                n6 = 0;
                while (true) {
                    if ((n5 = byArray2[n9++]) < 0) {
                        n5 = encodingSupport.decodeCharacter(byArray2, n9 - 1, n8, this.fMBLen);
                        n9 += this.fMBLen[0] - 1;
                    }
                    ++n6;
                    if (node.ch != n5) {
                        node = SymbolTable.splay(node, n5);
                        if (node.ch != n5) {
                            n7 = 1;
                            break block20;
                        }
                        node2.next = node;
                    }
                    if (n9 >= n8) break block21;
                    if (node.next == null) break;
                    node2 = node;
                    node = node2.next;
                }
                n7 = 2;
                break block20;
            }
            n4 = node.handle;
            if (n4 != 0) {
                return n4;
            }
            n7 = 3;
        }
        switch (n7) {
            case 1: {
                Node node3 = this.cacheNodeAllocate();
                node3.ch = n5;
                if (node.ch < n5) {
                    node3.right = node.right;
                    node3.left = node;
                    node.right = null;
                } else {
                    node3.left = node.left;
                    node3.right = node;
                    node.left = null;
                }
                node2.next = node = node3;
                if (n9 == n8) break;
            }
            case 2: {
                Node node3;
                do {
                    if ((n3 = byArray2[n9]) < 0) {
                        n5 = encodingSupport.decodeCharacter(byArray2, n9, n8, this.fMBLen);
                        n9 += this.fMBLen[0];
                    } else {
                        ++n9;
                        n5 = n3;
                    }
                    node3 = this.cacheNodeAllocate();
                    node3.ch = n5;
                    node.next = node3;
                    node = node3;
                    ++n6;
                } while (n9 < n8);
                break;
            }
        }
        node.handle = n4 = this.fSymbolCount++;
        if (string == null) {
            int n10;
            n3 = 0;
            char[] cArray = this.fStringChars;
            if (n6 << 1 > cArray.length) {
                n10 = cArray.length << 1;
                while (n6 << 1 > n10) {
                    n10 <<= 1;
                }
                cArray = this.fStringChars = new char[n10];
            }
            node = this.fCache.next;
            while (n6-- > 0) {
                n5 = node.ch;
                if (n5 < 65536) {
                    cArray[n3++] = (char)n5;
                } else {
                    n10 = n5 - 65536;
                    cArray[n3++] = (char)(55296 + (n10 >> 10));
                    cArray[n3++] = (char)(56320 + (n10 & 0x3FF));
                }
                node = node.next;
            }
            string = new String(cArray, 0, n3);
        }
        this.setStringForHandle(string.intern(), n4);
        return n4;
    }

    private int addSingleByteSymbol(byte[] byArray, int n, int n2, SingleByteEncodingSupport singleByteEncodingSupport, String string) {
        int n3;
        int n4;
        byte[] byArray2 = byArray;
        int n5 = n;
        int n6 = n2;
        char[] cArray = singleByteEncodingSupport.byteToCharMap;
        Node node = this.fCache;
        Node node2 = node.next;
        boolean bl = false;
        int n7 = 0;
        while (true) {
            Node node3;
            n4 = cArray[byArray2[n5++] & 0xFF];
            ++n7;
            if (node2.ch != n4) {
                node2 = SymbolTable.splay(node2, n4);
                if (node2.ch != n4) {
                    node3 = this.cacheNodeAllocate();
                    node3.ch = n4;
                    if (node2.ch < n4) {
                        node3.right = node2.right;
                        node3.left = node2;
                        node2.right = null;
                    } else {
                        node3.left = node2.left;
                        node3.right = node2;
                        node2.left = null;
                    }
                    node2 = node3;
                }
                node.next = node2;
            }
            if (n5 == n6) {
                n3 = node2.handle;
                if (n3 == 0) break;
                return n3;
            }
            if (node2.next == null) {
                do {
                    n4 = cArray[byArray2[n5++] & 0xFF];
                    node3 = this.cacheNodeAllocate();
                    node3.ch = n4;
                    node2.next = node3;
                    node2 = node3;
                    ++n7;
                } while (n5 < n6);
                break;
            }
            node = node2;
            node2 = node.next;
        }
        node2.handle = n3 = this.fSymbolCount++;
        if (string == null) {
            int n8;
            int n9 = 0;
            char[] cArray2 = this.fStringChars;
            if (n7 << 1 > cArray2.length) {
                n8 = cArray2.length << 1;
                while (n7 << 1 > n8) {
                    n8 <<= 1;
                }
                cArray2 = this.fStringChars = new char[n8];
            }
            node2 = this.fCache.next;
            while (n7-- > 0) {
                n4 = node2.ch;
                if (n4 < 65536) {
                    cArray2[n9++] = (char)n4;
                } else {
                    n8 = n4 - 65536;
                    cArray2[n9++] = (char)(55296 + (n8 >> 10));
                    cArray2[n9++] = (char)(56320 + (n8 & 0x3FF));
                }
                node2 = node2.next;
            }
            string = new String(cArray2, 0, n9);
        }
        this.setStringForHandle(string.intern(), n3);
        return n3;
    }

    private int addMultiByteSymbol(byte[] byArray, int n, int n2, EncodingSupport encodingSupport, String string) {
        int n3;
        int n4;
        byte[] byArray2 = byArray;
        int n5 = n;
        int n6 = n2;
        Node node = this.fCache;
        Node node2 = node.next;
        boolean bl = false;
        int n7 = 0;
        while (true) {
            Node node3;
            n4 = encodingSupport.decodeCharacter(byArray2, n5, n6, this.fMBLen);
            n5 += this.fMBLen[0];
            ++n7;
            if (node2.ch != n4) {
                node2 = SymbolTable.splay(node2, n4);
                if (node2.ch != n4) {
                    node3 = this.cacheNodeAllocate();
                    node3.ch = n4;
                    if (node2.ch < n4) {
                        node3.right = node2.right;
                        node3.left = node2;
                        node2.right = null;
                    } else {
                        node3.left = node2.left;
                        node3.right = node2;
                        node2.left = null;
                    }
                    node2 = node3;
                }
                node.next = node2;
            }
            if (n5 == n6) {
                n3 = node2.handle;
                if (n3 == 0) break;
                return n3;
            }
            if (node2.next == null) {
                do {
                    n4 = encodingSupport.decodeCharacter(byArray2, n5, n6, this.fMBLen);
                    n5 += this.fMBLen[0];
                    node3 = this.cacheNodeAllocate();
                    node3.ch = n4;
                    node2.next = node3;
                    node2 = node3;
                    ++n7;
                } while (n5 < n6);
                break;
            }
            node = node2;
            node2 = node.next;
        }
        node2.handle = n3 = this.fSymbolCount++;
        if (string == null) {
            int n8;
            int n9 = 0;
            char[] cArray = this.fStringChars;
            if (n7 << 1 > cArray.length) {
                n8 = cArray.length << 1;
                while (n7 << 1 > n8) {
                    n8 <<= 1;
                }
                cArray = this.fStringChars = new char[n8];
            }
            node2 = this.fCache.next;
            while (n7-- > 0) {
                n4 = node2.ch;
                if (n4 < 65536) {
                    cArray[n9++] = (char)n4;
                } else {
                    n8 = n4 - 65536;
                    cArray[n9++] = (char)(55296 + (n8 >> 10));
                    cArray[n9++] = (char)(56320 + (n8 & 0x3FF));
                }
                node2 = node2.next;
            }
            string = new String(cArray, 0, n9);
        }
        this.setStringForHandle(string.intern(), n3);
        return n3;
    }

    private int addSymbol(char[] cArray, int n, int n2, String string) {
        int n3;
        char c;
        int n4;
        Node node;
        int n5;
        int n6;
        int n7;
        char[] cArray2;
        block23: {
            block24: {
                cArray2 = cArray;
                n7 = n;
                n6 = n2;
                n5 = 0;
                Node node2 = this.fCache;
                node = node2.next;
                while (true) {
                    if ((n4 = cArray2[n7++]) >= 55296) {
                        if (n4 < 56320) {
                            if (n7 == n6) {
                                CharConversionError.missingSecondHalfOfSurrogatePair();
                            }
                            if ((c = cArray2[n7++]) < '\udc00' || c >= '\ue000') {
                                CharConversionError.invalidSecondHalfOfSurrogatePair();
                            }
                            n4 = 65536 + (n4 - 55296 << 10) + (c - 56320);
                        } else if (n4 < 57344) {
                            CharConversionError.invalidFirstHalfOfSurrogatePair();
                        }
                    }
                    if (node.ch != n4) {
                        node = SymbolTable.splay(node, n4);
                        if (node.ch != n4) {
                            n5 = 1;
                            break block23;
                        }
                        node2.next = node;
                    }
                    if (n7 >= n6) break block24;
                    if (node.next == null) break;
                    node2 = node;
                    node = node2.next;
                }
                n5 = 2;
                break block23;
            }
            n3 = node.handle;
            if (n3 != 0) {
                return n3;
            }
            n5 = 3;
        }
        switch (n5) {
            case 1: {
                Node node3 = this.cacheNodeAllocate();
                node3.ch = n4;
                if (node.ch < n4) {
                    node3.right = node.right;
                    node3.left = node;
                    node.right = null;
                } else {
                    node3.left = node.left;
                    node3.right = node;
                    node.left = null;
                }
                node2.next = node = node3;
                if (n7 == n6) break;
            }
            case 2: {
                Node node3;
                do {
                    if ((n4 = cArray2[n7++]) >= 55296) {
                        if (n4 < 56320) {
                            if (n7 == n6) {
                                CharConversionError.missingSecondHalfOfSurrogatePair();
                            }
                            if ((c = cArray2[n7++]) < '\udc00' || c >= '\ue000') {
                                CharConversionError.invalidSecondHalfOfSurrogatePair();
                            }
                            n4 = 65536 + (n4 - 55296 << 10) + (c - 56320);
                        } else {
                            CharConversionError.invalidFirstHalfOfSurrogatePair();
                        }
                    }
                    node3 = this.cacheNodeAllocate();
                    node3.ch = n4;
                    node.next = node3;
                    node = node3;
                } while (n7 < n6);
                break;
            }
        }
        node.handle = n3 = this.fSymbolCount++;
        if (string == null) {
            string = new String(cArray2, n, n2 - n);
        }
        this.setStringForHandle(string.intern(), n3);
        return n3;
    }

    private void setStringForHandle(String string, int n) {
        int n2 = n >>> 13;
        int n3 = n & 0x1FFF;
        if (n2 < this.fString.length) {
            if (this.fString[n2] != null) {
                if (n3 < this.fString[n2].length) {
                    this.fString[n2][n3] = string;
                    this.fPrefixHandle[n2][n3] = 0;
                    this.fLocalHandle[n2][n3] = 0;
                    return;
                }
                String[] stringArray = new String[n3 << 1];
                System.arraycopy(this.fString[n2], 0, stringArray, 0, n3);
                this.fString[n2] = stringArray;
                int[] nArray = new int[n3 << 1];
                System.arraycopy(this.fPrefixHandle[n2], 0, nArray, 0, n3);
                this.fPrefixHandle[n2] = nArray;
                nArray = new int[n3 << 1];
                System.arraycopy(this.fLocalHandle[n2], 0, nArray, 0, n3);
                this.fLocalHandle[n2] = nArray;
            } else {
                this.fString[n2] = new String[256];
                this.fPrefixHandle[n2] = new int[256];
                this.fLocalHandle[n2] = new int[256];
            }
        } else {
            String[][] stringArrayArray = new String[n2 << 1][];
            System.arraycopy(this.fString, 0, stringArrayArray, 0, n2);
            this.fString = stringArrayArray;
            int[][] nArrayArray = new int[n2 << 1][];
            System.arraycopy(this.fPrefixHandle, 0, nArrayArray, 0, n2);
            this.fPrefixHandle = nArrayArray;
            nArrayArray = new int[n2 << 1][];
            System.arraycopy(this.fLocalHandle, 0, nArrayArray, 0, n2);
            this.fLocalHandle = nArrayArray;
            this.fString[n2] = new String[256];
            this.fPrefixHandle[n2] = new int[256];
            this.fLocalHandle[n2] = new int[256];
        }
        this.fString[n2][n3] = string;
    }

    private static Node splay(Node node, int n) {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        Node node5 = null;
        while (node.ch != n) {
            if (node.ch < n) {
                if (node.right == null) break;
                if (node.right.ch > n && node.right.left != null) {
                    if (node4 == null) {
                        node2 = node;
                    } else {
                        node4.right = node;
                    }
                    node4 = node;
                    if (node5 == null) {
                        node3 = node.right;
                    } else {
                        node5.left = node.right;
                    }
                    node5 = node.right;
                    node = node5.left;
                    continue;
                }
                if (node.right.ch < n && node.right.right != null) {
                    if (node4 == null) {
                        node2 = node.right;
                    } else {
                        node4.right = node.right;
                    }
                    node4 = node.right;
                    node.right = node4.left;
                    node4.left = node;
                    node = node4.right;
                    continue;
                }
                if (node4 == null) {
                    node2 = node;
                } else {
                    node4.right = node;
                }
                node4 = node;
                node = node.right;
                break;
            }
            if (node.left == null) break;
            if (node.left.ch < n && node.left.right != null) {
                if (node5 == null) {
                    node3 = node;
                } else {
                    node5.left = node;
                }
                node5 = node;
                if (node4 == null) {
                    node2 = node.left;
                } else {
                    node4.right = node.left;
                }
                node4 = node.left;
                node = node4.right;
                continue;
            }
            if (node.left.ch > n && node.left.left != null) {
                if (node5 == null) {
                    node3 = node.left;
                } else {
                    node5.left = node.left;
                }
                node5 = node.left;
                node.left = node5.right;
                node5.right = node;
                node = node5.left;
                continue;
            }
            if (node5 == null) {
                node3 = node;
            } else {
                node5.left = node;
            }
            node5 = node;
            node = node.left;
            break;
        }
        if (node4 != null) {
            node4.right = node.left;
            node.left = node2;
        }
        if (node5 != null) {
            node5.left = node.right;
            node.right = node3;
        }
        return node;
    }

    public static final class Node {
        public Node left;
        public Node right;
        public Node next;
        public int ch;
        public int handle;
    }
}

