/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1421746759512286392L;
    private static final String initialPropValue;
    private static String CLONE_HASHTABLE_FOR_SYNCHRONIZATION;
    transient int elementCount;
    transient Entry<K, V>[] elementData;
    private float loadFactor;
    private int threshold;
    transient int firstSlot = 0;
    transient int lastSlot = -1;
    transient int modCount = 0;
    private static final Enumeration emptyEnumerator;
    private static final Iterator emptyIterator;
    private static boolean isInitialized;
    private static boolean useHashCache;

    private static Entry newEntry(Object object, Object object2, int n) {
        if (useHashCache) {
            return new HashtableCacheHashEntry<Object, Object>(object, object2, n);
        }
        return new Entry<Object, Object>(object, object2);
    }

    public Hashtable() {
        this(11);
        if (!isInitialized && System.getProperties() != null && System.getProperty("java.vm.version") != null) {
            String string = System.getProperty("HASHTABLE_CACHE_HASHCODE");
            if (string == null || !string.equals("false")) {
                useHashCache = true;
            }
            isInitialized = true;
        }
    }

    public Hashtable(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.elementData = new Entry[n == 0 ? 1 : n];
        this.firstSlot = this.elementData.length;
        this.loadFactor = 0.75f;
        this.computeMaxSize();
    }

    public Hashtable(int n, float f) {
        if (n < 0 || !(f > 0.0f)) {
            throw new IllegalArgumentException();
        }
        this.elementCount = 0;
        this.firstSlot = n;
        this.elementData = new Entry[n == 0 ? 1 : n];
        this.loadFactor = f;
        this.computeMaxSize();
    }

    public Hashtable(Map<? extends K, ? extends V> map) {
        this(map.size() < 6 ? 11 : map.size() * 4 / 3 + 11);
        this.putAll(map);
    }

    @Override
    public synchronized void clear() {
        this.elementCount = 0;
        Arrays.fill(this.elementData, null);
        ++this.modCount;
    }

    public synchronized Object clone() {
        try {
            Hashtable hashtable = (Hashtable)super.clone();
            hashtable.elementData = new Entry[this.elementData.length];
            int n = this.elementData.length;
            while (--n >= 0) {
                Entry<K, V> entry = this.elementData[n];
                if (entry == null) continue;
                hashtable.elementData[n] = (Entry)entry.clone();
            }
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    public synchronized boolean contains(Object object) {
        if (object != null) {
            int n = this.elementData.length;
            while (--n >= 0) {
                Entry<K, V> entry = this.elementData[n];
                while (entry != null) {
                    if (object.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
            return false;
        }
        throw new NullPointerException();
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    @Override
    public synchronized Enumeration<V> elements() {
        if (this.elementCount == 0) {
            return emptyEnumerator;
        }
        return new HashIterator(false);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new Collections.SynchronizedSet<Map.Entry<K, V>>(new AbstractSet(){

            public int size() {
                return Hashtable.this.elementCount;
            }

            public void clear() {
                Hashtable.this.clear();
            }

            public boolean remove(Object object) {
                if (this.contains(object)) {
                    Hashtable.this.remove(((Map.Entry)object).getKey());
                    return true;
                }
                return false;
            }

            public boolean contains(Object object) {
                if (object instanceof Map.Entry) {
                    Entry entry = Hashtable.this.getEntry(((Map.Entry)object).getKey());
                    if (entry == null) {
                        return false;
                    }
                    return entry.equals(object);
                }
                return false;
            }

            public Iterator iterator() {
                if (Hashtable.this.elementCount == 0) {
                    return emptyIterator;
                }
                return new HashIterator(MapEntry.Type.entryIterator);
            }
        }, (Object)this);
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() != map.size()) {
                return false;
            }
            Set set = map.entrySet();
            Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                if (set.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized V get(Object object) {
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = this.elementData[n2];
        while (entry != null) {
            if (entry.equalsKey(object, n)) {
                return (V)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    Entry getEntry(Object object) {
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = this.elementData[n2];
        while (entry != null) {
            if (entry.equalsKey(object, n)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public synchronized int hashCode() {
        int n = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            K k = entry.getKey();
            V v = entry.getValue();
            int n2 = (k != this ? k.hashCode() : 0) ^ (v != this ? (v != null ? v.hashCode() : 0) : 0);
            n += n2;
        }
        return n;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public synchronized Enumeration<K> keys() {
        if (this.elementCount == 0) {
            return emptyEnumerator;
        }
        return new HashIterator(true);
    }

    @Override
    public Set<K> keySet() {
        return new Collections.SynchronizedSet(new AbstractSet(){

            public boolean contains(Object object) {
                return Hashtable.this.containsKey(object);
            }

            public int size() {
                return Hashtable.this.elementCount;
            }

            public void clear() {
                Hashtable.this.clear();
            }

            public boolean remove(Object object) {
                if (Hashtable.this.containsKey(object)) {
                    Hashtable.this.remove(object);
                    return true;
                }
                return false;
            }

            public Iterator iterator() {
                if (Hashtable.this.elementCount == 0) {
                    return emptyIterator;
                }
                return new HashIterator(MapEntry.Type.keyIterator);
            }
        }, (Object)this);
    }

    @Override
    public synchronized V put(K k, V v) {
        if (k != null && v != null) {
            int n = k.hashCode();
            int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
            Entry entry = this.elementData[n2];
            while (entry != null && !entry.equalsKey(k, n)) {
                entry = entry.next;
            }
            if (entry == null) {
                ++this.modCount;
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                    n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
                }
                if (n2 < this.firstSlot) {
                    this.firstSlot = n2;
                }
                if (n2 > this.lastSlot) {
                    this.lastSlot = n2;
                }
                entry = Hashtable.newEntry(k, v, n);
                entry.next = this.elementData[n2];
                this.elementData[n2] = entry;
                return null;
            }
            Object object = entry.value;
            entry.value = v;
            return (V)object;
        }
        throw new NullPointerException();
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected void rehash() {
        int n = (this.elementData.length << 1) + 1;
        if (n == 0) {
            n = 1;
        }
        int n2 = n;
        int n3 = -1;
        Entry[] entryArray = new Entry[n];
        int n4 = this.lastSlot + 1;
        while (--n4 >= this.firstSlot) {
            Entry<K, V> entry = this.elementData[n4];
            while (entry != null) {
                int n5 = (entry.getKeyHash() & Integer.MAX_VALUE) % n;
                if (n5 < n2) {
                    n2 = n5;
                }
                if (n5 > n3) {
                    n3 = n5;
                }
                Entry entry2 = entry.next;
                entry.next = entryArray[n5];
                entryArray[n5] = entry;
                entry = entry2;
            }
        }
        this.firstSlot = n2;
        this.lastSlot = n3;
        this.elementData = entryArray;
        this.computeMaxSize();
    }

    @Override
    public synchronized V remove(Object object) {
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = null;
        Entry<K, V> entry2 = this.elementData[n2];
        while (entry2 != null && !entry2.equalsKey(object, n)) {
            entry = entry2;
            entry2 = entry2.next;
        }
        if (entry2 != null) {
            ++this.modCount;
            if (entry == null) {
                this.elementData[n2] = entry2.next;
            } else {
                entry.next = entry2.next;
            }
            --this.elementCount;
            Object object2 = entry2.value;
            entry2.value = null;
            return (V)object2;
        }
        return null;
    }

    @Override
    public synchronized int size() {
        return this.elementCount;
    }

    public synchronized String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(this.size() * 28);
        stringBuilder.append('{');
        for (int i = this.lastSlot; i >= this.firstSlot; --i) {
            Entry<K, V> entry = this.elementData[i];
            while (entry != null) {
                if (entry.key != this) {
                    stringBuilder.append(entry.key);
                } else {
                    stringBuilder.append("(this Map)");
                }
                stringBuilder.append('=');
                if (entry.value != this) {
                    stringBuilder.append(entry.value);
                } else {
                    stringBuilder.append("(this Map)");
                }
                stringBuilder.append(", ");
                entry = entry.next;
            }
        }
        if (this.elementCount > 0) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Collection<V> values() {
        return new Collections.SynchronizedCollection(new AbstractCollection(){

            public boolean contains(Object object) {
                return Hashtable.this.contains(object);
            }

            public int size() {
                return Hashtable.this.elementCount;
            }

            public void clear() {
                Hashtable.this.clear();
            }

            public Iterator iterator() {
                if (Hashtable.this.elementCount == 0) {
                    return emptyIterator;
                }
                return new HashIterator(MapEntry.Type.valueIterator);
            }
        }, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (CLONE_HASHTABLE_FOR_SYNCHRONIZATION == initialPropValue) {
            CLONE_HASHTABLE_FOR_SYNCHRONIZATION = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("CLONE_HASHTABLE_FOR_SYNCHRONIZATION");
                }
            });
        }
        if (CLONE_HASHTABLE_FOR_SYNCHRONIZATION != null) {
            Hashtable hashtable = (Hashtable)this.clone();
            this.writeObject(hashtable, objectOutputStream);
            return;
        }
        Hashtable hashtable = this;
        synchronized (hashtable) {
            this.writeObject(this, objectOutputStream);
        }
    }

    private void writeObject(Hashtable hashtable, ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("threshold", hashtable.threshold);
        putField.put("loadFactor", hashtable.loadFactor);
        objectOutputStream.writeFields();
        objectOutputStream.writeInt(hashtable.elementData.length);
        objectOutputStream.writeInt(hashtable.elementCount);
        int n = hashtable.elementData.length;
        while (--n >= 0) {
            Entry<K, V> entry = hashtable.elementData[n];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elementData = new Entry[n];
        int n2 = this.elementCount = objectInputStream.readInt();
        while (--n2 >= 0) {
            Object object = objectInputStream.readObject();
            int n3 = object.hashCode();
            int n4 = (n3 & Integer.MAX_VALUE) % n;
            if (n4 < this.firstSlot) {
                this.firstSlot = n4;
            }
            if (n4 > this.lastSlot) {
                this.lastSlot = n4;
            }
            Entry entry = Hashtable.newEntry(object, objectInputStream.readObject(), n3);
            entry.next = this.elementData[n4];
            this.elementData[n4] = entry;
        }
    }

    static {
        CLONE_HASHTABLE_FOR_SYNCHRONIZATION = initialPropValue = new String();
        emptyEnumerator = new EmptyEnumerator();
        emptyIterator = new EmptyIterator();
        isInitialized = false;
        useHashCache = false;
    }

    private final class HashIterator
    implements Iterator,
    Enumeration {
        private int position;
        private int expectedModCount;
        private MapEntry.Type type;
        private Entry entry;
        private Entry removeEntry;
        private int removePosition;

        HashIterator(MapEntry.Type type) {
            this.type = type;
            this.position = Hashtable.this.lastSlot + 1;
            this.expectedModCount = Hashtable.this.modCount;
        }

        HashIterator(boolean bl) {
            this.type = bl ? MapEntry.Type.keyEnumeration : MapEntry.Type.valueEnumeration;
            this.position = Hashtable.this.lastSlot + 1;
            this.expectedModCount = Hashtable.this.modCount;
        }

        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.position > Hashtable.this.firstSlot) {
                if (Hashtable.this.elementData[--this.position] == null) continue;
                this.entry = Hashtable.this.elementData[this.position];
                return true;
            }
            return false;
        }

        public boolean hasNext() {
            if (this.entry != null) {
                return true;
            }
            while (this.position > Hashtable.this.firstSlot) {
                if ((this.entry = Hashtable.this.elementData[--this.position]) == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasNext()) {
                this.removeEntry = this.entry;
                this.removePosition = this.position;
                Object object = this.type.get(this.entry);
                this.entry = this.entry.next;
                return object;
            }
            throw new NoSuchElementException();
        }

        public Object next() {
            if (this.expectedModCount == Hashtable.this.modCount) {
                if (this.hasNext()) {
                    this.removeEntry = this.entry;
                    this.removePosition = this.position;
                    Object object = this.type.get(this.entry);
                    this.entry = this.entry.next;
                    return object;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this.type.isIterator()) {
                if (this.expectedModCount == Hashtable.this.modCount) {
                    if (this.removeEntry != null) {
                        Hashtable hashtable = Hashtable.this;
                        synchronized (hashtable) {
                            boolean bl = false;
                            Entry entry = Hashtable.this.elementData[this.removePosition];
                            if (entry == this.removeEntry) {
                                Hashtable.this.elementData[this.removePosition] = entry.next;
                                bl = true;
                            } else {
                                while (entry != null && entry.next != this.removeEntry) {
                                    entry = entry.next;
                                }
                                if (entry != null) {
                                    entry.next = this.removeEntry.next;
                                    bl = true;
                                }
                            }
                            this.removeEntry = null;
                            if (bl) {
                                ++Hashtable.this.modCount;
                                --Hashtable.this.elementCount;
                                ++this.expectedModCount;
                                return;
                            }
                        }
                    } else {
                        throw new IllegalStateException();
                    }
                }
                throw new ConcurrentModificationException();
            }
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    extends MapEntry<K, V> {
        Entry<K, V> next;

        Entry(K k, V v) {
            super(k, v);
        }

        @Override
        public Object clone() {
            Entry entry = (Entry)super.clone();
            if (this.next != null) {
                entry.next = (Entry)this.next.clone();
            }
            return entry;
        }

        @Override
        public V setValue(V v) {
            if (v == null) {
                throw new NullPointerException();
            }
            Object object = this.value;
            this.value = v;
            return (V)object;
        }

        public int getKeyHash() {
            return this.key.hashCode();
        }

        public boolean equalsKey(Object object, int n) {
            return this.key.equals(object);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HashtableCacheHashEntry<K, V>
    extends Entry<K, V> {
        private int hashCode;

        HashtableCacheHashEntry(K k, V v, int n) {
            super(k, v);
            this.hashCode = n;
        }

        @Override
        public int getKeyHash() {
            return this.hashCode;
        }

        @Override
        public boolean equalsKey(Object object, int n) {
            return n == this.hashCode && this.key.equals(object);
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class EmptyEnumerator
    implements Enumeration {
        private EmptyEnumerator() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }
}

