/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.io.ConsoleInputStream;
import com.ibm.jvm.io.ConsolePrintStream;
import com.ibm.misc.SystemIntialization;
import com.ibm.oti.util.Msg;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static final Runtime RUNTIME;
    private static Properties systemProperties;
    private static SecurityManager security;
    private static final int NANO_RETURN = 0;
    private static final int NANO_DIVIDE = 1;
    private static final int NANO_INT_DIVIDE = 2;
    private static final int NANO_MULTIPLY = 3;
    private static final int NANO_INT_MULTIPLY = 4;
    private static final int nanoType;
    private static final double nanoAdjust;
    private static final long nanoIntAdjust;
    private static final int InitLocale = 0;
    private static final int PlatformEncoding = 1;
    private static final int FileEncoding = 2;
    private static final int OSEncoding = 3;

    static void completeInitialization() {
        System.setIn(ConsoleInputStream.localize((InputStream)new BufferedInputStream(new FileInputStream(FileDescriptor.in))));
        Terminator.setup();
        SystemIntialization.lastChanceHook();
    }

    public static void setIn(InputStream inputStream) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(RuntimePermission.permissionToSetIO);
        }
        System.setFieldImpl("in", inputStream);
    }

    public static void setOut(PrintStream printStream) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(RuntimePermission.permissionToSetIO);
        }
        System.setFieldImpl("out", printStream);
    }

    public static void setErr(PrintStream printStream) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(RuntimePermission.permissionToSetIO);
        }
        System.setFieldImpl("err", printStream);
    }

    private System() {
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    private static void arraycopy(Object[] objectArray, int n, Object[] objectArray2, int n2, int n3) {
        if (objectArray == null || objectArray2 == null) {
            throw new NullPointerException();
        }
        if (n >= 0 && n2 >= 0 && n3 >= 0 && n3 <= objectArray.length - n && n3 <= objectArray2.length - n2) {
            if (objectArray != objectArray2 || n > n2 || n + n3 <= n2) {
                for (int i = 0; i < n3; ++i) {
                    objectArray2[n2 + i] = objectArray[n + i];
                }
            } else {
                for (int i = n3 - 1; i >= 0; --i) {
                    objectArray2[n2 + i] = objectArray[n + i];
                }
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static native long currentTimeMillis();

    private static void ensureProperties() {
        String string;
        String string2;
        systemProperties = new Properties();
        String string3 = System.getEncoding(1);
        String string4 = null;
        String string5 = System.getEncoding(2);
        String string6 = System.getEncoding(3);
        if (string5 != null) {
            string2 = string5;
            if (string6 == null) {
                string4 = string3;
            }
        } else {
            string2 = string3;
        }
        if (string4 == null) {
            string4 = string6;
        }
        if (string4 != null) {
            systemProperties.put("os.encoding", string4);
        }
        systemProperties.put("ibm.system.encoding", string3);
        systemProperties.put("sun.jnu.encoding", string3);
        systemProperties.put("file.encoding", string2);
        systemProperties.put("java.version", "1.5.0");
        systemProperties.put("java.specification.version", "1.5");
        systemProperties.put("java.specification.vendor", "Sun Microsystems Inc.");
        systemProperties.put("java.specification.name", "Java Platform API Specification");
        systemProperties.put("com.ibm.oti.configuration", "scar");
        String[] stringArray = System.getPropertyList();
        for (int i = 0; i < stringArray.length && (string = stringArray[i]) != null; i += 2) {
            systemProperties.put(string, stringArray[i + 1]);
        }
        systemProperties.put("com.ibm.oti.jcl.build", "20091026_1356");
    }

    public static void exit(int n) {
        RUNTIME.exit(n);
    }

    public static void gc() {
        RUNTIME.gc();
    }

    public static String getenv(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv." + string));
        }
        return ProcessEnvironment.getenv(string);
    }

    public static Properties getProperties() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        return systemProperties;
    }

    static Properties internalGetProperties() {
        return systemProperties;
    }

    public static String getProperty(String string) {
        return System.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return systemProperties.getProperty(string, string2);
    }

    public static String setProperty(String string, String string2) {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return (String)systemProperties.setProperty(string, string2);
    }

    private static native String[] getPropertyList();

    private static native String getEncoding(int var0);

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static native int identityHashCode(Object var0);

    public static void load(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkLink(string);
        }
        ClassLoader.loadLibraryWithPath(string, ClassLoader.callerClassLoader(), null);
    }

    public static void loadLibrary(String string) {
        ClassLoader.loadLibraryWithClassLoader(string, ClassLoader.callerClassLoader());
    }

    public static void runFinalization() {
        RUNTIME.runFinalization();
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean bl) {
        Runtime.runFinalizersOnExit((boolean)bl);
    }

    public static void setProperties(Properties properties) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        if (properties == null) {
            System.ensureProperties();
        } else {
            systemProperties = properties;
        }
    }

    public static void setSecurityManager(final SecurityManager securityManager) {
        final SecurityManager securityManager2 = security;
        if (securityManager != null) {
            try {
                securityManager.checkPackageAccess("java.lang");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ProtectionDomain protectionDomain;
                        ProtectionDomain protectionDomain2 = securityManager2 == null ? System.class.getPDImpl() : securityManager2.getClass().getPDImpl();
                        if (protectionDomain2 != (protectionDomain = securityManager.getClass().getPDImpl())) {
                            Msg.getString("K002c");
                            protectionDomain.implies(new AllPermission());
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (securityManager2 != null) {
            securityManager2.checkPermission(RuntimePermission.permissionToSetSecurityManager);
        }
        security = securityManager;
    }

    public static native String mapLibraryName(String var0);

    private static native void setFieldImpl(String var0, Object var1);

    static Class getCallerClass() {
        return Class.getStackClass(2);
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    private static native long hiresFrequencyImpl();

    private static native long hiresClockImpl();

    public static long nanoTime() {
        long l = System.hiresClockImpl();
        switch (nanoType) {
            case 1: {
                return (long)((double)l / nanoAdjust);
            }
            case 2: {
                return l / nanoIntAdjust;
            }
            case 3: {
                return (long)((double)l * nanoAdjust);
            }
            case 4: {
                return l * nanoIntAdjust;
            }
        }
        return l;
    }

    public static String clearProperty(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return (String)systemProperties.remove(string);
    }

    public static Map<String, String> getenv() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv.*"));
        }
        return ProcessEnvironment.getenv();
    }

    static {
        RUNTIME = Runtime.getRuntime();
        long l = System.hiresFrequencyImpl();
        if (l == 1000000000L) {
            nanoType = 0;
            nanoAdjust = 0.0;
            nanoIntAdjust = 0L;
        } else if (l < 1000000000L) {
            nanoAdjust = 1.0E9 / (double)l;
            if (Math.floor(nanoAdjust) == nanoAdjust) {
                nanoType = 4;
                nanoIntAdjust = (long)nanoAdjust;
            } else {
                nanoType = 3;
                nanoIntAdjust = 0L;
            }
        } else {
            nanoAdjust = (double)l / 1.0E9;
            if (Math.floor(nanoAdjust) == nanoAdjust) {
                nanoType = 1;
                nanoIntAdjust = (long)nanoAdjust;
            } else {
                nanoType = 1;
                nanoIntAdjust = 0L;
            }
        }
        System.ensureProperties();
        StringCoding.encode((char[])new char[1], (int)0, (int)1);
        err = ConsolePrintStream.localize((OutputStream)new BufferedOutputStream(new FileOutputStream(FileDescriptor.err)), (boolean)true);
        out = ConsolePrintStream.localize((OutputStream)new BufferedOutputStream(new FileOutputStream(FileDescriptor.out)), (boolean)true);
        in = null;
        SystemIntialization.firstChanceHook();
    }
}

