/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.AgentInitializationException;
import com.ibm.tools.attach.AgentLoadException;
import com.ibm.tools.attach.AttachNotSupportedException;
import com.ibm.tools.attach.VirtualMachineDescriptor;
import com.ibm.tools.attach.javaSE.AttachHandler;
import com.ibm.tools.attach.javaSE.AttachProvider;
import com.ibm.tools.attach.javaSE.BlockingFileLockManager;
import com.ibm.tools.attach.javaSE.IPC;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VirtualMachine
extends com.ibm.tools.attach.VirtualMachine {
    private static final String DEFAULT_TIMEOUT_STRING = "120000";
    static final String COM_IBM_TOOLS_ATTACH_TIMEOUT = "com.ibm.tools.attach.timeout";
    private static int ATTACH_TIMEOUT;
    private static final String INSTRUMENT_LIBRARY = "instrument";
    private static final int ACK_TIMEOUT;
    private static final int ATTACH_RETRY_LIMIT = 4;
    private final IPC targetIPC;
    private final AttachProvider myProvider;
    private ServerSocket targetServer;
    private int portNumber;
    private final com.ibm.tools.attach.javaSE.VirtualMachineDescriptor descriptor;
    private Socket targetSocket;
    private InputStream responseStream;
    private OutputStream commandStream;
    private BlockingFileLockManager[] targetLocks;
    private boolean targetAttached = false;

    private static int setTimeout() {
        int n;
        String string = System.getProperties().getProperty(COM_IBM_TOOLS_ATTACH_TIMEOUT, DEFAULT_TIMEOUT_STRING);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = Integer.parseInt(DEFAULT_TIMEOUT_STRING);
        }
        return n;
    }

    VirtualMachine(com.ibm.tools.attach.spi.AttachProvider attachProvider, String string) throws NullPointerException {
        super(attachProvider, string);
        if (null == string || null == attachProvider) {
            throw new NullPointerException(Msg.getString("K03bd"));
        }
        this.targetIPC = new IPC(string);
        this.myProvider = (AttachProvider)attachProvider;
        this.descriptor = (com.ibm.tools.attach.javaSE.VirtualMachineDescriptor)this.myProvider.getDescriptor(string);
        if (null != this.descriptor) {
            this.targetIPC.setSemaphoreName(this.descriptor.getNotifierId());
        }
    }

    void attachTarget() throws IOException, AttachNotSupportedException {
        AttachNotSupportedException attachNotSupportedException = null;
        for (int i = 0; i < 4; ++i) {
            attachNotSupportedException = null;
            try {
                this.tryAttachTarget();
            }
            catch (AttachNotSupportedException attachNotSupportedException2) {
                AttachHandler.logMessage("attachTarget " + this.targetIPC.getVmId() + " timeout #" + i);
                attachNotSupportedException = attachNotSupportedException2;
            }
            if (null == attachNotSupportedException) break;
        }
        if (null != attachNotSupportedException) {
            throw attachNotSupportedException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryAttachTarget() throws IOException, AttachNotSupportedException {
        IPC.ReplyFileset replyFileset = null;
        this.targetIPC.obtainAttachLock();
        Object object = AttachHandler.getMainHandler().getIgnoreNotification();
        if (!AttachHandler.isAttachApiInitialized()) {
            throw new AttachNotSupportedException(Msg.getString("K0541"));
        }
        Object object2 = object;
        synchronized (object2) {
            List<VirtualMachineDescriptor> list;
            int n;
            block24: {
                n = 0;
                try {
                    if (null == this.descriptor) {
                        throw new AttachNotSupportedException(Msg.getString("K0531"));
                    }
                    list = this.myProvider.listVirtualMachines();
                    if (null != list) break block24;
                    if (null != replyFileset) {
                        replyFileset.eraseReply();
                    }
                    this.unlockAllAttachNotificationSyncFiles();
                    this.targetIPC.cancelNotify(n);
                }
                catch (Throwable throwable) {
                    if (null != replyFileset) {
                        replyFileset.eraseReply();
                    }
                    this.unlockAllAttachNotificationSyncFiles();
                    this.targetIPC.cancelNotify(n);
                    if (n > 2) {
                        try {
                            int n2 = 100 * (n > 10 ? 10 : n);
                            AttachHandler.logMessage("attachTarget sleep for " + n2);
                            Thread.sleep(n2);
                        }
                        catch (InterruptedException interruptedException) {
                            AttachHandler.logMessage("attachTarget sleep interrupted");
                        }
                    }
                    this.targetIPC.releaseAttachLock();
                    throw throwable;
                }
                if (n > 2) {
                    try {
                        int n3 = 100 * (n > 10 ? 10 : n);
                        AttachHandler.logMessage("attachTarget sleep for " + n3);
                        Thread.sleep(n3);
                    }
                    catch (InterruptedException interruptedException) {
                        AttachHandler.logMessage("attachTarget sleep interrupted");
                    }
                }
                this.targetIPC.releaseAttachLock();
                return;
            }
            this.targetServer = new ServerSocket(0);
            this.portNumber = this.targetServer.getLocalPort();
            String string = Integer.toString(this.portNumber);
            String string2 = Integer.toHexString(new Random(System.nanoTime()).nextInt());
            replyFileset = new IPC.ReplyFileset(IPC.getTargetDirectoryPath(this.descriptor.id()));
            replyFileset.writeReply(string2, string);
            this.lockAllAttachNotificationSyncFiles(list);
            n = AttachHandler.getNumberOfTargets();
            int n4 = this.targetIPC.notifyVm(n);
            if (0 != n4 && 103 != n4) {
                throw new AttachNotSupportedException(Msg.getString("K0532", n4));
            }
            try {
                AttachHandler.logMessage("attachTarget " + this.targetIPC.getVmId() + " on port " + string);
                this.targetServer.setSoTimeout(ATTACH_TIMEOUT);
                this.targetSocket = this.targetServer.accept();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.targetServer.close();
                AttachHandler.logMessage("attachTarget SocketTimeoutException on " + string + " to " + this.targetIPC.getVmId());
                throw new AttachNotSupportedException(Msg.getString("K0539", this.targetIPC.getVmId(), string));
            }
            this.commandStream = this.targetSocket.getOutputStream();
            this.targetSocket.setSoTimeout(ACK_TIMEOUT);
            this.responseStream = this.targetSocket.getInputStream();
            String string3 = IPC.streamReceiveString(this.responseStream);
            if (!string3.contains(' ' + string2 + ' ')) {
                throw new AttachNotSupportedException(Msg.getString("K0533", string3));
            }
            AttachHandler.logMessage("attachTarget connected on " + string);
            this.targetAttached = true;
            if (null != replyFileset) {
                replyFileset.eraseReply();
            }
            this.unlockAllAttachNotificationSyncFiles();
            this.targetIPC.cancelNotify(n);
            if (n > 2) {
                try {
                    int n5 = 100 * (n > 10 ? 10 : n);
                    AttachHandler.logMessage("attachTarget sleep for " + n5);
                    Thread.sleep(n5);
                }
                catch (InterruptedException interruptedException) {
                    AttachHandler.logMessage("attachTarget sleep interrupted");
                }
            }
            this.targetIPC.releaseAttachLock();
        }
    }

    private void lockAllAttachNotificationSyncFiles(List<VirtualMachineDescriptor> list) {
        Iterator<VirtualMachineDescriptor> iterator = list.iterator();
        int n = 0;
        this.targetLocks = new BlockingFileLockManager[list.size()];
        while (iterator.hasNext()) {
            com.ibm.tools.attach.javaSE.VirtualMachineDescriptor virtualMachineDescriptor;
            try {
                virtualMachineDescriptor = (com.ibm.tools.attach.javaSE.VirtualMachineDescriptor)iterator.next();
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            if (!virtualMachineDescriptor.id().equalsIgnoreCase(AttachHandler.getMyVmId())) {
                String string = virtualMachineDescriptor.getAttachSyncFileValue();
                if (null != string) {
                    AttachHandler.logMessage("lockAllAttachNotificationSyncFiles locking targetLocks[" + n + "]" + string);
                    this.targetLocks[n] = new BlockingFileLockManager(string);
                    this.targetLocks[n].obtainLock();
                }
            } else {
                this.targetLocks[n] = null;
            }
            ++n;
        }
    }

    private void unlockAllAttachNotificationSyncFiles() {
        if (null != this.targetLocks) {
            for (int i = 0; i < this.targetLocks.length; ++i) {
                AttachHandler.logMessage("unlockAllAttachNotificationSyncFiles unlocking targetLocks[" + i + "]");
                if (null == this.targetLocks[i]) continue;
                this.targetLocks[i].releaseLock();
            }
        }
    }

    private String createLoadAgentLibrary(String string, String string2, boolean bl) {
        String string3 = bl ? "ATTACH_LOADAGENTPATH" : "ATTACH_LOADAGENTLIBRARY";
        String string4 = null == string2 || string2.equals("") ? "" : ',' + string2;
        String string5 = string3 + '(' + string + string4 + ")";
        return string5;
    }

    private String createLoadAgent(String string, String string2) {
        String string3 = null == string2 ? "" : string2;
        String string4 = "ATTACH_LOADAGENT(instrument," + string + '=' + string3 + ')';
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void detach() throws IOException {
        IPC.streamSend(this.commandStream, "ATTACH_DETACH");
        try {
            IPC.streamReceiveString(this.responseStream);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            AttachHandler.logMessage("VirtualMachine.detach");
            if (null != this.commandStream) {
                this.commandStream.close();
                this.commandStream = null;
            }
            if (null != this.targetSocket) {
                this.targetSocket.close();
                this.targetSocket = null;
            }
            if (null != this.targetServer) {
                this.targetServer.close();
                this.targetServer = null;
            }
            throw throwable;
        }
        AttachHandler.logMessage("VirtualMachine.detach");
        if (null != this.commandStream) {
            this.commandStream.close();
            this.commandStream = null;
        }
        if (null != this.targetSocket) {
            this.targetSocket.close();
            this.targetSocket = null;
        }
        if (null != this.targetServer) {
            this.targetServer.close();
            this.targetServer = null;
        }
        this.targetAttached = false;
    }

    @Override
    public Properties getAgentProperties() throws IOException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString("K0544"));
        }
        Properties properties = this.getTargetProperties(false);
        return properties;
    }

    @Override
    public Properties getSystemProperties() throws IOException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString("K0544"));
        }
        Properties properties = this.getTargetProperties(true);
        return properties;
    }

    private synchronized Properties getTargetProperties(boolean bl) throws IOException {
        IPC.streamSend(this.commandStream, bl ? "ATTACH_GETSYSTEMPROPERTIES" : "ATTACH_GETAGENTPROPERTIES");
        Properties properties = new Properties();
        byte[] byArray = IPC.streamReceiveBytes(this.responseStream);
        properties.load(new ByteArrayInputStream(byArray));
        return properties;
    }

    @Override
    public synchronized void loadAgentLibrary(String string, String string2) throws AgentLoadException, AgentInitializationException, IOException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString("K0544"));
        }
        IPC.streamSend(this.commandStream, this.createLoadAgentLibrary(string, string2, false));
        String string3 = IPC.streamReceiveString(this.responseStream);
        this.parseResponse(string3);
    }

    @Override
    public synchronized void loadAgentPath(String string, String string2) throws AgentLoadException, AgentInitializationException, IOException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString("K0544"));
        }
        IPC.streamSend(this.commandStream, this.createLoadAgentLibrary(string, string2, true));
        String string3 = IPC.streamReceiveString(this.responseStream);
        this.parseResponse(string3);
    }

    private void parseResponse(String string) throws IOException, AgentInitializationException, AgentLoadException {
        if (string.startsWith("ATTACH_ERR".toString())) {
            int n = string.indexOf(0);
            String string2 = -1 == n ? string : string.substring(0, n);
            if (string.contains("IOException")) {
                throw new IOException();
            }
            if (string.contains("AgentInitializationException")) {
                throw new AgentInitializationException(string2);
            }
            if (string.contains("AgentLoadException")) {
                throw new AgentLoadException(string2);
            }
        }
    }

    static {
        ACK_TIMEOUT = ATTACH_TIMEOUT = VirtualMachine.setTimeout();
    }
}

