/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.javaSE;

import com.ibm.tools.attach.javaSE.AttachHandler;
import com.ibm.tools.attach.javaSE.FileLockManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Random;

class BlockingFileLockManager
extends Thread
implements FileLockManager {
    private static int FILE_LOCK_TIMEOUT = 10000;
    File myLockFile;
    private RandomAccessFile lockRAF;
    private FileChannel lockChannel;
    private FileLock myLock;
    private LockingStatus fileLockStatus = new LockingStatus();

    public BlockingFileLockManager(File file) {
        this.setDaemon(true);
        this.myLockFile = file;
        try {
            this.openLockChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.lockChannel = null;
        }
    }

    public BlockingFileLockManager(String string) {
        this(new File(string));
    }

    private void openLockChannel() throws FileNotFoundException {
        this.lockRAF = new RandomAccessFile(this.myLockFile, "rw");
        if (null != this.lockRAF) {
            this.lockChannel = this.lockRAF.getChannel();
        }
    }

    private void closeLockChannel() {
        try {
            if (null != this.lockChannel) {
                this.lockChannel.close();
            }
            if (null != this.lockRAF) {
                this.lockRAF.close();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void run() {
        this.waitAndCheckLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitAndCheckLock() {
        LockingStatus lockingStatus = this.getFileLockStatus();
        Object object = lockingStatus;
        synchronized (object) {
            try {
                lockingStatus.wait(FILE_LOCK_TIMEOUT);
            }
            catch (InterruptedException interruptedException) {
                AttachHandler.logMessage("waitAndCheckLock obtained lock on " + this.myLockFile.getAbsolutePath());
            }
        }
        if (!this.fileLockStatus.isFileLocked()) {
            AttachHandler.logMessage("waitAndCheckLock recreating " + this.myLockFile.getAbsolutePath());
            object = this.myLockFile.getAbsolutePath();
            String string = ".trash_" + new Random(System.nanoTime()).nextInt();
            this.myLockFile.renameTo(new File(string));
            File file = new File((String)object);
            try {
                if (null != this.lockChannel) {
                    this.lockChannel.close();
                }
            }
            catch (IOException iOException) {
                return false;
            }
            this.myLockFile.delete();
            this.myLockFile = file;
        }
        AttachHandler.logMessage("waitAndCheckLock normal return ");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean obtainLock() {
        for (int i = 0; i < 1; ++i) {
            Object object = this;
            synchronized (object) {
                this.start();
            }
            if (null == this.lockChannel) continue;
            try {
                object = this.fileLockStatus;
                synchronized (object) {
                    this.fileLockStatus.setFileLocked(false);
                    this.myLock = this.lockChannel.lock();
                    this.fileLockStatus.setFileLocked(true);
                    this.fileLockStatus.notifyAll();
                }
                this.lockChannel.force(true);
                this.interrupt();
                break;
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                break;
            }
            catch (ClosedChannelException closedChannelException) {
                try {
                    this.closeLockChannel();
                    this.openLockChannel();
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public void releaseLock() {
        try {
            if (null != this.myLock) {
                this.myLock.release();
            }
            if (null != this.lockChannel) {
                this.lockChannel.close();
            }
        }
        catch (IOException iOException) {
            this.myLock = null;
        }
        this.closeLockChannel();
    }

    public static int getFILE_LOCK_TIMEOUT() {
        return FILE_LOCK_TIMEOUT;
    }

    public static void setFILE_LOCK_TIMEOUT(int n) {
        FILE_LOCK_TIMEOUT = n;
    }

    public long lockFileLength() {
        return this.myLockFile.length();
    }

    public synchronized LockingStatus getFileLockStatus() {
        return this.fileLockStatus;
    }

    public synchronized void setFileLockStatus(LockingStatus lockingStatus) {
        this.fileLockStatus = lockingStatus;
    }

    protected class LockingStatus {
        private boolean fileLocked = false;

        protected LockingStatus() {
        }

        public synchronized boolean isFileLocked() {
            return this.fileLocked;
        }

        public synchronized void setFileLocked(boolean bl) {
            this.fileLocked = bl;
        }
    }
}

