/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class AbstractClassLoader
extends ClassLoader {
    private static ClassLoader systemClassLoader;
    String[] parsedPath;
    int[] types;
    Object[] cache;
    static Object cacheLock;
    FilePermission[] permissions;
    private static Object manifestLock;

    public AbstractClassLoader() {
    }

    public AbstractClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    void fillCache(int n) {
        this.setTypeElement(n, VM.getClassPathEntryType(this, n));
        switch (this.types[n]) {
            case 0: {
                this.setCacheElement(n, this.cache);
                return;
            }
            case 1: 
            case 2: {
                String string;
                if (this.parsedPath[n] == null) {
                    this.setParsedPathElement(n, Util.toString(VM.getPathFromClassPath(n)));
                }
                File file = new File(this.parsedPath[n]);
                try {
                    string = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string = file.getAbsolutePath();
                }
                if (this.types[n] == 1) {
                    if (string.charAt(string.length() - 1) != File.separatorChar) {
                        string = new StringBuffer(string.length() + 1).append(string).append(File.separatorChar).toString();
                    }
                    this.setParsedPathElement(n, string);
                    this.setCacheElement(n, this.cache);
                } else {
                    this.setParsedPathElement(n, string);
                    try {
                        JarFile jarFile = new JarFile(this.parsedPath[n]);
                        this.setCacheElement(n, jarFile);
                        return;
                    }
                    catch (IOException iOException) {
                        this.setTypeElement(n, 5);
                        this.setCacheElement(n, this.cache);
                    }
                }
                return;
            }
            case 4: 
            case 8: {
                this.setTypeElement(n, 5);
            }
            case 3: 
            case 5: {
                this.setCacheElement(n, this.cache);
                return;
            }
        }
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream;
        if (string == null || string.length() < 1 || string.charAt(0) == '/') {
            return null;
        }
        if (this != systemClassLoader && (inputStream = this.getParent() == null ? systemClassLoader.getResourceAsStream(string) : this.getParent().getResourceAsStream(string)) != null) {
            return inputStream;
        }
        int n = this.cache.length;
        block8: for (int i = 0; i < n; ++i) {
            try {
                if (this.cache[i] == null) {
                    this.fillCache(i);
                }
                switch (this.types[i]) {
                    case 2: {
                        ZipFile zipFile = (ZipFile)this.cache[i];
                        ZipEntry zipEntry = zipFile.getEntry(string);
                        if (zipEntry == null) continue block8;
                        Object object = System.getSecurityManager();
                        if (object != null) {
                            this.initalizePermissions();
                            if (this.permissions[i] == null) {
                                this.setPermissionElement(i, new FilePermission(this.parsedPath[i], "read"));
                            }
                            ((SecurityManager)object).checkPermission(this.permissions[i]);
                        }
                        try {
                            return zipFile.getInputStream(zipEntry);
                        }
                        catch (IOException iOException) {
                            break;
                        }
                    }
                    case 1: {
                        Object object = new StringBuffer(this.parsedPath[i].length() + string.length()).append(this.parsedPath[i]).append(string).toString();
                        InputStream inputStream2 = this.openFile((String)object);
                        if (inputStream2 == null) continue block8;
                        return inputStream2;
                    }
                }
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    private void setCacheElement(int n, Object object) {
        this.cache[n] = object;
    }

    private void setTypeElement(int n, int n2) {
        this.types[n] = n2;
    }

    private void setParsedPathElement(int n, String string) {
        this.parsedPath[n] = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initalizePermissions() {
        Object object = cacheLock;
        synchronized (object) {
            if (this.permissions == null) {
                this.permissions = new FilePermission[this.cache.length];
            }
        }
    }

    private void setPermissionElement(int n, FilePermission filePermission) {
        this.permissions[n] = filePermission;
    }

    private InputStream openFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    protected URL findResource(final String string) {
        SecurityManager securityManager;
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < AbstractClassLoader.this.cache.length; ++i) {
                    URL uRL = AbstractClassLoader.this.findResourceImpl(i, string);
                    if (uRL == null) continue;
                    return uRL;
                }
                return null;
            }
        });
        if (uRL != null && (securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkPermission(uRL.openConnection().getPermission());
            }
            catch (IOException iOException) {
                return null;
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        return uRL;
    }

    private URL findResourceImpl(int n, String string) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            return null;
        }
        if (this.cache[n] == null) {
            this.fillCache(n);
        }
        try {
            switch (this.types[n]) {
                case 2: {
                    ZipFile zipFile = (ZipFile)this.cache[n];
                    if (zipFile.getEntry(string) != null) {
                        return new URL("jar", null, -1, AbstractClassLoader.toURLString(this.parsedPath[n] + "!/" + string), null);
                    }
                    return null;
                }
                case 1: {
                    String string2 = new StringBuffer(this.parsedPath[n].length() + string.length()).append(this.parsedPath[n]).append(string).toString();
                    File file = new File(string2);
                    if (file.exists()) {
                        return new URL(AbstractClassLoader.toURLString(string2));
                    }
                    return null;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    protected Enumeration findResources(final String string) throws IOException {
        SecurityManager securityManager;
        Vector<URL> vector = (Vector<URL>)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Vector<URL> vector = new Vector<URL>();
                for (int i = 0; i < AbstractClassLoader.this.cache.length; ++i) {
                    URL uRL = AbstractClassLoader.this.findResourceImpl(i, string);
                    if (uRL == null) continue;
                    vector.addElement(uRL);
                }
                return vector;
            }
        });
        int n = vector.size();
        if (n > 0 && (securityManager = System.getSecurityManager()) != null) {
            Vector<URL> vector2 = new Vector<URL>(n);
            for (int i = 0; i < n; ++i) {
                URL uRL = (URL)vector.elementAt(i);
                try {
                    securityManager.checkPermission(uRL.openConnection().getPermission());
                    vector2.addElement(uRL);
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            vector = vector2;
        }
        return vector.elements();
    }

    static String toURLString(String string) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        string2 = Util.urlEncode(string2);
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 6).append("file:");
        if (!string2.startsWith("/")) {
            stringBuffer.append('/');
        }
        string2 = stringBuffer.append(string2).toString();
        return string2;
    }

    public static void setBootstrapClassLoader(ClassLoader classLoader) {
        if (systemClassLoader != null) {
            throw new IllegalArgumentException();
        }
        systemClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void definePackage(String string, final int n) {
        Object object;
        if (n >= 0 && this.cache[n] == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AbstractClassLoader.this.fillCache(n);
                    return null;
                }
            });
        }
        if (n >= 0 && this.types[n] == 2) {
            Object object2;
            object = null;
            try {
                object2 = (JarFile)this.cache[n];
                object = ((JarFile)object2).getManifest();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (object != null) {
                object2 = manifestLock;
                synchronized (object2) {
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    if (super.getPackage(string) != null) {
                        return;
                    }
                    Attributes attributes = ((Manifest)object).getMainAttributes();
                    String string8 = attributes.getValue(Attributes.Name.SEALED);
                    boolean bl = string8 != null && string8.toLowerCase().equals("true");
                    String string9 = string.replace('.', '/') + "/";
                    Attributes attributes2 = ((Manifest)object).getAttributes(string9);
                    if (attributes2 != null) {
                        string8 = attributes2.getValue(Attributes.Name.SEALED);
                        if (string8 != null) {
                            bl = string8.toLowerCase().equals("true");
                        }
                        string2 = attributes2.getValue(Attributes.Name.SPECIFICATION_TITLE);
                        string3 = attributes2.getValue(Attributes.Name.SPECIFICATION_VERSION);
                        string4 = attributes2.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                        string5 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                        string6 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        string7 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                    }
                    URL uRL = null;
                    try {
                        if (bl) {
                            uRL = new URL(AbstractClassLoader.toURLString(this.parsedPath[n]));
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (string2 == null) {
                        string2 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    }
                    if (string3 == null) {
                        string3 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    }
                    if (string4 == null) {
                        string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                    }
                    if (string5 == null) {
                        string5 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    }
                    if (string6 == null) {
                        string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    }
                    if (string7 == null) {
                        string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                    }
                    this.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
                    return;
                }
            }
        }
        object = manifestLock;
        synchronized (object) {
            if (super.getPackage(string) != null) {
                return;
            }
            this.definePackage(string, null, null, null, null, null, null, null);
        }
    }

    String getPackageName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    static {
        cacheLock = new CacheLock();
        manifestLock = new ManifestLock();
    }

    private static class ManifestLock {
        private ManifestLock() {
        }
    }

    private static class CacheLock {
        private CacheLock() {
        }
    }
}

