/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.reflect;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public class AnnotationHelper {
    public static final int ANNOTATION_TYPE_CLASS = 0;
    public static final int ANNOTATION_TYPE_FIELD = 1;
    public static final int ANNOTATION_TYPE_METHOD = 2;
    public static final int ANNOTATION_TYPE_PARAMETER = 3;
    public static final int ANNOTATION_TYPE_ANNOTATION = 4;
    public static final int ANNOTATION_PARM_SHIFT = 24;

    private static native long[] getAnnotationEntries(Class var0, int var1, Object var2);

    private static native String getAnnotationClassNameForEntry(long var0);

    private static native Object getReturnValueForEntry(Class var0, Class var1, Class var2, long var3, String var5);

    static native Object getDefaultReturnValueFromMethod(Class var0, Class var1, Object var2);

    public static Annotation getAnnotation(Class clazz, long l) {
        Annotation annotation = null;
        String string = AnnotationHelper.getAnnotationClassNameForEntry(l);
        try {
            Class<?> clazz2 = Class.forName(string, true, clazz.getClassLoader());
            annotation = (Annotation)Proxy.newProxyInstance(clazz2.getClassLoader(), new Class[]{clazz2}, (InvocationHandler)new AnnotationInvocationHandler(clazz, clazz2, l));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TypeNotPresentException(string, classNotFoundException);
        }
        return annotation;
    }

    public static Annotation[] getDeclaredAnnotations(Class clazz, int n, AccessibleObject accessibleObject) {
        long[] lArray = AnnotationHelper.getAnnotationEntries(clazz, n, accessibleObject);
        if (lArray == null) {
            return new Annotation[0];
        }
        Annotation[] annotationArray = new Annotation[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            annotationArray[i] = AnnotationHelper.getAnnotation(clazz, lArray[i]);
        }
        return annotationArray;
    }

    private Enum getEnumForValue(Class clazz, String string) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        for (int i = 0; i < enumArray.length; ++i) {
            if (!enumArray[i].name().equals(string)) continue;
            return enumArray[i];
        }
        return null;
    }

    private static Enum getEnumFromValue(Class clazz, String string) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        for (int i = 0; i < enumArray.length; ++i) {
            if (!enumArray[i].name().equals(string)) continue;
            return enumArray[i];
        }
        return null;
    }

    static class AnnotationInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 3206093459760838691L;
        private long entry;
        private Class clazz;
        private Class annType;

        AnnotationInvocationHandler(Class clazz, Class clazz2, long l) {
            this.entry = l;
            this.clazz = clazz;
            this.annType = clazz2;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getName().equals("toString")) {
                return this.objectToString();
            }
            if (method.getName().equals("annotationType")) {
                return this.annType;
            }
            if (method.getName().equals("equals")) {
                return this.compare(objectArray) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.getHashValue());
            }
            return AnnotationHelper.getReturnValueForEntry(this.clazz, this.annType, method.getReturnType(), this.entry, method.getName());
        }

        private String objectToString() throws Throwable {
            Method[] methodArray = this.annType.getDeclaredMethods();
            StringBuffer stringBuffer = new StringBuffer(methodArray.length * 48);
            stringBuffer.append('@').append(this.annType.getCanonicalName()).append('(');
            for (int i = 0; i < methodArray.length; ++i) {
                stringBuffer.append(methodArray[i].getName()).append('=');
                Object object = AnnotationHelper.getReturnValueForEntry(this.clazz, this.annType, methodArray[i].getReturnType(), this.entry, methodArray[i].getName());
                if (object.getClass().isArray()) {
                    stringBuffer.append(this.getArrayValue(object));
                } else {
                    stringBuffer.append(object);
                }
                if (i == methodArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        private boolean compare(Object[] objectArray) throws Throwable {
            if (objectArray.length != 1) {
                return false;
            }
            if (!(objectArray[0] instanceof Annotation)) {
                return false;
            }
            Class<? extends Annotation> clazz = ((Annotation)objectArray[0]).annotationType();
            if (!this.annType.equals(clazz)) {
                return false;
            }
            Method[] methodArray = this.annType.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Object object = AnnotationHelper.getReturnValueForEntry(this.clazz, this.annType, methodArray[i].getReturnType(), this.entry, methodArray[i].getName());
                methodArray[i].setAccessible(true);
                Object object2 = methodArray[i].invoke(objectArray[0], new Object[0]);
                if (object == null || object2 == null) {
                    if (object == object2) continue;
                    return false;
                }
                if (object.getClass().isArray() && object2.getClass().isArray()) {
                    if (object instanceof boolean[] && object2 instanceof boolean[]) {
                        if (Arrays.equals((boolean[])object, (boolean[])object2)) continue;
                        return false;
                    }
                    if (object instanceof char[] && object2 instanceof char[]) {
                        if (Arrays.equals((char[])object, (char[])object2)) continue;
                        return false;
                    }
                    if (object instanceof byte[] && object2 instanceof byte[]) {
                        if (Arrays.equals((byte[])object, (byte[])object2)) continue;
                        return false;
                    }
                    if (object instanceof short[] && object2 instanceof short[]) {
                        if (Arrays.equals((short[])object, (short[])object2)) continue;
                        return false;
                    }
                    if (object instanceof int[] && object2 instanceof int[]) {
                        if (Arrays.equals((int[])object, (int[])object2)) continue;
                        return false;
                    }
                    if (object instanceof float[] && object2 instanceof float[]) {
                        if (Arrays.equals((float[])object, (float[])object2)) continue;
                        return false;
                    }
                    if (object instanceof double[] && object2 instanceof double[]) {
                        if (Arrays.equals((double[])object, (double[])object2)) continue;
                        return false;
                    }
                    if (object instanceof long[] && object2 instanceof long[]) {
                        if (Arrays.equals((long[])object, (long[])object2)) continue;
                        return false;
                    }
                    if (object instanceof Object[] && object2 instanceof Object[]) {
                        if (Arrays.equals((Object[])object, (Object[])object2)) continue;
                        return false;
                    }
                    return false;
                }
                if (object.equals(object2)) continue;
                return false;
            }
            return true;
        }

        private int getHashValue() throws Throwable {
            Method[] methodArray = this.annType.getDeclaredMethods();
            int n = 0;
            for (int i = 0; i < methodArray.length; ++i) {
                int n2 = methodArray[i].getName().hashCode() * 127;
                Object object = AnnotationHelper.getReturnValueForEntry(this.clazz, this.annType, methodArray[i].getReturnType(), this.entry, methodArray[i].getName());
                if (object == null) {
                    n2 = 0;
                } else if (object.getClass().isArray()) {
                    if (object instanceof boolean[]) {
                        n2 ^= Arrays.hashCode((boolean[])object);
                    } else if (object instanceof char[]) {
                        n2 ^= Arrays.hashCode((char[])object);
                    } else if (object instanceof byte[]) {
                        n2 ^= Arrays.hashCode((byte[])object);
                    } else if (object instanceof short[]) {
                        n2 ^= Arrays.hashCode((short[])object);
                    } else if (object instanceof int[]) {
                        n2 ^= Arrays.hashCode((int[])object);
                    } else if (object instanceof float[]) {
                        n2 ^= Arrays.hashCode((float[])object);
                    } else if (object instanceof double[]) {
                        n2 ^= Arrays.hashCode((double[])object);
                    } else if (object instanceof long[]) {
                        n2 ^= Arrays.hashCode((long[])object);
                    } else if (object instanceof Object[]) {
                        n2 ^= Arrays.hashCode((Object[])object);
                    }
                } else {
                    n2 ^= object.hashCode();
                }
                n += n2;
            }
            return n;
        }

        private String getArrayValue(Object object) {
            if (object instanceof boolean[]) {
                return this.getBooleanArrayData((boolean[])object);
            }
            if (object instanceof char[]) {
                return this.getCharArrayData((char[])object);
            }
            if (object instanceof byte[]) {
                return this.getByteArrayData((byte[])object);
            }
            if (object instanceof char[]) {
                return this.getCharArrayData((char[])object);
            }
            if (object instanceof short[]) {
                return this.getShortArrayData((short[])object);
            }
            if (object instanceof int[]) {
                return this.getIntArrayData((int[])object);
            }
            if (object instanceof float[]) {
                return this.getFloatArrayData((float[])object);
            }
            if (object instanceof double[]) {
                return this.getDoubleArrayData((double[])object);
            }
            if (object instanceof long[]) {
                return this.getLongArrayData((long[])object);
            }
            return this.getObjectArrayData((Object[])object);
        }

        private String getObjectArrayData(Object[] objectArray) {
            StringBuffer stringBuffer = new StringBuffer(objectArray.length * 20);
            stringBuffer.append('[');
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i]);
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        private String getBooleanArrayData(boolean[] blArray) {
            StringBuffer stringBuffer = new StringBuffer(2 + blArray.length * 6);
            stringBuffer.append('[');
            for (int i = 0; i < blArray.length; ++i) {
                stringBuffer.append(blArray[i]);
                if (i >= blArray.length - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        private String getCharArrayData(char[] cArray) {
            StringBuffer stringBuffer = new StringBuffer(2 + cArray.length * 4);
            stringBuffer.append('[');
            for (int i = 0; i < cArray.length; ++i) {
                stringBuffer.append(cArray[i]);
                if (i >= cArray.length - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        private String getByteArrayData(byte[] byArray) {
            StringBuffer stringBuffer = new StringBuffer(2 + byArray.length * 4);
            stringBuffer.append('[');
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(byArray[i]);
                if (i >= byArray.length - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        private String getShortArrayData(short[] sArray) {
            StringBuffer stringBuffer = new StringBuffer(sArray.length * 6);
            stringBuffer.append('[');
            for (int i = 0; i < sArray.length; ++i) {
                stringBuffer.append(sArray[i]);
                if (i >= sArray.length - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        private String getIntArrayData(int[] nArray) {
            StringBuffer stringBuffer = new StringBuffer(nArray.length * 12);
            stringBuffer.append('[');
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(nArray[i]);
                if (i >= nArray.length - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        private String getFloatArrayData(float[] fArray) {
            StringBuffer stringBuffer = new StringBuffer(fArray.length * 15);
            stringBuffer.append('[');
            for (int i = 0; i < fArray.length; ++i) {
                stringBuffer.append(fArray[i]);
                if (i >= fArray.length - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        private String getDoubleArrayData(double[] dArray) {
            StringBuffer stringBuffer = new StringBuffer(dArray.length * 20);
            stringBuffer.append('[');
            for (int i = 0; i < dArray.length; ++i) {
                stringBuffer.append(dArray[i]);
                if (i >= dArray.length - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }

        private String getLongArrayData(long[] lArray) {
            StringBuffer stringBuffer = new StringBuffer(lArray.length * 20);
            stringBuffer.append('[');
            for (int i = 0; i < lArray.length; ++i) {
                stringBuffer.append(lArray[i]);
                if (i >= lArray.length - 1) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

