/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.InvalidSpannedRecordException;
import com.ibm.jvm.format.Merge;
import com.ibm.jvm.format.Message;
import com.ibm.jvm.format.MessageFile;
import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TracePoint;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.TraceRecord50;
import com.ibm.jvm.format.TraceThread;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public final class TraceFormat {
    private TraceArgs traceArgs = null;
    private Vector traceFiles = new Vector();
    private TraceFile traceFile = null;
    private BufferedWriter out;
    private static int generations;
    protected static MessageFile messageFile;
    protected static MessageFile messageFileBase;
    protected static Vector threads;
    protected static int invalidBuffers;
    protected static float verMod;
    protected static BigInteger overallStartSystem;
    protected static BigInteger overallStartPlatform;
    protected static BigInteger first;
    protected static BigInteger last;
    protected static BigInteger lastWritePlatform;
    protected static BigInteger lastWriteSystem;
    protected static BigInteger timeConversion;
    protected static String headings;
    protected static PrintStream outStream;
    protected static PrintStream errStream;
    protected static int expectedRecords;
    private Vector vectorOfAllTracePoints = null;
    private boolean populateGlobalArray = false;
    private boolean traceFileIsTruncatedOrCorrupt = false;
    private String[] types = new String[]{"Event     ", "Exception ", "Entry     ", "Entry     ", "Exit      ", "Exit      ", "Mem       ", "Mem       ", "Debug     ", "Debug     ", "Perf      ", "Perf      ", "AppTrace  "};
    protected static final String usageMessage = "Usage:\njava com.ibm.jvm.format.TraceFormat input_filespec [output_filespec] \n\t[-summary] [-datdir datfiledirectory] [-uservmid vmid] [-indent] \n\t[-overridetimezone noOfHours] [-help]\n\nwhere:\n\tinput_filespec = trace file generated by the jvm to be processed\n\toutput_filespec = name of the formatted file - default is\n\t      input_filespec.fmt\n\tsummary = print summary information to screen without generating\n\t      formatted file\n\n\tdatdir = used when the formatter is used to format a pre 5.0 vm's\n\t      tracefile. The datfilelocation tells the formatter where to\n\t      find the .dat files of the older vm's dat files. Default is\n\t      current directory, and the .dat files can be safely copied\n\t      into the current directory (as long as they don't overwrite\n\t      the current vm's .dat files).\n\tuservmid = users can specify a string to be inserted into each\n\t      tracepoint's formatted output, to help track and compare\n\t      tracefiles from multiple jvm runs.\n\t      e.g. java com.ibm.jvm.format.TraceFormat 142trcfile /\n\t           -datdir /142sdk/jre/lib\n\toverridetimezone = specify an integer number of hours to be\n\t      added to the formatted tracepoints (can be negative).\n\t      This option allows the user to override the default time\n\t      zone used in the formatter (GMT)\n\t      e.g. java com.ibm.jvm.format.TraceFormat trcfile /\n\t           -overridetimezone -4\n\tindent = specify indentation at Entry/Exit trace points.\n\t      Default is not to indent.\n\thelp \t= display this message and stop.";
    protected static final String header = "                Trace Formatted Data ";
    private static final int FAIL = -1;
    private static final int OK = 0;
    private static String userVMIdentifier;
    private int tracedThreadWithNewestTracePoint = -1;

    public static void main(String[] stringArray) {
        TraceFormat traceFormat = new TraceFormat();
        traceFormat.readAndFormat(stringArray);
    }

    public TraceFormat() {
        this.initStatics();
        this.vectorOfAllTracePoints = new Vector();
        outStream = System.out;
        errStream = new PrintStream(new PipedOutputStream());
    }

    public TraceFormat(String[] stringArray) {
        new TraceFormat(System.out, stringArray);
    }

    public TraceFormat(PrintStream printStream, String[] stringArray) {
        this.initStatics();
        outStream = printStream;
        errStream = new PrintStream(new PipedOutputStream());
        this.readAndFormat(stringArray);
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            outStream.println("Error closing formatted trace file.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void initStatics() {
        threads = new Vector();
        invalidBuffers = 0;
        overallStartSystem = BigInteger.ZERO;
        overallStartPlatform = BigInteger.ZERO;
        first = new BigInteger("FFFFFFFFFFFFFFFF", 16);
        last = BigInteger.ZERO;
        lastWritePlatform = BigInteger.ZERO;
        lastWriteSystem = BigInteger.ZERO;
        timeConversion = BigInteger.ZERO;
        headings = new String("ThreadID         TP id  Type         TraceEntry ");
        expectedRecords = 0;
        Util.initStatics();
        TraceArgs.initStatics();
        TraceRecord.initStatics();
        MessageFile.initStatics();
    }

    private void readAndFormat(String[] stringArray) {
        block48: {
            try {
                this.traceArgs = new TraceArgs(stringArray);
            }
            catch (TraceArgs.UsageException usageException) {
                outStream.println("TraceFormat Usage:\njava com.ibm.jvm.format.TraceFormat input_filespec [output_filespec] \n\t[-summary] [-datdir datfiledirectory] [-uservmid vmid] [-indent] \n\t[-overridetimezone noOfHours] [-help]\n\nwhere:\n\tinput_filespec = trace file generated by the jvm to be processed\n\toutput_filespec = name of the formatted file - default is\n\t      input_filespec.fmt\n\tsummary = print summary information to screen without generating\n\t      formatted file\n\n\tdatdir = used when the formatter is used to format a pre 5.0 vm's\n\t      tracefile. The datfilelocation tells the formatter where to\n\t      find the .dat files of the older vm's dat files. Default is\n\t      current directory, and the .dat files can be safely copied\n\t      into the current directory (as long as they don't overwrite\n\t      the current vm's .dat files).\n\tuservmid = users can specify a string to be inserted into each\n\t      tracepoint's formatted output, to help track and compare\n\t      tracefiles from multiple jvm runs.\n\t      e.g. java com.ibm.jvm.format.TraceFormat 142trcfile /\n\t           -datdir /142sdk/jre/lib\n\toverridetimezone = specify an integer number of hours to be\n\t      added to the formatted tracepoints (can be negative).\n\t      This option allows the user to override the default time\n\t      zone used in the formatter (GMT)\n\t      e.g. java com.ibm.jvm.format.TraceFormat trcfile /\n\t           -overridetimezone -4\n\tindent = specify indentation at Entry/Exit trace points.\n\t      Default is not to indent.\n\thelp \t= display this message and stop.");
                return;
            }
            if (TraceArgs.isHelpOnly) {
                outStream.println("TraceFormat Usage:\njava com.ibm.jvm.format.TraceFormat input_filespec [output_filespec] \n\t[-summary] [-datdir datfiledirectory] [-uservmid vmid] [-indent] \n\t[-overridetimezone noOfHours] [-help]\n\nwhere:\n\tinput_filespec = trace file generated by the jvm to be processed\n\toutput_filespec = name of the formatted file - default is\n\t      input_filespec.fmt\n\tsummary = print summary information to screen without generating\n\t      formatted file\n\n\tdatdir = used when the formatter is used to format a pre 5.0 vm's\n\t      tracefile. The datfilelocation tells the formatter where to\n\t      find the .dat files of the older vm's dat files. Default is\n\t      current directory, and the .dat files can be safely copied\n\t      into the current directory (as long as they don't overwrite\n\t      the current vm's .dat files).\n\tuservmid = users can specify a string to be inserted into each\n\t      tracepoint's formatted output, to help track and compare\n\t      tracefiles from multiple jvm runs.\n\t      e.g. java com.ibm.jvm.format.TraceFormat 142trcfile /\n\t           -datdir /142sdk/jre/lib\n\toverridetimezone = specify an integer number of hours to be\n\t      added to the formatted tracepoints (can be negative).\n\t      This option allows the user to override the default time\n\t      zone used in the formatter (GMT)\n\t      e.g. java com.ibm.jvm.format.TraceFormat trcfile /\n\t           -overridetimezone -4\n\tindent = specify indentation at Entry/Exit trace points.\n\t      Default is not to indent.\n\thelp \t= display this message and stop.");
                return;
            }
            if (TraceArgs.verbose) {
                errStream = System.err;
            }
            userVMIdentifier = TraceArgs.userVMIdentifier;
            try {
                TracePoint tracePoint;
                if (this.getTraceFiles() != 0) {
                    return;
                }
                this.out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(TraceArgs.outputFile)));
                Util.Debug.println("TraceFormat.verMod = " + verMod);
                if (!TraceArgs.is50orNewer && (double)verMod < 5.0 || TraceArgs.override) {
                    for (TraceFile this.traceFile : this.traceFiles) {
                        this.instantiateMessageFileOldStyle();
                        this.traceFile.traceFileHeader.processTraceBufferHeaders();
                    }
                    for (Object object : threads) {
                        Collections.sort(object);
                    }
                    if (TraceArgs.summary) {
                        this.doSummary(new BufferedWriter(new OutputStreamWriter(outStream)));
                        return;
                    }
                    if (this.doSummary(this.out) != 0) {
                        return;
                    }
                    outStream.println("*** starting formatting of entries");
                    this.out.write(header, 0, header.length());
                    this.out.newLine();
                    this.out.newLine();
                    if (Integer.valueOf(Util.getProperty("POINTER_SIZE")) == 4) {
                        headings = "ThreadID TP id  Type         TraceEntry ";
                    }
                    this.out.write(Util.getTimerDescription() + headings, 0, headings.length() + Util.getTimerDescription().length());
                    this.out.newLine();
                    try {
                        String string;
                        Merge merge = new Merge(threads);
                        String string2 = System.getProperty("line.separator");
                        while ((string = merge.getNextEntry()) != null) {
                            this.out.write(string + string2);
                        }
                    }
                    catch (InvalidSpannedRecordException invalidSpannedRecordException) {
                        outStream.println("\n" + invalidSpannedRecordException.getMessage());
                        return;
                    }
                    this.out.flush();
                    outStream.println("*** formatted ");
                    outStream.println("Formatted output written to file: " + TraceArgs.outputFile);
                    break block48;
                }
                long l = 0L;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                Hashtable<Long, TraceThread> hashtable = new Hashtable<Long, TraceThread>();
                outStream.println("*** Starting data extraction from binary file(s) ");
                for (TraceFile this.traceFile : this.traceFiles) {
                    this.instantiateMessageFilesNewStyle();
                    int n4 = this.traceFile.traceFileHeader.getTraceDataStart();
                    n3 = this.traceFile.traceFileHeader.getBufferSize();
                    long l2 = this.traceFile.length();
                    int n5 = this.traceFile.traceFileHeader.traceSection.getTraceType();
                    n = (int)(l2 - (long)n4) / n3;
                    n2 += n;
                    if ((l2 - (long)n4) / (long)n3 >= Integer.MAX_VALUE) {
                        outStream.println("Trace file " + this.traceFile + " contains more than INT_MAX trace buffers, can only process INT_MAX buffers");
                    }
                    if ((l2 - (long)n4) % (long)n3 != 0L) {
                        outStream.println("*** TraceFile is truncated, or corrupted, will ignore some incomplete data at the end, but process everything that is avaiable");
                        this.traceFileIsTruncatedOrCorrupt = true;
                    }
                    if (n == 0) {
                        outStream.println("\n\n*** " + this.traceFile + " CONTAINS NO TRACE DATA - skipping file.\n\n");
                        continue;
                    }
                    Util.Debug.println("TP data starts at " + n4 + ", buffer size is " + n3 + ": file contains " + n + " buffers.");
                    outStream.println("*** Extracting " + n + " buffers from " + this.traceFile);
                    for (int i = 0; i < n; ++i) {
                        TraceThread traceThread;
                        Util.Debug.println("Processing buffer " + i + " at " + (n4 + i * n3));
                        TraceRecord50 traceRecord50 = new TraceRecord50();
                        traceRecord50.setTraceType(n5);
                        Util.Debug.println(" buffer is " + (n5 == 0 ? "internal" : "external"));
                        traceRecord50.processTraceBufferHeader(this.traceFile, n4 + i * n3, n3);
                        Long l3 = new Long(traceRecord50.getThreadIDAsLong());
                        if (hashtable.containsKey(l3)) {
                            traceThread = (TraceThread)hashtable.get(l3);
                            traceThread.add(traceRecord50);
                            continue;
                        }
                        traceThread = new TraceThread(l3, traceRecord50.getThreadName());
                        traceThread.addElement(traceRecord50);
                        threads.addElement(traceThread);
                        hashtable.put(l3, traceThread);
                    }
                }
                if (lastWritePlatform.equals(BigInteger.ZERO)) {
                    lastWritePlatform = overallStartPlatform;
                    lastWriteSystem = overallStartSystem;
                    first = overallStartPlatform;
                    last = overallStartPlatform;
                }
                outStream.println("*** Sorting extracted tracepoints");
                if (TraceArgs.summary) {
                    this.doSummary(new BufferedWriter(new OutputStreamWriter(outStream)));
                    return;
                }
                if (this.doSummary(this.out) != 0) {
                    outStream.println("*** Problem printing summary to file - may be incomplete ... continuing");
                }
                outStream.println("*** Starting formatting of entries into text file " + TraceArgs.outputFile);
                this.out.write(header, 0, header.length());
                this.out.newLine();
                this.out.newLine();
                int n6 = Integer.valueOf(Util.getProperty("POINTER_SIZE"));
                if (userVMIdentifier != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < userVMIdentifier.length(); ++i) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("  ");
                    headings = n6 == 4 ? stringBuffer + "ThreadID       TP id     Type        TraceEntry " : stringBuffer + "ThreadID               TP id     Type        TraceEntry ";
                } else {
                    headings = n6 == 4 ? "ThreadID       TP id     Type        TraceEntry " : "ThreadID               TP id     Type        TraceEntry ";
                }
                this.out.write(Util.getTimerDescription() + headings, 0, headings.length() + Util.getTimerDescription().length());
                this.out.newLine();
                TraceThread[] traceThreadArray = new TraceThread[]{};
                TraceThread[] traceThreadArray2 = threads.toArray(traceThreadArray);
                int n7 = traceThreadArray2.length;
                System.out.println("*** Number of traced threads = " + n7);
                BigInteger[] bigIntegerArray = new BigInteger[n7];
                this.populateTimeStamps(traceThreadArray2, bigIntegerArray, n7);
                double d = (double)n2 / 10.0;
                int n8 = 0;
                int n9 = 0;
                long l4 = 0L;
                int n10 = 0;
                while ((tracePoint = this.findNextTracePoint(traceThreadArray2, bigIntegerArray, n7)) != null) {
                    n9 = TraceThread.getBuffersProcessed();
                    StringBuffer stringBuffer = new StringBuffer();
                    if ((double)n9 >= (double)n8 * d) {
                        outStream.print(n8 * 10 + "% ");
                        ++n8;
                    }
                    Util.Debug.println("next tracepoint: " + tracePoint.getComponentName() + "." + tracePoint.getTPID());
                    TraceThread traceThread = this.getCurrentTraceThread(traceThreadArray2);
                    Message message = MessageFile.getMessageFromID(tracePoint.getComponentName(), tracePoint.getTPID());
                    ++n10;
                    long l5 = tracePoint.getThreadID();
                    BigInteger bigInteger = tracePoint.getRawTimeStamp();
                    String string = Util.getFormattedTime(bigInteger);
                    tracePoint.setFormattedTime(string);
                    stringBuffer.append(string);
                    if (l5 == l4) {
                        stringBuffer.append(" ");
                    } else {
                        stringBuffer.append("*");
                    }
                    l4 = l5;
                    stringBuffer.append(tracePoint.toString() + " ");
                    if (message == null) {
                        Util.Debug.println("No message for tracepoint [" + tracePoint.getComponentName() + "." + tracePoint.getTPID() + "]");
                    } else {
                        int n11 = message.getType();
                        stringBuffer.append(this.types[n11]);
                        if (TraceArgs.indent) {
                            if (n11 == 2 || n11 == 3) {
                                traceThread.indent();
                            }
                            for (int i = 0; i < traceThread.getIndent(); ++i) {
                                stringBuffer.append(" ");
                            }
                            if (n11 == 4 || n11 == 5) {
                                traceThread.outdent();
                            }
                        }
                        byte[] byArray = tracePoint.getParmData();
                        String string3 = null;
                        if (byArray == null) {
                            byArray = new byte[1];
                            try {
                                string3 = message.getMessage(byArray, 0, 0);
                            }
                            catch (Exception exception) {
                                string3 = "FORMATTING PROBLEM OCCURRED WHILE PROCESSING THE RAW DATA FOR THIS TRACEPOINT - PARAMETER DATA UNAVAILABLE";
                            }
                        } else {
                            try {
                                string3 = message.getMessage(byArray, 0, byArray.length);
                            }
                            catch (Exception exception) {
                                string3 = "FORMATTING PROBLEM OCCURRED WHILE PROCESSING THE RAW DATA FOR THIS TRACEPOINT - PARAMETER DATA UNAVAILABLE";
                            }
                        }
                        stringBuffer.append(string3);
                    }
                    if (this.populateGlobalArray) {
                        this.vectorOfAllTracePoints.add(tracePoint);
                    }
                    this.out.write(stringBuffer.toString());
                    this.out.newLine();
                    this.populateTimeStamps(traceThreadArray2, bigIntegerArray, n7);
                }
                if (n8 < 11) {
                    outStream.print("... 100%");
                }
                outStream.print("\n");
                outStream.println("*** Number of formatted tracepoints = " + n10);
                if (n9 < n2) {
                    outStream.println("\n" + n9 + "/" + n2 + " buffers processed successfully\n");
                }
                if (this.traceFileIsTruncatedOrCorrupt) {
                    this.out.write(" NOTE - PROBLEMS WERE ENCOUNTERED PROCESSING THE TRACE FILE(S), MOST LIKELY DUE TO TRACE FILE CORRUPTION OR TRUNCATION");
                    this.out.newLine();
                    this.out.write(" THE CONTENT OF THIS FORMATTED FILE COULD THEREFORE BE TRUNCATED OR CORRUPTED ALSO - REFER TO FORMATTER OUTPUT FOR FURTHER DETAILS");
                    this.out.newLine();
                }
                this.out.flush();
                outStream.println("*** Formatting complete");
                outStream.println("*** Formatted output written to file: " + TraceArgs.outputFile);
            }
            catch (Exception exception) {
                exception.printStackTrace(outStream);
            }
        }
    }

    private void instantiateMessageFileOldStyle() {
        try {
            outStream.println("Processing pre 50 trace file with 50 formatter. Searching for the .dat files supplied with the traced vm.");
            outStream.println("****Will look in current directory and directory specified by ibm.dg.trc.format environment variable. ***");
            String string = System.getProperty("ibm.dg.trc.format");
            this.instantiateMessageFiles(string);
        }
        catch (Exception exception) {
            outStream.println("Can't open dat files - you need to copy the dat files from the traced vm to the current directory");
            outStream.println(" or use the -datdir flag to tell the formatter which directory it can find them in");
            Util.Debug.println(exception);
            return;
        }
    }

    private void instantiateMessageFiles(String string) {
        Object object;
        String string2 = null;
        String string3 = this.traceFile.formatFileName();
        if (TraceArgs.datFileDirectory == null) {
            string2 = ".";
            object = new File(string3);
            outStream.println("Looking for " + object + " in current directory.");
            if (!((File)object).exists()) {
                string2 = string;
            }
        } else {
            string2 = TraceArgs.datFileDirectory;
        }
        if (string2 != null) {
            object = this.constructFullyQualifiedName(string2, string3);
            outStream.println("*** Loading formatting strings from " + (String)object);
            messageFile = new MessageFile((String)object);
            if (!string3.equals("TraceFormat.dat")) {
                object = this.constructFullyQualifiedName(string2, "TraceFormat.dat");
                outStream.println("*** Loading further formatting strings from " + (String)object);
                messageFileBase = new MessageFile((String)object);
            }
        }
        if (messageFile == null) {
            outStream.println("Could not find a dat file. No trace points will be formatted.");
        }
    }

    private void instantiateMessageFilesNewStyle() {
        String string = System.getProperty("java.home");
        string = string.concat(File.separator).concat("lib");
        this.instantiateMessageFiles(string);
    }

    private final String constructFullyQualifiedName(String string, String string2) {
        return string + File.separator + string2;
    }

    protected int doSummary(BufferedWriter bufferedWriter) throws IOException {
        Object object;
        Object object2;
        bufferedWriter.write("                Trace Summary");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        TraceFile traceFile = (TraceFile)this.traceFiles.firstElement();
        traceFile.traceFileHeader.summarize(bufferedWriter);
        bufferedWriter.write("Active Threads :");
        bufferedWriter.newLine();
        for (TraceThread traceThread : threads) {
            bufferedWriter.write("        " + Long.toHexString(traceThread.threadID));
            bufferedWriter.write("  ");
            bufferedWriter.write(traceThread.threadName);
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
        if ((double)verMod >= 1.1) {
            object2 = lastWritePlatform.subtract(overallStartPlatform);
            object = lastWriteSystem.subtract(overallStartSystem);
            Util.Debug.println("lastWritePlatform:  " + lastWritePlatform);
            Util.Debug.println("overallStartSystem: " + overallStartSystem);
            Util.Debug.println("spanPlatform:       " + object2);
            Util.Debug.println("spanSystem:         " + object);
            timeConversion = ((BigInteger)object).compareTo(BigInteger.ZERO) != 0 ? ((BigInteger)object2).divide((BigInteger)object) : BigInteger.ONE;
            Util.Debug.println("timeConversion:         " + timeConversion);
            bufferedWriter.write("JVM started      : " + Util.getFormattedTime(overallStartPlatform));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("Last buffer write: " + Util.getFormattedTime(lastWritePlatform));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
        }
        object2 = "First tracepoint:  " + Util.getFormattedTime(first);
        object = "Last tracepoint :  " + Util.getFormattedTime(last);
        bufferedWriter.write((String)object2, 0, ((String)object2).length());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write((String)object, 0, ((String)object).length());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.flush();
        return 0;
    }

    static final void setStartSystem(BigInteger bigInteger) {
        if (overallStartSystem.equals(BigInteger.ZERO)) {
            overallStartSystem = bigInteger;
        }
        if (overallStartSystem.compareTo(bigInteger) == -1) {
            overallStartSystem = bigInteger;
        }
    }

    static final void setStartPlatform(BigInteger bigInteger) {
        if (overallStartPlatform.equals(BigInteger.ZERO)) {
            overallStartPlatform = bigInteger;
        }
        if (overallStartPlatform.compareTo(bigInteger) == -1) {
            overallStartPlatform = bigInteger;
        }
    }

    final int getTraceFiles() {
        int n = 36;
        int n2 = TraceArgs.traceFile.indexOf("#");
        if (n2 == -1) {
            try {
                this.traceFiles.addElement(new TraceFile(TraceArgs.traceFile, "r"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                outStream.println("Trace file " + TraceArgs.traceFile + " not found");
                return -1;
            }
            catch (Exception exception) {
                exception.printStackTrace(errStream);
                return -1;
            }
        } else {
            int n3 = 0;
            char c = '\u0000';
            for (n3 = 0; n3 < n; ++n3) {
                c = Integer.toString(n3, n).toUpperCase().charAt(0);
                try {
                    this.traceFiles.addElement(new TraceFile(TraceArgs.traceFile.replace('#', c), "r"));
                    continue;
                }
                catch (Exception exception) {
                    Util.Debug.println("TraceFormat: generations found " + n3);
                    break;
                }
            }
            if (n3 == 0) {
                outStream.println("Trace file " + TraceArgs.traceFile + " not found");
                return -1;
            }
            if (n3 != generations) {
                Util.Debug.println("TraceFormat: generations = " + generations);
                outStream.println("Trace file " + TraceArgs.traceFile.replace('#', c) + " is missing");
            }
            outStream.println("Processing " + (n3 != generations ? Integer.toString(n3) : "all") + " of the " + generations + " generations specified at runtime");
        }
        return 0;
    }

    static final void setGenerations(int n) {
        generations = n;
    }

    public static String getUserVMIdentifier() {
        return userVMIdentifier;
    }

    public Vector getVectorOfAllTracePoints() {
        return this.vectorOfAllTracePoints;
    }

    public void populateGlobalArray(boolean bl) {
        this.populateGlobalArray = bl;
    }

    public boolean populateTimeStamps(TraceThread[] traceThreadArray, BigInteger[] bigIntegerArray, int n) {
        for (int i = 0; i < n; ++i) {
            bigIntegerArray[i] = traceThreadArray[i].getTimeOfNextTracePoint();
        }
        return true;
    }

    public boolean threadsContainUnprocessedTracePoints(BigInteger[] bigIntegerArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (bigIntegerArray[i] == null) continue;
            return true;
        }
        return false;
    }

    public TraceThread getCurrentTraceThread(TraceThread[] traceThreadArray) {
        if (this.tracedThreadWithNewestTracePoint < 0) {
            return null;
        }
        return traceThreadArray[this.tracedThreadWithNewestTracePoint];
    }

    public TracePoint findNextTracePoint(TraceThread[] traceThreadArray, BigInteger[] bigIntegerArray, int n) {
        this.tracedThreadWithNewestTracePoint = 0;
        if (bigIntegerArray.length == 0 || traceThreadArray == null || n == 0) {
            this.tracedThreadWithNewestTracePoint = -1;
            return null;
        }
        BigInteger bigInteger = bigIntegerArray[0];
        for (int i = 1; i < n; ++i) {
            if (bigInteger == null) {
                bigInteger = bigIntegerArray[i];
                this.tracedThreadWithNewestTracePoint = i;
                continue;
            }
            if (bigIntegerArray[i] == null || bigInteger.compareTo(bigIntegerArray[i]) <= 0) continue;
            bigInteger = bigIntegerArray[i];
            this.tracedThreadWithNewestTracePoint = i;
        }
        if (bigInteger == null) {
            this.tracedThreadWithNewestTracePoint = -1;
            return null;
        }
        return traceThreadArray[this.tracedThreadWithNewestTracePoint].getNextTracePoint();
    }

    static {
        userVMIdentifier = null;
    }
}

