/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMUtils;
import com.ibm.jvm.j9.dump.systemdump.ClassField;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Static;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class J9Object {
    private long oAddr;
    private long classId;
    private long flags;
    private long lockInfo;
    private int heapId;
    private static Dump theDump;
    private static int ptrSize;
    private boolean instanceOfClass;
    private boolean isArray;
    private int instanceSize;
    private int elementCount;
    private int elementSize;

    protected J9Object(long l, long l2, int n, int n2) {
        this.oAddr = l;
        this.classId = l2;
        this.heapId = n;
        this.instanceSize = n2;
    }

    public J9Object(long l, int n) {
        this.heapId = n;
        this.oAddr = l;
        if (null == theDump && !(theDump = DumpConsole.getTheDump()).is32bit()) {
            ptrSize = 8;
        }
        J9Class j9Class = null;
        try {
            this.classId = theDump.readPtr(this.oAddr);
            if (theDump.getIntVersion() == 22) {
                this.flags = theDump.readPtr(this.oAddr + (long)ptrSize);
            } else if (theDump.seekToMemoryAddress(this.oAddr + (long)ptrSize) > 0L) {
                this.flags = theDump.readIntEx();
            }
            this.lockInfo = theDump.readPtr(this.oAddr + (long)(2 * ptrSize));
            j9Class = J9JVMConsole.getClass(this.classId);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null == j9Class) {
            this.classId = -1L;
        } else if (j9Class.isArrayClass()) {
            this.isArray = true;
            int n2 = j9Class.getSizeOffset();
            long l2 = 0L;
            try {
                if (theDump.getIntVersion() == 22) {
                    l2 = theDump.readPtr(this.oAddr + (long)n2);
                } else if (theDump.seekToMemoryAddress(this.oAddr + (long)n2) > 0L) {
                    l2 = theDump.readIntEx();
                }
                this.elementCount = (int)l2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (j9Class.isSizedAsElements()) {
                long l3 = j9Class.getLeaf();
                J9Class j9Class2 = J9JVMUtils.findClass(l3);
                this.elementSize = j9Class2.getArrayElementSize();
                if (-1 == this.elementSize || j9Class.getArity() > 1) {
                    this.elementSize = ptrSize;
                }
                this.instanceSize = j9Class.getFirstElementOffset() + (int)l2 * this.elementSize;
            } else {
                this.instanceSize = j9Class.getFirstElementOffset() + (int)l2;
            }
        } else {
            this.instanceSize = j9Class.getInstanceSize();
        }
        J9Class j9Class3 = this.getClassForObject();
        if (j9Class3 != null && j9Class3.getName().equals("java/lang/Class")) {
            this.instanceOfClass = true;
            int n3 = j9Class.getSizeOffset();
            long l4 = 0L;
            try {
                this.instanceSize = (int)theDump.readPtr(this.oAddr + (long)n3);
                this.instanceSize += n3;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static long[] getObjectRefs(long l) {
        long[] lArray = null;
        J9Object j9Object = new J9Object(l, -1);
        lArray = j9Object.getObjectRefs();
        return lArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        J9Class j9Class = this.getClassForObject();
        String string = j9Class.getName();
        String string2 = "";
        int n = 0;
        if (string.startsWith("[")) {
            int n2 = string.lastIndexOf("[");
            string2 = string.substring(n2);
            string = string.substring(0, n2) + string2;
            n = j9Class.getArity();
        }
        stringBuffer.append("\n " + string + "@0x" + Long.toHexString(this.oAddr));
        if (string.equals("java/lang/Class")) {
            J9Class j9Class2 = J9JVMConsole.getClass(this.oAddr);
            string = j9Class2.getName();
            if (string.startsWith("[")) {
                // empty if block
            }
            stringBuffer.append("\n\tClass definition of: " + string);
        }
        if (!this.isArray) {
            stringBuffer.append("\n " + j9Class.formatObject(this.oAddr));
        } else {
            String string3 = "primitive";
            if (!this.isPrimitiveArray()) {
                string3 = "non-primitive";
            }
            if (1 == n) {
                stringBuffer.append("\n It's an Array object: " + string3 + ": filled with - " + string2);
            } else {
                stringBuffer.append("\n It's an Array of Array objects: " + string3 + ": filled with - ");
                for (int i = 0; i < n - 1; ++i) {
                    stringBuffer.append("[");
                }
                stringBuffer.append(string2);
            }
            stringBuffer.append("\n\t instance size = " + this.getInstanceSize());
            stringBuffer.append("\n\t " + this.elementCount + " elements , element size = " + this.elementSize);
            stringBuffer.append("\n\t arity is " + j9Class.getArity());
        }
        return stringBuffer.toString();
    }

    public long getObjectAddress() {
        return this.oAddr;
    }

    public long[] getObjectRefs() {
        return this.getObjectRefs(false);
    }

    public long[] getObjectRefs(boolean bl) {
        Object object;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (null == theDump && !(theDump = DumpConsole.getTheDump()).is32bit()) {
            ptrSize = 8;
        }
        J9Class j9Class = this.getClassForObject();
        Vector vector = null;
        if (this.isInstanceOfClass()) {
            vector = j9Class.getStatics();
        } else {
            if (this.isArray) {
                if (j9Class.isPrimitiveArray() && j9Class.getArity() == 1) {
                    return null;
                }
                int n = 0;
                int n2 = j9Class.getFirstElementOffset();
                long l = 0L;
                long[] lArray = new long[this.elementCount];
                for (int i = 0; i < this.elementCount; ++i) {
                    try {
                        l = theDump.readPtr(this.oAddr + (long)n2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (bl || l != 0L) {
                        lArray[n] = l;
                        ++n;
                    }
                    n2 += this.elementSize;
                }
                if (0 == n) {
                    return null;
                }
                long[] lArray2 = new long[n];
                for (int i = 0; i < n; ++i) {
                    lArray2[i] = lArray[i];
                }
                return lArray2;
            }
            vector = j9Class.getFields();
        }
        int n = vector.size();
        if (n > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                if (this.isInstanceOfClass()) {
                    object = (J9Static)vector.get(i);
                    if (!object.getSignature().startsWith("L") || 0L == object.getValue()) continue;
                    arrayList.add(new Long(object.getValue()));
                    continue;
                }
                object = (ClassField)vector.get(i);
                String string = object.getSignature();
                boolean bl2 = false;
                if (string.startsWith("L") || string.startsWith("[")) {
                    bl2 = true;
                }
                if (!bl2) continue;
                int n3 = object.getOffset();
                long l = 0L;
                try {
                    l = theDump.readPtr(this.oAddr + (long)n3);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (-1L == l) continue;
                arrayList.add(new Long(l));
            }
        }
        if (0 == arrayList.size()) {
            return null;
        }
        long[] lArray = new long[arrayList.size()];
        object = arrayList.toArray(new Long[0]);
        for (int i = 0; i < ((Long[])object).length; ++i) {
            lArray[i] = object[i];
        }
        return lArray;
    }

    public J9Class getClassForObject() {
        return J9JVMConsole.getClass(this.classId);
    }

    public boolean isInstanceOfClass() {
        return this.instanceOfClass;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isPrimitiveArray() {
        J9Class j9Class = this.getClassForObject();
        return j9Class.isPrimitiveArray();
    }

    public byte getPrimitiveArrayType() {
        J9Class j9Class = this.getClassForObject();
        long l = j9Class.getLeaf();
        J9Class j9Class2 = J9JVMUtils.findClass(l);
        return j9Class2.getArrayType();
    }

    public String getArrayTypeAsString() {
        J9Class j9Class = this.getClassForObject();
        long l = j9Class.getLeaf();
        J9Class j9Class2 = J9JVMUtils.findClass(l);
        return j9Class2.getName();
    }

    public int getInstanceSize() {
        return this.instanceSize;
    }

    public int getHeapId() {
        return this.heapId;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public long getFlags() {
        return this.flags;
    }

    public long getHashCode() {
        long l = this.flags >> 16 & 0x7FFFL;
        l |= l << 16;
        return l;
    }

    public long getLockInfo() {
        return this.lockInfo;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.instanceSize];
        try {
            if (theDump.seekToMemoryAddress(this.oAddr) > 0L) {
                theDump.readEx(byArray);
            }
        }
        catch (IOException iOException) {
            byArray = null;
        }
        return byArray;
    }

    public byte[] getBytes(int n, int n2) {
        byte[] byArray = null;
        if (n2 > 0 && n < this.instanceSize) {
            byArray = new byte[n2];
            try {
                if (theDump.seekToMemoryAddress(this.oAddr + (long)n) > 0L) {
                    theDump.readEx(byArray);
                }
            }
            catch (IOException iOException) {
                byArray = null;
            }
        }
        return byArray;
    }

    static {
        ptrSize = 4;
    }
}

