/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.systemdump.Aixdump;
import com.ibm.jvm.j9.dump.systemdump.DumpFile;
import com.ibm.jvm.j9.dump.systemdump.Elfdump;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9AddressSpace;
import com.ibm.jvm.j9.dump.systemdump.J9Jvm;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import com.ibm.jvm.j9.dump.systemdump.PageCache;
import com.ibm.jvm.j9.dump.systemdump.StackFrame;
import com.ibm.jvm.j9.dump.systemdump.Windump;
import com.ibm.jvm.j9.dump.systemdump.ZOSdump;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;

public abstract class Dump
implements DumpFile {
    protected boolean bIs32Bit = true;
    protected static int systemType;
    protected static boolean bIsLittleEndian;
    protected String dumpName;
    protected long dumpTime;
    protected int processorCount;
    protected String processorType;
    protected String processorSubType;
    protected String systemSubType;
    protected String size;
    protected J9AddressSpace[] addressSpaces;
    protected int currentAS = 0;
    protected J9Jvm currentJvm;
    private String stamp;
    private String version;
    private String shortVersion;
    private int intVersion;
    private String arch;
    private long memory = 0L;
    private long environ;
    private Properties envVars;
    private final DumpFile delegate;
    private String uuid;
    protected String fullversion = "<unknown>";
    protected int prevMemRange = -1;
    protected long pmrStartAddr = 0L;
    protected long pmrSize = 0L;
    protected MemoryRange[] sortedMemoryRanges;
    protected PageCache memoryPages;
    protected long filesize;
    public static final int IS_EXECUTEABLE_FLAG = 1;
    public static final int IS_READONLY_FLAG = 2;
    public static final int IS_SHARED_FLAG = 4;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_WINDOWS = 1;
    public static final int TYPE_LINUX = 2;
    public static final int TYPE_ZOS = 3;
    public static final int TYPE_AIX = 4;
    public static final int FILE_EXISTS = 1;
    public static final int FILE_READABLE = 2;
    public static final int DUMP_SUPPORTED = 4;
    private static final String[] types;
    private static final String[][] subTypes;

    protected void initialize() {
        try {
            this.filesize = this.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.memoryPages = this instanceof Windump ? new PageCache(8, 262144, 0.5, 0.1) : new PageCache();
    }

    protected Dump(DumpFile dumpFile) throws FileNotFoundException {
        this.delegate = dumpFile;
        this.initialize();
    }

    public final String getSystemTypeAsString(int n) {
        return types[n];
    }

    protected static int compareAddress(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        if (l >= 0L && l2 >= 0L || l < 0L && l2 < 0L) {
            return l < l2 ? -1 : 1;
        }
        return l < l2 ? 1 : -1;
    }

    protected abstract MemoryRange[] getRawMemoryRanges();

    protected void refreshMemoryRanges() {
        this.sortedMemoryRanges = null;
    }

    public MemoryRange[] getMemoryRanges() {
        if (this.sortedMemoryRanges == null) {
            this.sortedMemoryRanges = this.getRawMemoryRanges();
            if (null == this.sortedMemoryRanges) {
                System.err.println("No raw memory ranges found in core.  The core is likely truncated or otherwise incomplete.");
                this.sortedMemoryRanges = new MemoryRange[0];
            } else {
                Arrays.sort(this.sortedMemoryRanges);
            }
        }
        return this.sortedMemoryRanges;
    }

    public byte[] getMemoryBytes(long l, int n) {
        PageCache.Page page;
        int n2 = this.findWhichMemoryRange(l);
        if (n2 < 0) {
            return null;
        }
        byte[] byArray = null;
        PageCache.Page page2 = page = this.memoryPages != null ? this.memoryPages.find(n2, l, n) : null;
        if (page != null) {
            byte[] byArray2;
            if (page.isEmpty() && (byArray2 = this.getRawMemoryBytes(l, this.memoryPages.pageSize)) != null) {
                page.push(n2, l, byArray2);
            }
            byArray = page.pull(n2, l, n);
        }
        if (byArray == null) {
            byArray = this.getRawMemoryBytes(l, n);
        }
        return byArray;
    }

    protected byte[] getRawMemoryBytes(long l, int n) {
        byte[] byArray = null;
        try {
            long l2 = this.seekToMemoryAddress(l);
            if (l2 < (long)n) {
                n = (int)l2;
            }
            if (n < 0) {
                return null;
            }
            byArray = new byte[n];
            this.readFully(byArray, 0, n);
            return byArray;
        }
        catch (IOException iOException) {
            return byArray;
        }
    }

    public long seekToMemoryAddress(long l) {
        int n = this.findWhichMemoryRange(l);
        if (n >= 0) {
            try {
                MemoryRange memoryRange = this.sortedMemoryRanges[n];
                long l2 = l - memoryRange.getVaddr();
                long l3 = memoryRange.getFileoffset();
                long l4 = memoryRange.getSize();
                long l5 = l3 + l2;
                if (l5 > this.filesize) {
                    return 0L;
                }
                this.seek(l5);
                long l6 = l4 - l2;
                if (this.filesize - l5 < l6) {
                    l6 = this.filesize - l5;
                }
                return l6;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public int findWhichMemoryRange(long l) {
        int n = -1;
        MemoryRange[] memoryRangeArray = this.getMemoryRanges();
        if (null != memoryRangeArray) {
            long l2;
            int n2;
            if (this.prevMemRange != -1 && Dump.compareAddress(l, this.pmrStartAddr) >= 0 && Dump.compareAddress(l, this.pmrStartAddr + this.pmrSize) < 0) {
                return this.prevMemRange;
            }
            int n3 = memoryRangeArray.length - 1;
            int n4 = 0;
            while (n4 <= n3) {
                n2 = n4 + (n3 - n4 >>> 1);
                l2 = memoryRangeArray[n2].getVaddr();
                if (Dump.compareAddress(l, l2) >= 0) {
                    if (Dump.compareAddress(l, l2 + memoryRangeArray[n2].getSize()) < 0) {
                        n = n2;
                        break;
                    }
                    n4 = n2 + 1;
                    continue;
                }
                n3 = n2 - 1;
            }
            if (-1 == n) {
                for (n2 = 0; n2 < n4; ++n2) {
                    l2 = memoryRangeArray[n2].getVaddr();
                    if (Dump.compareAddress(l, l2) < 0 || Dump.compareAddress(l, l2 + memoryRangeArray[n2].getSize()) >= 0) continue;
                    n = n2;
                    break;
                }
            }
        }
        if (-1 != n) {
            this.prevMemRange = n;
            this.pmrStartAddr = memoryRangeArray[n].getVaddr();
            this.pmrSize = memoryRangeArray[n].getSize();
        }
        return n;
    }

    public int findWhichMemoryRange(long l, int n) {
        int n2 = -1;
        MemoryRange[] memoryRangeArray = this.getMemoryRanges();
        if (null != memoryRangeArray) {
            for (int i = 0; i < memoryRangeArray.length; ++i) {
                if (memoryRangeArray[i].getAsid() != n) continue;
                long l2 = memoryRangeArray[i].getVaddr();
                if (Dump.compareAddress(l, l2) >= 0) {
                    if (Dump.compareAddress(l, l2 + memoryRangeArray[i].getSize()) >= 0) continue;
                    n2 = i;
                    i = memoryRangeArray.length;
                    continue;
                }
                return -1;
            }
        }
        return n2;
    }

    public long findBytes(byte[] byArray, int n) {
        long l = -1L;
        l = this.findPattern(byArray, n, 0L);
        return l;
    }

    public long findPattern(byte[] byArray, int n, long l) {
        long l2 = -1L;
        Vector vector = DumpUtils.findInMemory(this, byArray, l, -1L, n, 1, false);
        if (0 != vector.size()) {
            l2 = (Long)vector.get(0);
        }
        return l2;
    }

    public static int dumpStat(String string) {
        return Aixdump.dumpStat(string) | Elfdump.dumpStat(string) | ZOSdump.dumpStat(string) | Windump.dumpStat(string);
    }

    private static boolean isSupportedDump(int n) {
        return (n & 4) != 0;
    }

    public static Dump getDump(String string) throws FileNotFoundException {
        if (Dump.isSupportedDump(Aixdump.dumpStat(string))) {
            return new Aixdump(string);
        }
        if (Dump.isSupportedDump(Elfdump.dumpStat(string))) {
            return new Elfdump(string);
        }
        if (Dump.isSupportedDump(ZOSdump.dumpStat(string))) {
            return new ZOSdump(string);
        }
        if (Dump.isSupportedDump(Windump.dumpStat(string))) {
            return new Windump(string);
        }
        return null;
    }

    public boolean is32bit() {
        return this.bIs32Bit;
    }

    public boolean is64bit() {
        return !this.is32bit();
    }

    public boolean isLittleEndian() {
        return bIsLittleEndian;
    }

    public long readPtr(byte[] byArray, int n) throws IOException {
        int n2 = 8;
        if (this.bIs32Bit) {
            n2 = 4;
        }
        long[] lArray = new long[8];
        for (int i = 0; i < n2; ++i) {
            lArray[i] = byArray[n + i];
            lArray[i] = lArray[i] & 0xFFL;
        }
        if (this.isLittleEndian()) {
            return lArray[0] + (lArray[1] << 8) + (lArray[2] << 16) + (lArray[3] << 24) + (lArray[4] << 32) + (lArray[5] << 40) + (lArray[6] << 48) + (lArray[7] << 56);
        }
        return lArray[7] + (lArray[6] << 8) + (lArray[5] << 16) + (lArray[4] << 24) + (lArray[3] << 32) + (lArray[2] << 40) + (lArray[1] << 48) + (lArray[0] << 56);
    }

    public long readPtr() throws IOException {
        long l = -1L;
        l = this.bIs32Bit ? (long)this.readIntEx() & 0xFFFFFFFFL : this.readLongEx();
        return l;
    }

    public long readPtr(long l) throws IOException {
        long l2 = -1L;
        if (this.seekToMemoryAddress(l) > 0L) {
            if (this.bIs32Bit) {
                l2 = (long)this.readIntEx() & 0xFFFFFFFFL;
            }
            l2 = this.readLongEx();
        } else {
            throw new IOException("jformat: seek to memory address failed");
        }
        return l2;
    }

    public int getSystemType() {
        return systemType;
    }

    public void setSystemType(int n) {
        systemType = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Operating System : " + this.getSystemTypeAsString(systemType));
        stringBuffer.append("\nArchitecture     : ");
        if (this.is32bit()) {
            stringBuffer.append("32bit - ");
        } else {
            stringBuffer.append("64bit - ");
        }
        if (this.isLittleEndian()) {
            stringBuffer.append("Little Endian");
        } else {
            stringBuffer.append("Big Endian");
        }
        stringBuffer.append("\nSystem Memory    : " + this.getMemory());
        stringBuffer.append("\nJVM Version      : " + this.version);
        stringBuffer.append("\nBuild Level      : " + this.stamp);
        stringBuffer.append("\nUuid             : " + this.uuid);
        stringBuffer.append("\n\n" + this.fullversion);
        return stringBuffer.toString();
    }

    public void setStamp(String string) {
        this.stamp = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setUuid(String string) {
        this.uuid = string;
    }

    public String getStamp() {
        return this.stamp;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getVersion() {
        StringBuffer stringBuffer = new StringBuffer("J2RE IBM J9 ");
        if (this.version != null) {
            stringBuffer.append(this.version.trim());
        }
        if (this.arch != null) {
            stringBuffer.append(" ");
            stringBuffer.append(this.arch);
        }
        if (this.size != null) {
            stringBuffer.append("-");
            stringBuffer.append(this.size);
        }
        if (this.stamp != null) {
            stringBuffer.append(" build " + this.stamp);
        }
        return stringBuffer.toString();
    }

    public void setFullVersion(String string) {
        this.fullversion = string;
    }

    public String getFullVersion() {
        return this.fullversion;
    }

    public void set32Bit(boolean bl) {
        this.bIs32Bit = bl;
    }

    public static void setLittleEndian(boolean bl) {
        bIsLittleEndian = bl;
    }

    public String getDumpName() {
        return this.delegate.getDumpName();
    }

    public long readLongEx() throws IOException {
        long l = this.readLong();
        if (bIsLittleEndian) {
            l = DumpUtils.convertEndian(l);
        }
        return l;
    }

    public int readIntEx() throws IOException {
        int n = this.readInt();
        if (bIsLittleEndian) {
            n = DumpUtils.convertEndian(n);
        }
        return n;
    }

    public short readShortEx() throws IOException {
        short s = this.readShort();
        if (bIsLittleEndian) {
            s = DumpUtils.convertEndian(s);
        }
        return s;
    }

    public void readFullyEx(byte[] byArray) throws IOException {
        this.readFully(byArray);
    }

    public int readEx(byte[] byArray) throws IOException {
        return this.read(byArray);
    }

    public int readEx(byte[] byArray, int n, int n2) throws IOException {
        return this.read(byArray, n, n2);
    }

    public long getDumpTime() {
        return this.dumpTime;
    }

    public long getInstalledMemory() {
        return this.memory;
    }

    public int getProcessorCount() {
        return this.processorCount;
    }

    public String getProcessorSubType() {
        return this.processorSubType;
    }

    public String getProcessorType() {
        return this.processorType;
    }

    public String getSystemSubType() {
        return this.systemSubType;
    }

    public int getCurrentAS() {
        return this.currentAS;
    }

    public String getCurrentASName() {
        return this.addressSpaces[this.currentAS].getAddressSpaceName();
    }

    public void setCurrentAS(int n) {
        this.currentAS = n;
    }

    public int getAddressSpaceCount() {
        return this.addressSpaces.length;
    }

    public J9AddressSpace getAddressSpace(int n) {
        return this.addressSpaces[n];
    }

    public int getSREFlags(long l, int n) {
        int n2 = this.findWhichMemoryRange(l, n);
        if (-1 != n2) {
            MemoryRange[] memoryRangeArray = this.getMemoryRanges();
            int n3 = 0;
            if (memoryRangeArray[n2].isExecutable()) {
                ++n3;
            }
            if (memoryRangeArray[n2].isReadOnly()) {
                n3 += 2;
            }
            if (memoryRangeArray[n2].isShared()) {
                n3 += 4;
            }
            return n3;
        }
        return -1;
    }

    public void setProcessorCount(int n) {
        this.processorCount = n;
    }

    public String getShortVersion() {
        return this.shortVersion;
    }

    public void setShortVersion(String string) {
        this.shortVersion = string;
        float f = 0.0f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.intVersion = (int)(f * 10.0f);
    }

    public int getIntVersion() {
        return this.intVersion;
    }

    public J9Jvm getCurrentJvm() {
        return this.currentJvm;
    }

    public void setCurrentJvm(J9Jvm j9Jvm) {
        this.currentJvm = j9Jvm;
    }

    public String getArch() {
        return this.arch;
    }

    public void setArch(String string) {
        this.arch = string;
    }

    public static Vector findDebugFiles(String string, Dump dump, boolean bl) {
        if (dump instanceof Elfdump) {
            return Elfdump.findDebugFiles(string, dump, bl);
        }
        if (dump instanceof Windump) {
            return Windump.findDebugFiles(string, dump, bl);
        }
        if (dump instanceof Aixdump) {
            return Aixdump.findDebugFiles(string, dump, false);
        }
        return null;
    }

    public String readString() throws IOException {
        int n;
        int n2 = 512;
        byte[] byArray = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray[n] = this.readByte();
            if (byArray[n] == 0) break;
        }
        return new String(byArray, 0, n);
    }

    public String getMemory() {
        String string = this.memory == 0L ? "<unknown>" : this.memory + " Mb";
        return string;
    }

    public void setMemory(String string) {
        this.memory = null == string ? 0L : Long.parseLong(string);
    }

    public long getEnviron() {
        return this.environ;
    }

    public void setEnviron(String string) {
        if (null != string) {
            try {
                this.environ = Long.parseLong(DumpUtils.stripOff0x(string), 16);
            }
            catch (NumberFormatException numberFormatException) {
                this.environ = 0L;
            }
        } else {
            this.environ = 0L;
        }
    }

    public Properties getEnvVars() {
        if (this.envVars == null) {
            this.envVars = new Properties();
            if (this.environ != 0L) {
                long l;
                boolean bl = false;
                Vector<Long> vector = new Vector<Long>();
                if (-1L == this.seekToMemoryAddress(this.environ)) {
                    bl = true;
                } else {
                    try {
                        l = this.readPtr();
                        if (-1L == this.seekToMemoryAddress(l)) {
                            bl = true;
                        }
                    }
                    catch (IOException iOException) {
                        bl = true;
                    }
                }
                while (!bl && vector.size() < 1024) {
                    try {
                        l = this.readPtr();
                        if (l == 0L) {
                            bl = true;
                            continue;
                        }
                        vector.add(new Long(l));
                    }
                    catch (IOException iOException) {
                        bl = true;
                    }
                }
                for (int i = 0; i < vector.size(); ++i) {
                    int n;
                    long l2 = (Long)vector.get(i);
                    byte[] byArray = this.getMemoryBytes(l2, 256);
                    String string = "";
                    if (byArray != null) {
                        n = byArray.length;
                        for (int j = 0; j < byArray.length; ++j) {
                            if (byArray[j] != 0) continue;
                            n = j;
                            j = byArray.length;
                        }
                        string = new String(byArray, 0, n);
                    }
                    if ((n = string.indexOf("=")) <= 0) continue;
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    this.envVars.put(string2, string3);
                }
            } else {
                this.envVars = null;
            }
        }
        return this.envVars;
    }

    protected void analyseStack(GenericThread genericThread) {
        Vector vector = new Vector();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        try {
            l = genericThread.context.getSp();
            l2 = genericThread.context.getBp();
            l3 = genericThread.context.getPc();
        }
        catch (Exception exception) {
            return;
        }
        if (l3 == 0L || -1 == this.findWhichMemoryRange(l3)) {
            l3 = genericThread.context.getLr();
        }
        if (l3 != 0L && l2 != 0L && -1 != this.findWhichMemoryRange(l3)) {
            boolean bl = false;
            long l4 = genericThread.getStackstart();
            long l5 = genericThread.getStacksize();
            StackFrame stackFrame = new StackFrame(l2, l3);
            genericThread.addNativeFrame(stackFrame);
            this.seekToMemoryAddress(l2);
            try {
                while (l2 < l4 + l5 && l2 > l4) {
                    l2 = this.readPtr();
                    l3 = this.readPtr();
                    stackFrame = new StackFrame(l2, l3);
                    genericThread.addNativeFrame(stackFrame);
                    this.seekToMemoryAddress(l2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setProcessorSubType(String string) {
        this.processorSubType = string;
    }

    public void setProcessorType(String string) {
        this.processorType = string;
    }

    public void setSystemSubType(String string) {
        this.systemSubType = string;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String string) {
        this.size = string;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public byte readByte() throws IOException {
        return this.delegate.readByte();
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.delegate.readFully(byArray, n, n2);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.delegate.readFully(byArray);
    }

    public int readInt() throws IOException {
        return this.delegate.readInt();
    }

    public long readLong() throws IOException {
        return this.delegate.readLong();
    }

    public short readShort() throws IOException {
        return this.delegate.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.delegate.readUnsignedByte();
    }

    public long length() throws IOException {
        return this.delegate.length();
    }

    public int read() throws IOException {
        return this.delegate.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.delegate.read(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.delegate.read(byArray);
    }

    public void seek(long l) throws IOException {
        this.delegate.seek(l);
    }

    public long getFilePointer() throws IOException {
        return this.delegate.getFilePointer();
    }

    static {
        types = new String[]{"unknown", "Windows", "Linux", "zOS", "AIX"};
        subTypes = new String[][]{{"unknown"}, {"Windows unknown", "Windows XP", "Windows 2000", "Windows ME", "Windows NT", "Windows 95", "Windows 98"}, {"Linux ia32", "ZOS64", "ZOS32"}, {"AIX51", "AIX52"}};
    }
}

