/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConsoleUtils {
    public static Vector breakUpInput(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = null;
        if (stringTokenizer.countTokens() != 0) {
            string3 = stringTokenizer.nextToken();
        }
        if (null != string3) {
            vector.add(string3);
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public static boolean verifyAsHex(String string) {
        boolean bl = true;
        try {
            long l = DumpUtils.parseLongHex(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public static boolean verifyAsPositiveNumber(String string) {
        boolean bl = true;
        try {
            long l = Long.parseLong(string);
            if (l < 0L) {
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public static int hexValue(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    public static long hexToLong(String string) throws NumberFormatException {
        int n;
        long l = 0L;
        if (string.startsWith("0x")) {
            string = string.substring(2, string.length());
        }
        if ((n = string.length()) <= 16) {
            for (int i = 0; i < n; ++i) {
                int n2 = ConsoleUtils.hexValue(string.charAt(i));
                if (n2 == -1) {
                    throw new NumberFormatException("Bad hex input");
                }
                l = 16L * l + (long)n2;
            }
        } else {
            throw new NumberFormatException("Too many hex digits");
        }
        return l;
    }
}

