/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.command.BaseCommands;
import com.ibm.jvm.j9.dump.command.Command;
import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.command.DumpBaseCmds;
import com.ibm.jvm.j9.dump.command.J9JVMBaseCmds;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleInput;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleMsg;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleOutput;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class Console
implements Observer {
    private static boolean verboseMode = false;
    private static Console mySelf;
    private static int mode;
    private static ConsoleOutput[] output;
    private static ConsoleInput input;
    private static Vector commandList;
    private static String title;
    protected static HashMap cmdConversions;
    private static boolean bTerminate;
    private static boolean bCommandEcho;
    private static boolean bStripdown;
    private static Vector errors;
    private static Properties setProperties;
    private static ArrayList help;
    private static PropertyResourceBundle helpData;
    private static CommandPlugin cp;
    private static Method argsProcessorMethod;

    public Console(String string) {
        title = string;
        mySelf = this;
        try {
            helpData = (PropertyResourceBundle)ResourceBundle.getBundle("com.ibm.jvm.j9.dump.command.CommandHelp");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (null != helpData) {
            Console.addHelp(helpData);
        }
    }

    public static void main(String[] stringArray) {
        new Console("Generic");
        Console.mainLoop();
    }

    public static void mainLoop() {
        Console.commandPreProcessorInit();
        if (mode == 0) {
            Console.setOutput(new ConsoleOutput(), false);
            input = new ConsoleInput();
        }
        BaseCommands baseCommands = new BaseCommands();
        Command[] commandArray = ((CommandPlugin)baseCommands).getCommandSet();
        Console.registerCommandSet(commandArray);
        baseCommands.addObserver(mySelf);
        Console.doOutput("jdmpview " + title);
        if (null != argsProcessorMethod) {
            try {
                argsProcessorMethod.invoke((Object)null, (Object[])null);
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        Console.doOutput("\nReady....('h' shows help, 'cmds' shows available commands)");
        while (!bTerminate) {
            String string = input.getInput();
            Console.handleInput(string, true);
        }
    }

    public static void handleInput(String string, boolean bl) {
        int n;
        String string2 = string;
        if (bStripdown) {
            string = Console.stripDown(string);
        }
        if (bCommandEcho) {
            Console.doOutput(string + "\n");
        }
        if (-1 == (n = Console.findVerbNounCombo(string.toUpperCase()))) {
            Console.doOutput("\" " + string + " \" not recognised as a valid command.");
        }
        String string3 = null;
        if (-1 != n) {
            try {
                string3 = Console.doCommand(n, string, string2);
            }
            catch (Exception exception) {
                Console.reportError(" Unexpected/unhandled error in the code involved processing \"" + string + "\"", exception);
            }
            if (string3 != null) {
                Console.doOutput(string3);
            }
        }
        if (verboseMode && errors.size() > 0) {
            Console.doOutput("\n\t!!! " + errors.size() + " error(s) were detected whilst processing one or more commands");
            Console.doOutput("\n\tThese errors may require further investigation, XML errors (in particular) may be due to problems");
            Console.doOutput("\tencountered during jextract processing and flagged within the output xml using <error> elements");
            Console.doOutput("\tThe errors are: \n");
            for (int i = 0; i < errors.size(); ++i) {
                Console.doOutput("#" + (i + 1) + ": " + errors.get(i));
            }
            errors.clear();
        }
        if (!bTerminate && bl) {
            String string4 = Console.getProperty("ASID");
            String string5 = Console.getProperty("Proc");
            String string6 = " ";
            if (null != string4) {
                string6 = string6 + " asid:" + string4;
            }
            if (null != string5) {
                string6 = string6 + " proc:" + string5;
            }
            Console.doOutput("\nReady" + string6 + " ....");
        } else if (bTerminate) {
            cp = new J9JVMBaseCmds();
            cp.cleanUp();
            cp = new DumpBaseCmds();
            String string7 = cp.cleanUp();
            if (string7 != null && new File(string7).exists()) {
                Console.doOutput("Jdmpview was passed a .zip file on initialization or with the SET DUMP command \nit may be necessary to manually delete the temporary files that have been created.\nThese files can be found at: \n" + string7);
            }
            Console.doOutput("\nQuitting - bye");
        }
    }

    public static boolean registerCommand(Command command) {
        boolean bl = false;
        int n = Console.findInCommandList(command.getVerb(), command.getNoun());
        if (-1 == n) {
            commandList.add(command);
            bl = true;
        }
        return bl;
    }

    public static void registerCommandSet(Command[] commandArray) {
        for (int i = 0; i < commandArray.length; ++i) {
            if (null == commandArray[i]) continue;
            Console.registerCommand(commandArray[i]);
        }
    }

    public void update(Observable observable, Object object) {
        Object object2;
        if (object instanceof ConsoleMsg) {
            object2 = (ConsoleMsg)object;
            if (((ConsoleMsg)object2).verboseOnly && !verboseMode) {
                return;
            }
        }
        if (object instanceof Vector) {
            object2 = (Vector)object;
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                Object e = ((Vector)object2).get(i);
                if (e instanceof Vector) {
                    Vector vector = (Vector)e;
                    for (int j = 0; j < vector.size(); ++j) {
                        Object e2 = vector.get(j);
                        Console.doOutput(e2.toString());
                    }
                    continue;
                }
                Console.doOutput(e.toString());
            }
        } else {
            Console.doOutput(object.toString());
        }
    }

    public static String doCommand(int n, String string, String string2) {
        String string3 = null;
        Command command = (Command)commandList.elementAt(n);
        CommandPlugin commandPlugin = command.getCommandObject();
        string3 = commandPlugin.checkCommandValidity(command);
        if (string3 == null) {
            string3 = commandPlugin.go(string, string2);
        }
        return string3;
    }

    private static int findInCommandList(String string, String string2) {
        int n = -1;
        for (int i = 0; -1 == n && i < commandList.size(); ++i) {
            Command command = (Command)commandList.get(i);
            if (command.getNoun().equals(string2) && command.getVerb().equals(string)) {
                n = i;
            }
            if (!string2.equals("*") || !command.getNoun().equals("") || !command.getVerb().equals(string)) continue;
            n = i;
        }
        return n;
    }

    public static int findVerbNounCombo(String string) {
        int n = -1;
        String string2 = null;
        String string3 = "*";
        String string4 = null;
        String string5 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() > 0) {
            string2 = stringTokenizer.nextToken();
            if (stringTokenizer.countTokens() > 0) {
                string3 = stringTokenizer.nextToken();
            }
            string4 = Console.commandPreProcessor(string2);
            string5 = Console.commandPreProcessor(string3);
            n = Console.findInCommandList(string4, string5);
        }
        if (-1 == n && !string3.equals("*")) {
            string3 = "*";
            n = Console.findInCommandList(string4, string3);
        }
        return n;
    }

    public static Vector getCommandList() {
        return commandList;
    }

    public static String commandPreProcessor(String string) {
        String string2 = string;
        Object v = cmdConversions.get(string.toUpperCase());
        if (v != null) {
            string2 = (String)v;
        }
        return string2;
    }

    private static void commandPreProcessorInit() {
        cmdConversions.put("Q", "QUIT");
        cmdConversions.put("?", "HELP");
        cmdConversions.put("H", "HELP");
        cmdConversions.put("DISPLAY", "DIS");
        cmdConversions.put("D", "DIS");
        cmdConversions.put("M", "MEM");
        cmdConversions.put("MEMORY", "MEM");
        cmdConversions.put("EXIT", "QUIT");
        cmdConversions.put("END", "QUIT");
        cmdConversions.put("S", "SET");
        cmdConversions.put("T", "THREAD");
        cmdConversions.put("MD", "METADATA");
        cmdConversions.put("DU", "DUMP");
        cmdConversions.put("O", "OBJECT");
        cmdConversions.put("C", "CLASS");
        cmdConversions.put("CL", "CLASS");
        cmdConversions.put("SYN", "SYNONYMS");
        cmdConversions.put("OUTPUT", "OUT");
        cmdConversions.put("INPUT", "IN");
        cmdConversions.put("A", "ADD");
        cmdConversions.put("SYSTEM", "SYS");
        cmdConversions.put("OBJ", "OBJECT");
        cmdConversions.put("FP", "FINDPTR");
        cmdConversions.put("FINDP", "FINDPTR");
        cmdConversions.put("FN", "FINDNEXT");
        cmdConversions.put("P", "PTR");
        cmdConversions.put("I", "INT");
        cmdConversions.put("L", "LONG");
        cmdConversions.put("W", "WHATIS");
        cmdConversions.put("EXEC", "EX");
        cmdConversions.put("EXECUTE", "EX");
    }

    public void addCmdConversion(String string, String string2) {
        cmdConversions.put(string, string2);
    }

    public static void quitConsole() {
        bTerminate = true;
    }

    public static ConsoleOutput[] getOutput() {
        return output;
    }

    public static void setOutput(ConsoleOutput consoleOutput, boolean bl) {
        if (null == output) {
            output = new ConsoleOutput[1];
            Console.output[0] = consoleOutput;
            Console.setProperty("out", "*");
        } else if (bl) {
            ConsoleOutput[] consoleOutputArray = new ConsoleOutput[output.length + 1];
            String string = "";
            for (int i = 0; i < output.length; ++i) {
                consoleOutputArray[i] = output[i];
                string = string + consoleOutputArray[i].getName();
                string = string + " + ";
            }
            consoleOutputArray[consoleOutputArray.length - 1] = consoleOutput;
            string = string + consoleOutputArray[consoleOutputArray.length - 1].getName();
            output = consoleOutputArray;
            Console.setProperty("out", string);
        } else {
            for (int i = 0; i < output.length; ++i) {
                String string = output[i].getName();
                if (string.equals("*")) continue;
                output[i].close();
            }
            output = new ConsoleOutput[1];
            Console.output[0] = null == consoleOutput ? new ConsoleOutput() : consoleOutput;
            Console.setProperty("out", output[0].getName());
        }
    }

    public static void setBCommandEcho(boolean bl) {
        bCommandEcho = bl;
    }

    public static boolean isBCommandEcho() {
        return bCommandEcho;
    }

    protected static void doOutput(Object object) {
        if (null != output) {
            for (int i = 0; i < output.length; ++i) {
                output[i].doOutput(object);
            }
        } else {
            System.err.println(object.toString());
        }
    }

    private static String stripDown(String string) {
        String string2 = string;
        if (-1 != string2.indexOf(61)) {
            string2 = string2.replace('=', ' ');
        }
        return string2;
    }

    public static Vector getErrors() {
        return errors;
    }

    public static void addError(Object object) {
        errors.add(object);
    }

    public static String setProperty(String string, String string2) {
        String string3 = null;
        if (null == setProperties) {
            setProperties = new Properties();
        }
        if (setProperties.containsKey(string)) {
            String string4 = setProperties.getProperty(string);
            setProperties.remove(string);
            setProperties.put(string, string2);
            string3 = "\n " + string + " successfully changed from \"" + string4 + "\"";
        } else {
            setProperties.put(string, string2);
            string3 = "\n " + string + " successfully set";
        }
        return string3;
    }

    public static String removeProperty(String string) {
        String string2 = "\n " + string + " successfuly removed";
        if (null == setProperties) {
            setProperties = new Properties();
        }
        if (setProperties.containsKey(string)) {
            setProperties.remove(string);
        } else {
            string2 = "\n " + string + " not found";
        }
        return null;
    }

    public static String getProperty(String string) {
        String string2 = null;
        if (null == setProperties) {
            setProperties = new Properties();
        }
        if (null == string) {
            Set<Object> set = setProperties.keySet();
            StringBuffer stringBuffer = new StringBuffer();
            for (String string3 : set) {
                String string4 = (String)setProperties.get(string3);
                stringBuffer.append("\n" + string3 + " : " + string4);
            }
            string2 = stringBuffer.toString();
        } else {
            string2 = (String)setProperties.get(string);
        }
        return string2;
    }

    public static void reportError(String string, Exception exception) {
        block6: {
            if (!verboseMode) {
                return;
            }
            Console.doOutput("\n*** Error Message: " + string + "\n");
            if (null == exception) break block6;
            Console.doOutput("\n\tException attached to error:\n");
            if (null != exception.getMessage()) {
                Console.doOutput(exception.getMessage());
            }
            if (exception instanceof InvocationTargetException) {
                InvocationTargetException invocationTargetException = (InvocationTargetException)exception;
                Throwable throwable = invocationTargetException.getTargetException();
                Console.doOutput("\t\tInvocationTargetException: really " + throwable.toString());
                Console.doOutput("\n\tStack trace:");
                throwable.fillInStackTrace();
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    Console.doOutput("\t\t" + stackTraceElementArray[i].toString());
                }
            } else {
                Console.doOutput(exception.getClass().getName());
                Console.doOutput("\n\tStack trace:");
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    Console.doOutput("\t\t" + stackTraceElementArray[i].toString());
                }
            }
        }
    }

    public void setArgsProcessorMethod(Method method) {
        argsProcessorMethod = method;
    }

    public static HashMap getCmdConversions() {
        return cmdConversions;
    }

    public static void addHelp(PropertyResourceBundle propertyResourceBundle) {
        if (null == help) {
            help = new ArrayList();
        }
        help.add(propertyResourceBundle);
    }

    public static String getHelp(String string) {
        String string2 = " No help found for \"" + string + "\"";
        boolean bl = false;
        Iterator iterator = help.iterator();
        String string3 = null;
        while (iterator.hasNext() && !bl) {
            PropertyResourceBundle propertyResourceBundle = (PropertyResourceBundle)iterator.next();
            string3 = null;
            try {
                string3 = propertyResourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (null == string3) continue;
            string2 = string3;
            bl = true;
        }
        return string2;
    }

    public static void setVerboseMode(boolean bl) {
        verboseMode = bl;
    }

    public static boolean getVerboseMode() {
        return verboseMode;
    }

    static {
        mode = 0;
        commandList = new Vector();
        title = "Generic";
        cmdConversions = new HashMap();
        bTerminate = false;
        bCommandEcho = false;
        bStripdown = true;
        errors = new Vector();
    }
}

