/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command;

import com.ibm.jvm.j9.dump.command.Command;
import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.command.J9JVMBaseCmds;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleUtils;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.commandconsole.ZipHandler;
import com.ibm.jvm.j9.dump.saxhandler.GenericSaxHandler;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9AddressSpace;
import com.ibm.jvm.j9.dump.systemdump.J9Jvm;
import com.ibm.jvm.j9.dump.systemdump.J9Module;
import com.ibm.jvm.j9.dump.systemdump.J9Process;
import com.ibm.jvm.j9.dump.systemdump.J9Thread;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import com.ibm.jvm.j9.dump.systemdump.NativeThreadContext;
import com.ibm.jvm.j9.dump.systemdump.Symbol;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Observer;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipException;

public class DumpBaseCmds
extends CommandPlugin {
    private Observer observer;
    private DumpBaseCmds mySelf = this;
    private Command[] myCommands;
    private Command[] commandsPostSetDump;
    private static Dump theDump;
    private static GenericThread currentThread;
    private static ZipHandler zh;
    private static String zipDir;

    public DumpBaseCmds() {
        int n = 1;
        this.myCommands = new Command[n];
        this.myCommands[0] = new Command("set", "dump", this.mySelf, false, false, false, "Identifies the dump to work with");
        this.commandsPostSetDump = new Command[]{new Command("dis", "mmap", this.mySelf, true, false, false, "Displays the virtual address ranges within the dump"), new Command("dis", "mem", this.mySelf, true, false, false, "Formats and displays portions of memory"), new Command("dis", "sys", this.mySelf, true, false, false, "Displays build and version info for the JVM"), new Command("dis", "ptr", this.mySelf, true, false, false, "Displays the value at an address as a pointer"), new Command("dis", "long", this.mySelf, true, false, false, "Displays the value at an address as a long (8 bytes)"), new Command("dis", "int", this.mySelf, true, false, false, "Displays the value at an address as an int (4 bytes)"), new Command("find", "*", this.mySelf, true, false, false, "Find a string in memory"), new Command("findptr", "*", this.mySelf, true, false, false, "Find a pointer in memory"), new Command("findnext", "*", this.mySelf, true, false, false, "Repeat previous find command"), new Command("whatis", "*", this.mySelf, true, false, false, "Attempt to identify where an address "), new Command("+", "*", this.mySelf, true, false, false, "Scroll forwards through memory"), new Command("-", "*", this.mySelf, true, false, false, "Scroll backwards through memory"), new Command("set", "as", this.mySelf, true, false, false, "Set current AddressSpace"), new Command("set", "proc", this.mySelf, true, false, false, "Set current Process within AddressSpace"), new Command("dis", "proc", this.mySelf, true, false, false, "Display details on current process"), new Command("dis", "thread", this.mySelf, true, false, false, "Display thread details"), new Command("set", "thread", this.mySelf, true, false, false, "Set the current thread"), new Command("dis", "rs", this.mySelf, true, false, false, "Display raw stack for native threads"), new Command("dis", "sym", this.mySelf, true, false, false, "Display all known symbols"), new Command("dis", "ns", this.mySelf, true, false, false, "Display native stack for thread")};
    }

    public String go(String string, String string2) {
        String string3 = null;
        CommandDetails commandDetails = new CommandDetails(string);
        String string4 = commandDetails.getVerb();
        String string5 = commandDetails.getNoun();
        if (string4.equals("SET") && string5.equals("DUMP")) {
            string3 = this.doSetDump(commandDetails.getRest());
        }
        if (string4.equals("SET") && string5.equals("AS")) {
            string3 = this.doSetAS(commandDetails.getRest());
        }
        if (string4.equals("SET") && string5.equals("PROC")) {
            string3 = this.doSetProc(commandDetails.getRest());
        }
        if (null == theDump) {
            theDump = DumpConsole.getTheDump();
        }
        if (null != theDump) {
            if (string4.equals("DIS") && string5.equals("MMAP")) {
                string3 = this.doMemMap();
            } else if (string4.equals("DIS") && string5.equals("MEM")) {
                string3 = this.doDisplayMem(commandDetails.getRest());
            } else if (string4.equals("DIS") && string5.equals("SYS")) {
                string3 = this.doDisplaySys();
            } else if (string4.equals("DIS") && string5.equals("PROC")) {
                string3 = this.doDisProc();
            } else if (string4.equals("DIS") && string5.equals("THREAD")) {
                string3 = this.doDisplayThread(commandDetails.getRest());
            } else if (string4.equals("DIS") && string5.equals("NS")) {
                string3 = this.doDisplayNativeStack(commandDetails.getRest());
            } else if (string4.equals("DIS") && string5.equals("RS")) {
                string3 = this.doRawStack();
            } else if (string4.equals("DIS") && string5.equals("SYM")) {
                string3 = this.doDisSym();
            } else if (string4.equals("SET") && string5.equals("THREAD")) {
                string3 = this.doSetThread(commandDetails.getRest());
            } else if (string4.equals("FIND")) {
                string3 = this.goFind("FIND", string5, commandDetails, string2);
            } else if (string4.equals("FINDNEXT")) {
                string3 = this.doFindNext();
            } else if (string4.equals("FINDPTR")) {
                string3 = this.doFindPtr(string5, commandDetails);
            } else if (string4.equals("DIS") && (string5.equals("PTR") || string5.equals("INT") || string5.equals("LONG"))) {
                string3 = this.doDisplayPIL(commandDetails.getRest(), string5);
            } else if (string4.equals("WHATIS")) {
                string3 = this.doWhatis(string5);
            } else if (string4.equals("+") || string4.equals("-")) {
                string3 = this.doPlusMinus(string4);
            }
        }
        return string3;
    }

    public String cleanUp() {
        if (theDump != null) {
            try {
                theDump.close();
            }
            catch (IOException iOException) {
                System.out.println("IOException when closing Dump file. /n" + iOException);
            }
        }
        if (zh != null) {
            zh.close();
        }
        if (zipDir != null) {
            boolean bl = true;
            File file = new File(zipDir);
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    bl = bl && fileArray[i].delete();
                }
            }
            boolean bl2 = bl = bl && file.delete();
            if (bl) {
                return null;
            }
            return zipDir;
        }
        return null;
    }

    private String goFind(String string, String string2, CommandDetails commandDetails, String string3) {
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ,");
        String string5 = null;
        if (stringTokenizer.countTokens() > 1) {
            stringTokenizer.nextToken();
            string5 = stringTokenizer.nextToken();
        }
        if (string5 == null) {
            string4 = this.doFindHelp();
            return string4;
        }
        boolean bl = false;
        if (string5.startsWith("\"")) {
            int n;
            int n2 = string3.indexOf("\"");
            int n3 = string3.lastIndexOf("\"");
            if (n3 != n2) {
                bl = true;
                n = string3.length();
                if (n > n3 + 1) {
                    if (string3.substring(n3 + 1, n3 + 2).equals(",")) {
                        string5 = string3.substring(n2 + 1, n3);
                        commandDetails.setRest(string3.substring(n3 + 2));
                    }
                } else if (n == n3 + 1) {
                    string5 = string3.substring(n2 + 1, n3);
                    commandDetails.setRest(null);
                }
            }
            if ((-1 == n3 || n3 == n2) && -1 != (n = string3.indexOf(","))) {
                commandDetails.setRest(string3.substring(n));
            }
        } else {
            int n = string3.indexOf(",");
            if (-1 != n) {
                commandDetails.setRest(string3.substring(n));
            }
        }
        string4 = this.findInMemory(string, string5, commandDetails.getRest(), bl);
        return string4;
    }

    public Command[] getCommandSet() {
        return this.myCommands;
    }

    private String doSetAS(String string) {
        String string2 = "Not yet supported";
        if (theDump.getAddressSpaceCount() <= 1) {
            string2 = "Only 1 address space (" + theDump.getCurrentASName() + ")";
        }
        return string2;
    }

    private String doSetProc(String string) {
        return "Not yet supported";
    }

    private String doDisProc() {
        J9Module[] j9ModuleArray;
        Object object;
        int n;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nProcess Information\n===================\n");
        stringBuffer.append("Architecture: ");
        Dump dump = DumpConsole.getTheDump();
        if (dump.is32bit()) {
            stringBuffer.append("32bit - ");
        } else {
            stringBuffer.append("64bit - ");
        }
        if (dump.isLittleEndian()) {
            stringBuffer.append("Little Endian\n");
        } else {
            stringBuffer.append("Big Endian\n");
        }
        J9Jvm j9Jvm = dump.getCurrentJvm();
        if (j9Jvm != null) {
            for (n = 0; n < j9Jvm.getThreads().size(); ++n) {
                object = (GenericThread)j9Jvm.getThreads().get(n);
                stringBuffer.append("\n Thread: " + ((GenericThread)object).getThreadId() + "   Thread name: " + ((GenericThread)object).getThreadName());
            }
        } else {
            stringBuffer.append("\n No known java threads");
        }
        n = dump.getCurrentAS();
        object = dump.getAddressSpace(n);
        int n2 = ((J9AddressSpace)object).getCurrentProcess();
        J9Process j9Process = ((J9AddressSpace)object).getProcess(n2);
        stringBuffer.append("\n\nCommandLine = " + j9Process.getCmdLine());
        if (null != GenericSaxHandler.getGpfSb()) {
            stringBuffer.append("\n\nGPF details\n===============\n");
            stringBuffer.append(GenericSaxHandler.getGpfSb());
        }
        stringBuffer.append("\n\nEnvironment Variables\n=====================\n\n");
        Properties properties = dump.getEnvVars();
        if (properties == null) {
            stringBuffer.append("  Data Unavailable\n");
        } else {
            j9ModuleArray = properties.keys();
            while (j9ModuleArray.hasMoreElements()) {
                String string2 = (String)j9ModuleArray.nextElement();
                stringBuffer.append("\t" + string2 + "=" + properties.get(string2) + "\n");
            }
        }
        stringBuffer.append("\n\nLoaded Information\n==================\n");
        j9ModuleArray = j9Process.getLoadedInfo();
        if (null == j9ModuleArray) {
            stringBuffer.append("\n\nNO LOADED DATA AVAILABLE\n\n");
        } else {
            for (int i = 0; i < j9ModuleArray.length; ++i) {
                stringBuffer.append("\n\t" + j9ModuleArray[i].getName());
                stringBuffer.append("\n\t\t at 0x" + Long.toHexString(j9ModuleArray[i].getStartAddress()));
                long l = j9ModuleArray[i].getSize();
                stringBuffer.append("  length=" + l + "(0x" + Long.toHexString(l) + ")");
            }
        }
        this.notifyObservers(stringBuffer.toString());
        return string;
    }

    private String doSetDump(String string) {
        String string2 = null;
        Dump dump = DumpConsole.getTheDump();
        if (dump != null) {
            return "Set dump has already been done";
        }
        try {
            if (zh != null) {
                zh.close();
            }
            DumpConsole.setInputFilePath(string);
            if (string.indexOf(".zip") >= 0) {
                File file = new File(string);
                zh = new ZipHandler(file, null, null);
                string = zh.openAndProcessZipFile();
                zipDir = zh.getTempDirName();
                this.notifyObservers("\nCompressed files extracted into temporary folder at:  " + zipDir + "\n");
            }
            int n = Dump.dumpStat(string);
            dump = Dump.getDump(string);
            if ((4 & n) == 0) {
                string2 = (1 & n) == 0 ? "\"" + string + "\" does not exist" : ((2 & n) == 0 ? "\"" + string + "\" exists but is not readable" : "\"" + string + "\" exists and is readable, but is not recognised as a valid dump");
            } else if (dump == null) {
                string2 = "Dump exists, is readable and is supported, but cannot be parsed for reasons unknown.";
            } else {
                string2 = "  Input file recognised as a ";
                string2 = dump.is32bit() ? string2 + "32-bit " : string2 + "64-bit ";
                string2 = dump.isLittleEndian() ? string2 + "little-endian " : string2 + "big-endian ";
                string2 = string2 + dump.getSystemTypeAsString(dump.getSystemType()) + " dump.";
                this.notifyObservers(string2);
                string2 = null;
                DumpConsole.setTheDump(dump);
                Vector vector = Dump.findDebugFiles(null, dump, false);
                if (vector == null || vector.size() == 0) {
                    this.notifyObservers(" Unable to establish loaded libraries.....");
                }
                DumpConsole.addInAdditionalCommands(this.commandsPostSetDump, this);
                String string3 = dump.getDumpName() + ".xml";
                File file = new File(string3);
                if (file.exists()) {
                    String string4 = "SET METADATA " + string3;
                    this.notifyObservers(" Issuing \"" + string4 + "\"");
                    int n2 = Console.findVerbNounCombo(string4);
                    if (-1 != n2) {
                        String string5 = Console.doCommand(n2, string4, null);
                        if (null != string5) {
                            this.notifyObservers("\n " + string5);
                        }
                    } else {
                        Console.reportError("Unable to find \"SET METADATA\" as a command", null);
                    }
                } else {
                    this.notifyObservers(" Unable to find \"" + string3 + "\" ..... set metadata will need to be entered manually");
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string6 = Console.getProperty("WORKDIR");
            string2 = null != string6 && !string.startsWith(string6) ? this.doSetDump(string6 + File.separator + string) : "File \"" + string + "\" not found";
        }
        catch (ZipException zipException) {
            this.notifyObservers("Zip Exception when creating ZipHandler object." + zipException);
        }
        catch (IOException iOException) {
            this.notifyObservers("IO Exception when creating ZipHandler object." + iOException);
        }
        return string2;
    }

    private String doFindNext() {
        String string = null;
        String string2 = Console.getProperty("FINDNEXT");
        if (null == string2) {
            string = "No previous find has been done";
        } else {
            this.notifyObservers("issuing FIND " + string2);
            Console.handleInput("FIND " + string2, false);
        }
        return string;
    }

    private String doFindPtr(String string, CommandDetails commandDetails) {
        int n;
        int n2;
        String string2 = null;
        if (string == null) {
            this.notifyObservers("No parameter specified - ");
            String string3 = Console.getHelp("FINDPTR");
            this.notifyObservers(string3);
            return string2;
        }
        String string4 = DumpUtils.stripOff0x(string);
        boolean bl = false;
        for (n2 = 0; n2 < string4.length(); ++n2) {
            n = ConsoleUtils.hexValue(string4.charAt(n2));
            if (n != -1) continue;
            bl = true;
        }
        if (bl) {
            this.notifyObservers("\nInvalid hex value in input: 0x" + string4 + "\n");
        } else {
            n2 = string4.length();
            if (theDump.is32bit()) {
                if (n2 > 8) {
                    this.notifyObservers("\nPointer is too long (max 8 hex characters!\n");
                    return string2;
                }
                if (n2 < 8) {
                    for (n = 0; n < 8 - n2; ++n) {
                        string4 = "0" + string4;
                    }
                }
            } else {
                if (n2 > 16) {
                    this.notifyObservers("\nPointer is too long (max 16 hex characters!\n");
                    return string2;
                }
                if (n2 < 16) {
                    for (n = 0; n < 16 - n2; ++n) {
                        string4 = "0" + string4;
                    }
                }
            }
            if (theDump.isLittleEndian()) {
                if (theDump.is32bit()) {
                    String string5 = string4.substring(6, 8) + string4.substring(4, 6) + string4.substring(2, 4) + string4.substring(0, 2);
                    string4 = "0x" + string5;
                } else {
                    String string6 = string4.substring(14, 16) + string4.substring(12, 14) + string4.substring(10, 12) + string4.substring(8, 10) + string4.substring(6, 8) + string4.substring(4, 6) + string4.substring(2, 4) + string4.substring(0, 2);
                    string4 = "0x" + string6;
                }
                string2 = this.findInMemory("FINDPTR", string4, commandDetails.getRest(), false);
            }
        }
        return string2;
    }

    private String doDisSym() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\nSymbols (address followed by name)....");
        Iterator iterator = Symbol.getSymbolsIterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            Symbol symbol = Symbol.getSymbolUsingValue(l);
            stringBuffer.append("\n\t0x" + Long.toHexString(l) + "\t" + symbol.getSymbolName());
            if (stringBuffer.length() <= 2000) continue;
            this.notifyObservers(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        if (stringBuffer.length() > 0) {
            this.notifyObservers(stringBuffer.toString());
        }
        return "\n\nSymbol display finished";
    }

    private String doRawStack() {
        Object var1_1 = null;
        int n = 8;
        if (J9JVMConsole.getTheDump().is32bit()) {
            n = 4;
        }
        J9Process j9Process = null;
        J9AddressSpace j9AddressSpace = theDump.getAddressSpace(theDump.getCurrentAS());
        if (j9AddressSpace != null) {
            j9Process = j9AddressSpace.getProcess(j9AddressSpace.getCurrentProcess());
        }
        if (j9Process != null) {
            Iterator iterator = j9Process.getThreads();
            while (iterator.hasNext()) {
                GenericThread genericThread = (GenericThread)iterator.next();
                boolean bl = false;
                long l = genericThread.getStackstart();
                int n2 = genericThread.getStacksize();
                StringBuffer stringBuffer = new StringBuffer();
                if (l != 0L && n2 != 0) {
                    stringBuffer.append("\n\n Thread id: " + genericThread.getThreadId() + " Stack Start: 0x" + Long.toHexString(l) + " Size: 0x" + Integer.toHexString(n2) + "\n");
                    NativeThreadContext nativeThreadContext = genericThread.getContext();
                    if (nativeThreadContext != null) {
                        String string = null;
                        long l2 = 0L;
                        l2 = nativeThreadContext.getBp();
                        stringBuffer.append("\n\tBack Pointer(bp equiv): 0x" + Long.toHexString(l2));
                        if (l2 != 0L && null != (string = Symbol.getSymbolForAddress(l2))) {
                            stringBuffer.append("  " + string);
                        }
                        l2 = nativeThreadContext.getPc();
                        stringBuffer.append("\n\tProgram Counter(pc equiv): 0x" + Long.toHexString(l2));
                        if (l2 != 0L && null != (string = Symbol.getSymbolForAddress(l2))) {
                            stringBuffer.append("  " + string);
                        }
                        l2 = nativeThreadContext.getSp();
                        stringBuffer.append("\n\tStack Pointer(sp equiv): 0x" + Long.toHexString(l2));
                        if (l2 != 0L && null != (string = Symbol.getSymbolForAddress(l2))) {
                            stringBuffer.append("  " + string);
                        }
                    } else {
                        stringBuffer.append("  !!! No native thread context found !!!");
                    }
                    try {
                        theDump.seekToMemoryAddress(l);
                        long l3 = 0L;
                        int n3 = 0;
                        for (int i = 0; i < n2; i += n) {
                            String string;
                            if (n == 4) {
                                n3 = theDump.readIntEx();
                                stringBuffer.append("\n\t0x" + Long.toHexString(l + (long)i) + "\t" + DumpUtils.padToPtrSize(Integer.toHexString(n3)));
                                if ((long)n3 >= l && (long)n3 <= l + (long)n2) {
                                    stringBuffer.append("  *");
                                    int n4 = n3 - ((int)l + i);
                                    if (l + (long)i <= (long)n3) {
                                        stringBuffer.append("+ 0x" + Integer.toHexString(n4));
                                    } else {
                                        stringBuffer.append("- 0x" + Integer.toHexString(-n4));
                                    }
                                }
                                if (null != (string = Symbol.getSymbolForAddress(n3)) && n3 != 0) {
                                    stringBuffer.append(" " + string);
                                }
                            } else {
                                l3 = theDump.readLongEx();
                                stringBuffer.append("\n\t0x" + Long.toHexString(l + (long)i) + "\t" + DumpUtils.padToPtrSize(Long.toHexString(l3)));
                                if (l3 >= l && l3 <= l + (long)n2) {
                                    stringBuffer.append("  *");
                                    int n5 = (int)(l3 - (long)((int)l + i));
                                    if (l + (long)i <= l3) {
                                        stringBuffer.append("+ 0x" + Integer.toHexString(n5));
                                    } else {
                                        stringBuffer.append("- 0x" + Integer.toHexString(-n5));
                                    }
                                }
                                if (null != (string = Symbol.getSymbolForAddress(l3)) && l3 != 0L) {
                                    stringBuffer.append(" " + string);
                                }
                            }
                            if (stringBuffer.length() <= 2048) continue;
                            this.notifyObservers(stringBuffer.toString());
                            stringBuffer.setLength(0);
                        }
                    }
                    catch (Exception exception) {
                        stringBuffer.append("\n Exception whilst traversing stack\n");
                    }
                }
                if (stringBuffer.length() <= 0) continue;
                this.notifyObservers(stringBuffer.toString());
            }
        }
        return " dis rs finished";
    }

    private String doMemMap() {
        String string = null;
        MemoryRange[] memoryRangeArray = theDump.getMemoryRanges();
        if (null != memoryRangeArray) {
            this.notifyObservers("\nMemory Map\n==========");
            for (int i = 0; i < memoryRangeArray.length; ++i) {
                if (null == memoryRangeArray[i] || memoryRangeArray[i].getSize() == 0L) continue;
                this.notifyObservers(memoryRangeArray[i].toString());
            }
        }
        return string;
    }

    private String doDisplayPIL(String string, String string2) {
        String string3;
        block11: {
            string3 = null;
            String string4 = new String(string);
            if (string4.startsWith("@") && null == (string4 = DumpUtils.chainViaPtr(string4, theDump.isLittleEndian()))) {
                string3 = "Error - Invalid pointer using @ in " + string;
            }
            if (string3 == null) {
                if (ConsoleUtils.verifyAsHex(string4 = DumpUtils.stripOff0x(string4))) {
                    try {
                        long l = DumpUtils.parseLongHex(string4);
                        Dump dump = DumpConsole.getTheDump();
                        long l2 = 0L;
                        if (dump.seekToMemoryAddress(l) > 0L) {
                            try {
                                if (string2.equals("INT")) {
                                    l2 = DumpUtils.convertEndian(dump.readIntEx());
                                    string3 = l2 + " (0x" + Long.toHexString(l2) + ")";
                                    break block11;
                                }
                                if (string2.equals("LONG")) {
                                    l2 = DumpUtils.convertEndian(dump.readLongEx());
                                    string3 = l2 + " (0x" + Long.toHexString(l2) + ")";
                                    break block11;
                                }
                                l2 = dump.readPtr(l);
                                string3 = " 0x" + Long.toHexString(l2);
                            }
                            catch (IOException iOException) {}
                            break block11;
                        }
                        string3 = "Error address not found in dump - 0x" + Long.toHexString(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        string3 = "Error - was expecting valid hex and not " + string;
                    }
                } else {
                    string3 = "Error - was expecting valid hex and not " + string;
                }
            }
        }
        return string3;
    }

    private String doDisplayMem(String string) {
        String string2;
        block14: {
            string2 = null;
            Vector vector = new Vector();
            vector = ConsoleUtils.breakUpInput(string, ",. ");
            if (vector.size() == 1) {
                vector.add("256");
            }
            if (vector.size() != 0) {
                String string3 = (String)vector.get(0);
                String string4 = new String(string3);
                if (string3.startsWith("@") && null == (string3 = DumpUtils.chainViaPtr(string3, theDump.isLittleEndian()))) {
                    string2 = "Error - Invalid pointer using @ in " + string4;
                }
                string3 = DumpUtils.stripOff0x(string3);
                String string5 = (String)vector.get(1);
                if (ConsoleUtils.verifyAsHex(string3)) {
                    if (!ConsoleUtils.verifyAsPositiveNumber(string5)) {
                        string2 = "Error - Invalid Length!";
                    } else {
                        try {
                            long l = DumpUtils.parseLongHex(string3);
                            int n = Integer.parseInt(string5);
                            Dump dump = DumpConsole.getTheDump();
                            byte[] byArray = dump.getMemoryBytes(l, n);
                            if (null != byArray) {
                                boolean bl = true;
                                if (dump.getSystemType() == 3) {
                                    bl = false;
                                }
                                long l2 = l;
                                long l3 = l;
                                String string6 = "0x" + Long.toHexString(l2 += (long)n) + "," + n;
                                String string7 = "0x" + Long.toHexString(l3 -= (long)n) + "," + n;
                                Console.setProperty("DISNEXTMEM", string6);
                                Console.setProperty("DISPREVMEM", string7);
                                Vector vector2 = DumpUtils.formatMemory(byArray, l, 16, bl);
                                if (vector2.size() != 0) {
                                    for (int i = 0; i < vector2.size(); ++i) {
                                        this.notifyObservers(vector2.get(i));
                                    }
                                }
                                break block14;
                            }
                            string2 = "Error - Address not in memory: " + string4;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else {
                    string2 = "Error - Invalid Address!";
                }
            } else {
                string2 = "Error - No address specified!";
            }
        }
        return string2;
    }

    private String doDisplaySys() {
        this.notifyObservers("\nSystem Summary\n==============");
        this.notifyObservers(theDump.toString());
        return null;
    }

    public static Dump getTheDump() {
        return theDump;
    }

    public String checkCommandValidity(Command command) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (command.isSetDumpRun() && null == DumpConsole.getTheDump()) {
            stringBuffer.append("\n \"Set dump\" needs to be run before this command! (no dump file established)");
        }
        if (command.isSetMetadataRun() && null == J9JVMConsole.getKnownHeaps()) {
            stringBuffer.append("\n \"Set metadata\" needs to be run before this command! (no known heaps)");
        }
        if (command.isDisOsRun() && null == J9JVMConsole.getNamesFile()) {
            stringBuffer.append("\n \"Dis os\" needs to be run before this command! (no names index file)");
        }
        if ((string = stringBuffer.toString()).equals("")) {
            string = null;
        }
        return string;
    }

    private String findInMemory(String string, String string2, String string3, boolean bl) {
        String string4;
        long l = 0L;
        long l2 = -1L;
        boolean bl2 = false;
        int n = 256;
        int n2 = 1;
        boolean bl3 = false;
        int n3 = 1;
        String string5 = "1";
        boolean bl4 = false;
        Vector<Object> vector = new Vector<Object>();
        String string6 = null;
        String string7 = string2;
        boolean bl5 = false;
        Vector vector2 = null;
        if (string.equals("FINDPTR")) {
            bl5 = true;
        }
        if (null == string2) {
            bl4 = true;
            String string8 = this.doFindHelp();
            this.notifyObservers(string8);
        } else {
            int n4;
            int n5;
            Object object;
            int n6;
            int n7;
            boolean bl6 = false;
            if (theDump.getSystemType() == 3) {
                bl6 = true;
            }
            string4 = null;
            if (null != string3) {
                string4 = string3;
                n7 = string3.indexOf("\"");
                if (-1 != n7) {
                    string4 = string3.substring(n7 + 2);
                }
            }
            if (!bl4 && !bl && string7.toUpperCase().startsWith("0X")) {
                if (2 < string7.length()) {
                    bl3 = true;
                    string7 = DumpUtils.stripOff0x(string7);
                    string7.trim();
                    if (1 == string7.length() % 2) {
                        string7 = "0" + string7;
                    }
                    for (n7 = 0; n7 < string7.length(); ++n7) {
                        n6 = ConsoleUtils.hexValue(string7.charAt(n7));
                        if (n6 != -1) continue;
                        bl4 = true;
                    }
                    if (bl4) {
                        vector.add("\nInvalid hex value: 0x" + string7 + "\n");
                    }
                } else {
                    vector.add("\nInvalid command structure:" + string7 + "\n");
                    bl4 = true;
                }
            }
            if (!bl4 && bl5) {
                bl3 = true;
                for (n7 = 0; n7 < string7.length(); ++n7) {
                    n6 = ConsoleUtils.hexValue(string7.charAt(n7));
                    if (n6 != -1) continue;
                    bl4 = true;
                }
                if (bl4) {
                    vector.add("\nInvalid hex value: 0x" + string7 + "\n");
                }
            }
            Vector<String> vector3 = new Vector<String>();
            if (!bl4 && null != string4) {
                n6 = 0;
                while (0 == n6) {
                    int n8 = string4.indexOf(",,");
                    if (-1 == n8) {
                        n6 = 1;
                        continue;
                    }
                    string4 = string4.substring(0, n8 + 1) + " " + string4.substring(n8 + 1);
                }
                object = new StringTokenizer(string4, ",");
                n5 = ((StringTokenizer)object).countTokens();
                if (0 != n5) {
                    for (n4 = 0; n4 < n5; ++n4) {
                        vector3.add(((StringTokenizer)object).nextToken().trim());
                    }
                }
                if (n5 > 5) {
                    vector.add("\nInvalid command structure: too many parameters\n");
                    bl4 = true;
                }
            }
            if (!bl4 && 0 != vector3.size()) {
                String string9 = (String)vector3.get(0);
                if (0 != string9.length()) {
                    try {
                        l = ConsoleUtils.hexToLong(string9);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid parameter:" + string9);
                    }
                }
                if (1 < vector3.size() && 0 != ((String)(object = (String)vector3.get(1))).length()) {
                    try {
                        l2 = ConsoleUtils.hexToLong((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid parameter:" + (String)object);
                    }
                }
                if (2 < vector3.size() && ((String)(object = (String)vector3.get(2))).length() != 0) {
                    try {
                        n2 = Integer.parseInt((String)object);
                        if (1 > n2 || 256 < n2) {
                            bl4 = true;
                            vector.add("Invalid boundary parameter (between 1 and 256 are valid) :" + (String)object);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid boundary parameter:" + (String)object);
                    }
                }
                if (3 < vector3.size() && ((String)(object = (String)vector3.get(3))).length() != 0) {
                    try {
                        n = Integer.parseInt((String)object);
                        if (16 > n) {
                            bl4 = true;
                            vector.add("Invalid print length parameter (less than 16) :" + (String)object);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid print length parameter:" + (String)object);
                    }
                }
                if (4 < vector3.size() && (string5 = (String)vector3.get(4)).length() != 0) {
                    try {
                        n3 = Integer.parseInt(string5);
                        if (n3 > 100 || n3 < 1) {
                            bl4 = true;
                            vector.add("Invalid find limit (>100 or <1) :" + string5);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid find limit:" + string5);
                    }
                }
            }
            if (!bl4) {
                int n9;
                byte[] byArray;
                if (bl3) {
                    byArray = new byte[string7.length() / 2];
                    for (n9 = 0; n9 < byArray.length; ++n9) {
                        String string10 = string7.substring(n9 * 2, n9 * 2 + 2);
                        n4 = Integer.parseInt(string10, 16);
                        if (n4 > 127) {
                            n4 -= 256;
                        }
                        string10 = String.valueOf(n4);
                        byArray[n9] = Byte.parseByte(string10);
                    }
                } else {
                    byArray = new byte[string7.length()];
                    n9 = 0;
                    n5 = 0;
                    String string11 = Console.getProperty("FORMATAS");
                    if (null != string11) {
                        if ((string11 = string11.toUpperCase()).startsWith("E")) {
                            n9 = 1;
                        }
                        if (string11.startsWith("A")) {
                            n5 = 1;
                        }
                    }
                    if (bl6 && 0 == n5 || 1 == n9) {
                        try {
                            byArray = string7.getBytes("Cp1047");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            Console.reportError("Cp1047 not found", unsupportedEncodingException);
                        }
                    } else {
                        byArray = string7.getBytes();
                    }
                }
                if ((vector2 = DumpUtils.findInMemory(theDump, byArray, l, l2, n2, n3, bl2)).size() == n3) {
                    vector.add("  Note: your search result limit was " + n3 + " ... there may be more results\n");
                }
                if (1 < vector2.size()) {
                    for (n9 = 0; n9 < vector2.size(); ++n9) {
                        long l3 = (Long)vector2.elementAt(n9);
                        vector.add("#" + n9 + ": " + Long.toHexString(l3));
                    }
                }
                if (0 != vector2.size()) {
                    Long l4 = (Long)vector2.elementAt(vector2.size() - 1);
                    String string12 = string7;
                    if (bl) {
                        string12 = "\"" + string12 + "\"";
                    }
                    if (bl3) {
                        string12 = "0x" + string12;
                    }
                    long l5 = l4;
                    string12 = string12 + "," + Long.toHexString(l5 += (long)n2) + ",";
                    string12 = string12 + Long.toHexString(l2) + "," + n2 + ",";
                    string12 = string12 + n + "," + string5;
                    Console.setProperty("FINDNEXT", string12);
                    byte[] byArray2 = null;
                    byArray2 = theDump.getMemoryBytes(l5 - (long)n2, n);
                    Vector vector4 = DumpUtils.formatMemory(byArray2, l5 - (long)n2, 16, !bl6);
                    if (null != vector4) {
                        vector.add(vector4);
                    }
                    vector.add("  Tip 1: Use FINDNEXT (FN) command to progress through them");
                    vector.add("  Tip 2: Use \"SET FINDMODE=V\" to do automatic WHATIS\n");
                } else if (bl5) {
                    vector.add("\n No occurrence of pointer found.");
                } else {
                    vector.add("\n No occurrence of search parameter found.\n Note: If parameter was a string then check case.\nIf required \"SET FORMATAS=A\" can be used to\n force ASCII search on EBCDIC dump (and vice versa).\n Note: You can use \" SET FINDMODE=V\" to cause find to\n issue a WHATIS against each found memory position.");
                }
                vector.add(" Find finished...\n");
            }
        }
        if (null != vector) {
            this.notifyObservers(vector);
        }
        boolean bl7 = false;
        string4 = Console.getProperty("FINDMODE");
        if (null != string4 && string4.toUpperCase().startsWith("V")) {
            bl7 = true;
        }
        if (bl7) {
            for (int i = 0; i < vector2.size(); ++i) {
                long l6 = (Long)vector2.elementAt(i);
                this.notifyObservers("Issuing \"whatis " + Long.toHexString(l6) + "\" \n");
                String string13 = "whatis 0x" + Long.toHexString(l6);
                Console.handleInput(string13, false);
            }
        }
        return string6;
    }

    private String doPlusMinus(String string) {
        String string2 = null;
        String string3 = null;
        string3 = string.equals("+") ? Console.getProperty("DISNEXTMEM") : Console.getProperty("DISPREVMEM");
        string2 = null == string3 ? " No previous \"dis mem\" command has been issued." : this.doDisplayMem(string3);
        return string2;
    }

    private String doWhatis(String string) {
        String string2 = null;
        if (null == string) {
            this.notifyObservers(" Sorry, but I need to know what you want to know about.\n\t e.g. whatis 0x888abc");
            return string2;
        }
        try {
            long l = DumpUtils.parseLongHex(string);
            int n = theDump.findWhichMemoryRange(l);
            if (-1 == n) {
                this.notifyObservers(" \"" + string + "\" is not a known address in memory  ");
            } else {
                this.notifyObservers(" \"" + string + "\" is a known address in memory (range = " + n + ")");
                if (J9JVMBaseCmds.isSetMetaDataDone()) {
                    string2 = J9JVMBaseCmds.whatis(string, l, this);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.notifyObservers(" \"" + string + "\" is not recognised as a valid address");
        }
        return string2;
    }

    private String doFindHelp() {
        return Console.getHelp("FIND");
    }

    private String doDisplayThread(String string) {
        String string2 = null;
        J9Jvm j9Jvm = J9JVMConsole.getTheDump().getCurrentJvm();
        if (j9Jvm == null || j9Jvm.getThreads().size() == 0) {
            this.notifyObservers("No known jvm threads (possible xml metadata problem?)");
            return null;
        }
        if (null == string || string.equals("")) {
            this.notifyObservers(currentThread.toString());
        } else {
            int n = 0;
            if (null != j9Jvm) {
                Vector vector = j9Jvm.getThreads();
                for (int i = 0; i < vector.size(); ++i) {
                    GenericThread genericThread = (GenericThread)vector.get(i);
                    if (null == genericThread || !genericThread.matchIdOrName(string)) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    genericThread.printHeader(stringBuffer);
                    stringBuffer.append(genericThread.toString());
                    this.notifyObservers(stringBuffer.toString());
                    ++n;
                }
            }
            if (n == 0) {
                this.notifyObservers("Unable to find thread identified with \"" + string + "\" - use \"set thread\" to display valid values");
            }
        }
        return string2;
    }

    private String doDisplayNativeStack(String string) {
        Object object;
        Object object2;
        Object object3;
        J9Jvm j9Jvm = J9JVMConsole.getTheDump().getCurrentJvm();
        if (j9Jvm == null || !j9Jvm.getOwningProcess().getThreads().hasNext()) {
            this.notifyObservers("No known native threads");
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        if (null == string || string.equals("")) {
            if (currentThread instanceof J9Thread) {
                object3 = ((J9Thread)currentThread).getNativeThread();
                if (object3 != null) {
                    vector.add(object3);
                }
            } else {
                vector.add(currentThread);
            }
        } else if (null != j9Jvm) {
            object3 = j9Jvm.getOwningProcess().getThreads();
            while (object3.hasNext()) {
                object2 = (GenericThread)object3.next();
                if (!((GenericThread)object2).matchIdOrName(string)) continue;
                vector.add(object2);
            }
            if (vector.isEmpty()) {
                object2 = j9Jvm.getJavaThreads();
                while (object2.hasNext()) {
                    GenericThread genericThread;
                    object = (J9Thread)object2.next();
                    if (!((GenericThread)object).matchIdOrName(string) || (genericThread = ((J9Thread)object).getNativeThread()) == null) continue;
                    vector.add(genericThread);
                }
            }
        }
        if (vector.isEmpty()) {
            this.notifyObservers("Unable to find thread identified with \"" + string + "\" - use \"set thread\" to display valid values");
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                object2 = (GenericThread)vector.get(i);
                object = new StringBuffer();
                if (object2 == null) {
                    this.notifyObservers("Invalid thread data - possible xml metadata problem");
                    continue;
                }
                ((GenericThread)object2).printHeader((StringBuffer)object);
                ((GenericThread)object2).printNativeFrames((StringBuffer)object);
                this.notifyObservers(((StringBuffer)object).toString());
            }
        }
        return null;
    }

    private String doSetThread(String string) {
        String string2;
        GenericThread genericThread;
        int n;
        String string3 = null;
        boolean bl = false;
        J9Jvm j9Jvm = J9JVMConsole.getTheDump().getCurrentJvm();
        if (j9Jvm == null) {
            this.notifyObservers("No known jvm threads (possible xml metadata problem?)");
            return null;
        }
        if (string != null) {
            string = DumpUtils.stripOff0x(string);
            string = "0X" + string;
            for (n = 0; n < j9Jvm.getThreads().size(); ++n) {
                genericThread = (GenericThread)j9Jvm.getThreads().get(n);
                string2 = genericThread.getThreadId().toUpperCase();
                if (!string2.equals(string)) continue;
                currentThread = genericThread;
                bl = true;
                break;
            }
        } else {
            string = "";
        }
        if (!bl) {
            this.notifyObservers("Unable to find thread with Id: " + string + " - valid ids are....");
            for (n = 0; n < j9Jvm.getThreads().size(); ++n) {
                genericThread = (GenericThread)j9Jvm.getThreads().get(n);
                string2 = "  " + genericThread.getThreadId() + "  " + genericThread.getThreadName();
                if (genericThread == currentThread) {
                    string2 = string2 + "  <<<< Current Thread";
                }
                this.notifyObservers(string2);
            }
        } else {
            this.notifyObservers("Current thread now: " + string + "  " + currentThread.getThreadName());
        }
        return string3;
    }

    public static void setCurrentThread(GenericThread genericThread) {
        currentThread = genericThread;
    }
}

