/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.heapdump.portableheapdump;

import com.ibm.jvm.heapdump.ReferenceIterator;
import java.io.DataOutput;
import java.io.IOException;

public abstract class PortableHeapDumpRecord {
    public static final byte ONE_BYTE_REF = 0;
    public static final byte TWO_BYTE_REF = 1;
    public static final byte FOUR_BYTE_REF = 2;
    public static final byte EIGHT_BYTE_REF = 3;
    public static final int ADDRESS_SHIFT_SIZE = 2;
    protected final long _baseAddress;
    protected final ReferenceIterator _references;
    protected final byte _referenceFieldSize;
    protected final long _gapPreceding;
    protected final byte _gapSize;
    protected int _numberOfReferences;

    protected PortableHeapDumpRecord(long l, long l2, ReferenceIterator referenceIterator) {
        this._baseAddress = l;
        if (referenceIterator != null) {
            this._references = this.getDifferenceReferences(referenceIterator, l);
            this._referenceFieldSize = this.calculateReferenceFieldSize(referenceIterator);
        } else {
            this._references = null;
            this._referenceFieldSize = 0;
        }
        this._gapPreceding = PortableHeapDumpRecord.getAddressDifference(l, l2);
        this._gapSize = PortableHeapDumpRecord.sizeofReference(this._gapPreceding);
    }

    private byte calculateReferenceFieldSize(ReferenceIterator referenceIterator) {
        byte by = 0;
        referenceIterator.reset();
        this._numberOfReferences = 0;
        while (referenceIterator.hasNext()) {
            Long l = referenceIterator.next();
            byte by2 = PortableHeapDumpRecord.sizeofReference(l);
            if (by2 > by) {
                by = by2;
            }
            ++this._numberOfReferences;
        }
        return by;
    }

    protected static byte sizeofReference(long l) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            return 3;
        }
        if (l > 32767L || l < -32768L) {
            return 2;
        }
        if (l > 127L || l < -128L) {
            return 1;
        }
        return 0;
    }

    protected ReferenceIterator getDifferenceReferences(final ReferenceIterator referenceIterator, final long l) {
        return new ReferenceIterator(){

            public boolean hasNext() {
                return referenceIterator.hasNext();
            }

            public Long next() {
                Long l2 = referenceIterator.next();
                if (l2 == null) {
                    return null;
                }
                return new Long(PortableHeapDumpRecord.getAddressDifference(l2, l));
            }

            public void reset() {
                referenceIterator.reset();
            }
        };
    }

    protected static long getAddressDifference(long l, long l2) {
        return l - l2 >> 2;
    }

    protected final void writeReferences(DataOutput dataOutput) throws IOException {
        this._references.reset();
        if (!this._references.hasNext()) {
            return;
        }
        switch (this._referenceFieldSize) {
            case 0: {
                while (this._references.hasNext()) {
                    Long l = this._references.next();
                    dataOutput.writeByte(l.byteValue());
                }
                break;
            }
            case 1: {
                while (this._references.hasNext()) {
                    Long l = this._references.next();
                    dataOutput.writeShort(l.shortValue());
                }
                break;
            }
            case 2: {
                while (this._references.hasNext()) {
                    Long l = this._references.next();
                    dataOutput.writeInt(l.intValue());
                }
                break;
            }
            case 3: {
                while (this._references.hasNext()) {
                    Long l = this._references.next();
                    dataOutput.writeLong(l);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Error size byte invalid");
            }
        }
    }

    protected void writeReference(DataOutput dataOutput, byte by, long l) throws IOException {
        switch (by) {
            case 0: {
                dataOutput.writeByte((byte)l);
                break;
            }
            case 1: {
                dataOutput.writeShort((short)l);
                break;
            }
            case 2: {
                dataOutput.writeInt((int)l);
                break;
            }
            case 3: {
                dataOutput.writeLong(l);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong size argument!");
            }
        }
    }

    protected abstract void writeHeapDump(DataOutput var1) throws IOException;
}

