/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FilePermission;
import java.net.URI;
import java.util.Hashtable;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.StreamPrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.windows.FontKey1;
import sun.awt.windows.FontKey2;
import sun.awt.windows.WPageDialog;
import sun.awt.windows.WPathGraphics;
import sun.awt.windows.WPrintDialog;
import sun.font.FontManager;
import sun.print.PeekGraphics;
import sun.print.PeekMetrics;
import sun.print.RasterPrinterJob;
import sun.print.SunAlternateMedia;
import sun.print.SunMinMaxPage;
import sun.print.SunPageSelection;
import sun.print.Win32MediaTray;
import sun.print.Win32PrintService;
import sun.print.Win32PrintServiceLookup;

public class WPrinterJob
extends RasterPrinterJob {
    protected static final long PS_ENDCAP_ROUND = 0L;
    protected static final long PS_ENDCAP_SQUARE = 256L;
    protected static final long PS_ENDCAP_FLAT = 512L;
    protected static final long PS_JOIN_ROUND = 0L;
    protected static final long PS_JOIN_BEVEL = 4096L;
    protected static final long PS_JOIN_MITER = 8192L;
    protected static final int POLYFILL_ALTERNATE = 1;
    protected static final int POLYFILL_WINDING = 2;
    private static final int MAX_WCOLOR = 255;
    private static final int SET_DUP_VERTICAL = 16;
    private static final int SET_DUP_HORIZONTAL = 32;
    private static final int SET_RES_HIGH = 64;
    private static final int SET_RES_LOW = 128;
    private static final int SET_COLOR = 512;
    private static final int SET_ORIENTATION = 16384;
    private static final int PD_ALLPAGES = 0;
    private static final int PD_SELECTION = 1;
    private static final int PD_PAGENUMS = 2;
    private static final int PD_NOSELECTION = 4;
    private static final int PD_COLLATE = 16;
    private static final int PD_PRINTTOFILE = 32;
    private static final int DM_ORIENTATION = 1;
    private static final int DM_PRINTQUALITY = 1024;
    private static final int DM_COLOR = 2048;
    private static final int DM_DUPLEX = 4096;
    private static final int MAX_UNKNOWN_PAGES = 9999;
    private boolean driverDoesMultipleCopies = false;
    private boolean driverDoesCollation = false;
    private boolean userRequestedCollation = false;
    private boolean noDefaultPrinter = false;
    private long mPrintDC;
    private long mPrintHDevMode;
    private long mPrintHDevNames;
    private int mPrintPaperSize;
    private int mPrintXRes;
    private int mPrintYRes;
    private int mPrintPhysX;
    private int mPrintPhysY;
    private int mPrintWidth;
    private int mPrintHeight;
    private int mPageWidth;
    private int mPageHeight;
    private int mAttSides;
    private int mAttChromaticity;
    private int mAttXRes;
    private int mAttYRes;
    private int mAttQuality;
    private int mAttCollate;
    private int mAttCopies;
    private int mAttOrientation;
    private int mAttMediaSizeName;
    private int mAttMediaTray;
    private String mDestination = null;
    private Color mLastColor;
    private Color mLastTextColor;
    private Font mLastFont;
    private int mLastRotation;
    private float mLastAwScale;
    Hashtable<FontKey1, Font> fontCache1 = new Hashtable();
    Hashtable<FontKey2, Font> fontCache2 = new Hashtable();
    private PrinterJob pjob;
    private ComponentPeer dialogOwnerPeer = null;
    protected Frame dialogOwner;

    public WPrinterJob() {
        this.initAttributeMembers();
    }

    protected void finalize() {
        this.deleteDC();
    }

    public PageFormat pageDialog(PageFormat pageFormat) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        PrintService printService = this.getPrintService();
        if (printService instanceof StreamPrintService) {
            return super.pageDialog(pageFormat);
        }
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        boolean bl = false;
        this.dialogOwner = new Frame();
        if (this.dialogOwner != null) {
            this.dialogOwnerPeer = this.dialogOwner.getPeer();
            WPageDialog wPageDialog = new WPageDialog(this.dialogOwner, this, pageFormat2, null);
            wPageDialog.setRetVal(false);
            wPageDialog.show();
            bl = wPageDialog.getRetVal();
            this.dialogOwner.dispose();
        }
        if (bl && printService != null) {
            this.updatePageAttributes(printService, pageFormat2);
            return pageFormat2;
        }
        return pageFormat;
    }

    private boolean displayNativeDialog() {
        Object object;
        Object object2;
        String string;
        if (this.attributes == null) {
            return false;
        }
        WPrintDialog wPrintDialog = new WPrintDialog(this.dialogOwner, this);
        wPrintDialog.setRetVal(false);
        wPrintDialog.show();
        boolean bl = wPrintDialog.getRetVal();
        Destination destination = (Destination)this.attributes.get(Destination.class);
        if (destination == null || !bl) {
            return bl;
        }
        FileDialog fileDialog = new FileDialog(this.dialogOwner, "", 1);
        URI uRI = destination.getURI();
        String string2 = string = uRI != null ? uRI.getPath() : null;
        if (string != null) {
            object2 = new File(string);
            fileDialog.setFile(((File)object2).getName());
            object = ((File)object2).getParentFile();
            if (object != null) {
                fileDialog.setDirectory(((File)object).getPath());
            }
        } else {
            fileDialog.setFile("out.prn");
        }
        fileDialog.show();
        object2 = fileDialog.getFile();
        if (object2 == null) {
            return false;
        }
        object = fileDialog.getDirectory() + (String)object2;
        File file = new File((String)object);
        this.attributes.add(new Destination(file.toURI()));
        return true;
    }

    public boolean printDialog() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (this.attributes == null) {
            this.attributes = new HashPrintRequestAttributeSet();
        }
        if (this.getPrintService() instanceof StreamPrintService) {
            return super.printDialog(this.attributes);
        }
        if (this.noDefaultPrinter) {
            return false;
        }
        this.dialogOwner = new Frame();
        if (this.dialogOwner != null) {
            this.dialogOwnerPeer = this.dialogOwner.getPeer();
            boolean bl = this.displayNativeDialog();
            this.dialogOwner.dispose();
            return bl;
        }
        this.pjob = this;
        return this.jobSetup(this.getPageable(), this.checkAllowedToPrintToFile());
    }

    public void setPrintService(PrintService printService) throws PrinterException {
        super.setPrintService(printService);
        this.driverDoesMultipleCopies = false;
        this.driverDoesCollation = false;
        this.setNativePrintService(printService.getName());
    }

    private native void setNativePrintService(String var1);

    public PrintService getPrintService() {
        if (this.myService == null) {
            String string = this.getNativePrintService();
            if (string != null) {
                HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
                hashPrintServiceAttributeSet.add(new PrinterName(string, null));
                PrintService[] printServiceArray = new Win32PrintServiceLookup().getPrintServices(null, hashPrintServiceAttributeSet);
                if (printServiceArray.length > 0) {
                    this.myService = printServiceArray[0];
                    return this.myService;
                }
            }
            this.myService = PrintServiceLookup.lookupDefaultPrintService();
            if (this.myService != null) {
                this.setNativePrintService(this.myService.getName());
            }
        }
        return this.myService;
    }

    private native String getNativePrintService();

    private void initAttributeMembers() {
        this.mAttSides = 0;
        this.mAttChromaticity = 0;
        this.mAttXRes = 0;
        this.mAttYRes = 0;
        this.mAttQuality = 0;
        this.mAttCollate = -1;
        this.mAttCopies = 0;
        this.mAttOrientation = 0;
        this.mAttMediaTray = 0;
        this.mAttMediaSizeName = 0;
        this.mDestination = null;
    }

    protected void setAttributes(PrintRequestAttributeSet printRequestAttributeSet) throws PrinterException {
        this.initAttributeMembers();
        super.setAttributes(printRequestAttributeSet);
        this.mAttCopies = this.getCopiesInt();
        this.mDestination = this.destinationAttr;
        if (printRequestAttributeSet == null) {
            return;
        }
        Attribute[] attributeArray = printRequestAttributeSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            try {
                Cloneable cloneable;
                Attribute attribute = attributeArray[i];
                if (attribute.getCategory() == Sides.class) {
                    if (attribute.equals(Sides.TWO_SIDED_LONG_EDGE)) {
                        this.mAttSides = 2;
                        continue;
                    }
                    if (attribute.equals(Sides.TWO_SIDED_SHORT_EDGE)) {
                        this.mAttSides = 3;
                        continue;
                    }
                    this.mAttSides = 1;
                    continue;
                }
                if (attribute.getCategory() == Chromaticity.class) {
                    if (attribute.equals(Chromaticity.COLOR)) {
                        this.mAttChromaticity = 2;
                        continue;
                    }
                    this.mAttChromaticity = 1;
                    continue;
                }
                if (attribute.getCategory() == PrinterResolution.class) {
                    cloneable = (PrinterResolution)attribute;
                    this.mAttXRes = cloneable.getCrossFeedResolution(100);
                    this.mAttYRes = cloneable.getFeedResolution(100);
                    continue;
                }
                if (attribute.getCategory() == PrintQuality.class) {
                    if (attribute.equals(PrintQuality.HIGH)) {
                        this.mAttQuality = -4;
                        continue;
                    }
                    if (attribute.equals(PrintQuality.NORMAL)) {
                        this.mAttQuality = -3;
                        continue;
                    }
                    this.mAttQuality = -2;
                    continue;
                }
                if (attribute.getCategory() == SheetCollate.class) {
                    if (attribute.equals(SheetCollate.COLLATED)) {
                        this.mAttCollate = 1;
                        continue;
                    }
                    this.mAttCollate = 0;
                    continue;
                }
                if (attribute.getCategory() != Media.class && attribute.getCategory() != SunAlternateMedia.class) continue;
                if (!(attribute.getCategory() != SunAlternateMedia.class || (cloneable = (Media)printRequestAttributeSet.get(Media.class)) != null && cloneable instanceof MediaTray)) {
                    attribute = ((SunAlternateMedia)attribute).getMedia();
                }
                if (attribute instanceof MediaSizeName) {
                    // empty if block
                }
                if (!(attribute instanceof MediaTray)) continue;
                if (attribute.equals(MediaTray.BOTTOM)) {
                    this.mAttMediaTray = 2;
                    continue;
                }
                if (attribute.equals(MediaTray.ENVELOPE)) {
                    this.mAttMediaTray = 5;
                    continue;
                }
                if (attribute.equals(MediaTray.LARGE_CAPACITY)) {
                    this.mAttMediaTray = 11;
                    continue;
                }
                if (attribute.equals(MediaTray.MAIN)) {
                    this.mAttMediaTray = 1;
                    continue;
                }
                if (attribute.equals(MediaTray.MANUAL)) {
                    this.mAttMediaTray = 4;
                    continue;
                }
                if (attribute.equals(MediaTray.MIDDLE)) {
                    this.mAttMediaTray = 3;
                    continue;
                }
                if (attribute.equals(MediaTray.SIDE)) {
                    this.mAttMediaTray = 7;
                    continue;
                }
                if (attribute.equals(MediaTray.TOP)) {
                    this.mAttMediaTray = 1;
                    continue;
                }
                if (attribute instanceof Win32MediaTray) {
                    this.mAttMediaTray = ((Win32MediaTray)attribute).winID;
                    continue;
                }
                this.mAttMediaTray = 1;
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private native void getDefaultPage(PageFormat var1);

    public PageFormat defaultPage(PageFormat pageFormat) {
        PageFormat pageFormat2 = (PageFormat)pageFormat.clone();
        this.getDefaultPage(pageFormat2);
        return pageFormat2;
    }

    protected native void validatePaper(Paper var1, Paper var2);

    protected Graphics2D createPathGraphics(PeekGraphics peekGraphics, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n) {
        WPathGraphics wPathGraphics;
        PeekMetrics peekMetrics = peekGraphics.getMetrics();
        if (!forcePDL && (forceRaster || peekMetrics.hasNonSolidColors() || peekMetrics.hasCompositing())) {
            wPathGraphics = null;
        } else {
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            boolean bl = !peekGraphics.getAWTDrawingOnly();
            wPathGraphics = new WPathGraphics(graphics2D, printerJob, printable, pageFormat, n, bl);
        }
        return wPathGraphics;
    }

    protected double getXRes() {
        if (this.mAttXRes != 0) {
            return this.mAttXRes;
        }
        return this.mPrintXRes;
    }

    protected double getYRes() {
        if (this.mAttYRes != 0) {
            return this.mAttYRes;
        }
        return this.mPrintYRes;
    }

    protected double getPhysicalPrintableX(Paper paper) {
        return this.mPrintPhysX;
    }

    protected double getPhysicalPrintableY(Paper paper) {
        return this.mPrintPhysY;
    }

    protected double getPhysicalPrintableWidth(Paper paper) {
        return this.mPrintWidth;
    }

    protected double getPhysicalPrintableHeight(Paper paper) {
        return this.mPrintHeight;
    }

    protected double getPhysicalPageWidth(Paper paper) {
        return this.mPageWidth;
    }

    protected double getPhysicalPageHeight(Paper paper) {
        return this.mPageHeight;
    }

    protected boolean isCollated() {
        return this.userRequestedCollation;
    }

    protected int getCollatedCopies() {
        this.debug_println("driverDoesMultipleCopies=" + this.driverDoesMultipleCopies + " driverDoesCollation=" + this.driverDoesCollation);
        if (super.isCollated() && !this.driverDoesCollation) {
            this.mAttCollate = 0;
            this.mAttCopies = 1;
            return this.getCopies();
        }
        return 1;
    }

    protected int getNoncollatedCopies() {
        if (this.driverDoesMultipleCopies || super.isCollated()) {
            return 1;
        }
        return this.getCopies();
    }

    protected long getPrintDC() {
        return this.mPrintDC;
    }

    protected void beginPath() {
        this.beginPath(this.mPrintDC);
    }

    protected void endPath() {
        this.endPath(this.mPrintDC);
    }

    protected void closeFigure() {
        this.closeFigure(this.mPrintDC);
    }

    protected void fillPath() {
        this.fillPath(this.mPrintDC);
    }

    protected void moveTo(float f, float f2) {
        this.moveTo(this.mPrintDC, f, f2);
    }

    protected void lineTo(float f, float f2) {
        this.lineTo(this.mPrintDC, f, f2);
    }

    protected void polyBezierTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.polyBezierTo(this.mPrintDC, f, f2, f3, f4, f5, f6);
    }

    protected void setPolyFillMode(int n) {
        this.setPolyFillMode(this.mPrintDC, n);
    }

    protected void selectSolidBrush(Color color) {
        if (!color.equals(this.mLastColor)) {
            this.mLastColor = color;
            float[] fArray = color.getColorComponents(null);
            this.selectSolidBrush(this.mPrintDC, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
        }
    }

    protected int getPenX() {
        return this.getPenX(this.mPrintDC);
    }

    protected int getPenY() {
        return this.getPenY(this.mPrintDC);
    }

    protected void selectClipPath() {
        this.selectClipPath(this.mPrintDC);
    }

    protected void frameRect(float f, float f2, float f3, float f4) {
        this.frameRect(this.mPrintDC, f, f2, f3, f4);
    }

    protected void fillRect(float f, float f2, float f3, float f4, Color color) {
        float[] fArray = color.getColorComponents(null);
        this.fillRect(this.mPrintDC, f, f2, f3, f4, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
    }

    protected void selectPen(float f, Color color) {
        float[] fArray = color.getColorComponents(null);
        this.selectPen(this.mPrintDC, f, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
    }

    protected boolean selectStylePen(int n, int n2, float f, Color color) {
        long l;
        long l2;
        float[] fArray = color.getColorComponents(null);
        switch (n) {
            case 0: {
                l2 = 512L;
                break;
            }
            case 1: {
                l2 = 0L;
                break;
            }
            default: {
                l2 = 256L;
            }
        }
        switch (n2) {
            case 2: {
                l = 4096L;
                break;
            }
            default: {
                l = 8192L;
                break;
            }
            case 1: {
                l = 0L;
            }
        }
        return this.selectStylePen(this.mPrintDC, l2, l, f, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
    }

    protected boolean setFont(Font font, int n, float f) {
        boolean bl = true;
        if (!font.equals(this.mLastFont) || n != this.mLastRotation || f != this.mLastAwScale) {
            int n2 = FontManager.getFont2D((Font)font).getStyle();
            int n3 = font.getStyle() | n2;
            bl = this.setFont(this.mPrintDC, font.getFamily(), font.getSize2D(), (n3 & 1) != 0, (n3 & 2) != 0, n, f);
            if (bl) {
                this.mLastFont = font;
                this.mLastRotation = n;
                this.mLastAwScale = f;
            }
        }
        return bl;
    }

    protected void setTextColor(Color color) {
        if (!color.equals(this.mLastTextColor)) {
            this.mLastTextColor = color;
            float[] fArray = color.getColorComponents(null);
            this.setTextColor(this.mPrintDC, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
        }
    }

    protected void textOut(String string, float f, float f2, Font font) {
        this.textOut(this.mPrintDC, string, f, f2, font);
    }

    protected void drawImage3ByteBGR(byte[] byArray, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.drawImage3ByteBGR(this.mPrintDC, byArray, f, f2, f3, f4, f5, f6, f7, f8);
    }

    protected void startPage(PageFormat pageFormat, Printable printable, int n) {
        this.invalidateCachedState();
        this.deviceStartPage(pageFormat, printable, n);
    }

    protected void endPage(PageFormat pageFormat, Printable printable, int n) {
        this.deviceEndPage(pageFormat, printable, n);
    }

    private void invalidateCachedState() {
        this.mLastColor = null;
        this.mLastTextColor = null;
        this.mLastFont = null;
    }

    public void setCopies(int n) {
        super.setCopies(n);
        this.setNativeCopies(n);
    }

    public native void setNativeCopies(int var1);

    public native boolean pageSetup(PageFormat var1, Printable var2);

    private native boolean jobSetup(Pageable var1, boolean var2);

    protected native void initPrinter();

    private native void _startDoc(String var1);

    protected void startDoc() {
        this._startDoc(this.mDestination);
    }

    protected native void endDoc();

    protected native void abortDoc();

    protected native void deleteDC();

    protected native void deviceStartPage(PageFormat var1, Printable var2, int var3);

    protected native void deviceEndPage(PageFormat var1, Printable var2, int var3);

    protected native void printBand(byte[] var1, int var2, int var3, int var4, int var5);

    protected native void beginPath(long var1);

    protected native void endPath(long var1);

    protected native void closeFigure(long var1);

    protected native void fillPath(long var1);

    protected native void moveTo(long var1, float var3, float var4);

    protected native void lineTo(long var1, float var3, float var4);

    protected native void polyBezierTo(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    protected native void setPolyFillMode(long var1, int var3);

    protected native void selectSolidBrush(long var1, int var3, int var4, int var5);

    protected native int getPenX(long var1);

    protected native int getPenY(long var1);

    protected native void selectClipPath(long var1);

    protected native void frameRect(long var1, float var3, float var4, float var5, float var6);

    protected native void fillRect(long var1, float var3, float var4, float var5, float var6, int var7, int var8, int var9);

    protected native void selectPen(long var1, float var3, int var4, int var5, int var6);

    protected native boolean selectStylePen(long var1, long var3, long var5, float var7, int var8, int var9, int var10);

    protected native boolean setLogicalFont(Font var1, int var2, float var3);

    protected native boolean setFont(long var1, String var3, float var4, boolean var5, boolean var6, int var7, float var8);

    protected native void setTextColor(long var1, int var3, int var4, int var5);

    protected native void textOut(long var1, String var3, float var4, float var5, Font var6);

    protected native void drawImage3ByteBGR(long var1, byte[] var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11);

    public final String getPrinterAttrib() {
        PrintService printService = this.getPrintService();
        String string = printService != null ? printService.getName() : null;
        return string;
    }

    public final int getCopiesAttrib() {
        return this.getCopiesInt();
    }

    public final boolean getMDHAttrib() {
        return this.mAttCollate == 1;
    }

    public final int getOrientAttrib() {
        OrientationRequested orientationRequested;
        int n = 1;
        OrientationRequested orientationRequested2 = orientationRequested = this.attributes == null ? null : (OrientationRequested)this.attributes.get(OrientationRequested.class);
        if (orientationRequested != null) {
            if (orientationRequested.equals(OrientationRequested.REVERSE_LANDSCAPE)) {
                n = 2;
            } else if (orientationRequested.equals(OrientationRequested.LANDSCAPE)) {
                n = 0;
            }
        }
        return n;
    }

    public final int getFromPageAttrib() {
        PageRanges pageRanges;
        if (this.attributes != null && (pageRanges = (PageRanges)this.attributes.get(PageRanges.class)) != null) {
            int[][] nArray = pageRanges.getMembers();
            return nArray[0][0];
        }
        return this.getMinPageAttrib();
    }

    public final int getToPageAttrib() {
        PageRanges pageRanges;
        if (this.attributes != null && (pageRanges = (PageRanges)this.attributes.get(PageRanges.class)) != null) {
            int[][] nArray = pageRanges.getMembers();
            return nArray[nArray.length - 1][1];
        }
        return this.getMaxPageAttrib();
    }

    public final int getMinPageAttrib() {
        SunMinMaxPage sunMinMaxPage;
        if (this.attributes != null && (sunMinMaxPage = (SunMinMaxPage)this.attributes.get(SunMinMaxPage.class)) != null) {
            return sunMinMaxPage.getMin();
        }
        return 1;
    }

    public final int getMaxPageAttrib() {
        Object object;
        if (this.attributes != null && (object = (SunMinMaxPage)this.attributes.get(SunMinMaxPage.class)) != null) {
            return ((SunMinMaxPage)object).getMax();
        }
        object = this.getPageable();
        if (object != null) {
            int n = object.getNumberOfPages();
            if (n <= -1) {
                n = 9999;
            }
            return n == 0 ? 1 : n;
        }
        return Integer.MAX_VALUE;
    }

    public final boolean getDestAttrib() {
        return this.mDestination != null;
    }

    public final int getQualityAttrib() {
        return this.mAttQuality;
    }

    public final int getColorAttrib() {
        return this.mAttChromaticity;
    }

    public final int getSidesAttrib() {
        return this.mAttSides;
    }

    public final int[] getWin32MediaAttrib() {
        MediaSizeName mediaSizeName;
        MediaSize mediaSize;
        Media media;
        int[] nArray = new int[]{0, 0};
        if (this.attributes != null && (media = (Media)this.attributes.get(Media.class)) instanceof MediaSizeName && (mediaSize = MediaSize.getMediaSizeForName(mediaSizeName = (MediaSizeName)media)) != null) {
            nArray[0] = (int)((double)mediaSize.getX(25400) * 72.0);
            nArray[1] = (int)((double)mediaSize.getY(25400) * 72.0);
        }
        return nArray;
    }

    public final int getSelectAttrib() {
        if (this.attributes != null) {
            SunPageSelection sunPageSelection = (SunPageSelection)this.attributes.get(SunPageSelection.class);
            if (sunPageSelection == SunPageSelection.RANGE) {
                return 2;
            }
            if (sunPageSelection == SunPageSelection.SELECTION) {
                return 1;
            }
            if (sunPageSelection == SunPageSelection.ALL) {
                return 0;
            }
        }
        return 4;
    }

    public final boolean getPrintToFileEnabled() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            FilePermission filePermission = new FilePermission("<<ALL FILES>>", "read,write");
            try {
                securityManager.checkPermission(filePermission);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    public final void setNativeAttributes(int n, int n2) {
        if (this.attributes == null) {
            return;
        }
        if ((n & 0x20) != 0) {
            Destination destination = (Destination)this.attributes.get(Destination.class);
            if (destination == null) {
                try {
                    this.attributes.add(new Destination(new File("./out.prn").toURI()));
                }
                catch (SecurityException securityException) {}
            }
        } else {
            this.attributes.remove(Destination.class);
        }
        if ((n & 0x10) != 0) {
            this.attributes.add(SheetCollate.COLLATED);
        } else {
            this.attributes.add(SheetCollate.UNCOLLATED);
        }
        if ((n & 2) != 0) {
            this.attributes.add(SunPageSelection.RANGE);
        } else if ((n & 1) != 0) {
            this.attributes.add(SunPageSelection.SELECTION);
        } else {
            this.attributes.add(SunPageSelection.ALL);
        }
        if ((n2 & 1) != 0) {
            if ((n2 & 0x4000) != 0) {
                this.attributes.add(OrientationRequested.LANDSCAPE);
            } else {
                this.attributes.add(OrientationRequested.PORTRAIT);
            }
        }
        if ((n2 & 0x800) != 0) {
            if ((n2 & 0x200) != 0) {
                this.attributes.add(Chromaticity.COLOR);
            } else {
                this.attributes.add(Chromaticity.MONOCHROME);
            }
        }
        if ((n2 & 0x400) != 0) {
            if ((n2 & 0x80) != 0) {
                this.attributes.add(PrintQuality.DRAFT);
            } else if ((n2 & 0x40) != 0) {
                this.attributes.add(PrintQuality.HIGH);
            } else {
                this.attributes.add(PrintQuality.NORMAL);
            }
        }
        if ((n2 & 0x1000) != 0) {
            if ((n2 & 0x10) != 0) {
                this.attributes.add(Sides.TWO_SIDED_LONG_EDGE);
            } else if ((n2 & 0x20) != 0) {
                this.attributes.add(Sides.TWO_SIDED_SHORT_EDGE);
            } else {
                this.attributes.add(Sides.ONE_SIDED);
            }
        }
    }

    public final void setResolutionDPI(int n, int n2) {
        if (this.attributes != null) {
            this.attributes.add(new PrinterResolution(n, n2, 100));
        }
    }

    public final void setRangeCopiesAttribute(int n, int n2, boolean bl, int n3) {
        if (this.attributes != null) {
            if (bl) {
                this.attributes.add(new PageRanges(n, n2));
            }
            this.attributes.add(new Copies(n3));
        }
    }

    public void setWin32MediaAttrib(int n, int n2, int n3) {
        MediaSizeName mediaSizeName = ((Win32PrintService)this.myService).findWin32Media(n);
        if (mediaSizeName == null) {
            mediaSizeName = ((Win32PrintService)this.myService).findMatchingMediaSizeNameMM(n2, n3);
        }
        if (mediaSizeName != null && this.attributes != null) {
            this.attributes.add(mediaSizeName);
        }
    }

    public void setPrinterNameAttrib(String string) {
        PrintService printService = this.getPrintService();
        if (string == null) {
            return;
        }
        if (printService != null && string.equals(printService.getName())) {
            return;
        }
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        for (int i = 0; i < printServiceArray.length; ++i) {
            if (!string.equals(printServiceArray[i].getName())) continue;
            try {
                this.setPrintService(printServiceArray[i]);
            }
            catch (PrinterException printerException) {
                // empty catch block
            }
            return;
        }
    }

    private static native void initIDs();

    static {
        Toolkit.getDefaultToolkit();
        WPrinterJob.initIDs();
        Win32GraphicsEnvironment.registerJREFontsForPrinting();
    }
}

