/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import sun.awt.windows.WToolkit;

public class ThemeReader {
    private static volatile boolean isLoaded = false;
    private static final String textResourcesKey = "win.xpstyle.resources.strings";
    private static Map textResources;
    private static final String imageResourcesKey = "win.xpstyle.resources.images";
    private static Map imageResources;
    private static final String dllNameKey = "win.xpstyle.dllName";
    private static final String sizeNameKey = "win.xpstyle.sizeName";
    private static final String colorNameKey = "win.xpstyle.colorName";
    private static StyleChangeListener styleChangeListener;

    private static native int[] getBitmapResource(String var0, String var1);

    private static native String getTextResourceByName(String var0, String var1, String var2);

    private static native String getTextResourceByInt(String var0, int var1, String var2);

    static Map loadResources(String string) {
        if (!isLoaded) {
            ThemeReader.loadResources();
        }
        if (string.equals(textResourcesKey)) {
            return textResources;
        }
        if (string.equals(imageResourcesKey)) {
            return imageResources;
        }
        return null;
    }

    static boolean isXPThemeResources(String string) {
        return string.equals(textResourcesKey) || string.equals(imageResourcesKey);
    }

    private static void loadResources() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        String string = (String)toolkit.getDesktopProperty(dllNameKey);
        String string2 = (String)toolkit.getDesktopProperty(sizeNameKey);
        String string3 = (String)toolkit.getDesktopProperty(colorNameKey);
        if (string != null && string2 != null && string3 != null) {
            textResources = new TextResources(string, string2, string3);
            imageResources = new ImageResources(string);
            isLoaded = true;
            if (styleChangeListener == null) {
                styleChangeListener = new StyleChangeListener();
                toolkit.addPropertyChangeListener(dllNameKey, styleChangeListener);
                toolkit.addPropertyChangeListener(colorNameKey, styleChangeListener);
                toolkit.addPropertyChangeListener(sizeNameKey, styleChangeListener);
            }
        }
    }

    static {
        styleChangeListener = null;
    }

    private static class ImageResources
    implements Map {
        String styleFile;

        ImageResources(String string) {
            this.styleFile = string;
        }

        public synchronized Object get(Object object) {
            int n;
            StringBuffer stringBuffer = new StringBuffer((String)object);
            for (int i = 0; i < stringBuffer.length(); ++i) {
                n = stringBuffer.charAt(i);
                if (n != 92 && n != 46) continue;
                stringBuffer.setCharAt(i, '_');
            }
            int[] nArray = ThemeReader.getBitmapResource(this.styleFile, stringBuffer.toString().toUpperCase(Locale.ENGLISH));
            if (nArray == null) {
                return null;
            }
            n = nArray[0];
            int n2 = (nArray.length - 2) / n;
            int n3 = nArray[1];
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, n3);
            bufferedImage.setRGB(0, 0, n, n2, nArray, 2, n);
            return bufferedImage;
        }

        public void clear() {
            throw new UnsupportedOperationException("ReadOnly Map");
        }

        public boolean containsKey(Object object) {
            throw new UnsupportedOperationException("ReadOnly Map");
        }

        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException("Only get(Object key) is supported");
        }

        public Set entrySet() {
            throw new UnsupportedOperationException("Only get(Object key) is supported");
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException("Only get(Object key) is supported");
        }

        public Set keySet() {
            throw new UnsupportedOperationException("Only get(Object key) is supported");
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException("ReadOnly Map");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("ReadOnly Map");
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException("ReadOnly Map");
        }

        public int size() {
            throw new UnsupportedOperationException("Only get(Object key) is supported");
        }

        public Collection values() {
            throw new UnsupportedOperationException("Only get(Object key) is supported");
        }
    }

    private static class TextResources
    extends HashMap {
        private static final int EXPECT_KEY = 0;
        private static final int EXPECT_CATEGORY = 1;
        private static final int EXPECT_VALUE = 2;

        TextResources(String string, String string2, String string3) {
            String string4 = null;
            String[] stringArray = this.splitTextResource(ThemeReader.getTextResourceByInt(string, 1, "SIZENAMES"));
            String[] stringArray2 = this.splitTextResource(ThemeReader.getTextResourceByInt(string, 1, "COLORNAMES"));
            String[] stringArray3 = this.splitTextResource(ThemeReader.getTextResourceByInt(string, 1, "FILERESNAMES"));
            block0: for (int i = 0; i < stringArray2.length; ++i) {
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!string2.equals(stringArray[j]) || !string3.equals(stringArray2[i]) || i * stringArray.length + j >= stringArray3.length) continue;
                    string4 = stringArray3[i * stringArray.length + j];
                    break block0;
                }
            }
            if (string4 != null) {
                super.put("themeFile", string4);
                String string5 = ThemeReader.getTextResourceByName(string, string4, "TEXTFILE");
                if (string5 != null) {
                    this.parse(string5);
                }
            }
        }

        public synchronized Object get(Object object) {
            return super.get(object);
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException("ReadOnly Map");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("ReadOnly Map");
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException("ReadOnly Map");
        }

        public void clear() {
            throw new UnsupportedOperationException("ReadOnly Map");
        }

        private void parse(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "", true);
            String string2 = "";
            String string3 = "";
            int n = 0;
            boolean bl = false;
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken("\r\n[];=").trim();
                    if (string4.length() == 0) continue;
                    block1 : switch (string4.charAt(0)) {
                        case '[': {
                            n = 1;
                            string2 = "";
                            break;
                        }
                        case ';': 
                        case ']': {
                            bl = true;
                            break;
                        }
                        case '=': {
                            if (string3.length() > 0) {
                                n = 2;
                                break;
                            }
                            bl = true;
                            break;
                        }
                        default: {
                            switch (n) {
                                case 0: {
                                    string3 = string4.toLowerCase(Locale.ENGLISH);
                                    break block1;
                                }
                                case 1: {
                                    string2 = string4.toLowerCase(Locale.ENGLISH) + ".";
                                    bl = true;
                                    break block1;
                                }
                                case 2: {
                                    String string5 = string4;
                                    super.put(string2 + string3, string5);
                                    bl = true;
                                }
                            }
                        }
                    }
                    if (!bl) continue;
                    bl = false;
                    n = 0;
                    string3 = "";
                    stringTokenizer.nextToken("\r\n");
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }

        private String[] splitTextResource(String string) {
            if (string == null) {
                return new String[0];
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            return stringArray;
        }
    }

    private static class StyleChangeListener
    implements PropertyChangeListener {
        private StyleChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WToolkit wToolkit;
            WToolkit wToolkit2 = wToolkit = (WToolkit)Toolkit.getDefaultToolkit();
            synchronized (wToolkit2) {
                wToolkit.clearDesktopProperty(ThemeReader.textResourcesKey);
                wToolkit.clearDesktopProperty(ThemeReader.imageResourcesKey);
                textResources = null;
                imageResources = null;
                isLoaded = false;
            }
        }
    }
}

