/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sun.awt.shell.DefaultShellFolder;
import sun.awt.shell.ShellFolder;

class ShellFolderManager {
    private Comparator fileComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return this.compare((File)object, (File)object2);
        }

        public int compare(File file, File file2) {
            ShellFolder shellFolder = null;
            ShellFolder shellFolder2 = null;
            if (file instanceof ShellFolder && (shellFolder = (ShellFolder)file).isFileSystem()) {
                shellFolder = null;
            }
            if (file2 instanceof ShellFolder && (shellFolder2 = (ShellFolder)file2).isFileSystem()) {
                shellFolder2 = null;
            }
            if (shellFolder != null && shellFolder2 != null) {
                return shellFolder.compareTo(shellFolder2);
            }
            if (shellFolder != null) {
                return -1;
            }
            if (shellFolder2 != null) {
                return 1;
            }
            String string = file.getName();
            String string2 = file2.getName();
            int n = string.toLowerCase().compareTo(string2.toLowerCase());
            if (n != 0) {
                return n;
            }
            return string.compareTo(string2);
        }
    };

    ShellFolderManager() {
    }

    public ShellFolder createShellFolder(File file) throws FileNotFoundException {
        return new DefaultShellFolder(null, file);
    }

    public Object get(String string) {
        if (string.equals("fileChooserDefaultFolder")) {
            File file = new File(System.getProperty("user.home"));
            try {
                return this.createShellFolder(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return file;
            }
        }
        if (string.equals("roots")) {
            return File.listRoots();
        }
        if (string.equals("fileChooserComboBoxFolders")) {
            return this.get("roots");
        }
        if (string.equals("fileChooserShortcutPanelFolders")) {
            return new File[]{(File)this.get("fileChooserDefaultFolder")};
        }
        return null;
    }

    public boolean isComputerNode(File file) {
        return false;
    }

    public boolean isFileSystemRoot(File file) {
        if (file instanceof ShellFolder && !((ShellFolder)file).isFileSystem()) {
            return false;
        }
        return file.getParentFile() == null;
    }

    public void sortFiles(List list) {
        Collections.sort(list, this.fileComparator);
    }
}

