/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.SurfaceManager;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;

public abstract class VolatileSurfaceManager
extends SurfaceManager {
    protected SunVolatileImage vImg;
    protected SurfaceData sdAccel;
    protected SurfaceData sdBackup;
    protected SurfaceData sdCurrent;
    protected SurfaceData sdPrevious;
    protected boolean lostSurface;
    protected Object context;

    protected VolatileSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
        this.vImg = sunVolatileImage;
        this.context = object;
    }

    public void initialize() {
        if (this.isAccelerationEnabled()) {
            this.sdAccel = this.initAcceleratedSurface();
            if (this.sdAccel != null) {
                this.sdCurrent = this.sdAccel;
            }
        }
        if (this.sdCurrent == null) {
            this.sdCurrent = this.getBackupSurface();
        }
    }

    public SurfaceData getSourceSurfaceData(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl) {
        return this.sdCurrent;
    }

    public SurfaceData getDestSurfaceData() {
        return this.sdCurrent;
    }

    protected abstract boolean isAccelerationEnabled();

    public int validate(GraphicsConfiguration graphicsConfiguration) {
        int n = 0;
        boolean bl = this.lostSurface;
        this.lostSurface = false;
        if (this.isAccelerationEnabled()) {
            if (!this.isConfigValid(graphicsConfiguration)) {
                n = 2;
            } else if (this.sdAccel == null) {
                this.sdAccel = this.initAcceleratedSurface();
                if (this.sdAccel != null) {
                    this.sdCurrent = this.sdAccel;
                    this.sdBackup = null;
                    n = 1;
                } else {
                    this.sdCurrent = this.getBackupSurface();
                }
            } else if (this.sdAccel.isSurfaceLost()) {
                try {
                    this.restoreAcceleratedSurface();
                    this.sdCurrent = this.sdAccel;
                    this.sdAccel.setSurfaceLost(false);
                    this.sdBackup = null;
                    n = 1;
                }
                catch (InvalidPipeException invalidPipeException) {
                    this.sdCurrent = this.getBackupSurface();
                }
            } else if (bl) {
                n = 1;
            }
            if (n != 2 && this.sdCurrent != this.sdPrevious) {
                this.sdPrevious = this.sdCurrent;
                n = 1;
            }
            if (n == 1) {
                this.initContents();
            }
        }
        return n;
    }

    public boolean contentsLost() {
        return this.lostSurface;
    }

    protected abstract SurfaceData initAcceleratedSurface();

    protected SurfaceData getBackupSurface() {
        if (this.sdBackup == null) {
            BufferedImage bufferedImage = this.vImg.getBackupImage();
            this.sdBackup = BufImgSurfaceData.createData(bufferedImage);
        }
        return this.sdBackup;
    }

    public void initContents() {
        Graphics2D graphics2D = this.vImg.createGraphics();
        graphics2D.clearRect(0, 0, this.vImg.getWidth(), this.vImg.getHeight());
        graphics2D.dispose();
    }

    public SurfaceData restoreContents() {
        return this.getBackupSurface();
    }

    public void acceleratedSurfaceLost() {
        if (this.isAccelerationEnabled()) {
            this.lostSurface = true;
        }
    }

    protected void restoreAcceleratedSurface() {
    }

    protected boolean isConfigValid(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration == null || graphicsConfiguration.getDevice() == this.vImg.getGraphicsConfig().getDevice();
    }

    public ImageCapabilities getCapabilities() {
        if (this.imageCaps == null) {
            this.imageCaps = new DefaultImageCapabilities();
        }
        return this.imageCaps;
    }

    protected class DefaultImageCapabilities
    extends ImageCapabilities {
        public DefaultImageCapabilities() {
            super(false);
        }

        public boolean isAccelerated() {
            return VolatileSurfaceManager.this.sdCurrent == VolatileSurfaceManager.this.sdAccel;
        }
    }
}

