/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.ColorModel;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Vector;
import sun.awt.DisplayChangedListener;
import sun.awt.SunDisplayChanger;
import sun.awt.Win32GraphicsConfig;
import sun.awt.WindowsFlags;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WWindowPeer;
import sun.java2d.opengl.WGLGraphicsConfig;
import sun.security.action.GetPropertyAction;

public class Win32GraphicsDevice
extends GraphicsDevice
implements DisplayChangedListener {
    int screen;
    ColorModel dynamicColorModel;
    ColorModel colorModel;
    GraphicsConfiguration[] configs;
    GraphicsConfiguration defaultConfig;
    boolean offscreenAccelerationEnabled = true;
    private SunDisplayChanger topLevels = new SunDisplayChanger();
    private static boolean pfDisabled;
    private static AWTPermission fullScreenExclusivePermission;
    private Rectangle ownerWindowedModeBounds = null;

    private static native void initIDs();

    public boolean isOffscreenAccelerationEnabled() {
        return this.offscreenAccelerationEnabled;
    }

    native void initDevice(int var1);

    public Win32GraphicsDevice(int n) {
        this.screen = n;
        this.initDevice(n);
    }

    public int getType() {
        return 0;
    }

    public int getScreen() {
        return this.screen;
    }

    public String getIDstring() {
        return "\\Display" + this.screen;
    }

    public GraphicsConfiguration[] getConfigurations() {
        if (this.configs == null) {
            if (WindowsFlags.isOGLEnabled() && this.isDefaultDevice()) {
                this.defaultConfig = this.getDefaultConfiguration();
                if (this.defaultConfig != null) {
                    this.configs = new GraphicsConfiguration[1];
                    this.configs[0] = this.defaultConfig;
                    return (GraphicsConfiguration[])this.configs.clone();
                }
            }
            int n = this.getMaxConfigs(this.screen);
            int n2 = this.getDefaultPixID(this.screen);
            Vector<GraphicsConfiguration> vector = new Vector<GraphicsConfiguration>(n);
            if (n2 == 0) {
                this.defaultConfig = Win32GraphicsConfig.getConfig(this, n2);
                vector.addElement(this.defaultConfig);
            } else {
                for (int i = 1; i <= n; ++i) {
                    if (!this.isPixFmtSupported(i, this.screen)) continue;
                    if (i == n2) {
                        this.defaultConfig = Win32GraphicsConfig.getConfig(this, i);
                        vector.addElement(this.defaultConfig);
                        continue;
                    }
                    vector.addElement(Win32GraphicsConfig.getConfig(this, i));
                }
            }
            this.configs = new GraphicsConfiguration[vector.size()];
            vector.copyInto(this.configs);
        }
        return (GraphicsConfiguration[])this.configs.clone();
    }

    protected int getMaxConfigs(int n) {
        if (pfDisabled) {
            return 1;
        }
        return this.getMaxConfigsImpl(n);
    }

    private native int getMaxConfigsImpl(int var1);

    protected native boolean isPixFmtSupported(int var1, int var2);

    protected int getDefaultPixID(int n) {
        if (pfDisabled) {
            return 0;
        }
        return this.getDefaultPixIDImpl(n);
    }

    private native int getDefaultPixIDImpl(int var1);

    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            if (WindowsFlags.isOGLEnabled() && this.isDefaultDevice()) {
                int n = WGLGraphicsConfig.getDefaultPixFmt(this.screen);
                this.defaultConfig = WGLGraphicsConfig.getConfig(this, n);
                if (WindowsFlags.isOGLVerbose()) {
                    if (this.defaultConfig != null) {
                        System.out.print("OpenGL pipeline enabled");
                    } else {
                        System.out.print("Could not enable OpenGL pipeline");
                    }
                    System.out.println(" for default config on screen " + this.screen);
                }
            }
            if (this.defaultConfig == null) {
                this.defaultConfig = Win32GraphicsConfig.getConfig(this, 0);
            }
        }
        return this.defaultConfig;
    }

    public String toString() {
        return "Win32GraphicsDevice[screen=" + this.screen + "]";
    }

    private boolean isDefaultDevice() {
        return this == GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    private native boolean isDDEnabledOnDeviceNative(int var1);

    public boolean isDDEnabledOnDevice() {
        return WindowsFlags.isDDEnabled() && this.isDDEnabledOnDeviceNative(this.screen);
    }

    private native boolean isD3DEnabledOnDeviceNative(int var1);

    public boolean isD3DEnabledOnDevice() {
        return WindowsFlags.isD3DEnabled() && this.isD3DEnabledOnDeviceNative(this.screen);
    }

    public boolean isFullScreenSupported() {
        return this.screen == 0 || this.isDDEnabledOnDevice();
    }

    private Frame getToplevelOwner(Window window) {
        Window window2 = window;
        while (window2 != null) {
            if (!((window2 = window2.getOwner()) instanceof Frame)) continue;
            return (Frame)window2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFullScreenWindow(Window window) {
        Object object;
        Object object2;
        Window window2 = this.getFullScreenWindow();
        if (window == window2) {
            return;
        }
        boolean bl = this.isDDEnabledOnDevice();
        if (bl && window2 != null) {
            object2 = (WWindowPeer)window2.getPeer();
            if (object2 != null) {
                object = object2;
                synchronized (object) {
                    ((WComponentPeer)object2).destroyBuffers();
                    this.exitFullScreenExclusive(this.screen, (WindowPeer)object2);
                }
            }
            if (!(window2 instanceof Frame)) {
                object = this.getToplevelOwner(window2);
                if (object != null && this.ownerWindowedModeBounds != null) {
                    ((Component)object).setBounds(this.ownerWindowedModeBounds);
                }
                this.ownerWindowedModeBounds = null;
            }
        }
        super.setFullScreenWindow(window);
        if (bl && window != null) {
            if (!(window instanceof Frame) && (object2 = this.getToplevelOwner(window)) != null) {
                this.ownerWindowedModeBounds = ((Component)object2).getBounds();
                ((Component)object2).setBounds(window.getBounds());
            }
            if ((object2 = System.getSecurityManager()) != null) {
                if (fullScreenExclusivePermission == null) {
                    fullScreenExclusivePermission = new AWTPermission("fullScreenExclusive");
                }
                ((SecurityManager)object2).checkPermission(fullScreenExclusivePermission);
            }
            Object object3 = object = (WWindowPeer)window.getPeer();
            synchronized (object3) {
                this.enterFullScreenExclusive(this.screen, (WindowPeer)object);
            }
        }
    }

    private native void enterFullScreenExclusive(int var1, WindowPeer var2);

    private native void exitFullScreenExclusive(int var1, WindowPeer var2);

    public boolean isDisplayChangeSupported() {
        return this.isFullScreenSupported() && this.getFullScreenWindow() != null;
    }

    public synchronized void setDisplayMode(DisplayMode displayMode) {
        if (!this.isDisplayChangeSupported()) {
            super.setDisplayMode(displayMode);
            return;
        }
        if (displayMode == null || !this.isDisplayModeAvailable(displayMode)) {
            throw new IllegalArgumentException("Invalid display mode");
        }
        Window window = this.getFullScreenWindow();
        if (window == null) {
            throw new IllegalStateException("Must be in fullscreen mode in order to set display mode");
        }
        WWindowPeer wWindowPeer = (WWindowPeer)window.getPeer();
        this.configDisplayMode(this.screen, wWindowPeer, displayMode.getWidth(), displayMode.getHeight(), displayMode.getBitDepth(), displayMode.getRefreshRate());
    }

    private native DisplayMode getCurrentDisplayMode(int var1);

    private native void configDisplayMode(int var1, WindowPeer var2, int var3, int var4, int var5, int var6);

    private native void enumDisplayModes(int var1, ArrayList var2);

    private native boolean isDisplayModeAvailable(int var1, int var2, int var3, int var4, int var5);

    public synchronized DisplayMode getDisplayMode() {
        DisplayMode displayMode = this.getCurrentDisplayMode(this.screen);
        return displayMode;
    }

    public synchronized DisplayMode[] getDisplayModes() {
        ArrayList arrayList = new ArrayList();
        this.enumDisplayModes(this.screen, arrayList);
        int n = arrayList.size();
        DisplayMode[] displayModeArray = new DisplayMode[n];
        for (int i = 0; i < n; ++i) {
            displayModeArray[i] = (DisplayMode)arrayList.get(i);
        }
        return displayModeArray;
    }

    public synchronized boolean isDisplayModeAvailable(DisplayMode displayMode) {
        if (!this.isDisplayChangeSupported()) {
            return false;
        }
        if (this.isDDEnabledOnDevice()) {
            return this.isDisplayModeAvailable(this.screen, displayMode.getWidth(), displayMode.getHeight(), displayMode.getBitDepth(), displayMode.getRefreshRate());
        }
        DisplayMode[] displayModeArray = this.getDisplayModes();
        for (int i = 0; i < displayModeArray.length; ++i) {
            if (!displayMode.equals(displayModeArray[i])) continue;
            return true;
        }
        return false;
    }

    public void displayChanged() {
        this.dynamicColorModel = null;
        this.defaultConfig = null;
        this.configs = null;
        this.topLevels.notifyListeners();
    }

    public void paletteChanged() {
    }

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.remove(displayChangedListener);
    }

    private native ColorModel makeColorModel(int var1, boolean var2);

    public ColorModel getDynamicColorModel() {
        if (this.dynamicColorModel == null) {
            this.dynamicColorModel = this.makeColorModel(this.screen, true);
        }
        return this.dynamicColorModel;
    }

    public ColorModel getColorModel() {
        if (this.colorModel == null) {
            this.colorModel = this.makeColorModel(this.screen, false);
        }
        return this.colorModel;
    }

    private native int getDeviceMemoryNative(int var1);

    public int getAvailableAcceleratedMemory() {
        return this.getDeviceMemoryNative(this.screen);
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.awt.nopixfmt"));
        pfDisabled = string != null;
        Win32GraphicsDevice.initIDs();
    }
}

