/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.DisplayChangedListener;
import sun.awt.Win32GraphicsDevice;
import sun.awt.WindowsFlags;
import sun.awt.image.OffScreenImage;
import sun.awt.image.SunVolatileImage;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.Win32SurfaceData;
import sun.awt.windows.WinBackBuffer;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;

public class Win32GraphicsConfig
extends GraphicsConfiguration
implements DisplayChangedListener {
    protected Win32GraphicsDevice screen;
    protected int visual;
    protected RenderLoops solidloops;
    private static BufferCapabilities bufferCaps;
    private static ImageCapabilities imageCaps;
    private SurfaceType sTypeOrig = null;
    private static final int DCM_4444_RED_MASK = 3840;
    private static final int DCM_4444_GRN_MASK = 240;
    private static final int DCM_4444_BLU_MASK = 15;
    private static final int DCM_4444_ALP_MASK = 61440;
    static ColorModel translucentCM;

    private static native void initIDs();

    public static Win32GraphicsConfig getConfig(Win32GraphicsDevice win32GraphicsDevice, int n) {
        return new Win32GraphicsConfig(win32GraphicsDevice, n);
    }

    @Deprecated
    public Win32GraphicsConfig(GraphicsDevice graphicsDevice, int n) {
        this.screen = (Win32GraphicsDevice)graphicsDevice;
        this.visual = n;
        ((Win32GraphicsDevice)graphicsDevice).addDisplayChangedListener(this);
    }

    public GraphicsDevice getDevice() {
        return this.screen;
    }

    public int getVisual() {
        return this.visual;
    }

    public synchronized RenderLoops getSolidLoops(SurfaceType surfaceType) {
        if (this.solidloops == null || this.sTypeOrig != surfaceType) {
            this.solidloops = SurfaceData.makeRenderLoops(SurfaceType.OpaqueColor, CompositeType.SrcNoEa, surfaceType);
            this.sTypeOrig = surfaceType;
        }
        return this.solidloops;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        ColorModel colorModel = this.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2) {
        return new SunVolatileImage(this, n, n2);
    }

    public VolatileImage createCompatibleVolatileImage(int n, int n2, int n3) {
        return new SunVolatileImage(this, n, n2, n3);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                return this.createCompatibleImage(n, n2);
            }
            case 2: 
            case 3: {
                ColorModel colorModel = this.getColorModel(n3);
                WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
                return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            }
        }
        throw new IllegalArgumentException("Unknown transparency type " + n3);
    }

    public synchronized ColorModel getColorModel() {
        return this.screen.getColorModel();
    }

    public ColorModel getDeviceColorModel() {
        return this.screen.getDynamicColorModel();
    }

    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return this.getColorModel();
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                return Win32GraphicsConfig.getTranslucentColorModel();
            }
        }
        return null;
    }

    public static ColorModel getTranslucentColorModel() {
        if (WindowsFlags.getD3DTexBpp() == 16) {
            if (translucentCM == null) {
                translucentCM = new DirectColorModel(16, 3840, 240, 15, 61440);
            }
            return translucentCM;
        }
        return ColorModel.getRGBdefault();
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        double d = this.getXResolution() / 72.0;
        double d2 = this.getYResolution() / 72.0;
        return new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
    }

    private double getXResolution() {
        return 72.0;
    }

    private double getYResolution() {
        return 72.0;
    }

    public String toString() {
        return super.toString() + "[dev=" + this.screen + ",pixfmt=" + this.visual + "]";
    }

    private native Rectangle getBounds(int var1);

    public Rectangle getBounds() {
        return this.getBounds(this.screen.getScreen());
    }

    public BufferCapabilities getBufferCapabilities() {
        if (bufferCaps == null) {
            bufferCaps = WindowsFlags.isDDEnabled() ? new DDrawBufferCapabilities(this.getImageCapabilities()) : super.getBufferCapabilities();
        }
        return bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        if (imageCaps == null) {
            imageCaps = WindowsFlags.isDDEnabled() ? new DDrawImageCapabilities() : super.getImageCapabilities();
        }
        return imageCaps;
    }

    public synchronized void displayChanged() {
        this.solidloops = null;
    }

    public void paletteChanged() {
    }

    public SurfaceData createSurfaceData(WComponentPeer wComponentPeer, int n) {
        return Win32SurfaceData.createData(wComponentPeer, n);
    }

    public Image createAcceleratedImage(Component component, int n, int n2) {
        ColorModel colorModel = this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new OffScreenImage(component, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    private boolean isFullScreenExclusive(Component component) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)this.getDevice();
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return component == win32GraphicsDevice.getFullScreenWindow() && win32GraphicsDevice.isDDEnabledOnDevice();
    }

    public void assertOperationSupported(Component component, int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (!this.isFullScreenExclusive(component)) {
            throw new AWTException("The operation requested is only supported on a full-screen exclusive window");
        }
    }

    public VolatileImage createBackBuffer(WComponentPeer wComponentPeer) {
        return new WinBackBuffer((Component)wComponentPeer.getTarget(), (Win32SurfaceData)wComponentPeer.getSurfaceData());
    }

    public void flip(WComponentPeer wComponentPeer, Component component, VolatileImage volatileImage, BufferCapabilities.FlipContents flipContents) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            Graphics graphics = component.getGraphics();
            graphics.drawImage(volatileImage, 0, 0, n, n2, component);
            graphics.dispose();
        } else {
            Object object;
            try {
                object = (Win32SurfaceData)wComponentPeer.getSurfaceData();
                WinBackBuffer winBackBuffer = (WinBackBuffer)volatileImage;
                ((Win32SurfaceData)object).flip(winBackBuffer.getHWSurfaceData());
            }
            catch (InvalidPipeException invalidPipeException) {
                return;
            }
            if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
                object = volatileImage.getGraphics();
                ((Graphics)object).setColor(component.getBackground());
                ((Graphics)object).fillRect(0, 0, n, n2);
                ((Graphics)object).dispose();
            }
        }
    }

    static {
        Win32GraphicsConfig.initIDs();
        translucentCM = null;
    }

    private static class DDrawImageCapabilities
    extends ImageCapabilities {
        public DDrawImageCapabilities() {
            super(true);
        }

        public boolean isTrueVolatile() {
            return true;
        }
    }

    private static class DDrawBufferCapabilities
    extends BufferCapabilities {
        public DDrawBufferCapabilities(ImageCapabilities imageCapabilities) {
            super(imageCapabilities, imageCapabilities, BufferCapabilities.FlipContents.PRIOR);
        }

        public boolean isFullScreenRequired() {
            return true;
        }

        public boolean isMultiBufferAvailable() {
            return true;
        }
    }
}

