/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.View;

public class Utilities {
    static JComponent getJComponent(View view) {
        Container container;
        if (view != null && (container = view.getContainer()) instanceof JComponent) {
            return (JComponent)container;
        }
        return null;
    }

    public static final int drawTabbedText(Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3) {
        return Utilities.drawTabbedText(null, segment, n, n2, graphics, tabExpander, n3);
    }

    static final int drawTabbedText(View view, Segment segment, int n, int n2, Graphics graphics, TabExpander tabExpander, int n3) {
        JComponent jComponent = Utilities.getJComponent(view);
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics);
        int n4 = n;
        char[] cArray = segment.array;
        int n5 = segment.offset;
        int n6 = 0;
        int n7 = segment.offset;
        int n8 = segment.offset + segment.count;
        for (int i = n5; i < n8; ++i) {
            if (cArray[i] == '\t') {
                if (n6 > 0) {
                    n4 = SwingUtilities2.drawChars(jComponent, graphics, cArray, n7, n6, n, n2);
                    n6 = 0;
                }
                n7 = i + 1;
                n4 = tabExpander != null ? (int)tabExpander.nextTabStop(n4, n3 + i - n5) : (n4 += fontMetrics.charWidth(' '));
                n = n4;
                continue;
            }
            if (cArray[i] == '\n' || cArray[i] == '\r') {
                if (n6 > 0) {
                    n4 = SwingUtilities2.drawChars(jComponent, graphics, cArray, n7, n6, n, n2);
                    n6 = 0;
                }
                n7 = i + 1;
                n = n4;
                continue;
            }
            ++n6;
        }
        if (n6 > 0) {
            n4 = SwingUtilities2.drawChars(jComponent, graphics, cArray, n7, n6, n, n2);
        }
        return n4;
    }

    public static final int getTabbedTextWidth(Segment segment, FontMetrics fontMetrics, int n, TabExpander tabExpander, int n2) {
        int n3 = n;
        char[] cArray = segment.array;
        int n4 = segment.offset;
        int n5 = segment.offset + segment.count;
        int n6 = 0;
        for (int i = n4; i < n5; ++i) {
            if (cArray[i] == '\t') {
                n3 += fontMetrics.charsWidth(cArray, i - n6, n6);
                n6 = 0;
                if (tabExpander != null) {
                    n3 = (int)tabExpander.nextTabStop(n3, n2 + i - n4);
                    continue;
                }
                n3 += fontMetrics.charWidth(' ');
                continue;
            }
            if (cArray[i] == '\n') {
                n3 += fontMetrics.charsWidth(cArray, i - n6, n6);
                n6 = 0;
                continue;
            }
            ++n6;
        }
        return (n3 += fontMetrics.charsWidth(cArray, n5 - n6, n6)) - n;
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        return Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3, true);
    }

    public static final int getTabbedTextOffset(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3, boolean bl) {
        int n4;
        if (n >= n2) {
            return 0;
        }
        int n5 = n4 = n;
        char[] cArray = segment.array;
        int n6 = segment.offset;
        int n7 = segment.count;
        int n8 = segment.offset + segment.count;
        for (int i = segment.offset; i < n8; ++i) {
            n5 = cArray[i] == '\t' ? (tabExpander != null ? (int)tabExpander.nextTabStop(n5, n3 + i - n6) : (n5 += fontMetrics.charWidth(' '))) : (n5 += fontMetrics.charWidth(cArray[i]));
            if (n2 >= n4 && n2 < n5) {
                if (!bl || n2 - n4 < n5 - n2) {
                    return i - n6;
                }
                return i + 1 - n6;
            }
            n4 = n5;
        }
        return n7;
    }

    public static final int getBreakLocation(Segment segment, FontMetrics fontMetrics, int n, int n2, TabExpander tabExpander, int n3) {
        char[] cArray = segment.array;
        int n4 = segment.offset;
        int n5 = segment.count;
        int n6 = Utilities.getTabbedTextOffset(segment, fontMetrics, n, n2, tabExpander, n3, false);
        if (n6 >= n5 - 1) {
            return n5;
        }
        for (int i = n4 + n6; i >= n4; --i) {
            char c = cArray[i];
            if (c < '\u0100') {
                if (!Character.isWhitespace(c)) continue;
                n6 = i - n4 + 1;
                break;
            }
            BreakIterator breakIterator = BreakIterator.getLineInstance();
            breakIterator.setText(segment);
            int n7 = breakIterator.preceding(i + 1);
            if (n7 <= n4) break;
            n6 = n7 - n4;
            break;
        }
        return n6;
    }

    public static final int getRowStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        Rectangle rectangle = jTextComponent.modelToView(n);
        if (rectangle == null) {
            return -1;
        }
        int n2 = n;
        int n3 = rectangle.y;
        while (rectangle != null && n3 == rectangle.y) {
            n = n2--;
            rectangle = n2 >= 0 ? jTextComponent.modelToView(n2) : null;
        }
        return n;
    }

    public static final int getRowEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        Rectangle rectangle = jTextComponent.modelToView(n);
        if (rectangle == null) {
            return -1;
        }
        int n2 = jTextComponent.getDocument().getLength();
        int n3 = n;
        int n4 = rectangle.y;
        while (rectangle != null && n4 == rectangle.y) {
            n = n3++;
            rectangle = n3 <= n2 ? jTextComponent.modelToView(n3) : null;
        }
        return n;
    }

    public static final int getPositionAbove(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        int n3 = Utilities.getRowStart(jTextComponent, n) - 1;
        if (n3 < 0) {
            return -1;
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        Rectangle rectangle = null;
        if (n3 >= 0) {
            rectangle = jTextComponent.modelToView(n3);
            n5 = rectangle.y;
        }
        while (rectangle != null && n5 == rectangle.y) {
            int n6 = Math.abs(rectangle.x - n2);
            if (n6 < n4) {
                n = n3;
                n4 = n6;
            }
            rectangle = --n3 >= 0 ? jTextComponent.modelToView(n3) : null;
        }
        return n;
    }

    public static final int getPositionBelow(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        int n3 = Utilities.getRowEnd(jTextComponent, n) + 1;
        if (n3 <= 0) {
            return -1;
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = jTextComponent.getDocument().getLength();
        int n6 = 0;
        Rectangle rectangle = null;
        if (n3 <= n5) {
            rectangle = jTextComponent.modelToView(n3);
            n6 = rectangle.y;
        }
        while (rectangle != null && n6 == rectangle.y) {
            int n7 = Math.abs(n2 - rectangle.x);
            if (n7 < n4) {
                n = n3;
                n4 = n7;
            }
            rectangle = ++n3 <= n5 ? jTextComponent.modelToView(n3) : null;
        }
        return n;
    }

    public static final int getWordStart(JTextComponent jTextComponent, int n) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        Element element = Utilities.getParagraphElement(jTextComponent, n);
        if (element == null) {
            throw new BadLocationException("No word at " + n, n);
        }
        int n2 = element.getStartOffset();
        int n3 = Math.min(element.getEndOffset(), document.getLength());
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n2, n3 - n2, segment);
        if (segment.count > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
            breakIterator.setText(segment);
            int n4 = segment.offset + n - n2;
            if (n4 >= breakIterator.last()) {
                n4 = breakIterator.last() - 1;
            }
            breakIterator.following(n4);
            n = n2 + breakIterator.previous() - segment.offset;
        }
        SegmentCache.releaseSharedSegment(segment);
        return n;
    }

    public static final int getWordEnd(JTextComponent jTextComponent, int n) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        Element element = Utilities.getParagraphElement(jTextComponent, n);
        if (element == null) {
            throw new BadLocationException("No word at " + n, n);
        }
        int n2 = element.getStartOffset();
        int n3 = Math.min(element.getEndOffset(), document.getLength());
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n2, n3 - n2, segment);
        if (segment.count > 0) {
            BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
            breakIterator.setText(segment);
            int n4 = n - n2 + segment.offset;
            if (n4 >= breakIterator.last()) {
                n4 = breakIterator.last() - 1;
            }
            n = n2 + breakIterator.following(n4) - segment.offset;
        }
        SegmentCache.releaseSharedSegment(segment);
        return n;
    }

    public static final int getNextWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        Element element = Utilities.getParagraphElement(jTextComponent, n);
        int n2 = Utilities.getNextWordInParagraph(jTextComponent, element, n, false);
        while (n2 == -1) {
            n = element.getEndOffset();
            element = Utilities.getParagraphElement(jTextComponent, n);
            n2 = Utilities.getNextWordInParagraph(jTextComponent, element, n, true);
        }
        return n2;
    }

    static int getNextWordInParagraph(JTextComponent jTextComponent, Element element, int n, boolean bl) throws BadLocationException {
        if (element == null) {
            throw new BadLocationException("No more words", n);
        }
        Document document = element.getDocument();
        int n2 = element.getStartOffset();
        int n3 = Math.min(element.getEndOffset(), document.getLength());
        if (n >= n3 || n < n2) {
            throw new BadLocationException("No more words", n);
        }
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n2, n3 - n2, segment);
        BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
        breakIterator.setText(segment);
        if (bl && breakIterator.first() == segment.offset + n - n2 && !Character.isWhitespace(segment.array[breakIterator.first()])) {
            return n;
        }
        int n4 = breakIterator.following(segment.offset + n - n2);
        if (n4 == -1 || n4 >= segment.offset + segment.count) {
            return -1;
        }
        char c = segment.array[n4];
        if (!Character.isWhitespace(c)) {
            return n2 + n4 - segment.offset;
        }
        n4 = breakIterator.next();
        if (n4 != -1 && (n = n2 + n4 - segment.offset) != n3) {
            return n;
        }
        SegmentCache.releaseSharedSegment(segment);
        return -1;
    }

    public static final int getPreviousWord(JTextComponent jTextComponent, int n) throws BadLocationException {
        Element element = Utilities.getParagraphElement(jTextComponent, n);
        int n2 = Utilities.getPrevWordInParagraph(jTextComponent, element, n);
        while (n2 == -1) {
            n = element.getStartOffset() - 1;
            element = Utilities.getParagraphElement(jTextComponent, n);
            n2 = Utilities.getPrevWordInParagraph(jTextComponent, element, n);
        }
        return n2;
    }

    static int getPrevWordInParagraph(JTextComponent jTextComponent, Element element, int n) throws BadLocationException {
        int n2;
        if (element == null) {
            throw new BadLocationException("No more words", n);
        }
        Document document = element.getDocument();
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        if (n > n4 || n < n3) {
            throw new BadLocationException("No more words", n);
        }
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n3, n4 - n3, segment);
        BreakIterator breakIterator = BreakIterator.getWordInstance(jTextComponent.getLocale());
        breakIterator.setText(segment);
        if (breakIterator.following(segment.offset + n - n3) == -1) {
            breakIterator.last();
        }
        if ((n2 = breakIterator.previous()) == segment.offset + n - n3) {
            n2 = breakIterator.previous();
        }
        if (n2 == -1) {
            return -1;
        }
        char c = segment.array[n2];
        if (!Character.isWhitespace(c)) {
            return n3 + n2 - segment.offset;
        }
        n2 = breakIterator.previous();
        if (n2 != -1) {
            return n3 + n2 - segment.offset;
        }
        SegmentCache.releaseSharedSegment(segment);
        return -1;
    }

    public static final Element getParagraphElement(JTextComponent jTextComponent, int n) {
        int n2;
        Document document = jTextComponent.getDocument();
        if (document instanceof StyledDocument) {
            return ((StyledDocument)document).getParagraphElement(n);
        }
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(n2 = element.getElementIndex(n));
        if (n >= element2.getStartOffset() && n < element2.getEndOffset()) {
            return element2;
        }
        return null;
    }

    static boolean isComposedTextElement(Document document, int n) {
        Element element = document.getDefaultRootElement();
        while (!element.isLeaf()) {
            element = element.getElement(element.getElementIndex(n));
        }
        return Utilities.isComposedTextElement(element);
    }

    static boolean isComposedTextElement(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        return Utilities.isComposedTextAttributeDefined(attributeSet);
    }

    static boolean isComposedTextAttributeDefined(AttributeSet attributeSet) {
        return attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute);
    }

    static int drawComposedText(View view, AttributeSet attributeSet, Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AttributedString attributedString = (AttributedString)attributeSet.getAttribute(StyleConstants.ComposedTextAttribute);
        attributedString.addAttribute(TextAttribute.FONT, graphics.getFont());
        if (n3 >= n4) {
            return n;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator(null, n3, n4);
        return n + (int)SwingUtilities2.drawString(Utilities.getJComponent(view), (Graphics)graphics2D, attributedCharacterIterator, n, n2);
    }

    static void paintComposedText(Graphics graphics, Rectangle rectangle, GlyphView glyphView) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = glyphView.getStartOffset();
            int n2 = glyphView.getEndOffset();
            AttributeSet attributeSet = glyphView.getElement().getAttributes();
            AttributedString attributedString = (AttributedString)attributeSet.getAttribute(StyleConstants.ComposedTextAttribute);
            int n3 = glyphView.getElement().getStartOffset();
            int n4 = rectangle.y + rectangle.height - (int)glyphView.getGlyphPainter().getDescent(glyphView);
            int n5 = rectangle.x;
            attributedString.addAttribute(TextAttribute.FONT, glyphView.getFont());
            attributedString.addAttribute(TextAttribute.FOREGROUND, glyphView.getForeground());
            if (StyleConstants.isBold(glyphView.getAttributes())) {
                attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (StyleConstants.isItalic(glyphView.getAttributes())) {
                attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if (glyphView.isUnderline()) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (glyphView.isStrikeThrough()) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            if (glyphView.isSuperscript()) {
                attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
            }
            if (glyphView.isSubscript()) {
                attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
            }
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator(null, n - n3, n2 - n3);
            SwingUtilities2.drawString(Utilities.getJComponent(glyphView), (Graphics)graphics2D, attributedCharacterIterator, n5, n4);
        }
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static int getNextVisualPositionFrom(View view, int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3;
        boolean bl;
        if (view.getViewCount() == 0) {
            return n;
        }
        boolean bl2 = bl = n2 == 1 || n2 == 7;
        if (n == -1) {
            Shape shape2;
            int n4 = bl ? view.getViewCount() - 1 : 0;
            View view2 = view.getView(n4);
            n3 = view2.getNextVisualPositionFrom(n, bias, shape2 = view.getChildAllocation(n4, shape), n2, biasArray);
            if (n3 == -1 && !bl && view.getViewCount() > 1) {
                view2 = view.getView(1);
                shape2 = view.getChildAllocation(1, shape);
                n3 = view2.getNextVisualPositionFrom(-1, biasArray[0], shape2, n2, biasArray);
            }
        } else {
            int n5 = bl ? -1 : 1;
            int n6 = bias == Position.Bias.Backward && n > 0 ? view.getViewIndex(n - 1, Position.Bias.Forward) : view.getViewIndex(n, Position.Bias.Forward);
            View view3 = view.getView(n6);
            Shape shape3 = view.getChildAllocation(n6, shape);
            n3 = view3.getNextVisualPositionFrom(n, bias, shape3, n2, biasArray);
            if ((n2 == 3 || n2 == 7) && view instanceof CompositeView && ((CompositeView)view).flipEastAndWestAtEnds(n, bias)) {
                n5 *= -1;
            }
            if (n3 == -1 && (n6 += n5) >= 0 && n6 < view.getViewCount()) {
                view3 = view.getView(n6);
                n3 = view3.getNextVisualPositionFrom(-1, bias, shape3 = view.getChildAllocation(n6, shape), n2, biasArray);
                if (n3 == n && biasArray[0] != bias) {
                    return Utilities.getNextVisualPositionFrom(view, n, biasArray[0], shape, n2, biasArray);
                }
            } else if (n3 != -1 && biasArray[0] != bias && (n5 == 1 && view3.getEndOffset() == n3 || n5 == -1 && view3.getStartOffset() == n3) && n6 >= 0 && n6 < view.getViewCount()) {
                view3 = view.getView(n6);
                shape3 = view.getChildAllocation(n6, shape);
                Position.Bias bias2 = biasArray[0];
                int n7 = view3.getNextVisualPositionFrom(-1, bias, shape3, n2, biasArray);
                if (biasArray[0] == bias) {
                    n3 = n7;
                } else {
                    biasArray[0] = bias2;
                }
            }
        }
        return n3;
    }
}

