/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import sun.awt.shell.ShellFolder;
import sun.swing.FilePane;
import sun.swing.WindowsPlacesBar;

public class WindowsFileChooserUI
extends BasicFileChooserUI {
    private static final String[] OS_NAMES = new String[]{"Windows 3.1", "Windows 95", "Windows NT", "Windows 98", "Windows 2000", "Windows Me", "Windows XP"};
    private static int WIN_31 = 0;
    private static int WIN_95 = 1;
    private static int WIN_NT = 2;
    private static int WIN_98 = 3;
    private static int WIN_2k = 4;
    private static int WIN_Me = 5;
    private static int WIN_XP = 6;
    private static String osName = System.getProperty("os.name");
    private static String osVersion = System.getProperty("os.version");
    private static final String OS_NAME = osName.equals(OS_NAMES[WIN_98]) && osVersion.startsWith("4.9") ? "Windows Me" : osName;
    private static final int OS_LEVEL = Arrays.asList(OS_NAMES).indexOf(OS_NAME);
    private JPanel centerPanel;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private ActionListener directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField filenameTextField;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private FilePane filePane;
    private WindowsPlacesBar placesBar;
    private boolean useShellFolder;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension vstrut4 = new Dimension(1, 4);
    private static final Dimension vstrut6 = new Dimension(1, 6);
    private static final Dimension vstrut8 = new Dimension(1, 8);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 425;
    private static int PREF_HEIGHT = 245;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 425;
    private static int MIN_HEIGHT = 245;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 444;
    private static int LIST_PREF_HEIGHT = 138;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private BasicFileChooserUI.BasicFileView fileView = new WindowsFileView();
    private static Hashtable pclHash = new Hashtable();
    static final int space = 10;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsFileChooserUI((JFileChooser)jComponent);
    }

    public WindowsFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        Component component = SwingUtilities.findFocusOwner(jFileChooser);
        if (component != null) {
            jFileChooser.requestFocus();
        }
        jFileChooser.removeAll();
    }

    public void installComponents(JFileChooser jFileChooser) {
        JButton jButton;
        Object object;
        Serializable serializable;
        this.filePane = new FilePane(new WindowsFileChooserUIAccessor());
        jFileChooser.addPropertyChangeListener(this.filePane);
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        jFileChooser.setBorder(new EmptyBorder(4, 10, 10, 10));
        jFileChooser.setLayout(new BorderLayout(8, 8));
        this.updateUseShellFolder();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        if (OS_LEVEL >= WIN_2k) {
            jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        }
        jFileChooser.add((Component)jToolBar, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText, 11){

            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getPreferredSize();
                if (WindowsFileChooserUI.this.placesBar != null) {
                    dimension.width = Math.max(dimension.width, WindowsFileChooserUI.this.placesBar.getWidth());
                }
                return dimension;
            }
        };
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        this.lookInLabel.setAlignmentX(0.0f);
        this.lookInLabel.setAlignmentY(0.5f);
        jToolBar.add(this.lookInLabel);
        jToolBar.add(Box.createRigidArea(new Dimension(8, 0)));
        this.directoryComboBox = new JComboBox(){

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = 60;
                return dimension;
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 150;
                return dimension;
            }
        };
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        this.directoryComboBox.setMaximumRowCount(8);
        jToolBar.add(this.directoryComboBox);
        jToolBar.add(Box.createRigidArea(hstrut10));
        class ButtonFocusListener
        implements FocusListener {
            ButtonFocusListener() {
            }

            public void focusGained(FocusEvent focusEvent) {
                JButton jButton;
                JButton jButton2 = (JButton)focusEvent.getSource();
                JRootPane jRootPane = jButton2.getRootPane();
                if (jRootPane != null && (jButton = jRootPane.getDefaultButton()) != jButton2) {
                    jRootPane.putClientProperty("temporaryDefaultButton", jButton2);
                    jRootPane.setDefaultButton(jButton2);
                    jRootPane.putClientProperty("temporaryDefaultButton", null);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                JButton jButton;
                JButton jButton2 = (JButton)focusEvent.getSource();
                JRootPane jRootPane = jButton2.getRootPane();
                if (jRootPane != null && jButton2 != (jButton = (JButton)jRootPane.getClientProperty("initialDefaultButton"))) {
                    jRootPane.setDefaultButton(jButton);
                }
            }
        }
        ButtonFocusListener buttonFocusListener = new ButtonFocusListener();
        JButton jButton2 = new JButton(this.getChangeToParentDirectoryAction());
        jButton2.setText(null);
        jButton2.setIcon(this.upFolderIcon);
        jButton2.setToolTipText(this.upFolderToolTipText);
        jButton2.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        jButton2.setAlignmentX(0.0f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setMargin(shrinkwrap);
        jButton2.setFocusPainted(true);
        jToolBar.add(jButton2);
        if (OS_LEVEL < WIN_2k) {
            jToolBar.add(Box.createRigidArea(hstrut10));
            jButton2.addFocusListener(buttonFocusListener);
        }
        if (OS_LEVEL == WIN_98) {
            serializable = fileSystemView.getHomeDirectory();
            object = this.homeFolderToolTipText;
            if (fileSystemView.isRoot((File)serializable)) {
                object = this.getFileView(jFileChooser).getName((File)serializable);
            }
            jButton = new JButton(this.getFileView(jFileChooser).getIcon((File)serializable));
            jButton.setToolTipText((String)object);
            jButton.getAccessibleContext().setAccessibleName((String)object);
            jButton.setAlignmentX(0.0f);
            jButton.setAlignmentY(0.5f);
            jButton.setMargin(shrinkwrap);
            jButton.setFocusPainted(false);
            jButton.addActionListener(this.getGoHomeAction());
            jToolBar.add(jButton);
            jToolBar.add(Box.createRigidArea(hstrut10));
            jButton.addFocusListener(buttonFocusListener);
        }
        if (!UIManager.getBoolean("FileChooser.readOnly")) {
            jButton = new JButton(this.filePane.getNewFolderAction());
            jButton.setText(null);
            jButton.setIcon(this.newFolderIcon);
            jButton.setToolTipText(this.newFolderToolTipText);
            jButton.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
            jButton.setAlignmentX(0.0f);
            jButton.setAlignmentY(0.5f);
            jButton.setMargin(shrinkwrap);
            jButton.setFocusPainted(true);
            jToolBar.add(jButton);
            if (OS_LEVEL < WIN_2k) {
                jButton.addFocusListener(buttonFocusListener);
            }
        }
        if (OS_LEVEL < WIN_2k) {
            jToolBar.add(Box.createRigidArea(hstrut10));
        }
        serializable = new ButtonGroup();
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setFocusPainted(true);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(this.filePane.getViewTypeAction(0));
        jToolBar.add(this.listViewButton);
        ((ButtonGroup)serializable).add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setFocusPainted(true);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(this.filePane.getViewTypeAction(1));
        jToolBar.add(this.detailsViewButton);
        ((ButtonGroup)serializable).add(this.detailsViewButton);
        jToolBar.add(Box.createRigidArea(new Dimension(60, 0)));
        this.filePane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("viewType".equals(propertyChangeEvent.getPropertyName())) {
                    int n = WindowsFileChooserUI.this.filePane.getViewType();
                    switch (n) {
                        case 0: {
                            WindowsFileChooserUI.this.listViewButton.setSelected(true);
                            break;
                        }
                        case 1: {
                            WindowsFileChooserUI.this.detailsViewButton.setSelected(true);
                        }
                    }
                }
            }
        });
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        object = jFileChooser.getAccessory();
        if (object != null) {
            this.getAccessoryPanel().add((Component)object);
        }
        this.filePane.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.filePane, "Center");
        jFileChooser.add((Component)this.centerPanel, "Center");
        this.getBottomPanel().setLayout(new BoxLayout(this.getBottomPanel(), 2));
        this.centerPanel.add((Component)this.getBottomPanel(), "South");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(Box.createRigidArea(vstrut4));
        JLabel jLabel = new JLabel(this.fileNameLabelText);
        jLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        jLabel.setAlignmentY(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(1, 12)));
        JLabel jLabel2 = new JLabel(this.filesOfTypeLabelText);
        jLabel2.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        jPanel.add(jLabel2);
        this.getBottomPanel().add(jPanel);
        this.getBottomPanel().add(Box.createRigidArea(new Dimension(15, 0)));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(Box.createRigidArea(vstrut8));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.filenameTextField = new JTextField(35){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        jLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!WindowsFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    WindowsFileChooserUI.this.filePane.clearSelection();
                }
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFile()));
        }
        jPanel2.add(this.filenameTextField);
        jPanel2.add(Box.createRigidArea(vstrut8));
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        jLabel2.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jPanel2.add(this.filterComboBox);
        this.getBottomPanel().add(jPanel2);
        this.getBottomPanel().add(Box.createRigidArea(new Dimension(30, 0)));
        this.getButtonPanel().setLayout(new BoxLayout(this.getButtonPanel(), 1));
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser)){

            public Dimension getMaximumSize() {
                return ((WindowsFileChooserUI)WindowsFileChooserUI.this).approveButton.getPreferredSize().width > ((WindowsFileChooserUI)WindowsFileChooserUI.this).cancelButton.getPreferredSize().width ? WindowsFileChooserUI.this.approveButton.getPreferredSize() : WindowsFileChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        Insets insets = this.approveButton.getMargin();
        insets = new InsetsUIResource(insets.top, insets.left + 5, insets.bottom, insets.right + 5);
        this.approveButton.setMargin(insets);
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.getButtonPanel().add(Box.createRigidArea(vstrut6));
        this.getButtonPanel().add(this.approveButton);
        this.getButtonPanel().add(Box.createRigidArea(vstrut4));
        this.cancelButton = new JButton(this.cancelButtonText){

            public Dimension getMaximumSize() {
                return ((WindowsFileChooserUI)WindowsFileChooserUI.this).approveButton.getPreferredSize().width > ((WindowsFileChooserUI)WindowsFileChooserUI.this).cancelButton.getPreferredSize().width ? WindowsFileChooserUI.this.approveButton.getPreferredSize() : WindowsFileChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        this.cancelButton.setMargin(insets);
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (jFileChooser.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
    }

    private void updateUseShellFolder() {
        JFileChooser jFileChooser = this.getFileChooser();
        Boolean bl = (Boolean)jFileChooser.getClientProperty("FileChooser.useShellFolder");
        this.useShellFolder = bl != null ? bl.booleanValue() : jFileChooser.getFileSystemView().equals(FileSystemView.getFileSystemView());
        if (OS_LEVEL >= WIN_2k) {
            if (this.useShellFolder) {
                if (this.placesBar == null) {
                    this.placesBar = new WindowsPlacesBar(jFileChooser, XPStyle.getXP() != null);
                    jFileChooser.add((Component)this.placesBar, "Before");
                    jFileChooser.addPropertyChangeListener(this.placesBar);
                }
            } else if (this.placesBar != null) {
                jFileChooser.remove(this.placesBar);
                jFileChooser.removePropertyChangeListener(this.placesBar);
                this.placesBar = null;
            }
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", locale);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", locale);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", locale);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", locale);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", locale);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", locale);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", locale);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", locale);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", locale);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", locale);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", locale);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", locale);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", locale);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", locale);
    }

    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
        BorderWidthPropertyChangeListener borderWidthPropertyChangeListener = new BorderWidthPropertyChangeListener(jFileChooser);
        pclHash.put(jFileChooser, borderWidthPropertyChangeListener);
        Toolkit.getDefaultToolkit().addPropertyChangeListener("win.frame.sizingBorderWidth", borderWidthPropertyChangeListener);
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        super.uninstallListeners(jFileChooser);
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)pclHash.remove(jFileChooser);
        Toolkit.getDefaultToolkit().removePropertyChangeListener("win.frame.sizingBorderWidth", propertyChangeListener);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        FilePane.addActionsToMap(actionMapUIResource, this.filePane.getActions());
        return actionMapUIResource;
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        return this.filePane.createList();
    }

    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        return this.filePane.createDetailsView();
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return super.createListSelectionListener(jFileChooser);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        jComponent.removePropertyChangeListener(this.filePane);
        if (this.placesBar != null) {
            jComponent.removePropertyChangeListener(this.placesBar);
        }
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = WindowsFileChooserUI.PREF_SIZE.width;
        Dimension dimension = jComponent.getLayout().preferredLayoutSize(jComponent);
        if (dimension != null) {
            return new Dimension(dimension.width < n ? n : dimension.width, dimension.height < WindowsFileChooserUI.PREF_SIZE.height ? WindowsFileChooserUI.PREF_SIZE.height : dimension.height);
        }
        return new Dimension(n, WindowsFileChooserUI.PREF_SIZE.height);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.fileNameString(fileArray[i]));
            if (fileArray.length <= 1) continue;
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(file));
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileName(this.fileNameString(fileArray));
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.clearIconCache();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null) {
            this.directoryComboBoxModel.addItem(file);
            if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
                if (fileSystemView.isFileSystem(file)) {
                    this.setFileName(file.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.clearIconCache();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.clearIconCache();
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        if (jFileChooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(this.getFileChooser()));
    }

    private void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    WindowsFileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    WindowsFileChooserUI.this.doSelectedFilesChanged(propertyChangeEvent);
                } else if (string.equals("directoryChanged")) {
                    WindowsFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("fileFilterChanged")) {
                    WindowsFileChooserUI.this.doFilterChanged(propertyChangeEvent);
                } else if (string.equals("fileSelectionChanged")) {
                    WindowsFileChooserUI.this.doFileSelectionModeChanged(propertyChangeEvent);
                } else if (string.equals("AccessoryChangedProperty")) {
                    WindowsFileChooserUI.this.doAccessoryChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("ApproveButtonToolTipTextChangedProperty")) {
                    WindowsFileChooserUI.this.doApproveButtonTextChanged(propertyChangeEvent);
                } else if (string.equals("DialogTypeChangedProperty")) {
                    WindowsFileChooserUI.this.doDialogTypeChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    WindowsFileChooserUI.this.doApproveButtonMnemonicChanged(propertyChangeEvent);
                } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                    WindowsFileChooserUI.this.doControlButtonsChanged(propertyChangeEvent);
                } else if (string == "FileChooser.useShellFolder") {
                    WindowsFileChooserUI.this.updateUseShellFolder();
                    WindowsFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        jFileChooser.applyComponentOrientation(componentOrientation);
                    }
                } else if (string.equals("ancestor")) {
                    if (propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                        WindowsFileChooserUI.this.filenameTextField.selectAll();
                        WindowsFileChooserUI.this.filenameTextField.requestFocus();
                    }
                } else if (string.equals("UI") && propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getOldValue() != propertyChangeEvent.getNewValue()) {
                    Component component;
                    Object object = propertyChangeEvent.getSource();
                    JFileChooser jFileChooser = object instanceof JFileChooser ? (JFileChooser)object : null;
                    Component component2 = component = jFileChooser != null ? SwingUtilities.findFocusOwner(jFileChooser) : null;
                    if (component == null || !component.isShowing()) {
                        WindowsFileChooserUI.this.filenameTextField.requestFocus();
                    }
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        this.filePane.ensureFileIsVisible(jFileChooser, file);
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.filePane.rescanCurrentDirectory();
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    protected void setDirectorySelected(boolean bl) {
        super.setDirectorySelected(bl);
        JFileChooser jFileChooser = this.getFileChooser();
        if (bl) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
            this.approveButton.setMnemonic(this.directoryOpenButtonMnemonic);
        } else {
            this.approveButton.setText(this.getApproveButtonText(jFileChooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
            this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String string) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.fileNameString(file));
        }
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    protected class WindowsFileView
    extends BasicFileChooserUI.BasicFileView {
        protected WindowsFileView() {
            super(WindowsFileChooserUI.this);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            if (file != null) {
                icon = WindowsFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(file);
            }
            if (icon == null) {
                icon = super.getIcon(file);
            }
            this.cacheIcon(file, icon);
            return icon;
        }
    }

    protected class DirectoryComboBoxAction
    implements ActionListener {
        protected DirectoryComboBoxAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = (File)WindowsFileChooserUI.this.directoryComboBox.getSelectedItem();
            WindowsFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = WindowsFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                WindowsFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = WindowsFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != fileFilter) continue;
                    bl = true;
                }
                if (!bl) {
                    WindowsFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return WindowsFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return WindowsFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object != null && object instanceof FileFilter) {
                this.setText(((FileFilter)object).getDescription());
            }
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = WindowsFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File file = WindowsFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }

        private void addItem(File file) {
            if (file == null) {
                return;
            }
            this.directories.clear();
            File[] fileArray = WindowsFileChooserUI.this.useShellFolder ? AccessController.doPrivileged(new PrivilegedAction<File[]>(){

                @Override
                public File[] run() {
                    return (File[])ShellFolder.get("fileChooserComboBoxFolders");
                }
            }) : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(fileArray));
            File file2 = null;
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = file;
            }
            try {
                File file3;
                File file4 = file3 = WindowsFileChooserUI.this.useShellFolder ? ShellFolder.getShellFolder(file2) : file2;
                Vector<File> vector = new Vector<File>(10);
                do {
                    vector.addElement(file4);
                } while ((file4 = file4.getParentFile()) != null);
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    file4 = (File)vector.get(i);
                    if (!this.directories.contains(file4)) continue;
                    int n2 = this.directories.indexOf(file4);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt(vector.get(j), n2 + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(file3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File file = (File)this.directories.get(i);
                File file2 = file.getParentFile();
                this.depths[i] = 0;
                if (file2 == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!file2.equals((File)this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int n) {
            return this.depths != null && n >= 0 && n < this.depths.length ? this.depths[n] : 0;
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int n) {
            return this.directories.elementAt(n);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (component.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(component, graphics, n + this.depth * 10, n2);
            } else {
                this.icon.paintIcon(component, graphics, n, n2);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Icon icon;
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object == null) {
                this.setText("");
                return this;
            }
            File file = (File)object;
            this.setText(WindowsFileChooserUI.this.getFileChooser().getName(file));
            this.ii.icon = icon = WindowsFileChooserUI.this.getFileChooser().getIcon(file);
            this.ii.depth = WindowsFileChooserUI.this.directoryComboBoxModel.getDepth(n);
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        protected SingleClickListener() {
        }
    }

    protected class WindowsNewFolderAction
    extends BasicFileChooserUI.NewFolderAction {
        protected WindowsNewFolderAction() {
            super(WindowsFileChooserUI.this);
        }
    }

    private class BorderWidthPropertyChangeListener
    implements PropertyChangeListener {
        JFileChooser fc;

        public BorderWidthPropertyChangeListener(JFileChooser jFileChooser) {
            this.fc = jFileChooser;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Window window = SwingUtilities.windowForComponent(BorderWidthPropertyChangeListener.this.fc);
                    if (window != null && window.isShowing()) {
                        window.setSize(window.getPreferredSize());
                        window.pack();
                    }
                }
            });
        }
    }

    private class WindowsFileChooserUIAccessor
    implements FilePane.FileChooserUIAccessor {
        private WindowsFileChooserUIAccessor() {
        }

        public JFileChooser getFileChooser() {
            return WindowsFileChooserUI.this.getFileChooser();
        }

        public BasicDirectoryModel getModel() {
            return WindowsFileChooserUI.this.getModel();
        }

        public JPanel createList() {
            return WindowsFileChooserUI.this.createList(this.getFileChooser());
        }

        public JPanel createDetailsView() {
            return WindowsFileChooserUI.this.createDetailsView(this.getFileChooser());
        }

        public boolean isDirectorySelected() {
            return WindowsFileChooserUI.this.isDirectorySelected();
        }

        public File getDirectory() {
            return WindowsFileChooserUI.this.getDirectory();
        }

        public Action getChangeToParentDirectoryAction() {
            return WindowsFileChooserUI.this.getChangeToParentDirectoryAction();
        }

        public Action getApproveSelectionAction() {
            return WindowsFileChooserUI.this.getApproveSelectionAction();
        }

        public Action getNewFolderAction() {
            return WindowsFileChooserUI.this.getNewFolderAction();
        }

        public MouseListener createDoubleClickListener(JList jList) {
            return WindowsFileChooserUI.this.createDoubleClickListener(this.getFileChooser(), jList);
        }

        public ListSelectionListener createListSelectionListener() {
            return WindowsFileChooserUI.this.createListSelectionListener(this.getFileChooser());
        }
    }
}

