/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.awt.AppContext;

public class WindowsButtonUI
extends BasicButtonUI {
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    private boolean defaults_initialized = false;
    private static final Object WINDOWS_BUTTON_UI_KEY = new Object();
    private Rectangle viewRect = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        AppContext appContext = AppContext.getAppContext();
        WindowsButtonUI windowsButtonUI = (WindowsButtonUI)appContext.get(WINDOWS_BUTTON_UI_KEY);
        if (windowsButtonUI == null) {
            windowsButtonUI = new WindowsButtonUI();
            appContext.put(WINDOWS_BUTTON_UI_KEY, windowsButtonUI);
        }
        return windowsButtonUI;
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return super.createButtonListener(abstractButton);
    }

    protected void installDefaults(AbstractButton abstractButton) {
        Object object;
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            object = this.getPropertyPrefix();
            this.dashedRectGapX = UIManager.getInt((String)object + "dashedRectGapX");
            this.dashedRectGapY = UIManager.getInt((String)object + "dashedRectGapY");
            this.dashedRectGapWidth = UIManager.getInt((String)object + "dashedRectGapWidth");
            this.dashedRectGapHeight = UIManager.getInt((String)object + "dashedRectGapHeight");
            this.focusColor = UIManager.getColor((String)object + "focus");
            this.defaults_initialized = true;
        }
        if ((object = XPStyle.getXP()) != null) {
            abstractButton.setBorder(((XPStyle)object).getBorder("button.pushbutton"));
            LookAndFeel.installProperty(abstractButton, "rolloverEnabled", Boolean.TRUE);
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        WindowsGraphicsUtils.paintText(graphics, abstractButton, rectangle, string, this.getTextShiftOffset());
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (abstractButton.getParent() instanceof JToolBar) {
            if (abstractButton.getParent().getParent() instanceof JFileChooser) {
                Color color = UIManager.getColor("controlShadow");
                Color color2 = UIManager.getColor("controlLtHighlight");
                int n = abstractButton.getWidth();
                int n2 = abstractButton.getHeight();
                Container container = abstractButton.getParent();
                if (container.getBackground().equals(color)) {
                    color = UIManager.getColor("controlDkShadow");
                }
                Color color3 = graphics.getColor();
                graphics.setColor(color2);
                graphics.drawRect(0, 0, n - 1, n2 - 1);
                graphics.setColor(color);
                graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
                graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
                graphics.setColor(color3);
            }
            return;
        }
        if (XPStyle.getXP() != null) {
            return;
        }
        int n = abstractButton.getWidth();
        int n3 = abstractButton.getHeight();
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, this.dashedRectGapX, this.dashedRectGapY, n - this.dashedRectGapWidth, n3 - this.dashedRectGapHeight);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        this.setTextShiftOffset();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (dimension != null && abstractButton.isFocusPainted()) {
            if (dimension.width % 2 == 0) {
                ++dimension.width;
            }
            if (dimension.height % 2 == 0) {
                ++dimension.height;
            }
        }
        return dimension;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (XPStyle.getXP() != null) {
            WindowsButtonUI.paintXPButtonBackground(graphics, jComponent);
        }
        super.paint(graphics, jComponent);
    }

    static void paintXPButtonBackground(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        XPStyle xPStyle = XPStyle.getXP();
        if (abstractButton.isContentAreaFilled() && xPStyle != null) {
            if ("imagefile".equalsIgnoreCase(XPStyle.getString("button.pushbutton", null, "bgtype"))) {
                ButtonModel buttonModel = abstractButton.getModel();
                boolean bl = jComponent.getParent() instanceof JToolBar;
                XPStyle.Skin skin = xPStyle.getSkin(bl ? "toolbar.button" : "button.pushbutton");
                int n = 0;
                if (bl) {
                    if (buttonModel.isArmed() && buttonModel.isPressed()) {
                        n = 2;
                    } else if (buttonModel.isSelected() && buttonModel.isRollover()) {
                        n = 5;
                    } else if (buttonModel.isSelected()) {
                        n = 4;
                    } else if (buttonModel.isRollover()) {
                        n = 1;
                    } else if (jComponent.hasFocus() && abstractButton.isFocusPainted()) {
                        n = 1;
                    }
                } else if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                    n = 2;
                } else if (!buttonModel.isEnabled()) {
                    n = 3;
                } else if (buttonModel.isRollover() || buttonModel.isPressed()) {
                    n = 1;
                } else if (abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton() && (!jComponent.hasFocus() || abstractButton.isFocusPainted())) {
                    n = 4;
                } else if (jComponent.hasFocus() && abstractButton.isFocusPainted()) {
                    n = 1;
                }
                Dimension dimension = jComponent.getSize();
                int n2 = 0;
                int n3 = 0;
                int n4 = dimension.width;
                int n5 = dimension.height;
                Border border = jComponent.getBorder();
                Insets insets = border != null ? WindowsButtonUI.getOpaqueInsets(border, jComponent) : jComponent.getInsets();
                if (insets != null) {
                    n2 += insets.left;
                    n3 += insets.top;
                    n4 -= insets.left + insets.right;
                    n5 -= insets.top + insets.bottom;
                }
                skin.paintSkin(graphics, n2, n3, n4, n5, n);
            }
        }
    }

    private static Insets getOpaqueInsets(Border border, Component component) {
        if (border == null) {
            return null;
        }
        if (border.isBorderOpaque()) {
            return border.getBorderInsets(component);
        }
        if (border instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)border;
            Insets insets = WindowsButtonUI.getOpaqueInsets(compoundBorder.getOutsideBorder(), component);
            if (insets != null && insets.equals(compoundBorder.getOutsideBorder().getBorderInsets(component))) {
                Insets insets2 = WindowsButtonUI.getOpaqueInsets(compoundBorder.getInsideBorder(), component);
                if (insets2 == null) {
                    return insets;
                }
                return new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
            }
            return insets;
        }
        return null;
    }
}

