/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.spi;

import com.ibm.asn1.ASN1Decoder;
import com.ibm.asn1.ASN1Encoder;
import com.ibm.asn1.ASN1Exception;
import com.ibm.asn1.BERDecoder;
import com.ibm.asn1.DEREncoder;
import com.ibm.cfwk.KeyMaterial;
import com.ibm.cfwk.key.RSAKey;
import com.ibm.cfwk.pkcs.PKCS8;
import com.ibm.cfwk.pki.AlgId;
import com.ibm.cfwk.pki.X509Cert;
import com.ibm.cfwk.pki.X509Exception;
import com.ibm.cfwk.pki.X509Extension;
import com.ibm.cfwk.pki.X509Extensions;
import com.ibm.cfwk.tools.KeyCertGen;
import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import com.ibm.gsk_sslight.KeyStore;
import com.ibm.gsk_sslight.KeyStoreException;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.spi.IBMKeyStoreSpi;
import com.ibm.sslight.SSLightKeyRing;
import com.ibm.util.x500name.X500Name;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class SSLightKeyStoreSpi
extends KeyStoreSpi
implements IBMKeyStoreSpi {
    protected KeyStore keystore = new KeyStore();
    boolean initialized;
    private String keyDBPassword;
    private String classname;

    public CertificateItem parseCertificate(X509Cert x509Cert, byte[] byArray) throws java.security.KeyStoreException {
        try {
            if (x509Cert == null) {
                return null;
            }
            short s = (short)x509Cert.subjectKeySize();
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            if (x509Cert.issuer().attribute(X500Name.COMMON_NAME) != null) {
                string = x509Cert.issuer().attribute(X500Name.COMMON_NAME).valueToString();
            }
            if (x509Cert.issuer().attribute(X500Name.ORGANIZATIONAL_UNIT) != null) {
                string2 = x509Cert.issuer().attribute(X500Name.ORGANIZATIONAL_UNIT).valueToString();
            }
            if (x509Cert.issuer().attribute(X500Name.ORGANIZATION) != null) {
                string3 = x509Cert.issuer().attribute(X500Name.ORGANIZATION).valueToString();
            }
            if (x509Cert.issuer().attribute(X500Name.COUNTRY) != null) {
                string4 = x509Cert.issuer().attribute(X500Name.COUNTRY).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.COMMON_NAME) != null) {
                string5 = x509Cert.subject().attribute(X500Name.COMMON_NAME).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.ORGANIZATIONAL_UNIT) != null) {
                string6 = x509Cert.subject().attribute(X500Name.ORGANIZATIONAL_UNIT).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.ORGANIZATION) != null) {
                string7 = x509Cert.subject().attribute(X500Name.ORGANIZATION).valueToString();
            }
            if (x509Cert.subject().attribute(X500Name.COUNTRY) != null) {
                string8 = x509Cert.subject().attribute(X500Name.COUNTRY).valueToString();
            }
            DNItem dNItem = new DNItem(string, string2, string3, string4);
            DNItem dNItem2 = new DNItem(string5, string6, string7, string8);
            Date date = new Date(x509Cert.notBefore());
            Date date2 = new Date(x509Cert.notAfter());
            byte[] byArray2 = null;
            DEREncoder dEREncoder = new DEREncoder();
            x509Cert.extensions().encode((ASN1Encoder)dEREncoder);
            byArray2 = dEREncoder.toByteArray();
            AlgId algId = x509Cert.signatureKeyAlgId();
            byte[] byArray3 = null;
            DEREncoder dEREncoder2 = new DEREncoder();
            algId.encode((ASN1Encoder)dEREncoder2);
            byArray3 = dEREncoder2.toByteArray();
            CertificateItem certificateItem = new CertificateItem((short)x509Cert.version(), (short)x509Cert.subjectKeySize(), x509Cert.serialNo().toString(), dNItem, dNItem2, date, date2, new BERObject(x509Cert.subjectPublicKeyInfo()), new BERObject(byArray2), x509Cert.signature(), new BERObject(byArray3), algId.toString(), algId.asn1oid().name(), byArray);
            return certificateItem;
        }
        catch (ASN1Exception aSN1Exception) {
            throw new java.security.KeyStoreException("An ASN1Exception occurred: " + aSN1Exception.getMessage());
        }
    }

    public Enumeration engineAliases() {
        Enumeration enumeration = this.keystore.engineAliases();
        Vector<String> vector = new Vector<String>(this.engineSize());
        try {
            DNItem dNItem;
            DNItem dNItem2;
            CertificateItem certificateItem;
            byte[] byArray;
            X509Cert x509Cert;
            String string;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!this.engineIsKeyEntry(string)) continue;
                vector.add(string);
            }
            enumeration = this.keystore.engineAliases();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!this.engineIsCertificateEntry(string)) continue;
                x509Cert = new X509Cert(this.engineGetCertificate(string).getEncoded());
                byArray = x509Cert.getEncoded();
                certificateItem = this.parseCertificate(x509Cert, byArray);
                dNItem2 = null;
                dNItem = null;
                dNItem = certificateItem.getSubject();
                dNItem2 = certificateItem.getIssuer();
                if (!dNItem.toString().equals(dNItem2.toString())) continue;
                vector.add(string);
            }
            enumeration = this.keystore.engineAliases();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!this.engineIsCertificateEntry(string)) continue;
                x509Cert = new X509Cert(this.engineGetCertificate(string).getEncoded());
                byArray = x509Cert.getEncoded();
                certificateItem = this.parseCertificate(x509Cert, byArray);
                dNItem2 = null;
                dNItem = null;
                dNItem = certificateItem.getSubject();
                dNItem2 = certificateItem.getIssuer();
                if (dNItem.toString().equals(dNItem2.toString())) continue;
                vector.add(string);
            }
            enumeration = this.keystore.engineAliases();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!this.engineIsSiteCertificateEntry(string)) continue;
                vector.add(string);
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            System.out.println("A CertificateEncodingException occurred: " + certificateEncodingException.getMessage());
        }
        catch (ASN1Exception aSN1Exception) {
            System.out.println("An ASN1Exception occurred: " + aSN1Exception.getMessage());
        }
        catch (Exception exception) {
            System.out.println("An Exception occurred: " + exception.getMessage());
        }
        return vector.elements();
    }

    public boolean engineContainsAlias(String string) {
        return this.keystore.engineContainsAlias(string);
    }

    public void engineDeleteEntry(String string) throws java.security.KeyStoreException {
        try {
            this.keystore.engineDeleteEntry(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw new java.security.KeyStoreException(keyStoreException.getMessage());
        }
    }

    public int engineSize() {
        return this.keystore.engineSize();
    }

    public boolean engineIsKeyEntry(String string) {
        return this.keystore.engineIsKeyEntry(string);
    }

    public boolean engineIsCertificateEntry(String string) {
        return this.keystore.engineIsCertificateEntry(string);
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, CertificateException {
        if (inputStream == null) {
            this.initialized = true;
            return;
        }
        try {
            this.keystore.engineLoad(inputStream, cArray);
            this.initialized = true;
            this.keyDBPassword = new String(cArray);
        }
        catch (X509Exception x509Exception) {
            throw new CertificateException(x509Exception.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Might try to use method \"loadFromClass\"");
            throw iOException;
        }
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, CertificateException {
        try {
            this.keystore.engineStore(outputStream, cArray);
        }
        catch (X509Exception x509Exception) {
            throw new CertificateException(x509Exception.getMessage());
        }
    }

    public Certificate engineGetCertificate(String string) {
        if (this.engineIsCertReqEntry(string)) {
            return null;
        }
        X509Cert x509Cert = this.keystore.engineGetCertificate(string);
        try {
            return x509Cert == null ? null : new X509CertImpl(x509Cert.getEncoded());
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    public Certificate[] engineGetCertificateChain(String string) {
        X509CertImpl[] x509CertImplArray;
        X509Cert[] x509CertArray = this.keystore.engineGetCertificateChain(string);
        if (x509CertArray == null) {
            return null;
        }
        try {
            x509CertImplArray = new X509CertImpl[x509CertArray.length];
            int n = 0;
            while (n < x509CertArray.length) {
                x509CertImplArray[n] = new X509CertImpl(x509CertArray[n].getEncoded());
                ++n;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return x509CertImplArray;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        try {
            return this.keystore.engineGetCertificateAlias(new X509Cert(certificate.getEncoded()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyMaterial keyMaterial = this.keystore.engineGetKey(string, cArray);
        PKCS8 pKCS8 = new PKCS8((RSAKey)keyMaterial);
        try {
            DEREncoder dEREncoder = new DEREncoder();
            pKCS8.encode((ASN1Encoder)dEREncoder);
            byte[] byArray = dEREncoder.toByteArray();
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", KeyStoreManager.JCEProvider);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            return privateKey;
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException(exception.getMessage());
        }
    }

    public Date engineGetCreationDate(String string) {
        return new Date();
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws java.security.KeyStoreException {
        X509Cert[] x509CertArray = null;
        if (certificateArray != null) {
            x509CertArray = new X509Cert[certificateArray.length];
            int n = 0;
            while (n < certificateArray.length) {
                if (certificateArray[n] == null) {
                    x509CertArray[n] = null;
                } else if (certificateArray[n] instanceof X509Certificate) {
                    try {
                        x509CertArray[n] = new X509Cert(((X509Certificate)certificateArray[n]).getEncoded());
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                    }
                    catch (ASN1Exception aSN1Exception) {
                        throw new java.security.KeyStoreException("An ASN1Exception occurred: " + aSN1Exception.getMessage());
                    }
                } else {
                    throw new java.security.KeyStoreException("Cannot store a certificate of type " + certificateArray[n].getClass().getName());
                }
                ++n;
            }
        }
        if (!key.getFormat().equals("PKCS#8")) {
            throw new java.security.KeyStoreException("Key does not support PKCS#8 encoding");
        }
        try {
            PKCS8 pKCS8 = PKCS8.make((ASN1Decoder)new BERDecoder(key.getEncoded()));
            RSAKey rSAKey = (RSAKey)pKCS8.privateKey;
            this.keystore.engineSetKeyEntry(string, (KeyMaterial)rSAKey, cArray, x509CertArray);
        }
        catch (Exception exception) {
            throw new java.security.KeyStoreException(exception.getMessage());
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws java.security.KeyStoreException {
        throw new java.security.KeyStoreException("Unsupported KeyStore operation");
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws java.security.KeyStoreException {
        X509Cert x509Cert = null;
        if (certificate instanceof X509Certificate) {
            try {
                x509Cert = new X509Cert(((X509Certificate)certificate).getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new java.security.KeyStoreException("A certificate encoding occurred: " + certificateEncodingException.getMessage());
            }
            catch (ASN1Exception aSN1Exception) {
                throw new java.security.KeyStoreException("An ASN1Exception occurred: " + aSN1Exception.getMessage());
            }
        } else {
            throw new java.security.KeyStoreException("Cannot store a certificate of type " + certificate.getClass().getName());
        }
        try {
            this.keystore.engineSetCertificateEntry(string, x509Cert);
        }
        catch (KeyStoreException keyStoreException) {
            throw new java.security.KeyStoreException(keyStoreException.getMessage());
        }
    }

    public boolean engineIsDefaultKeyEntry(String string) {
        try {
            String string2 = this.keystore.engineGetDefaultKeyEntry();
            if (string2 != null) {
                return string2.equals(string);
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String engineGetDefaultKeyEntry() throws java.security.KeyStoreException {
        try {
            return this.keystore.engineGetDefaultKeyEntry();
        }
        catch (Exception exception) {
            throw new java.security.KeyStoreException("An error occured while extracting the default KeyItem");
        }
    }

    public void engineSetDefaultKeyEntry(String string) throws java.security.KeyStoreException {
        try {
            this.keystore.engineSetDefaultKeyEntry(string);
        }
        catch (Exception exception) {
            throw new java.security.KeyStoreException("An error occured while setting the default KeyItem");
        }
    }

    public boolean engineIsSiteCertificateEntry(String string) throws java.security.KeyStoreException {
        try {
            return this.keystore.engineIsSiteCertificateEntry(string);
        }
        catch (Exception exception) {
            throw new java.security.KeyStoreException("An error occured while check Site entry");
        }
    }

    public void engineSetSiteCertificateEntry(String string, Certificate certificate) throws java.security.KeyStoreException {
        X509Cert x509Cert = null;
        if (certificate instanceof X509Certificate) {
            try {
                x509Cert = new X509Cert(((X509Certificate)certificate).getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new java.security.KeyStoreException("A certificate encoding occurred: " + certificateEncodingException.getMessage());
            }
            catch (ASN1Exception aSN1Exception) {
                throw new java.security.KeyStoreException("An ASN1Exception occurred: " + aSN1Exception.getMessage());
            }
        } else {
            throw new java.security.KeyStoreException("Cannot store a certificate of type " + certificate.getClass().getName());
        }
        try {
            this.keystore.engineSetSiteCertificateEntry(string, x509Cert);
        }
        catch (KeyStoreException keyStoreException) {
            throw new java.security.KeyStoreException(keyStoreException.getMessage());
        }
    }

    public void engineLoadFromClass(InputStream inputStream, char[] cArray) throws IOException, CertificateException {
        try {
            String string = new KeyRingClassLoader().getKeyRingData(inputStream);
            this.keystore.engineLoad(string, cArray);
            this.initialized = true;
        }
        catch (X509Exception x509Exception) {
            throw new CertificateException(x509Exception.getMessage());
        }
    }

    public void engineStoreAsClass(OutputStream outputStream, char[] cArray, String string) throws IOException, CertificateException {
        if (string == null) {
            throw new IOException("Classname must be specified");
        }
        try {
            this.keystore.engineStore(outputStream, cArray, string);
        }
        catch (X509Exception x509Exception) {
            throw new CertificateException(x509Exception.getMessage());
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void engineLoadCMS(InputStream inputStream, InputStream inputStream2, InputStream inputStream3, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new NoSuchAlgorithmException("SSLight does not support");
    }

    public void engineLoad(String string, String string2) throws IOException {
        throw new IOException("SSLight doesn't not support");
    }

    public void engineStoreCMS(OutputStream outputStream, OutputStream outputStream2, OutputStream outputStream3, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new NoSuchAlgorithmException("SSLight does not support");
    }

    public void engineSetExpireTime(long l) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("SSLight does not support");
    }

    public boolean engineIsCertReqEntry(String string) {
        boolean bl = false;
        try {
            X509Cert x509Cert = this.keystore.engineGetCertificate(string);
            X509Extensions x509Extensions = x509Cert.extensions();
            if (x509Extensions != null && x509Extensions.findExtension(KeyCertGen.GSKCertificationRequestOID) != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void engineSetCertReqEntry(String string, CertificationRequest certificationRequest, Key key) throws java.security.KeyStoreException {
        X500Name x500Name = null;
        try {
            x500Name = new X500Name(certificationRequest.getCertRequestInfo().getSubjectName().getEncoded());
        }
        catch (Exception exception) {
            throw new java.security.KeyStoreException(exception.toString());
        }
        X509Extension x509Extension = new X509Extension(KeyCertGen.GSKCertificationRequestOID, false);
        X509Extension[] x509ExtensionArray = new X509Extension[]{x509Extension};
        X509Cert x509Cert = null;
        X509Cert[] x509CertArray = new X509Cert[1];
        String string2 = certificationRequest.getSignatureAlgorithm().getName();
        if (!key.getFormat().equals("PKCS#8")) {
            throw new java.security.KeyStoreException("Key does not support PKCS#8 encoding");
        }
        try {
            PKCS8 pKCS8 = PKCS8.make((ASN1Decoder)new BERDecoder(key.getEncoded()));
            RSAKey rSAKey = (RSAKey)pKCS8.privateKey;
            x509CertArray[0] = x509Cert = KeyCertGen.generateCertificate((KeyMaterial)rSAKey, (X500Name)x500Name, (int)2, (int)365, (String)"MD5 with RSA", (X509Extension[])x509ExtensionArray);
            this.keystore.engineSetKeyEntry(string, (KeyMaterial)rSAKey, null, x509CertArray);
        }
        catch (Exception exception) {
            throw new java.security.KeyStoreException(exception.toString());
        }
    }

    public CertificationRequest engineGetCertReqEntry(String string) throws java.security.KeyStoreException {
        CertificationRequest certificationRequest = null;
        try {
            X509Cert x509Cert = this.keystore.engineGetCertificate(string);
            X509Extensions x509Extensions = x509Cert.extensions();
            if (x509Extensions == null) {
                return null;
            }
            X500Name x500Name = x509Cert.subject();
            KeyMaterial keyMaterial = this.keystore.engineGetKey(string, null);
            certificationRequest = new CertificationRequest(KeyCertGen.generateCertificationRequest((KeyMaterial)keyMaterial, (X500Name)x500Name, (String)"MD5 with RSA", (X509Extension[])x509Extensions.extensions()).getEncoded());
        }
        catch (Exception exception) {
            throw new java.security.KeyStoreException(exception.toString());
        }
        return certificationRequest;
    }

    public boolean engineIsTrusted(String string) {
        return this.engineIsCertificateEntry(string);
    }

    public void engineSetTrusted(String string, boolean bl) {
    }

    public void engineStashKeydbPwd(OutputStream outputStream) throws IOException, NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("SSLight does not support");
    }

    public void engineCreateNewSelfSignedCertificate(int n, String string, int n2, DNItem dNItem, int n3, int n4, Vector vector) throws java.security.KeyStoreException {
    }

    private class KeyRingClassLoader
    extends ClassLoader {
        public String getKeyRingData(InputStream inputStream) throws IOException {
            Class<?> clazz;
            byte[] byArray = new byte[4096];
            int n = 0;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            do {
                if ((n = bufferedInputStream.read(byArray, 0, byArray.length)) <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            } while (n >= 0);
            bufferedInputStream.close();
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            SSLightKeyRing sSLightKeyRing = null;
            try {
                clazz = this.defineClass(null, byArray, 0, byArray.length);
                sSLightKeyRing = (SSLightKeyRing)clazz.newInstance();
                if (!(sSLightKeyRing instanceof SSLightKeyRing)) {
                    throw new IOException("Invalid format, not a subclass of SSLightKeyRing");
                }
            }
            catch (ClassFormatError classFormatError) {
                throw new IOException("Invalid format, unable to load keyring class");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException("Invalid format, unable to access keyring class");
            }
            catch (InstantiationException instantiationException) {
                throw new IOException("Invalid format, unable to instantiate keyring class");
            }
            SSLightKeyStoreSpi.this.classname = clazz.getName();
            return sSLightKeyRing.getKeyRingData();
        }
    }
}

