/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.cli;

import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import com.ibm.gsk.ikeyman.basic.KeyStoreManagerException;
import com.ibm.gsk.ikeyman.cli.CLIConstants;
import com.ibm.gsk.ikeyman.cli.CLIDefaults;
import com.ibm.gsk.ikeyman.cli.CLIKeyStoreManager;
import com.ibm.gsk.ikeyman.cli.CLIRequestInfo;
import com.ibm.gsk.ikeyman.ikeycmd;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.RDN;
import com.ibm.security.x509.X500Name;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Vector;

public class CLIKeyStoreRequestManager
implements CLIConstants {
    public static void create(CLIRequestInfo cLIRequestInfo) throws KeyStoreManagerException, KMException {
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.create.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.create.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.create.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLIRequestInfo.dn.getCommonName();
        String string4 = cLIRequestInfo.dn.getOrgUnit();
        String string5 = cLIRequestInfo.dn.getOrg();
        String string6 = cLIRequestInfo.dn.getLocality();
        String string7 = cLIRequestInfo.dn.getState();
        String string8 = cLIRequestInfo.dn.getZipCode();
        String string9 = cLIRequestInfo.dn.getCountry();
        String string10 = cLIRequestInfo.dn.getEmail();
        Vector vector = cLIRequestInfo.dn.getOptions();
        DNItem dNItem = new DNItem(string3, string4, string5, string6, string7, string8, string9, null, null);
        String string11 = cLIRequestInfo.getSanIpAddr();
        String string12 = cLIRequestInfo.getSanDnsName();
        String string13 = cLIRequestInfo.getSanEmailAddr();
        int n2 = cLIRequestInfo.getKeySize();
        String string14 = cLIRequestInfo.getLabel();
        String string15 = cLIRequestInfo.getFileName();
        boolean bl = true;
        keyStoreManager.open();
        ikeycmd.debugMsg("calling createNewCertRequest with parms: \nlabel: " + string14 + "\nkeySize: " + n2 + "\ncertFileName: " + string15 + "\nisNewKeyPair : " + bl + "\n");
        Vector vector2 = new Vector();
        if (CLIDefaults.subjectAltNameSupport) {
            KMUtil.addExtensions(vector2, 1, KMUtil.getStrings(string13));
            KMUtil.addExtensions(vector2, 7, KMUtil.getStrings(string11));
            KMUtil.addExtensions(vector2, 2, KMUtil.getStrings(string12));
        }
        keyStoreManager.createNewCertRequest(string14, n2, dNItem, CLIKeyStoreRequestManager.signatureAlg(), string15, bl, vector2);
        ikeycmd.debugMsg("returned from createNewCertReq ok\n");
        keyStoreManager.close();
    }

    public static void recreate(CLIRequestInfo cLIRequestInfo) throws KeyStoreManagerException, KMException {
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.recreate.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.recreate.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.recreate.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLIRequestInfo.getLabel();
        String string4 = cLIRequestInfo.getExtractTarget();
        try {
            keyStoreManager.open();
            keyStoreManager.extractCertificateRequest(string3, CLIKeyStoreRequestManager.signatureAlg(), string4);
            keyStoreManager.close();
            ikeycmd.debugMsg("returned from recreate ok\n");
        }
        catch (Exception exception) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_INVALID_FILE_PATH_NAME"));
            return;
        }
    }

    public static void list(CLIRequestInfo cLIRequestInfo) throws KeyStoreManagerException, KMException {
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.list.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.list.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.list.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        keyStoreManager.open();
        Vector vector = keyStoreManager.getReqKeyLabelList();
        if (vector == null || vector.size() == 0) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
        }
        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_LIST_MSG") + " " + string);
        int n2 = 0;
        while (n2 < vector.size()) {
            String string3 = (String)vector.elementAt(n2);
            System.out.println(string3);
            ++n2;
        }
        keyStoreManager.close();
        ikeycmd.debugMsg("returned from list ok\n");
    }

    public static void moreDetails(CLIRequestInfo cLIRequestInfo) throws KeyStoreManagerException, KMException {
        String string = "  ";
        String string2 = "    ";
        String string3 = "      ";
        String string4 = "        ";
        cLIRequestInfo.init();
        String string5 = cLIRequestInfo.cliDb.getName();
        String string6 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreRequestManager: moreDetails()");
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.moreDetails.KeyDbFileName: " + string5);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.moreDetails.keyDbPassword: " + string6);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.moreDetails.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string5, string6, l);
        String string7 = cLIRequestInfo.getLabel();
        KeyItem keyItem = null;
        keyStoreManager.open();
        keyItem = keyStoreManager.getKeyItemByLabel(string7);
        if (keyItem == null) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
        }
        CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
        if (null == certificateRequestItem) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
        }
        System.out.println("\n\n");
        System.out.println(ikeycmd.getNLSResString("GUI_LABEL_KEY_LABEL_COLON") + " " + string7);
        System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_CERTREQ_INFO"));
        byte[] byArray = certificateRequestItem.getEncoded();
        CertificationRequest certificationRequest = null;
        try {
            certificationRequest = new CertificationRequest(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (certificationRequest != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            AlgorithmId algorithmId;
            RDN[] rDNArray;
            CertificationRequestInfo certificationRequestInfo = certificationRequest.getCertRequestInfo();
            byte[] byArray2 = certificationRequestInfo.getVersion().toByteArray();
            String string8 = CLIKeyStoreRequestManager.getHexDumpForMoreDetails(byArray2);
            System.out.println(string2 + KMSystem.getNLSErrString("GSKKM_CLI_CERT_DETAILS_VERSION") + " " + string8);
            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT"));
            X500Name x500Name = certificationRequestInfo.getSubjectName();
            int n2 = x500Name.size();
            int n3 = 0;
            while (n3 < n2) {
                rDNArray = new RDN[n2];
                rDNArray[n3] = x500Name.getRDN(n3);
                int n4 = rDNArray[n3].size();
                int n5 = 0;
                while (n5 < n4) {
                    algorithmId = new AVA[n4];
                    algorithmId[n5] = rDNArray[n3].getAVA(n5);
                    object4 = algorithmId[n5].getOID();
                    object3 = CLIKeyStoreRequestManager.getAttributeName((ObjectIdentifier)object4);
                    System.out.println(string3 + (String)object3);
                    if (null != object4) {
                        object2 = object4.toString();
                        object = algorithmId[n5].getValue();
                        System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + (String)object2);
                        System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ": " + (String)object);
                    } else {
                        object2 = algorithmId[n5].toString();
                        object = algorithmId[n5].getValue();
                        System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + (String)object2);
                        System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ": " + (String)object);
                    }
                    ++n5;
                }
                ++n3;
            }
            rDNArray = certificationRequestInfo.getAttributes();
            String string9 = null;
            if (rDNArray != null) {
                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_ATTRIBUTES"));
                PKCSAttribute[] pKCSAttributeArray = rDNArray.getAttributes();
                if (pKCSAttributeArray != null) {
                    int n6 = 0;
                    while (n6 < pKCSAttributeArray.length) {
                        object4 = pKCSAttributeArray[n6].getAttributeId();
                        if (object4 != null) {
                            string9 = CLIKeyStoreRequestManager.getAttributeName((ObjectIdentifier)object4);
                            object3 = object4.toString();
                            if (object3 != null && ((String)object3).length() > 0) {
                                System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_TYPE") + ": " + (String)object3);
                            }
                        } else {
                            System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_ATTRIBUTE"));
                        }
                        try {
                            object3 = pKCSAttributeArray[n6].toString();
                            object2 = ((String)object3).getBytes();
                            if (object2 != null && ((Object)object2).length > 0) {
                                object = object3;
                                System.out.println(string4 + ikeycmd.getNLSResString("GUI_LABEL_VALUE") + ":\n" + string4 + (String)object3);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++n6;
                    }
                }
            }
            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEYINFO"));
            PublicKey publicKey = null;
            algorithmId = null;
            object4 = null;
            try {
                publicKey = certificationRequestInfo.getSubjectPublicKeyInfo();
                object3 = new DerValue(publicKey.getEncoded());
                algorithmId = AlgorithmId.parse((DerValue)object3.getData().getDerValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            object4 = publicKey.getEncoded();
            if (algorithmId != null) {
                object3 = algorithmId.getOID();
                if (object3 != null && (object2 = object3.toString()) != null && ((String)object2).length() > 0) {
                    System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_ALGORITHM") + ": " + (String)object2);
                }
                object2 = null;
                if (null == algorithmId.getAlgParameters()) {
                    System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + ikeycmd.getNLSResString("GUI_LABEL_NULL"));
                } else {
                    try {
                        object2 = CLIKeyStoreRequestManager.getHexDumpWithASCII(algorithmId.getParameters());
                        if (object2 != null && ((String)object2).length() > 0) {
                            System.out.println(string3 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + (String)object2);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (object4 != null && ((byte[])object4).length > 0) {
                object3 = CLIKeyStoreRequestManager.getHexDumpForMoreDetails(object4);
                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEY") + ":\n" + string3 + (String)object3);
            }
            object3 = certificationRequest.getSignatureAlgorithm();
            object2 = certificationRequest.getSignature();
            System.out.println(string + ikeycmd.getNLSResString("GUI_LABEL_SIG_ALG"));
            if (object3 != null) {
                String string10;
                object = object3.getOID();
                if (object != null && (string10 = object.toString()) != null && string10.length() > 0) {
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_ALGORITHM") + ": " + string10);
                }
                string10 = null;
                if (null == object3.getAlgParameters()) {
                    System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + ikeycmd.getNLSResString("GUI_LABEL_NULL"));
                } else {
                    try {
                        string10 = CLIKeyStoreRequestManager.getHexDumpWithASCII(object3.getParameters());
                        if (string10 != null && string10.length() > 0) {
                            System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_PARAMETERS") + ": " + string10);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (object2 != null) {
                System.out.println(string2 + ikeycmd.getNLSResString("GUI_LABEL_SIG_VALUE") + ":\n" + string3 + CLIKeyStoreRequestManager.getHexDumpForMoreDetails((byte[])object2));
            }
            System.out.println("\n");
        }
        keyStoreManager.close();
    }

    private static String getAttributeName(ObjectIdentifier objectIdentifier) {
        String string = null;
        if (objectIdentifier != null) {
            string = objectIdentifier.equals(X500Name.commonName_oid) ? ikeycmd.getNLSResString("GUI_LABEL_COMMON_NAME") : (objectIdentifier.equals(X500Name.serialNumber_oid) ? ikeycmd.getNLSResString("GUI_LABEL_SERIALNO") : (objectIdentifier.equals(X500Name.countryName_oid) ? ikeycmd.getNLSResString("GUI_LABEL_COUNTRY") : (objectIdentifier.equals(X500Name.localityName_oid) ? ikeycmd.getNLSResString("GUI_LABEL_LOCALITY") : (objectIdentifier.equals(X500Name.stateName_oid) ? ikeycmd.getNLSResString("GUI_LABEL_STATE") : (objectIdentifier.equals(X500Name.streetAddress_oid) ? ikeycmd.getNLSResString("GUI_LABEL_STREET") : (objectIdentifier.equals(X500Name.orgName_oid) ? ikeycmd.getNLSResString("GUI_LABEL_ORG") : (objectIdentifier.equals(X500Name.orgUnitName_oid) ? ikeycmd.getNLSResString("GUI_LABEL_ORG_UNIT") : (objectIdentifier.equals(X500Name.title_oid) ? ikeycmd.getNLSResString("GUI_LABEL_TITLE2") : (objectIdentifier.equals(X500Name.postalCode_oid) ? ikeycmd.getNLSResString("GUI_LABEL_ZIPCODE") : (objectIdentifier.equals(X500Name.emailAddress_oid) ? ikeycmd.getNLSResString("GUI_LABEL_EMAIL_ADDRESS1") : objectIdentifier.toString()))))))))));
        }
        return string;
    }

    private static String getHexDumpWithASCII(byte[] byArray) {
        String string = new String("");
        if (byArray != null && byArray.length > 0) {
            String string2 = new String("");
            String string3 = new String("");
            int n = 0;
            int n2 = 0;
            while (n < byArray.length) {
                int n3 = 0;
                n3 = n + 16 <= byArray.length ? 16 : byArray.length % 16;
                byte[] byArray2 = new byte[n3];
                string3 = "";
                n2 = 0;
                while (n2 < byArray2.length) {
                    byArray2[n2] = byArray[n + n2];
                    string3 = byArray2[n2] < 0 || Character.getType((char)byArray2[n2]) == 15 ? string3 + "." : string3 + (char)byArray2[n2];
                    ++n2;
                }
                string2 = CLIKeyStoreRequestManager.getHexDumpForMoreDetails(byArray2);
                string = string + string2;
                if (byArray2.length % 16 != 0) {
                    n2 = 0;
                    while (n2 < 16 - byArray2.length % 16) {
                        string = string + "   ";
                        ++n2;
                    }
                }
                string = string + "    " + string3;
                if (n + n3 < byArray.length) {
                    string = string + "\n";
                }
                n += n3;
            }
        }
        return string;
    }

    private static String getHexDumpForMoreDetails(byte[] byArray) {
        String string = new String("");
        String string2 = "      ";
        if (byArray != null && byArray.length > 0) {
            int n = 0;
            while (n < byArray.length) {
                int n2;
                if (n % 16 == 0) {
                    if (n > 0 && n < byArray.length) {
                        string = string + "\n" + string2;
                    }
                } else {
                    string = string + " ";
                }
                if ((n2 = byArray[n] & 0xFF) < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(n2).toUpperCase();
                ++n;
            }
        }
        return string;
    }

    public static void details(CLIRequestInfo cLIRequestInfo) throws KeyStoreManagerException, KMException {
        String string;
        String string2;
        cLIRequestInfo.init();
        String string3 = cLIRequestInfo.cliDb.getName();
        String string4 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.details.KeyDbFileName: " + string3);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.details.keyDbPassword: " + string4);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.details.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string3, string4, l);
        String string5 = cLIRequestInfo.getLabel();
        KeyItem keyItem = null;
        keyStoreManager.open();
        keyItem = keyStoreManager.getKeyItemByLabel(string5);
        if (keyItem == null) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
        }
        CertificateRequestItem certificateRequestItem = keyItem.getCertificateRequestItem();
        if (null == certificateRequestItem) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEYDB_NULL"));
        }
        System.out.println("\n\n");
        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_LABEL") + " " + string5);
        short s = certificateRequestItem.getKeySize();
        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_KEYSIZE") + " " + s);
        DNItem dNItem = certificateRequestItem.getSubject();
        if (dNItem != null) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_SUBJECT") + " " + dNItem.toStringWithoutTag());
        }
        if ((string2 = certificateRequestItem.getFingerPrint()) != null) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_FINGER") + " " + string2);
        }
        if ((string = certificateRequestItem.getSigAlgorithmIdOID()) != null) {
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_CERTREQ_DETAILS_SIG") + " " + string);
        }
        System.out.println("\n\n");
        keyStoreManager.close();
        ikeycmd.debugMsg("returned from details ok\n");
    }

    public static void extract(CLIRequestInfo cLIRequestInfo) throws KeyStoreManagerException, KMException {
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.extract.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.extract.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.extract.keyDbType:  " + n);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.extract.filename:  " + cLIRequestInfo.getFileName());
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.extract.label:  " + cLIRequestInfo.getExtractTarget());
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLIRequestInfo.getLabel();
        String string4 = cLIRequestInfo.getExtractTarget();
        File file = new File(string4);
        try {
            keyStoreManager.open();
            keyStoreManager.extractCertificateRequest(string3, CLIKeyStoreRequestManager.signatureAlg(), string4);
            keyStoreManager.close();
            ikeycmd.debugMsg("returned from extract ok\n");
        }
        catch (Exception exception) {
            if (file.exists()) {
                file.delete();
            }
            System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_INVALID_FILE_PATH_NAME"));
            return;
        }
    }

    public static void delete(CLIRequestInfo cLIRequestInfo) throws KeyStoreManagerException, KMException {
        cLIRequestInfo.init();
        String string = cLIRequestInfo.cliDb.getName();
        String string2 = cLIRequestInfo.cliDb.getPassword();
        int n = cLIRequestInfo.cliDb.getDbType();
        long l = cLIRequestInfo.cliDb.getExpire();
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.delete.KeyDbFileName: " + string);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.delete.keyDbPassword: " + string2);
        ikeycmd.debugMsg("CLIKeyStoreRequestManager.delete.keyDbType:  " + n);
        ikeycmd.debugMsg("\n");
        KeyStoreManager keyStoreManager = CLIKeyStoreManager.makeKeyDatabase(n, string, string2, l);
        String string3 = cLIRequestInfo.getLabel();
        ikeycmd.debugMsg("Deleteing label " + string3 + "\n");
        keyStoreManager.open();
        keyStoreManager.deleteKeyByLabel(string3);
        keyStoreManager.close();
        ikeycmd.debugMsg("returned from delete req ok\n");
    }

    public static int signatureAlg() {
        int n = KMSystem.getDefaultSignatureAlg();
        ikeycmd.debugMsg("254 CLI message returned check for slected algorithm= " + n);
        return n;
    }
}

