/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.awt.MsgDialog;
import com.ibm.gsk.ikeyman.basic.KMExtensionItem;
import com.ibm.security.x509.IPAddressName;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;

public class KMUtil {
    public static boolean printDebugMsg = false;
    public static String defaultDebugDumpFileName = "ikmgdbg.log";
    public static FileOutputStream debugDumpOutputStream = null;
    public static PrintWriter debugPrintWriter;
    private static int msgIndent;

    public static String changeFileNameExtension(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        if (string2.length() == 0 || string3.length() == 0) {
            return null;
        }
        String string4 = null;
        if (!string.endsWith(string2)) {
            string4 = string + string3;
        } else {
            int n = string.length() - string2.length();
            if (n < 1) {
                return null;
            }
            string4 = string.substring(0, n) + string3;
        }
        return string4;
    }

    public static String changeFileNameExtension(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            return null;
        }
        String string3 = null;
        int n = string.lastIndexOf(46);
        string3 = n < 0 ? string + string2 : string.substring(0, n) + string2;
        return string3;
    }

    public static synchronized String getTmpFileName(String string, String string2, String string3) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String string4 = string + string2;
        boolean bl = false;
        do {
            String string5;
            File file;
            File file2 = new File(string4);
            if (string3 != null && !string3.equals("") && (file = new File(string5 = KMUtil.changeFileNameExtension(string4, string2, string3))).exists()) {
                string4 = string4 + string2;
                continue;
            }
            if (file2.exists()) {
                string4 = string4 + string2;
                continue;
            }
            bl = true;
            break;
        } while (!bl);
        return string4;
    }

    public static synchronized String getTmpFileName(String string, String string2) {
        return KMUtil.getTmpFileName(string, string2, null);
    }

    public static String formatBinaryDataWithColon(byte[] byArray) {
        String string = "- not computed -";
        if (byArray == null || byArray.length > 24) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(48);
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            if (n > 0) {
                stringBuffer.append(':');
            }
            byte by = byArray[n];
            stringBuffer.append("0123456789ABCDEF".charAt(by >> 4 & 0xF));
            stringBuffer.append("0123456789ABCDEF".charAt(by & 0xF));
            ++n;
        }
        string = stringBuffer.toString();
        return string;
    }

    public static String getDigest(byte[] byArray, String string) {
        String string2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            byte[] byArray2 = messageDigest.digest(byArray);
            string2 = KMUtil.formatBinaryDataWithColon(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string2 = "- the given digest algorithm is not supported -";
        }
        catch (Exception exception) {
            string2 = "- not computed -";
        }
        return string2;
    }

    public static String getMD2(byte[] byArray) {
        return KMUtil.getDigest(byArray, "MD2");
    }

    public static String getMD5(byte[] byArray) {
        return KMUtil.getDigest(byArray, "MD5");
    }

    public static String getSHA1(byte[] byArray) {
        return KMUtil.getDigest(byArray, "SHA-1");
    }

    public static String getSHA(byte[] byArray) {
        return KMUtil.getDigest(byArray, "SHA");
    }

    public static int greater(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    public static int max(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        return KMUtil.max(nArray, nArray.length);
    }

    public static int max(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n2 == 0) {
            return 0;
        }
        if (n2 == 1 || n <= 1) {
            return nArray[0];
        }
        return KMUtil.greater(KMUtil.max(nArray, n - 1), nArray[n - 1]);
    }

    public static String trimBlankSpace(String string) {
        return KMUtil.trimBlankSpace(string, true, true);
    }

    public static String trimBlankSpace(String string, boolean bl, boolean bl2) {
        if (!bl && !bl2) {
            return string;
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = null;
        int n = string.length();
        if (bl && bl2) {
            string2 = string.trim();
            if (string2.length() == 0) {
                string2 = null;
            }
        } else if (bl) {
            int n2 = 0;
            while (n2 < n && string.charAt(n2) == ' ') {
                ++n2;
            }
            string2 = n2 == n ? null : string.substring(n2, n);
        } else if (bl2) {
            int n3 = n - 1;
            while (n3 >= 0 && string.charAt(n3) == ' ') {
                --n3;
            }
            string2 = n3 == -1 ? null : string.substring(0, n3 + 1);
        }
        return string2;
    }

    public static boolean isValidFileName(String string) {
        boolean bl = false;
        if (string != null) {
            File file = new File(string);
            try {
                if (file.getCanonicalPath() != null) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        return bl;
    }

    public static String getFullPathFileName(String string) {
        KMUtil.debugMsg("KMUtil::getFullPathFileName() 0000, fileName=" + string);
        String string2 = null;
        if (string != null) {
            File file = new File(string);
            try {
                string2 = file.getCanonicalPath();
                if (file.isDirectory() && !string2.endsWith(File.separator)) {
                    string2 = string2 + File.separator;
                }
            }
            catch (IOException iOException) {
                string2 = null;
            }
        }
        KMUtil.debugMsg("KMUtil::getFullPathFileName() 9999");
        return string2;
    }

    public static String toStringObjectArray(Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        String string = "";
        int n = 0;
        while (n < objectArray.length) {
            string = string + n + "." + objectArray[n] + " ";
            ++n;
        }
        return string;
    }

    public static String toStringVector(Vector vector) {
        if (vector == null) {
            return "<null vector>";
        }
        String string = "";
        String string2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string2 = string2 == null ? "null" : string2;
            string = string + ", " + string2;
        }
        return string;
    }

    public static void createTmpFilefrmBuffer(String string, byte[] byArray) {
        File file = new File(string);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void debugMsg(String string) {
        if (msgIndent < 0) {
            msgIndent = 0;
        }
        if (string.indexOf("9999") != -1) {
            msgIndent -= 2;
            string = "<<" + string;
        } else if (string.indexOf("0000") != -1) {
            string = ">>" + string;
        }
        int n = 0;
        while (n < msgIndent) {
            string = " " + string;
            ++n;
        }
        if (string.indexOf("0000") != -1) {
            msgIndent += 2;
        }
        if (printDebugMsg) {
            if (debugDumpOutputStream != null && debugPrintWriter != null) {
                debugPrintWriter.println(string);
            } else {
                System.out.println(string);
            }
        }
    }

    public static void closeDebugDumpFile() {
        if (debugDumpOutputStream != null && debugPrintWriter != null) {
            debugPrintWriter.close();
            try {
                debugDumpOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        debugDumpOutputStream = null;
        debugPrintWriter = null;
    }

    public static void initDebugMsg(String string) {
        printDebugMsg = true;
        defaultDebugDumpFileName = string;
        try {
            debugDumpOutputStream = new FileOutputStream(string);
            debugPrintWriter = new PrintWriter(debugDumpOutputStream, true);
        }
        catch (IOException iOException) {
            if (debugDumpOutputStream != null) {
                try {
                    debugDumpOutputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            debugDumpOutputStream = null;
            debugPrintWriter = null;
        }
    }

    public static void ikmShowDebugMessage(String string) {
        JFrame jFrame = new JFrame();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        MsgDialog msgDialog = new MsgDialog(jFrame, "Debug Message", string);
        ((Component)msgDialog).setLocation(dimension.width / 2 - 240, dimension.height / 2 - 150);
        ((Component)msgDialog).setVisible(true);
    }

    public static boolean isDBCSString(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\u20a9') {
                bl = false;
            }
            if ('\u0080' <= cArray[n] && cArray[n] <= '\u00a1' || '\u00a4' == cArray[n] || '\u00a7' <= cArray[n] && cArray[n] <= '\u00ab' || '\u00ad' <= cArray[n] && cArray[n] <= '\u00ae' || '\u0600' <= cArray[n] && cArray[n] <= '\u06ff' || '\u0f00' <= cArray[n] && cArray[n] <= '\u0fff' || '\u1100' <= cArray[n] && cArray[n] <= '\u11ff' || '\u1800' <= cArray[n] && cArray[n] <= '\u18ff' || '\u1e00' <= cArray[n] && cArray[n] <= '\u27bf' || '\u2ff0' <= cArray[n] && cArray[n] <= '\u2ffb' || '\u3000' <= cArray[n] && cArray[n] <= '\u33ff' || '\u3400' <= cArray[n] && cArray[n] <= '\u4dff' || '\u4e00' <= cArray[n] && cArray[n] <= '\u9fa5' || '\ua000' <= cArray[n] && cArray[n] <= '\ua4ff' || '\uac00' <= cArray[n] && cArray[n] <= '\ud7a3' || '\ue000' <= cArray[n] && cArray[n] <= '\uf86f' || '\uf900' <= cArray[n] && cArray[n] <= '\ufb4f' || '\ufb50' <= cArray[n] && cArray[n] <= '\ufdff' || '\ufe20' <= cArray[n] && cArray[n] <= '\ufe6f' || '\ufe70' <= cArray[n] && cArray[n] <= '\ufeff' || '\uff00' <= cArray[n] && cArray[n] <= '\uff5f' || '\uffe0' <= cArray[n] && cArray[n] <= '\uffe6' || '\ufff0' <= cArray[n] && cArray[n] <= '\uffff') {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public static boolean isInvalidIPAddressValid(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (KMUtil.isInvalidIPAddressValidSingle(string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInvalidIPAddressValidSingle(String string) {
        boolean bl = true;
        if (bl) {
            return false;
        }
        boolean bl2 = true;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.countTokens() != 0 && stringTokenizer.countTokens() >= 5) {
                KMUtil.debugMsg("KMUtil::isIPAddressValid(1 args) 0000, st.countTokens()= " + stringTokenizer.countTokens());
                throw new Exception("JCE defect");
            }
            IPAddressName iPAddressName = new IPAddressName(string);
            bl2 = false;
        }
        catch (Exception exception) {
            bl2 = true;
            KMUtil.debugMsg("KMUtil::isIPAddressValid(1 args) 0000, input ip= " + string + ", with exception= " + exception.toString());
        }
        return bl2;
    }

    public static void addExtensions(Vector vector, int n, String[] stringArray) {
        if (vector == null || stringArray == null) {
            return;
        }
        if (!KMExtensionItem.isValidFieldType(n)) {
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            vector.addElement(new KMExtensionItem(n, stringArray[n2]));
            ++n2;
        }
    }

    public static String[] getStrings(String string) {
        String string2 = KMUtil.trimBlankSpace(string);
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,");
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = new String(stringTokenizer.nextToken());
            ++n2;
        }
        return stringArray;
    }

    static {
        msgIndent = 0;
    }
}

