/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMAWTUtil;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class PasswordDialog
extends JDialog
implements ActionListener,
ItemListener,
DocumentListener {
    private boolean doConfirm;
    private boolean isStashBoxPresent = false;
    private boolean isSetExpireBoxPresent = false;
    private boolean askCurrPasswd = false;
    private KMButton okButton;
    private KMButton cancelButton;
    private KMButton resetButton;
    private KMButton helpButton;
    private JLabel pwdLabel;
    private JLabel pwdConfirmLabel;
    private JLabel pwdStrengthLabel;
    private JLabel currPwdLabel;
    private JPasswordField currPwdField;
    private JPasswordField pwdField;
    private JPasswordField pwdConfirmField;
    private JCheckBox setExpireTimeBox = null;
    private JCheckBox stashPwdBox = null;
    private JTextField expireTimeField;
    private JLabel expireDaysLabel;
    private long expireTime = 0L;
    private JPanel mainPanel;
    private JPanel pwdPanel;
    private JPanel buttonPanel;
    private String password = null;
    private String currPassword = null;
    private String currPasswdLabelText = null;
    private boolean defaultStashBoxState = false;
    private boolean isStashSelected = false;
    private JLabel[] pwdStrengthKeys;
    private static final int PWD_MAX_STRENGTH = 5;
    private JLabel keyDbFileNameLabel;
    private JDialog diagInstance;

    public PasswordDialog(JFrame jFrame, String string) {
        this(jFrame, string, null, null, false, false, true, false, null);
    }

    public PasswordDialog(JFrame jFrame, String string, boolean bl) {
        this(jFrame, string, null, null, bl, bl, true, false, null);
    }

    public PasswordDialog(JFrame jFrame, String string, boolean bl, String string2) {
        this(jFrame, string, null, null, bl, bl, true, false, string2);
    }

    public PasswordDialog(JFrame jFrame, String string, String string2, boolean bl) {
        this(jFrame, string, string2, null, bl, bl, true, false, null);
    }

    public PasswordDialog(JFrame jFrame, String string, String string2, String string3, boolean bl) {
        this(jFrame, string, string2, string3, bl, bl, true, false, null);
    }

    public PasswordDialog(JFrame jFrame, String string, String string2, boolean bl, boolean bl2) {
        this(jFrame, string, string2, null, bl, bl, bl2, false, null);
    }

    public PasswordDialog(JFrame jFrame, String string, String string2, boolean bl, boolean bl2, String string3) {
        this(jFrame, string, string2, null, bl, bl, bl2, false, string3);
    }

    public PasswordDialog(JFrame jFrame, String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3) {
        this(jFrame, string, string2, null, bl, bl2, bl3, false, string3);
    }

    public PasswordDialog(JFrame jFrame, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        this(jFrame, string, string2, null, bl, bl2, bl3, false, null);
    }

    public PasswordDialog(JFrame jFrame, String string, String string2, String string3, boolean bl, boolean bl2) {
        this(jFrame, string, string2, string3, bl, false, bl2, false, null);
    }

    public PasswordDialog(JFrame jFrame, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(jFrame, string, string2, string3, bl, bl2, bl3, bl4, null);
    }

    public PasswordDialog(JFrame jFrame, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string4) {
        super(jFrame, string, true);
        JComponent jComponent;
        this.doConfirm = bl;
        this.isSetExpireBoxPresent = bl2;
        this.isStashBoxPresent = bl3;
        this.askCurrPasswd = false;
        this.diagInstance = this;
        if (string2 == null) {
            string2 = Ikeyman.getNLSResString("GUI_LABEL_PASSWORD");
        }
        if (string3 == null) {
            string3 = Ikeyman.getNLSResString("GUI_LABEL_PASSWORD_CONFIRM");
        }
        this.currPasswdLabelText = Ikeyman.getNLSResString("GUI_LABEL_PASSWORD_CURRENT");
        this.populateFields(string2, string3, string4);
        this.mainPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.mainPanel.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (string4 != null) {
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(15, 5, 5, 5);
            gridBagLayout.setConstraints(this.keyDbFileNameLabel, gridBagConstraints);
            this.mainPanel.add(this.keyDbFileNameLabel);
        }
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(15, 5, 5, 5);
        gridBagLayout.setConstraints(this.pwdLabel, gridBagConstraints);
        this.mainPanel.add(this.pwdLabel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 5);
        gridBagLayout.setConstraints(this.pwdField, gridBagConstraints);
        this.mainPanel.add(this.pwdField);
        if (bl) {
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints(this.pwdConfirmLabel, gridBagConstraints);
            this.mainPanel.add(this.pwdConfirmLabel);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(5, 10, 5, 5);
            gridBagLayout.setConstraints(this.pwdConfirmField, gridBagConstraints);
            this.mainPanel.add(this.pwdConfirmField);
            if (this.askCurrPasswd) {
                gridBagConstraints.anchor = 13;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagLayout.setConstraints(this.pwdLabel, gridBagConstraints);
                this.mainPanel.add(this.currPwdLabel);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets = new Insets(5, 10, 5, 5);
                gridBagLayout.setConstraints(this.currPwdField, gridBagConstraints);
                this.mainPanel.add(this.currPwdField);
            }
            if (bl2) {
                gridBagConstraints.anchor = 13;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.insets = new Insets(10, 5, 5, 5);
                gridBagLayout.setConstraints(this.setExpireTimeBox, gridBagConstraints);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.insets = new Insets(10, 10, 5, 0);
                gridBagLayout.setConstraints(this.expireTimeField, gridBagConstraints);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.insets = new Insets(10, 0, 5, 5);
                gridBagLayout.setConstraints(this.expireDaysLabel, gridBagConstraints);
                jComponent = new JLabel();
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(jComponent, gridBagConstraints);
                this.mainPanel.add(this.setExpireTimeBox);
                this.mainPanel.add(this.expireTimeField);
                this.mainPanel.add(this.expireDaysLabel);
                this.mainPanel.add(jComponent);
            }
            if (bl3) {
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.insets = new Insets(10, 5, 5, 5);
                gridBagLayout.setConstraints(this.stashPwdBox, gridBagConstraints);
                this.mainPanel.add(this.stashPwdBox);
            }
            this.pwdStrengthLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_PASSWORD_STRENGTH"));
            this.pwdStrengthLabel.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_PASSWORD_STRENGTH"));
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(20, 5, 5, 5);
            gridBagLayout.setConstraints(this.pwdStrengthLabel, gridBagConstraints);
            this.mainPanel.add(this.pwdStrengthLabel);
            jComponent = new JPanel();
            jComponent.setLayout(new FlowLayout(1, 5, 0));
            this.pwdStrengthKeys = new JLabel[5];
            int n = 0;
            while (n < 5) {
                this.pwdStrengthKeys[n] = new JLabel(KMFrame.getIcon("KMFrame.pwdStrengthIcon"));
                this.pwdStrengthKeys[n].setEnabled(false);
                jComponent.add(this.pwdStrengthKeys[n]);
                ++n;
            }
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(20, 5, 5, 5);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.mainPanel.add(jComponent);
            this.pwdField.getDocument().addDocumentListener(this);
        }
        jComponent = new JSeparator();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 5, 10, 5);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.mainPanel.add(jComponent);
        KMHorizontalButtonPanel kMHorizontalButtonPanel = new KMHorizontalButtonPanel();
        kMHorizontalButtonPanel.add(this.okButton);
        kMHorizontalButtonPanel.add(this.resetButton);
        kMHorizontalButtonPanel.add(this.cancelButton);
        kMHorizontalButtonPanel.equalizeButtons();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(kMHorizontalButtonPanel, gridBagConstraints);
        this.mainPanel.add(kMHorizontalButtonPanel);
        BevelBorder bevelBorder = new BevelBorder(0);
        this.mainPanel.setBorder(bevelBorder);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.mainPanel, "Center");
        if (!Ikeyman.isHelpAvailable()) {
            this.helpButton.setEnabled(false);
        }
        this.addWindowListener(new DiagAdapter());
        this.pack();
        this.setResizable(false);
        this.pwdField.requestFocus();
        if (this.askCurrPasswd) {
            this.currPwdField.requestFocus();
        }
    }

    protected void populateFields(String string, String string2, String string3) {
        this.populateInputFields(string, string2);
        this.populateStaticFields(string3);
        this.populateButtons();
        this.setToolTips();
    }

    protected void populateInputFields(String string, String string2) {
        if (this.askCurrPasswd) {
            this.currPwdField = new JPasswordField(12);
            this.currPwdField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_PASSWORD"));
            this.currPwdField.setEchoChar('*');
            this.currPwdLabel = new JLabel(this.currPasswdLabelText);
            this.currPwdLabel.getAccessibleContext().setAccessibleName(this.currPasswdLabelText);
        }
        this.pwdField = new JPasswordField(12);
        this.pwdField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_PASSWORD"));
        this.pwdField.setEchoChar('*');
        this.pwdLabel = new JLabel(string);
        this.pwdLabel.getAccessibleContext().setAccessibleName(string);
        if (this.doConfirm) {
            this.pwdConfirmField = new JPasswordField(12);
            this.pwdConfirmField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_PASSWORD_CONFIRM"));
            this.pwdConfirmField.setEchoChar('*');
            this.pwdConfirmLabel = new JLabel(string2);
            this.pwdConfirmLabel.getAccessibleContext().setAccessibleName(string2);
            if (this.isSetExpireBoxPresent) {
                this.setExpireTimeBox = new JCheckBox(Ikeyman.getNLSResString("GUI_LABEL_SET_EXPIRE_TIME"), false);
                this.setExpireTimeBox.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_SET_EXPIRE_TIME"));
                this.expireTimeField = new JTextField("60", 5);
                this.expireTimeField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_EXPIRE_DAYS"));
                this.expireDaysLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_EXPIRE_DAYS"));
                this.expireDaysLabel.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_EXPIRE_DAYS"));
                this.setExpireTimeBox.addItemListener(this);
                this.expireTimeField.addActionListener(this);
                this.expireTimeField.setEnabled(false);
                this.expireDaysLabel.setEnabled(false);
            }
            if (this.isStashBoxPresent) {
                String string3 = KMSystem.getInitSetting("DEFAULT_PASSWORD_STASHING_STATE");
                if (string3 != null && (string3.equals("true") || string3.equals("TRUE"))) {
                    this.defaultStashBoxState = true;
                }
                this.stashPwdBox = new JCheckBox(Ikeyman.getNLSResString("GUI_LABEL_STASH_PASSWORD"), this.defaultStashBoxState);
                this.stashPwdBox.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_STASH_PASSWORD"));
                this.stashPwdBox.addItemListener(this);
                this.isStashSelected = this.defaultStashBoxState;
            }
        } else {
            this.pwdField.addActionListener(this);
        }
    }

    protected void populateStaticFields(String string) {
        if (string != null) {
            this.keyDbFileNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_FILENAME") + " " + string);
        }
    }

    protected void setToolTips() {
        this.pwdField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_PASSWORD"));
        if (this.doConfirm) {
            this.pwdConfirmField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_PASSWORD_CONFIRM"));
            if (this.isSetExpireBoxPresent) {
                this.expireTimeField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_PASSWORD_EXPIRE_TIME"));
            }
        }
    }

    protected void populateButtons() {
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.resetButton = this.isSetExpireBoxPresent ? new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_RESET")) : new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CLEAR"));
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.helpButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_HELP"));
        this.okButton.setActionCommand("OK");
        this.resetButton.setActionCommand("Reset");
        this.cancelButton.setActionCommand("Cancel");
        this.helpButton.setActionCommand("Help");
        this.okButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
    }

    public String getPassword() {
        return this.password;
    }

    public String getCurrPassword() {
        return this.currPassword;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public boolean getStashStatus() {
        return this.isStashSelected;
    }

    public void setPasswordLabel(String string) {
        this.pwdLabel.setText(string);
        this.pwdLabel.invalidate();
        this.mainPanel.validate();
    }

    public void setPasswordConfirmLabel(String string) {
        this.pwdConfirmLabel.setText(string);
        this.pwdConfirmLabel.invalidate();
        this.mainPanel.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        KMUtil.debugMsg("PasswordDailog::actionPerformed() 0000, source=" + object + ", arg=" + string);
        if (string.equals("OK") || object == this.pwdField && !this.doConfirm) {
            this.password = new String(this.pwdField.getPassword());
            if (this.askCurrPasswd) {
                this.currPassword = new String(this.currPwdField.getPassword());
            }
            if (this.doConfirm) {
                int n = 0;
                this.expireTime = 0L;
                if (this.isSetExpireBoxPresent && this.setExpireTimeBox.isSelected()) {
                    try {
                        n = Integer.parseInt(this.expireTimeField.getText());
                        if (n > 7300 || n < 0) {
                            KMFrame.errorHandler(KMAWTUtil.getFrame(this), n + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_EXPIRE"));
                            this.expireTimeField.requestFocus();
                            KMUtil.debugMsg("PasswordDailog::actionPerformed() 9999-1");
                            return;
                        }
                        Date date = new Date();
                        long l = date.getTime();
                        this.expireTime = l + (long)n * 24L * 3600L * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.expireTimeField.setText("");
                        this.expireTimeField.requestFocus();
                        KMUtil.debugMsg("PasswordDailog::actionPerformed() 9999-2");
                        return;
                    }
                }
                if (this.isStashBoxPresent) {
                    this.isStashSelected = this.stashPwdBox.isSelected();
                }
            }
            if (this.askCurrPasswd && this.currPassword.equals("")) {
                KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_PASSWORD_NULL"));
                ((JTextComponent)this.currPwdField).setText("");
                this.currPwdField.requestFocus();
            } else if (this.password.equals("")) {
                KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_PASSWORD_NULL"));
                ((JTextComponent)this.pwdField).setText("");
                this.pwdField.requestFocus();
            } else if (this.doConfirm && !this.password.equals(new String(this.pwdConfirmField.getPassword()))) {
                KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_PASSWORD_CONFIRM"));
                ((JTextComponent)this.pwdField).setText("");
                ((JTextComponent)this.pwdConfirmField).setText("");
                this.pwdField.requestFocus();
            } else {
                ((Component)this).setVisible(false);
            }
        } else if (string.equals("Cancel")) {
            if (Ikeyman.printDebugMsg) {
                KMUtil.debugMsg("Cancel button is hit\n");
            }
            this.password = null;
            ((Component)this).setVisible(false);
        } else if (string.equals("Reset")) {
            ((JTextComponent)this.pwdField).setText("");
            if (this.doConfirm) {
                ((JTextComponent)this.pwdConfirmField).setText("");
                if (this.isSetExpireBoxPresent) {
                    this.expireTimeField.setText("60");
                    this.expireTimeField.setEnabled(false);
                    this.expireDaysLabel.setEnabled(false);
                    this.setExpireTimeBox.setSelected(false);
                    this.expireTimeField.repaint();
                    this.expireDaysLabel.repaint();
                    this.mainPanel.validate();
                }
                if (this.isStashBoxPresent) {
                    this.stashPwdBox.setSelected(this.defaultStashBoxState);
                }
            }
            this.pwdField.requestFocus();
        } else if (string.equals("Help")) {
            String string2 = "packages.html";
            Ikeyman.showHelpWindow(this, string2);
        }
        KMUtil.debugMsg("PasswordDailog::actionPerformed() 9999-2");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        Object object2 = itemEvent.getSource();
        if (Ikeyman.printDebugMsg) {
            KMUtil.debugMsg("getItem=" + object + ", getSource=" + object2 + itemEvent.getStateChange());
        }
        if (object2 == this.setExpireTimeBox) {
            if (this.setExpireTimeBox.isSelected()) {
                this.expireTimeField.setEnabled(true);
                this.expireDaysLabel.setEnabled(true);
                this.expireTimeField.requestFocus();
            } else {
                this.expireTimeField.setEnabled(false);
                this.expireDaysLabel.setEnabled(false);
            }
            this.expireTimeField.repaint();
            this.expireDaysLabel.repaint();
            this.mainPanel.validate();
        } else if (this.isStashBoxPresent && object2 == this.stashPwdBox) {
            this.isStashSelected = this.stashPwdBox.isSelected();
            this.okButton.requestFocus();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.calculateStrength(documentEvent.getDocument());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.calculateStrength(documentEvent.getDocument());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void calculateStrength(Document document) {
        int n = document.getLength();
        String string = new String();
        try {
            string = document.getText(0, n);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_PASSWORD"));
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n4 = stringBuffer.length();
        if (n4 > 5) {
            ++n3;
            n2 = 0;
            while (n2 < n4) {
                char c = stringBuffer.charAt(n2);
                if (!Character.isLetterOrDigit(c)) {
                    bl2 = true;
                } else if (Character.isDigit(c)) {
                    bl = true;
                } else if (Character.isUpperCase(c)) {
                    bl3 = true;
                } else {
                    bl4 = true;
                }
                if (n2 > 0 && bl5 && stringBuffer.charAt(n2 - 1) != c) {
                    bl5 = false;
                }
                ++n2;
            }
        }
        if (bl2) {
            ++n3;
        }
        if (bl) {
            ++n3;
        }
        if (bl3 && bl4) {
            ++n3;
        }
        if (n4 > 7) {
            ++n3;
        }
        if (bl5) {
            n3 = 0;
        }
        n2 = 0;
        while (n2 < 5) {
            this.pwdStrengthKeys[n2].setEnabled(false);
            ++n2;
        }
        if (n3 > 5) {
            n3 = 5;
        }
        n2 = 0;
        while (n2 < n3) {
            this.pwdStrengthKeys[n2].setEnabled(true);
            ++n2;
        }
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.pwdField.requestFocus();
    }

    class DiagAdapter
    extends WindowAdapter {
        DiagAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            PasswordDialog.this.password = null;
            ((Component)PasswordDialog.this).setVisible(false);
        }
    }
}

