/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.UnsupportedEncodingException;
import sun.io.ByteToCharConverter;
import sun.io.ByteToCharISO8859_1;
import sun.io.CharacterEncoding;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class ByteToCharJISAutoDetect
extends ByteToCharConverter {
    private static final int EUCJP_MASK = 1;
    private static final int SJIS2B_MASK = 2;
    private static final int SJIS1B_MASK = 4;
    private static final int EUCJP_KANA1_MASK = 8;
    private static final int EUCJP_KANA2_MASK = 16;
    private static final int SS2 = 142;
    private static final int SS3 = 143;
    private String SJISName = CharacterEncoding.getSJISName();
    private String convName = null;
    private ByteToCharConverter detectedConv = null;
    private ByteToCharConverter defaultConv = new ByteToCharISO8859_1();
    private static final byte[] maskTable1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 5, 5, 5, 13, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0};
    private static final byte[] maskTable2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0};

    public ByteToCharJISAutoDetect() {
        this.defaultConv.subChars = this.subChars;
        this.defaultConv.subMode = this.subMode;
    }

    public int flush(char[] cArray, int n, int n2) throws MalformedInputException, ConversionBufferFullException {
        this.badInputLength = 0;
        if (this.detectedConv != null) {
            return this.detectedConv.flush(cArray, n, n2);
        }
        return this.defaultConv.flush(cArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int n5 = 0;
        this.charOff = n3;
        this.byteOff = n;
        try {
            if (this.detectedConv == null) {
                int n6 = 0;
                int n7 = 0;
                byte by = 0;
                byte by2 = 0;
                boolean bl = false;
                for (int i = n; i < n2; ++i) {
                    by = 0;
                    by2 = 0;
                    int n8 = byArray[i] & 0xFF;
                    if (n8 == 27) {
                        this.convName = "ISO2022JP";
                        break;
                    }
                    if (!bl && n8 < 128) {
                        if (this.charOff >= n4) {
                            throw new ConversionBufferFullException();
                        }
                        cArray[this.charOff++] = (char)n8;
                        ++this.byteOff;
                        ++n5;
                        continue;
                    }
                    bl = true;
                    by = maskTable1[n8];
                    if (n8 == 142) {
                        ++n7;
                    }
                    if (by == 0) continue;
                    if (i + 1 < n2) {
                        int n9;
                        int n10;
                        if ((n10 = by & (by2 = maskTable2[n9 = byArray[++i] & 0xFF])) == 1) {
                            this.convName = "EUC_JP";
                            break;
                        }
                        if (n10 == 2 || n10 == 4 || ByteToCharJISAutoDetect.canBeSJIS1B(by) && by2 == 0) {
                            this.convName = this.SJISName;
                            break;
                        }
                        if (n8 == 143 && ByteToCharJISAutoDetect.canBeEUCJP(by2)) {
                            if (i + 1 < n2) {
                                int n11 = byArray[i + 1] & 0xFF;
                                if (!ByteToCharJISAutoDetect.canBeEUCJP(maskTable2[n11])) {
                                    this.convName = this.SJISName;
                                }
                            } else {
                                this.convName = this.SJISName;
                            }
                        }
                        if (!ByteToCharJISAutoDetect.canBeEUCKana(by, by2)) continue;
                        ++n6;
                        continue;
                    }
                    if ((by & 4) == 0) continue;
                    this.convName = this.SJISName;
                    break;
                }
                if (bl && this.convName == null) {
                    this.convName = n6 > 1 || n7 > 1 ? "EUC_JP" : this.SJISName;
                }
                if (this.convName != null) {
                    try {
                        this.detectedConv = ByteToCharConverter.getConverter(this.convName);
                        this.detectedConv.subChars = this.subChars;
                        this.detectedConv.subMode = this.subMode;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.detectedConv = null;
                        this.convName = null;
                    }
                }
            }
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw conversionBufferFullException;
        }
        catch (Exception exception) {
            this.detectedConv = this.defaultConv;
        }
        if (this.byteOff == n2) {
            return n5;
        }
        if (this.detectedConv != null) {
            try {
                n5 += this.detectedConv.convert(byArray, n + n5, n2, cArray, n3 + n5, n4);
            }
            finally {
                this.charOff = this.detectedConv.nextCharIndex();
                this.byteOff = this.detectedConv.nextByteIndex();
                this.badInputLength = this.detectedConv.badInputLength;
            }
        }
        try {
            n5 += this.defaultConv.convert(byArray, n + n5, n2, cArray, n3 + n5, n4);
        }
        finally {
            this.charOff = this.defaultConv.nextCharIndex();
            this.byteOff = this.defaultConv.nextByteIndex();
            this.badInputLength = this.defaultConv.badInputLength;
        }
        return n5;
    }

    public void reset() {
        if (this.detectedConv != null) {
            this.detectedConv.reset();
            this.detectedConv = null;
            this.convName = null;
        } else {
            this.defaultConv.reset();
        }
        this.byteOff = 0;
        this.charOff = 0;
    }

    public String getCharacterEncoding() {
        return "JISAutoDetect";
    }

    public String toString() {
        String string = this.getCharacterEncoding();
        string = this.detectedConv != null ? string + "[" + this.detectedConv.getCharacterEncoding() + "]" : string + "[unknown]";
        return string;
    }

    private static final boolean canBeSJIS1B(int n) {
        return (n & 4) != 0;
    }

    private static final boolean canBeEUCJP(int n) {
        return (n & 1) != 0;
    }

    private static final boolean canBeEUCKana(int n, int n2) {
        return (n & 8) != 0 && (n2 & 0x10) != 0;
    }
}

