/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CRLNumberExtension;
import com.ibm.security.x509.CRLReasonCodeExtension;
import com.ibm.security.x509.DeltaCRLIndicatorExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.IssuingDistributionPointExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.ReasonFlags;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;

class CompositeCRL {
    static final int CERTIFICATE_REVOCATION_STATUS_UNSPECIFIED = 1000;
    static final int CERTIFICATE_REVOCATION_STATUS_KEY_COMPROMISE = 1001;
    static final int CERTIFICATE_REVOCATION_STATUS_CA_COMPROMISE = 1002;
    static final int CERTIFICATE_REVOCATION_STATUS_AFFILIATION_CHANGED = 1003;
    static final int CERTIFICATE_REVOCATION_STATUS_SUPERSEDED = 1004;
    static final int CERTIFICATE_REVOCATION_STATUS_CESSATION_OF_OPERATION = 1005;
    static final int CERTIFICATE_REVOCATION_STATUS_CERTIFICATE_HOLD = 1006;
    static final int CERTIFICATE_REVOCATION_STATUS_UNREVOKED = 2000;
    static final int CERTIFICATE_REVOCATION_STATUS_UNDETERMINED = 2001;
    static final int CERTIFICATE_REVOCATION_STATUS_REVOKED_NOREASONS = 2002;
    static final BigInteger BI_NEG_ONE = new BigInteger("-1");
    static final int COMPOSITE_UPDATED = 1001;
    static final int COMPOSITE_OUT_OF_DATE = 1002;
    static final int COMPOSITE_IS_CURRENT = 1003;
    static final int CRL_NOT_FOUND = 1004;
    static final int DELTA_OUT_OF_SEQUENCE = 1005;
    static final int COMPOSITE_IS_BACK_LEVEL = 1006;
    static final int CERTIFICATE_SETS_DO_NOT_MATCH = 1007;
    static final int REASONS_DO_NOT_MATCH = 1008;
    static final int DELTA_NOT_FOUND = 1009;
    static final int UPDATE_BASE_WITH_DELTA = 1010;
    static final int UPDATE_DELTA_WITH_BASE = 1011;
    static final int FAIL = Integer.MAX_VALUE;
    private int BASE_CRL_INDEX = 0;
    private int DELTA_CRL_INDEX = 1;
    private int NUMBER_INDEX = 2;
    private int REASONS_INDEX = 3;
    private int ONLY_CONTAINS_CA_INDEX = 4;
    private int ONLY_CONTAINS_EE_INDEX = 5;
    static Hashtable CAcompositeCRLHashtable = new Hashtable();
    static Hashtable EEcompositeCRLHashtable = new Hashtable();
    private X509Certificate issuerCertificate = null;
    private Principal issuerName = null;
    private String distributionPoint = null;
    private Object[] crlInfo = new Object[]{null, null, null, null, null, null};
    private long lastModified;

    CompositeCRL(String distributionPoint) {
        this.distributionPoint = distributionPoint;
    }

    int getStatus(BigInteger certificateSerialNumber, Date evaluationDate) throws CertPathValidatorException {
        int dateorder;
        int status = 2000;
        Object[] cInfo = this.crlInfo;
        X509CRLEntry xce = null;
        Date xDate = null;
        X509CRL baseCRL = (X509CRL)cInfo[this.BASE_CRL_INDEX];
        xDate = baseCRL.getNextUpdate();
        if (cInfo[this.DELTA_CRL_INDEX] != null) {
            X509CRL crl = (X509CRL)cInfo[this.DELTA_CRL_INDEX];
            xce = crl.getRevokedCertificate(certificateSerialNumber);
            xDate = crl.getNextUpdate();
        }
        if (xce == null) {
            xce = baseCRL.getRevokedCertificate(certificateSerialNumber);
        }
        if (xce != null) {
            status = CompositeCRL.getCRLEntryReasonCode(xce);
        }
        if ((status == 2000 || status == 1006) && (dateorder = xDate.compareTo(evaluationDate)) <= 0) {
            status = 2001;
        }
        return status;
    }

    void update(X509CRL crl) throws CertPathValidatorException {
        Object[] newInfo = new Object[this.crlInfo.length];
        if (CompositeCRL.isDeltaCRL(crl)) {
            newInfo[this.BASE_CRL_INDEX] = null;
            newInfo[this.DELTA_CRL_INDEX] = crl;
        } else {
            newInfo[this.BASE_CRL_INDEX] = crl;
            newInfo[this.DELTA_CRL_INDEX] = null;
        }
        newInfo[this.NUMBER_INDEX] = CompositeCRL.getCRLNumber(crl);
        Object[] obj = CompositeCRL.getIssuingDistributionPoint(crl);
        newInfo[this.ONLY_CONTAINS_CA_INDEX] = (Boolean)obj[2];
        newInfo[this.ONLY_CONTAINS_EE_INDEX] = (Boolean)obj[1];
        newInfo[this.REASONS_INDEX] = (boolean[])obj[3];
        this.crlInfo = newInfo;
    }

    int update(X509CRL crl, Date validationDate, String sigProvider, long lastModified) throws CertPathValidatorException {
        Date nextDate;
        int status = 0;
        int index = 0;
        index = CompositeCRL.isDeltaCRL(crl) ? this.DELTA_CRL_INDEX : this.BASE_CRL_INDEX;
        try {
            CertPathUtil.verifySignature(crl, this.getIssuerCertificate().getPublicKey(), sigProvider);
        }
        catch (CertificateNotYetValidException e) {
            throw new CertPathValidatorException(e);
        }
        if (this.crlInfo[this.BASE_CRL_INDEX] != null) {
            if (crl.getThisUpdate().compareTo(((X509CRL)this.crlInfo[index]).getThisUpdate()) > 0) {
                this.crlInfo[index] = crl;
                this.lastModified = lastModified;
            }
        } else {
            this.crlInfo[this.BASE_CRL_INDEX] = crl;
            this.lastModified = lastModified;
        }
        status = (nextDate = ((X509CRL)this.crlInfo[index]).getNextUpdate()) != null ? (nextDate.compareTo(validationDate) >= 0 ? 1003 : 1002) : 1003;
        return status;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int updateBase(X509CRL crl, Date validationDate, String sigProvider) throws CertPathValidatorException {
        int status = 0;
        if (crl != null) {
            if (CompositeCRL.isDeltaCRL(crl)) {
                return 1010;
            }
            try {
                CertPathUtil.verifySignature(crl, this.getIssuerCertificate().getPublicKey(), sigProvider);
            }
            catch (CertificateNotYetValidException e) {
                throw new CertPathValidatorException(e);
            }
            BigInteger crlNumber = CompositeCRL.getCRLNumber(crl);
            int compare = crlNumber.compareTo(this.getNumber());
            if (compare <= 0) {
                Date compNextUpdate = this.getNextUpdate();
                compare = compNextUpdate.compareTo(validationDate);
                if (compare > 0) {
                    return 1003;
                }
                if (compare > 0) return status;
                return 1002;
            }
            if (compare <= 0) return status;
            this.update(crl);
            Date compNextUpdate = this.getNextUpdate();
            compare = compNextUpdate.compareTo(validationDate);
            if (compare > 0) {
                return 1001;
            }
            if (compare > 0) return status;
            return 1002;
        }
        if (crl != null) return status;
        return 1004;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int updateDelta(X509CRL crl, Date validationDate, String sigProvider) throws CertPathValidatorException {
        int status = 0;
        if (crl != null) {
            if (!CompositeCRL.isDeltaCRL(crl)) return 1011;
            try {
                CertPathUtil.verifySignature(crl, this.getIssuerCertificate().getPublicKey(), sigProvider);
            }
            catch (CertificateNotYetValidException e) {
                throw new CertPathValidatorException(e);
            }
            BigInteger crlNumber = CompositeCRL.getCRLNumber(crl);
            int compare = crlNumber.compareTo(this.getNumber());
            if (compare < 0) {
                return 1005;
            }
            if (compare > 0) {
                return 1006;
            }
            if (compare != 0) return status;
            Object[] obj = CompositeCRL.getIssuingDistributionPoint(crl);
            if (!CertPathUtil.isEqualReasons(this.getReasons(), (boolean[])obj[3])) return 1008;
            if (!this.isTypeEE() || !((Boolean)obj[1]).booleanValue()) {
                if (!this.isTypeCA()) return 1007;
                if ((Boolean)obj[2] == false) return 1007;
            }
            this.refresh(crl);
            Date compNextUpdate = this.getNextUpdate();
            compare = compNextUpdate.compareTo(validationDate);
            if (compare > 0) {
                return 1001;
            }
            if (compare > 0) return status;
            return 1002;
        }
        if (crl != null) return status;
        return 1009;
    }

    void refresh(X509CRL deltaCRL) throws CertPathValidatorException {
        Object[] newInfo = new Object[this.crlInfo.length];
        newInfo[this.DELTA_CRL_INDEX] = deltaCRL;
        newInfo[this.BASE_CRL_INDEX] = this.crlInfo[this.BASE_CRL_INDEX];
        newInfo[this.NUMBER_INDEX] = CompositeCRL.getCRLNumber(deltaCRL);
        newInfo[this.REASONS_INDEX] = this.crlInfo[this.REASONS_INDEX];
        this.crlInfo = newInfo;
    }

    boolean[] getReasons() {
        if (this.crlInfo[this.REASONS_INDEX] != null) {
            boolean[] reasons = (boolean[])this.crlInfo[this.REASONS_INDEX];
            boolean[] result = new boolean[reasons.length];
            System.arraycopy(reasons, 0, result, 0, result.length);
            return result;
        }
        return null;
    }

    Date getNextUpdate() {
        Object[] cInfo = this.crlInfo;
        if (cInfo[this.DELTA_CRL_INDEX] != null) {
            return ((X509CRL)cInfo[this.DELTA_CRL_INDEX]).getNextUpdate();
        }
        return ((X509CRL)cInfo[this.BASE_CRL_INDEX]).getNextUpdate();
    }

    Date getThisUpdate() {
        Object[] cInfo = this.crlInfo;
        if (cInfo[this.DELTA_CRL_INDEX] != null) {
            return ((X509CRL)cInfo[this.DELTA_CRL_INDEX]).getThisUpdate();
        }
        return ((X509CRL)cInfo[this.BASE_CRL_INDEX]).getThisUpdate();
    }

    BigInteger getNumber() {
        return (BigInteger)this.crlInfo[this.NUMBER_INDEX];
    }

    Principal getIssuerName() {
        Object[] cInfo = this.crlInfo;
        return ((X509CRL)cInfo[this.BASE_CRL_INDEX]).getIssuerDN();
    }

    X509Certificate getIssuerCertificate() {
        return this.issuerCertificate;
    }

    boolean isTypeCA() {
        return !((Boolean)this.crlInfo[this.ONLY_CONTAINS_EE_INDEX]).equals(Boolean.TRUE);
    }

    boolean isTypeEE() {
        return !((Boolean)this.crlInfo[this.ONLY_CONTAINS_CA_INDEX]).equals(Boolean.TRUE);
    }

    void setIssuerCertificate(X509Certificate issuer) {
        this.issuerCertificate = issuer;
    }

    public String toString() {
        return super.toString();
    }

    static BigInteger getCRLNumber(X509CRL crl) throws CertPathValidatorException {
        BigInteger number = null;
        byte[] bytes = crl.getExtensionValue(OIDMap.getOID((String)"x509.info.extensions.CRLNumber").toString());
        if (bytes != null) {
            try {
                Extension ext = new Extension(PKIXExtensions.CRLNumber_Id, false, bytes);
                CRLNumberExtension obj = new CRLNumberExtension(new Boolean(ext.isCritical()), (Object)ext.getExtensionValue());
                number = (BigInteger)obj.get("value");
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred when processing the CRLNumber extension.", e);
            }
        }
        return number;
    }

    static BigInteger getBaseNumber(X509CRL crl) throws CertPathValidatorException {
        BigInteger number = null;
        byte[] bytes = crl.getExtensionValue(PKIXExtensions.DeltaCRLIndicator_Id.toString());
        if (bytes != null) {
            try {
                Extension ext = new Extension(PKIXExtensions.DeltaCRLIndicator_Id, false, bytes);
                DeltaCRLIndicatorExtension obj = new DeltaCRLIndicatorExtension(new Boolean(ext.isCritical()), (Object)ext.getExtensionValue());
                number = (BigInteger)obj.get("value");
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred when processing the DeltaCRLIndicator extension.", e);
            }
        }
        return number;
    }

    static boolean isDeltaCRL(X509CRL crl) throws CertPathValidatorException {
        boolean isDelta = false;
        BigInteger baseCRLNumber = CompositeCRL.getBaseNumber(crl);
        if (baseCRLNumber != null && baseCRLNumber.compareTo(BI_NEG_ONE) != 0) {
            isDelta = true;
        }
        return isDelta;
    }

    static Object[] getIssuingDistributionPoint(X509CRL crl) throws CertPathValidatorException {
        Object[] result = new Object[5];
        boolean[] tempB = new boolean[9];
        Arrays.fill(tempB, true);
        tempB[7] = false;
        result[1] = new Boolean(false);
        result[2] = new Boolean(false);
        result[3] = tempB;
        result[4] = new Boolean(false);
        byte[] bytes = crl.getExtensionValue(OIDMap.getOID((String)"x509.info.extensions.IssuingDistributionPoint").toString());
        if (bytes != null) {
            try {
                ReasonFlags rf;
                Extension ext = new Extension(PKIXExtensions.IssuingDistributionPoint_Id, true, bytes);
                IssuingDistributionPointExtension obj = new IssuingDistributionPointExtension(new Boolean(ext.isCritical()), (Object)ext.getExtensionValue());
                Boolean b = (Boolean)obj.get("ca_certs_only");
                if (b != null && b.equals(Boolean.TRUE)) {
                    result[2] = Boolean.TRUE;
                }
                if ((b = (Boolean)obj.get("user_certs_only")) != null && b.equals(Boolean.TRUE)) {
                    result[1] = Boolean.TRUE;
                }
                if ((rf = (ReasonFlags)obj.get("limited_reasons")) != null) {
                    BitArray ba = rf.getReasonFlags();
                    if (ba != null) {
                        int j = Math.min(ba.length(), tempB.length);
                        for (int i = 0; i < j; ++i) {
                            tempB[i] = ba.get(i);
                        }
                    }
                } else {
                    result[3] = null;
                }
                result[4] = (Boolean)obj.get("indirect_crl");
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred when processing the IssuingDistributionPoint extension.", e);
            }
        } else {
            result[3] = null;
        }
        return result;
    }

    static int getCRLEntryReasonCode(X509CRLEntry crlEntry) throws CertPathValidatorException {
        int reason = 1000;
        ObjectIdentifier oid = OIDMap.getOID((String)"x509.info.extensions.CRLReasonCode");
        byte[] bytes = crlEntry.getExtensionValue(oid.toString());
        if (bytes != null) {
            try {
                Extension ext = new Extension(oid, false, bytes);
                CRLReasonCodeExtension obj = new CRLReasonCodeExtension(new Boolean(ext.isCritical()), (Object)ext.getExtensionValue());
                Integer iReason = (Integer)obj.get("reason");
                int r = iReason;
                switch (r) {
                    case 1: {
                        reason = 1001;
                        break;
                    }
                    case 2: {
                        reason = 1002;
                        break;
                    }
                    case 3: {
                        reason = 1003;
                        break;
                    }
                    case 4: {
                        reason = 1004;
                        break;
                    }
                    case 5: {
                        reason = 1005;
                        break;
                    }
                    case 6: {
                        reason = 1006;
                        break;
                    }
                    case 8: {
                        reason = 2000;
                        break;
                    }
                    default: {
                        reason = 1000;
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred when processing the CRLReasonsCode extension.", e);
            }
        }
        return reason;
    }

    public long getModifiedTime() {
        return this.lastModified;
    }

    public void setModifiedTime(long time) {
        this.lastModified = time;
    }
}

