/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.base;

import com.ibm.security.certclient.base.PkAttr;
import com.ibm.security.certclient.base.PkNLSConstants;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class PkAttrs
implements Serializable,
Cloneable {
    private static final String sccsid = "@(#) 32 1.2    com/tivoli/pki/base/PkAttrs.java, PkBase, javapki, 04302002 4/24/02 12:26:34";
    private static final long serialVersionUID = -143094747636267207L;
    private static final PkAttr[] EMPTY = new PkAttr[0];
    private PkAttr[] array = EMPTY;

    public int size() {
        return this.array.length;
    }

    public boolean isEmpty() {
        return this.array.length == 0;
    }

    public Iter iterator() {
        return new Iter();
    }

    public boolean has(String name) {
        return this.get(name, PkAttr.NULL) != PkAttr.NULL;
    }

    public PkAttr get(String name) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!this.array[i].getName().equals(name)) continue;
            return this.array[i];
        }
        throw new IllegalArgumentException(PkNLSConstants.ATTR_DOESNOT_EXIST + " " + name);
    }

    public PkAttr get(String name, PkAttr defaultAttr) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!this.array[i].getName().equals(name)) continue;
            return this.array[i];
        }
        return defaultAttr;
    }

    public Object getValue(String name) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!this.array[i].getName().equals(name)) continue;
            return this.array[i].getValue();
        }
        throw new IllegalArgumentException(PkNLSConstants.ATTR_DOESNOT_EXIST + " " + name);
    }

    public Object getValue(String name, Object defaultValue) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!this.array[i].getName().equals(name)) continue;
            return this.array[i].getValue();
        }
        return defaultValue;
    }

    public String getString(String name) {
        return (String)this.getValue(name);
    }

    public String getString(String name, String defaultValue) {
        return (String)this.getValue(name, defaultValue);
    }

    public Object getValueIgnoreCase(String name) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!this.array[i].getName().equalsIgnoreCase(name)) continue;
            return this.array[i].getValue();
        }
        throw new IllegalArgumentException(PkNLSConstants.ATTR_DOESNOT_EXIST + " " + name);
    }

    public Object getValueIgnoreCase(String name, Object defaultValue) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!this.array[i].getName().equalsIgnoreCase(name)) continue;
            return this.array[i].getValue();
        }
        return defaultValue;
    }

    public String getStringIgnoreCase(String name) {
        return (String)this.getValueIgnoreCase(name);
    }

    public String getStringIgnoreCase(String name, String defaultValue) {
        return (String)this.getValueIgnoreCase(name, defaultValue);
    }

    public int getKind(String name) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!this.array[i].getName().equals(name)) continue;
            return this.array[i].getKind();
        }
        throw new IllegalArgumentException(PkNLSConstants.ATTR_DOESNOT_EXIST + " " + name);
    }

    public int getKind(String name, int defaultKind) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!this.array[i].getName().equals(name)) continue;
            return this.array[i].getKind();
        }
        return defaultKind;
    }

    public void add(String name, int kind, Object value) {
        if (value != null) {
            this.add(new PkAttr(name, kind, value));
        }
    }

    public void add(PkAttr attr) {
        int cmp;
        int i;
        if (attr.getValue() == null) {
            return;
        }
        String name = attr.getName();
        for (i = 0; i < this.array.length && (cmp = name.compareTo(this.array[i].getName())) <= 0; ++i) {
            if (cmp != 0) continue;
            throw new IllegalArgumentException(PkNLSConstants.ATTR_ALREADY_EXISTS);
        }
        PkAttr[] tmp = new PkAttr[this.array.length + 1];
        System.arraycopy(this.array, 0, tmp, 0, i);
        System.arraycopy(this.array, i, tmp, i + 1, this.array.length - i);
        tmp[i] = attr;
        this.array = tmp;
    }

    public void repOrAdd(String name, int kind, Object value) {
        PkAttr result = this.get(name, PkAttr.NULL);
        if (result == PkAttr.NULL) {
            if (value != null) {
                this.add(new PkAttr(name, kind, value));
            }
        } else if (value == null) {
            this.remove(name);
        } else {
            result.setKind(kind);
            result.setValue(value);
        }
    }

    public void addIfNotThere(String name, int kind, Object value) {
        if (value == null || this.has(name)) {
            return;
        }
        this.add(new PkAttr(name, kind, value));
    }

    public PkAttr remove(String name) {
        for (int i = 0; i < this.array.length; ++i) {
            if (!this.array[i].getName().equals(name)) continue;
            PkAttr result = this.array[i];
            PkAttr[] tmp = new PkAttr[this.array.length - 1];
            System.arraycopy(this.array, 0, tmp, 0, i);
            System.arraycopy(this.array, i + 1, tmp, i, this.array.length - i - 1);
            this.array = tmp;
            return result;
        }
        return null;
    }

    public void clear() {
        this.array = EMPTY;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.array.length; ++i) {
            result.append(this.array[i]);
            result.append("\n");
        }
        return result.toString();
    }

    public Object clone() {
        PkAttrs result = new PkAttrs();
        result.array = (PkAttr[])this.array.clone();
        return result;
    }

    static /* synthetic */ PkAttr[] access$002(PkAttrs x0, PkAttr[] x1) {
        x0.array = x1;
        return x1;
    }

    public class Iter
    implements Iterator {
        private int index = 0;

        private Iter() {
        }

        public boolean hasNext() {
            return this.index < PkAttrs.this.array.length;
        }

        public Object next() {
            try {
                return PkAttrs.this.array[this.index++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public PkAttr nextAttr() {
            try {
                return PkAttrs.this.array[this.index++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.index == 0 || this.index > PkAttrs.this.array.length) {
                throw new IllegalStateException();
            }
            PkAttr[] tmp = new PkAttr[PkAttrs.this.array.length - 1];
            System.arraycopy(PkAttrs.this.array, 0, tmp, 0, this.index - 1);
            System.arraycopy(PkAttrs.this.array, this.index, tmp, this.index - 1, PkAttrs.this.array.length - this.index);
            --this.index;
            PkAttrs.access$002(PkAttrs.this, tmp);
        }
    }
}

